/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsp.javaee.web.providers;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.jsp.JavaeeJspBundle;
import com.intellij.jsp.impl.FunctionDescriptor;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.XmlValueReference;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TaglibReferenceProvider
extends PsiReferenceProvider {
    public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        PsiReference[] psiReferenceArray;
        String localName;
        if (element == null) {
            TaglibReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            TaglibReferenceProvider.$$$reportNull$$$0(1);
        }
        XmlTag tag = (XmlTag)element;
        switch (localName = tag.getLocalName()) {
            case "name-given": 
            case "function-name": 
            case "tag-name": {
                PsiReference[] psiReferenceArray2 = new PsiReference[1];
                psiReferenceArray = psiReferenceArray2;
                psiReferenceArray2[0] = new NameReference(tag);
                break;
            }
            case "function-signature": {
                PsiReference[] psiReferenceArray3 = new PsiReference[1];
                psiReferenceArray = psiReferenceArray3;
                psiReferenceArray3[0] = new MethodReference(tag);
                break;
            }
            case "path": 
            case "source": {
                psiReferenceArray = new FileReferenceSet(tag.getValue().getText().trim(), (PsiElement)tag, ElementManipulators.getValueTextRange((PsiElement)tag).getStartOffset(), (PsiReferenceProvider)this, true).getAllReferences();
                break;
            }
            default: {
                psiReferenceArray = PsiReference.EMPTY_ARRAY;
            }
        }
        if (psiReferenceArray == null) {
            TaglibReferenceProvider.$$$reportNull$$$0(2);
        }
        return psiReferenceArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jsp/javaee/web/providers/TaglibReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jsp/javaee/web/providers/TaglibReferenceProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    static class NameReference
    extends XmlValueReference {
        protected NameReference(XmlTag tag) {
            super(tag);
        }

        @Nullable
        public PsiElement resolve() {
            return this.myTag.getParent();
        }

        public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
            if (newElementName == null) {
                NameReference.$$$reportNull$$$0(0);
            }
            this.replaceContent(newElementName);
            return null;
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element == null) {
                NameReference.$$$reportNull$$$0(1);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newElementName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/jsp/javaee/web/providers/TaglibReferenceProvider$NameReference";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handleElementRename";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "bindToElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class MethodReference
    extends XmlValueReference
    implements EmptyResolveMessageProvider {
        private @InspectionMessage String myUnresolvedMessage;

        MethodReference(XmlTag tag) {
            super(tag);
        }

        private JavaClassReference findFunctionClassReference() {
            PsiReference lastReference;
            PsiReference[] references;
            XmlTag tag;
            XmlTag clazzTag;
            PsiElement parent = this.myTag.getParent();
            if (parent instanceof XmlTag && (clazzTag = (tag = (XmlTag)parent).findFirstSubTag("function-class")) != null && (references = clazzTag.getReferences()).length > 0 && (lastReference = references[references.length - 1]) instanceof JavaClassReference) {
                return (JavaClassReference)lastReference;
            }
            return null;
        }

        private PsiClass resolveClass() {
            PsiElement psiElement;
            JavaClassReference lastReference = this.findFunctionClassReference();
            if (lastReference != null && (psiElement = lastReference.resolve()) instanceof PsiClass) {
                return (PsiClass)psiElement;
            }
            return null;
        }

        @Nullable
        public PsiElement resolve() {
            this.myUnresolvedMessage = JavaeeJspBundle.message("jsp.taglib.method.reference.error.class.is.not.valid", new Object[0]);
            PsiClass clazz = this.resolveClass();
            if (clazz == null) {
                return null;
            }
            if (!clazz.hasModifierProperty("public")) {
                this.myUnresolvedMessage = JavaeeJspBundle.message("jsp.taglib.method.reference.error.class.is.not.public", new Object[0]);
                return null;
            }
            PsiMetaData metaData = ((XmlTag)this.myTag.getParent()).getMetaData();
            if (metaData instanceof FunctionDescriptor) {
                FunctionDescriptor functionDescriptor = (FunctionDescriptor)metaData;
                PsiMethod[] methodsByName = clazz.findMethodsByName(functionDescriptor.getFunctionName(), false);
                this.myUnresolvedMessage = methodsByName.length == 0 ? JavaeeJspBundle.message("jsp.taglib.method.reference.error.no.such.method", new Object[0]) : JavaeeJspBundle.message("jsp.taglib.method.reference.error.method.should.be.public.or.static", new Object[0]);
                for (PsiMethod psiMethod : methodsByName) {
                    if (!psiMethod.hasModifierProperty("static") || !psiMethod.hasModifierProperty("public")) continue;
                    PsiParameter[] parameters = psiMethod.getParameterList().getParameters();
                    this.myUnresolvedMessage = JavaeeJspBundle.message("jsp.taglib.method.reference.error.signature.is.different", new Object[0]);
                    if (parameters.length != functionDescriptor.getParameterCount()) continue;
                    boolean matched = true;
                    int j = 0;
                    for (String parameterType : functionDescriptor.getFunctionParameters()) {
                        if (!MethodReference.isSameType(parameterType, parameters[j].getType().getCanonicalText())) {
                            matched = false;
                            break;
                        }
                        ++j;
                    }
                    if (!matched) continue;
                    if (MethodReference.isSameType(functionDescriptor.getFunctionReturnType(), psiMethod.getReturnType().getCanonicalText())) {
                        this.myUnresolvedMessage = "";
                        return psiMethod;
                    }
                    this.myUnresolvedMessage = JavaeeJspBundle.message("jsp.taglib.method.reference.error.different.return.type", new Object[0]);
                    return null;
                }
            }
            return null;
        }

        private static boolean isSameType(String functionReturnType, String returnTypeText) {
            return functionReturnType.equals(returnTypeText) || returnTypeText.startsWith(functionReturnType) && returnTypeText.charAt(functionReturnType.length()) == '<' && returnTypeText.charAt(returnTypeText.length() - 1) == '>';
        }

        public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
            PsiMetaData metaData;
            if (newElementName == null) {
                MethodReference.$$$reportNull$$$0(0);
            }
            if ((metaData = ((XmlTag)this.myTag.getParent()).getMetaData()) instanceof FunctionDescriptor) {
                FunctionDescriptor descriptor = (FunctionDescriptor)metaData;
                StringBuilder newsignature = new StringBuilder(descriptor.getFunctionSignature().length());
                newsignature.append(descriptor.getFunctionReturnType()).append(" ").append(newElementName).append('(');
                boolean first = true;
                for (String parameterType : descriptor.getFunctionParameters()) {
                    if (!first) {
                        newsignature.append(',');
                    }
                    first = false;
                    newsignature.append(parameterType);
                }
                newsignature.append(')');
                this.replaceContent(newsignature.toString());
            }
            return null;
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            JavaClassReference javaClassReference;
            if (element == null) {
                MethodReference.$$$reportNull$$$0(1);
            }
            if ((javaClassReference = this.findFunctionClassReference()) != null) {
                javaClassReference.bindToElement(element.getParent());
            }
            return null;
        }

        public Object @NotNull [] getVariants() {
            PsiClass psiClass = this.resolveClass();
            if (psiClass != null && psiClass.hasModifierProperty("public")) {
                PsiMethod[] allMethods = psiClass.getAllMethods();
                ArrayList<String> candidates = new ArrayList<String>(1);
                for (PsiMethod method : allMethods) {
                    if (!method.hasModifierProperty("public") || !method.hasModifierProperty("static")) continue;
                    StringBuilder signature = new StringBuilder();
                    signature.append(MethodReference.buildTypeImage(method.getReturnType()));
                    signature.append(" ");
                    signature.append(method.getName());
                    signature.append("(");
                    boolean first = true;
                    for (PsiParameter parameter : method.getParameterList().getParameters()) {
                        if (!first) {
                            signature.append(",");
                        }
                        signature.append(MethodReference.buildTypeImage(parameter.getType()));
                        first = false;
                    }
                    signature.append(")");
                    candidates.add(signature.toString());
                }
                Object[] objectArray = ArrayUtilRt.toStringArray(candidates);
                if (objectArray == null) {
                    MethodReference.$$$reportNull$$$0(2);
                }
                return objectArray;
            }
            if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
                MethodReference.$$$reportNull$$$0(3);
            }
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }

        private static String buildTypeImage(PsiType returnType) {
            if (returnType == null) {
                return null;
            }
            String image = returnType.getCanonicalText();
            int gt = image.indexOf(60);
            if (gt != -1) {
                image = image.substring(0, gt);
            }
            return image;
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            String string = this.myUnresolvedMessage;
            if (string == null) {
                MethodReference.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newElementName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/jsp/javaee/web/providers/TaglibReferenceProvider$MethodReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/jsp/javaee/web/providers/TaglibReferenceProvider$MethodReference";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnresolvedMessagePattern";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "handleElementRename";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "bindToElement";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

