/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.common;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.jpa.jpb.model.core.model.dbtype.DbType;
import com.intellij.jpa.jpb.model.util.QueryUtil;
import com.intellij.jpa.jpb.model.util.StudioAnnotationUtil;
import com.intellij.liquibase.common.LiquibaseHelper;
import com.intellij.liquibase.common.mapping.ReMappingSettings;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u000e0\rJ\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J$\u0010\u0012\u001a\u0016\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u0014\u0018\u00010\u00132\u0006\u0010\u0015\u001a\u00020\tH\u0002J\u0010\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u0017H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lcom/intellij/liquibase/common/LiquibaseDataTypeManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "findDataTypeClassByType", "Lcom/intellij/psi/PsiClass;", "typeName", "", "getAllDataTypes", "", "", "getAllDbTargetTypes", "dbType", "Lcom/intellij/jpa/jpb/model/core/model/dbtype/DbType;", "getTypeAndAliases", "Lkotlin/Pair;", "", "dataTypeClass", "createDataTypeQuery", "Lcom/intellij/util/Query;", "Companion", "intellij.liquibase.common"})
@SourceDebugExtension(value={"SMAP\nLiquibaseDataTypeManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LiquibaseDataTypeManager.kt\ncom/intellij/liquibase/common/LiquibaseDataTypeManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,116:1\n1#2:117\n1761#3,3:118\n1563#3:121\n1634#3,3:122\n1869#3:125\n1563#3:126\n1634#3,3:127\n1870#3:130\n*S KotlinDebug\n*F\n+ 1 LiquibaseDataTypeManager.kt\ncom/intellij/liquibase/common/LiquibaseDataTypeManager\n*L\n60#1:118,3\n93#1:121\n93#1:122,3\n94#1:125\n96#1:126\n96#1:127,3\n94#1:130\n*E\n"})
public final class LiquibaseDataTypeManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    public static final String DATA_TYPE_INFO_FQN = "liquibase.datatype.DataTypeInfo";
    @NotNull
    public static final String NAME = "name";
    @NotNull
    public static final String ALIASES = "aliases";
    @NotNull
    private static final Map<String, Set<String>> DATA_TYPES;

    public LiquibaseDataTypeManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final PsiClass findDataTypeClassByType(@NotNull String typeName) {
        PsiClass psiClass;
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        Object object = this.createDataTypeQuery();
        if (object != null && (object = object.asIterable()) != null) {
            Object v2;
            block9: {
                Object object2 = object;
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    boolean bl;
                    Object t;
                    block8: {
                        t = iterator.next();
                        PsiClass psiClass2 = (PsiClass)t;
                        boolean bl2 = false;
                        if (this.getTypeAndAliases(psiClass2) == null) {
                            bl = false;
                        } else {
                            Pair<String, Collection<String>> typeAndAliases;
                            Object object3 = new String[]{typeAndAliases.getFirst()};
                            Object $this$findDataTypeClassByType_u24lambda_u240_u240 = object3 = SetsKt.mutableSetOf((Object[])object3);
                            boolean bl3 = false;
                            $this$findDataTypeClassByType_u24lambda_u240_u240.addAll((Collection)typeAndAliases.getSecond());
                            Object allTypes = object3;
                            Iterable $this$any$iv = (Iterable)allTypes;
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl = false;
                            } else {
                                for (Object element$iv : $this$any$iv) {
                                    String it = (String)element$iv;
                                    boolean bl4 = false;
                                    if (!StringsKt.equals((String)it, (String)typeName, (boolean)true)) continue;
                                    bl = true;
                                    break block8;
                                }
                                bl = false;
                            }
                        }
                    }
                    if (!bl) continue;
                    v2 = t;
                    break block9;
                }
                v2 = null;
            }
            psiClass = v2;
        } else {
            psiClass = null;
        }
        return psiClass;
    }

    @NotNull
    public final Map<String, Set<String>> getAllDataTypes() {
        return DATA_TYPES;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<String> getAllDbTargetTypes(@Nullable DbType dbType) {
        Object object;
        void $this$mapTo$iv$iv;
        Set allDbTargetTypes;
        if (LiquibaseHelper.isLiquibaseSupported$default(LiquibaseHelper.Companion.getInstance(this.project), this.project, false, 2, null)) {
            Map<String, Set<String>> allDataTypes = this.getAllDataTypes();
            v0 = CollectionsKt.toSet((Iterable)SetsKt.plus(allDataTypes.keySet(), (Iterable)CollectionsKt.flatten((Iterable)allDataTypes.values())));
        } else {
            v0 = allDbTargetTypes = SetsKt.emptySet();
        }
        if (!((Collection)allDbTargetTypes).isEmpty()) {
            return allDbTargetTypes;
        }
        DbType dbType2 = dbType;
        if (dbType2 == null) {
            dbType2 = DbType.HSQL;
        }
        DbType nnDbType = dbType2;
        ReMappingSettings mappingSettings = ReMappingSettings.Companion.getInstance(this.project, nnDbType);
        Iterable $this$map$iv = mappingSettings.getMappingTypes().keySet();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            object = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            collection.add(string);
        }
        Set result = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv));
        Iterable $this$forEach$iv = mappingSettings.getSqlSynonymTypes().entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            Object item$iv$iv;
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            String string = ((String)it.getKey()).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            result.add(string);
            item$iv$iv = (Iterable)it.getValue();
            object = result;
            boolean $i$f$map2 = false;
            void var15_18 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void synonymSqlType;
                String string2 = (String)item$iv$iv2;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                String string3 = synonymSqlType.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                collection.add(string3);
            }
            object.addAll((List)destination$iv$iv2);
        }
        return result;
    }

    private final Pair<String, Collection<String>> getTypeAndAliases(PsiClass dataTypeClass) {
        PsiAnnotation psiAnnotation = dataTypeClass.getAnnotation(DATA_TYPE_INFO_FQN);
        if (psiAnnotation == null) {
            return null;
        }
        PsiAnnotation dataTypeAnn = psiAnnotation;
        String string = AnnotationUtil.getDeclaredStringAttributeValue((PsiAnnotation)dataTypeAnn, (String)NAME);
        if (string == null) {
            return null;
        }
        String dataTypeName = string;
        Collection aliases = StudioAnnotationUtil.getArrayAttributeValue((PsiAnnotation)dataTypeAnn, (String)ALIASES);
        return new Pair((Object)dataTypeName, (Object)aliases);
    }

    private final Query<PsiClass> createDataTypeQuery() {
        JavaPsiFacade entitySearch = JavaPsiFacade.getInstance((Project)this.project);
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(...)");
        GlobalSearchScope scope = globalSearchScope;
        PsiClass psiClass = entitySearch.findClass(DATA_TYPE_INFO_FQN, scope);
        if (psiClass == null) {
            return null;
        }
        PsiClass dataTypeInfoAnn = psiClass;
        Class[] classArray = new Class[]{PsiClass.class};
        Query query = AnnotatedElementsSearch.searchElements((PsiClass)dataTypeInfoAnn, (SearchScope)((SearchScope)scope), (Class[])classArray);
        Intrinsics.checkNotNullExpressionValue((Object)query, (String)"searchElements(...)");
        Query baseQuery = query;
        return QueryUtil.uniqueByFqn((Query)baseQuery);
    }

    @JvmStatic
    @NotNull
    public static final LiquibaseDataTypeManager getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    static {
        Pair[] pairArray = new Pair[24];
        Object[] objectArray = new String[]{"xmltype", "java.sql.Types.SQLXML"};
        pairArray[0] = TuplesKt.to((Object)"xml", (Object)SetsKt.setOf((Object[])objectArray));
        objectArray = new String[]{"java.sql.Types.TIME", "java.sql.Time", "timetz"};
        pairArray[1] = TuplesKt.to((Object)"time", (Object)SetsKt.setOf((Object[])objectArray));
        pairArray[2] = TuplesKt.to((Object)"mediumint", (Object)SetsKt.emptySet());
        objectArray = new String[]{"java.lang.Double", "java.sql.Types.DOUBLE"};
        pairArray[3] = TuplesKt.to((Object)"double", (Object)SetsKt.setOf((Object[])objectArray));
        objectArray = new String[]{"int4", "serial", "integer", "java.sql.Types.INTEGER", "java.lang.Integer", "serial4"};
        pairArray[4] = TuplesKt.to((Object)"int", (Object)SetsKt.setOf((Object[])objectArray));
        objectArray = new String[]{"java.sql.Types.DATE", "java.sql.Date"};
        pairArray[5] = TuplesKt.to((Object)"date", (Object)SetsKt.setOf((Object[])objectArray));
        objectArray = new String[]{"int2", "java.sql.Types.SMALLINT"};
        pairArray[6] = TuplesKt.to((Object)"smallint", (Object)SetsKt.setOf((Object[])objectArray));
        pairArray[7] = TuplesKt.to((Object)"function", (Object)SetsKt.setOf((Object)"liquibase.statement.DatabaseFunction"));
        objectArray = new String[]{"java.math.BigDecimal", "java.sql.Types.DECIMAL"};
        pairArray[8] = TuplesKt.to((Object)"decimal", (Object)SetsKt.setOf((Object[])objectArray));
        objectArray = new String[]{"java.sql.Types.NVARCHAR", "nvarchar2", "national"};
        pairArray[9] = TuplesKt.to((Object)"nvarchar", (Object)SetsKt.setOf((Object[])objectArray));
        objectArray = new String[]{"java.sql.Types.TIMESTAMP_WITH_TIMEZONE", "java.sql.Timestamp", "java.sql.Types.TIMESTAMP", "timestamptz"};
        pairArray[10] = TuplesKt.to((Object)"timestamp", (Object)SetsKt.setOf((Object[])objectArray));
        objectArray = new String[]{"java.util.Date", "smalldatetime", "datetime2", "java.sql.Types.DATETIME"};
        pairArray[11] = TuplesKt.to((Object)"datetime", (Object)SetsKt.setOf((Object[])objectArray));
        objectArray = new String[]{"nchar2", "java.sql.Types.NCHAR"};
        pairArray[12] = TuplesKt.to((Object)"nchar", (Object)SetsKt.setOf((Object[])objectArray));
        objectArray = new String[]{"java.sql.Types.LONGVARBINARY", "varbinary", "image", "java.sql.Types.LONGBLOB", "longvarbinary", "binary", "longblob", "java.sql.Types.BLOB", "tinyblob", "java.sql.Types.VARBINARY", "java.sql.Types.BINARY", "mediumblob"};
        pairArray[13] = TuplesKt.to((Object)"blob", (Object)SetsKt.setOf((Object[])objectArray));
        pairArray[14] = TuplesKt.to((Object)"tinyint", (Object)SetsKt.setOf((Object)"java.sql.Types.TINYINT"));
        objectArray = new String[]{"uniqueidentifier", "java.util.UUID"};
        pairArray[15] = TuplesKt.to((Object)"uuid", (Object)SetsKt.setOf((Object[])objectArray));
        objectArray = new String[]{"java.sql.Types.BOOLEAN", "bool", "java.lang.Boolean", "bit"};
        pairArray[16] = TuplesKt.to((Object)"boolean", (Object)SetsKt.setOf((Object[])objectArray));
        objectArray = new String[]{"java.sql.Types.CHAR", "bpchar"};
        pairArray[17] = TuplesKt.to((Object)"char", (Object)SetsKt.setOf((Object[])objectArray));
        objectArray = new String[]{"varchar2", "character varying", "java.sql.Types.VARCHAR", "java.lang.String"};
        pairArray[18] = TuplesKt.to((Object)"varchar", (Object)SetsKt.setOf((Object[])objectArray));
        objectArray = new String[]{"numeric", "java.sql.Types.NUMERIC"};
        pairArray[19] = TuplesKt.to((Object)"number", (Object)SetsKt.setOf((Object[])objectArray));
        objectArray = new String[]{"money", "smallmoney"};
        pairArray[20] = TuplesKt.to((Object)"currency", (Object)SetsKt.setOf((Object[])objectArray));
        objectArray = new String[]{"integer8", "java.lang.Long", "bigserial", "int8", "serial8", "java.sql.Types.BIGINT", "java.math.BigInteger"};
        pairArray[21] = TuplesKt.to((Object)"bigint", (Object)SetsKt.setOf((Object[])objectArray));
        objectArray = new String[]{"longtext", "java.sql.Types.LONGNVARCHAR", "java.sql.Types.NCLOB", "mediumtext", "longnvarchar", "nclob", "tinytext", "java.sql.Types.LONGVARCHAR", "text", "longvarchar", "java.sql.Types.CLOB", "ntext"};
        pairArray[22] = TuplesKt.to((Object)"clob", (Object)SetsKt.setOf((Object[])objectArray));
        objectArray = new String[]{"java.lang.Float", "java.sql.Types.FLOAT", "java.sql.Types.REAL", "real"};
        pairArray[23] = TuplesKt.to((Object)"float", (Object)SetsKt.setOf((Object[])objectArray));
        DATA_TYPES = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R#\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lcom/intellij/liquibase/common/LiquibaseDataTypeManager$Companion;", "", "<init>", "()V", "DATA_TYPE_INFO_FQN", "", "NAME", "ALIASES", "DATA_TYPES", "", "", "getDATA_TYPES", "()Ljava/util/Map;", "getInstance", "Lcom/intellij/liquibase/common/LiquibaseDataTypeManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.liquibase.common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<String, Set<String>> getDATA_TYPES() {
            return DATA_TYPES;
        }

        @JvmStatic
        @NotNull
        public final LiquibaseDataTypeManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(LiquibaseDataTypeManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (LiquibaseDataTypeManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

