/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.common.mapping;

import com.intellij.jpa.jpb.model.backend.ed.ddl.Db2DbDialect;
import com.intellij.jpa.jpb.model.backend.ed.ddl.DbDialect;
import com.intellij.jpa.jpb.model.core.model.dbtype.Db2Type;
import com.intellij.jpa.jpb.model.core.model.dbtype.DbType;
import com.intellij.jpa.jpb.model.db.HibernateSqlType;
import com.intellij.jpa.jpb.model.db.HibernateTypes;
import com.intellij.jpa.jpb.model.model.Datatype;
import com.intellij.jpa.jpb.model.model.Datatypes;
import com.intellij.jpa.jpb.model.model.EntityAttribute;
import com.intellij.jpa.jpb.model.util.JpaUtils;
import com.intellij.liquibase.common.mapping.ReMappingSettings;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import liquibase.structure.core.Column;
import liquibase.structure.core.DataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u001a\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u001a0\u000bH\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR \u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00110\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR&\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00140\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lcom/intellij/liquibase/common/mapping/Db2TypeReMappingSettings;", "Lcom/intellij/liquibase/common/mapping/ReMappingSettings;", "project", "Lcom/intellij/openapi/project/Project;", "dbType", "Lcom/intellij/jpa/jpb/model/core/model/dbtype/Db2Type;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/jpa/jpb/model/core/model/dbtype/Db2Type;)V", "isHibernate6Project", "", "mappingTypes", "", "", "Lcom/intellij/jpa/jpb/model/model/Datatypes$BasicDatatype;", "getMappingTypes", "()Ljava/util/Map;", "sqlTypeToJdbcTypeCode", "Lcom/intellij/jpa/jpb/model/db/HibernateSqlType;", "getSqlTypeToJdbcTypeCode", "sqlSynonymTypes", "", "getSqlSynonymTypes", "getDbDialect", "Lcom/intellij/jpa/jpb/model/backend/ed/ddl/DbDialect;", "getTemporalTypeMappings", "Lcom/intellij/jpa/jpb/model/model/EntityAttribute$TemporalType;", "", "getJavaType", "Lcom/intellij/jpa/jpb/model/model/Datatype;", "column", "Lliquibase/structure/core/Column;", "intellij.liquibase.common"})
public final class Db2TypeReMappingSettings
extends ReMappingSettings {
    private final boolean isHibernate6Project;
    @NotNull
    private final Map<String, HibernateSqlType> sqlTypeToJdbcTypeCode;

    public Db2TypeReMappingSettings(@NotNull Project project, @NotNull Db2Type dbType) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dbType, (String)"dbType");
        super(project, (DbType)dbType);
        this.isHibernate6Project = JpaUtils.isHibernate6Project((Project)project, null);
        this.sqlTypeToJdbcTypeCode = MapsKt.mapOf((Pair)TuplesKt.to((Object)"xml", (Object)HibernateSqlType.SQLXML));
    }

    @Override
    @NotNull
    public Map<String, Datatypes.BasicDatatype> getMappingTypes() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"smallint", (Object)Datatypes.BasicDatatype.Short), TuplesKt.to((Object)"integer", (Object)Datatypes.BasicDatatype.Integer), TuplesKt.to((Object)"bigint", (Object)Datatypes.BasicDatatype.Long), TuplesKt.to((Object)"numeric", (Object)Datatypes.BasicDatatype.BigDecimal), TuplesKt.to((Object)"real", (Object)Datatypes.BasicDatatype.Float), TuplesKt.to((Object)"double", (Object)Datatypes.BasicDatatype.Double), TuplesKt.to((Object)"CHAR", (Object)Datatypes.BasicDatatype.String), TuplesKt.to((Object)"varchar", (Object)Datatypes.BasicDatatype.String), TuplesKt.to((Object)"BINARY", (Object)Datatypes.BasicDatatype.PByteArray), TuplesKt.to((Object)"VARBINARY", (Object)Datatypes.BasicDatatype.PByteArray), TuplesKt.to((Object)"GRAPHIC", (Object)Datatypes.BasicDatatype.String), TuplesKt.to((Object)"VARGRAPHIC", (Object)Datatypes.BasicDatatype.String), TuplesKt.to((Object)"CLOB", (Object)Datatypes.BasicDatatype.String), TuplesKt.to((Object)"BLOB", (Object)Datatypes.BasicDatatype.PByteArray), TuplesKt.to((Object)"ROWID", (Object)Datatypes.BasicDatatype.String), TuplesKt.to((Object)"date", (Object)Datatypes.BasicDatatype.LocalDate), TuplesKt.to((Object)"time", (Object)Datatypes.BasicDatatype.LocalTime), TuplesKt.to((Object)"timestamp", (Object)Datatypes.BasicDatatype.Instant), TuplesKt.to((Object)"timestamp with time zone", (Object)Datatypes.BasicDatatype.OffsetDateTime), TuplesKt.to((Object)"xml", (Object)(this.isHibernate6Project ? HibernateTypes.INSTANCE.getMapStringToObject() : Datatypes.BasicDatatype.String))};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @Override
    @NotNull
    public Map<String, HibernateSqlType> getSqlTypeToJdbcTypeCode() {
        return this.sqlTypeToJdbcTypeCode;
    }

    @Override
    @NotNull
    public Map<String, Collection<String>> getSqlSynonymTypes() {
        Pair[] pairArray = new Pair[6];
        Object[] objectArray = new String[]{"nvarchar", "VARCHAR () FOR BIT DATA", "VARCHAR FOR BIT DATA"};
        pairArray[0] = TuplesKt.to((Object)"varchar", (Object)CollectionsKt.listOf((Object[])objectArray));
        objectArray = new String[]{"CHARACTER", "CHAR () FOR BIT DATA", "CHAR FOR BIT DATA"};
        pairArray[1] = TuplesKt.to((Object)"CHAR", (Object)CollectionsKt.listOf((Object[])objectArray));
        pairArray[2] = TuplesKt.to((Object)"CLOB", (Object)CollectionsKt.listOf((Object)"DBCLOB"));
        pairArray[3] = TuplesKt.to((Object)"INTEGER", (Object)CollectionsKt.listOf((Object)"INT"));
        objectArray = new String[]{"DECIMAL", "DECFLOAT"};
        pairArray[4] = TuplesKt.to((Object)"NUMERIC", (Object)CollectionsKt.listOf((Object[])objectArray));
        pairArray[5] = TuplesKt.to((Object)"timestamp", (Object)CollectionsKt.listOf((Object)"timestamp without time zone"));
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @Override
    @NotNull
    public DbDialect getDbDialect() {
        DbDialect dbDialect = Db2DbDialect.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)dbDialect, (String)"INSTANCE");
        return dbDialect;
    }

    @Override
    @NotNull
    public Map<EntityAttribute.TemporalType, String[]> getTemporalTypeMappings() {
        Pair[] pairArray = new Pair[3];
        String[] stringArray = new String[]{"date"};
        pairArray[0] = TuplesKt.to((Object)EntityAttribute.TemporalType.DATE, (Object)stringArray);
        stringArray = new String[]{"time", "time with time zone", "timetz"};
        pairArray[1] = TuplesKt.to((Object)EntityAttribute.TemporalType.TIME, (Object)stringArray);
        stringArray = new String[]{"timestamp", "timestamp with time zone", "timestamptz"};
        pairArray[2] = TuplesKt.to((Object)EntityAttribute.TemporalType.TIMESTAMP, (Object)stringArray);
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @Override
    @Nullable
    public Datatype getJavaType(@NotNull Column column) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        Datatype javaType = super.getJavaType(column);
        if (javaType != null) {
            return javaType;
        }
        DataType dataType = column.getType();
        String sqlType = dataType.getTypeName();
        Intrinsics.checkNotNull((Object)sqlType);
        if (StringsKt.startsWith$default((String)sqlType, (String)"TIMESTAMP(", (boolean)false, (int)2, null)) {
            return (Datatype)this.findMappingType(StringsKt.substringBefore$default((String)sqlType, (char)'(', null, (int)2, null) + StringsKt.substringAfter$default((String)sqlType, (char)')', null, (int)2, null));
        }
        return null;
    }
}

