/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.annotation;

import com.intellij.protobuf.lang.psi.PbField;
import com.intellij.protobuf.lang.psi.PbMessageType;
import com.intellij.protobuf.lang.psi.PbNamedTypeElement;
import com.intellij.protobuf.lang.psi.PbNumberValue;
import com.intellij.protobuf.lang.psi.PbTypeName;
import com.intellij.protobuf.lang.util.BuiltInType;
import com.intellij.psi.util.QualifiedName;
import java.util.Objects;

public final class AnyType {
    private final PbMessageType anyMessage;
    private final PbField typeUrlField;
    private final PbField valueField;

    public static AnyType forElement(PbNamedTypeElement element) {
        if (!(element instanceof PbMessageType)) {
            return null;
        }
        PbMessageType message = (PbMessageType)element;
        QualifiedName qualifiedName = message.getQualifiedName();
        if (qualifiedName == null || !"google.protobuf.Any".equals(qualifiedName.toString())) {
            return null;
        }
        PbField typeUrlField = null;
        PbField valueField = null;
        for (PbField field : message.getSymbols(PbField.class)) {
            PbNumberValue fieldNumberValue = field.getFieldNumber();
            Long fieldNumber = fieldNumberValue != null ? fieldNumberValue.getLongValue() : null;
            PbTypeName fieldType = field.getTypeName();
            if (fieldNumber != null && fieldNumber == 1L && fieldType != null && fieldType.getBuiltInType() == BuiltInType.STRING) {
                typeUrlField = field;
            } else if (fieldNumber != null && fieldNumber == 2L && fieldType != null && fieldType.getBuiltInType() == BuiltInType.BYTES) {
                valueField = field;
            }
            if (typeUrlField == null || valueField == null) continue;
            return new AnyType(message, typeUrlField, valueField);
        }
        return null;
    }

    private AnyType(PbMessageType anyMessage, PbField typeUrlField, PbField valueField) {
        this.anyMessage = anyMessage;
        this.typeUrlField = typeUrlField;
        this.valueField = valueField;
    }

    public PbMessageType getMessage() {
        return this.anyMessage;
    }

    public PbField getTypeUrlField() {
        return this.typeUrlField;
    }

    public PbField getValueField() {
        return this.valueField;
    }

    public int hashCode() {
        return Objects.hashCode(this.anyMessage);
    }

    public boolean equals(Object other) {
        return other instanceof AnyType && this.anyMessage.equals(((AnyType)other).anyMessage);
    }
}

