/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.annotation;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.protobuf.ide.highlighter.PbSyntaxHighlighter;
import com.intellij.protobuf.ide.highlighter.PbTextSyntaxHighlighter;
import com.intellij.protobuf.lang.PbLangBundle;
import com.intellij.protobuf.lang.annotation.AnyType;
import com.intellij.protobuf.lang.annotation.OptionOccurrenceTracker;
import com.intellij.protobuf.lang.annotation.SharedAnnotations;
import com.intellij.protobuf.lang.psi.PbEnumDefinition;
import com.intellij.protobuf.lang.psi.PbField;
import com.intellij.protobuf.lang.psi.PbFile;
import com.intellij.protobuf.lang.psi.PbMessageType;
import com.intellij.protobuf.lang.psi.PbNamedTypeElement;
import com.intellij.protobuf.lang.psi.PbTextDomain;
import com.intellij.protobuf.lang.psi.PbTextElement;
import com.intellij.protobuf.lang.psi.PbTextExtensionName;
import com.intellij.protobuf.lang.psi.PbTextField;
import com.intellij.protobuf.lang.psi.PbTextFieldName;
import com.intellij.protobuf.lang.psi.PbTextFile;
import com.intellij.protobuf.lang.psi.PbTextIdentifierValue;
import com.intellij.protobuf.lang.psi.PbTextLiteral;
import com.intellij.protobuf.lang.psi.PbTextMessage;
import com.intellij.protobuf.lang.psi.PbTextNumberValue;
import com.intellij.protobuf.lang.psi.PbTextStringPart;
import com.intellij.protobuf.lang.psi.PbTextSymbolPath;
import com.intellij.protobuf.lang.psi.PbTextValueList;
import com.intellij.protobuf.lang.psi.PbTextVisitor;
import com.intellij.protobuf.lang.util.BuiltInType;
import com.intellij.protobuf.lang.util.ValueTester;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PbTextAnnotator
implements Annotator {
    private static final Key<Map<PsiElement, Boolean>> RESERVED_FIELDS_KEY = Key.create((String)"RESERVED_FIELDS_KEY");

    public void annotate(@NotNull PsiElement element, final @NotNull AnnotationHolder holder) {
        if (element == null) {
            PbTextAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            PbTextAnnotator.$$$reportNull$$$0(1);
        }
        if (element instanceof PbTextStringPart) {
            PbTextStringPart part = (PbTextStringPart)element;
            SharedAnnotations.annotateStringPart(part, holder, PbTextAnnotator.getInvalidEscapeAttributes(part));
            return;
        }
        if (!PbTextAnnotator.fullAnnotation(element)) {
            return;
        }
        if (PbTextAnnotator.isReservedFieldOrDescendant(element, holder)) {
            return;
        }
        element.accept((PsiElementVisitor)new PbTextVisitor(this){

            @Override
            public void visitField(@NotNull PbTextField field) {
                if (field == null) {
                    1.$$$reportNull$$$0(0);
                }
                PbTextAnnotator.annotateField(field, holder);
            }

            @Override
            public void visitFieldName(@NotNull PbTextFieldName name) {
                if (name == null) {
                    1.$$$reportNull$$$0(1);
                }
                PbTextAnnotator.annotateFieldName(name, holder);
            }

            @Override
            public void visitSymbolPath(@NotNull PbTextSymbolPath path) {
                if (path == null) {
                    1.$$$reportNull$$$0(2);
                }
                SharedAnnotations.annotateSymbolPath(path, holder);
            }

            @Override
            public void visitExtensionName(@NotNull PbTextExtensionName name) {
                if (name == null) {
                    1.$$$reportNull$$$0(3);
                }
                PbTextAnnotator.annotateExtensionName(name, holder);
            }

            @Override
            public void visitDomain(@NotNull PbTextDomain domain) {
                if (domain == null) {
                    1.$$$reportNull$$$0(4);
                }
                PbTextAnnotator.annotateDomain(domain, holder);
            }

            @Override
            public void visitStringPart(@NotNull PbTextStringPart part) {
                if (part == null) {
                    1.$$$reportNull$$$0(5);
                }
                SharedAnnotations.annotateStringPart(part, holder, PbTextAnnotator.getInvalidEscapeAttributes(part));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "field";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "path";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "domain";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "part";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/protobuf/lang/annotation/PbTextAnnotator$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitField";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitFieldName";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitSymbolPath";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitExtensionName";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitDomain";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitStringPart";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static boolean isReservedFieldOrDescendant(PsiElement element, AnnotationHolder holder) {
        Boolean cached;
        if (element == null) {
            return false;
        }
        PbTextField containingField = (PbTextField)PsiTreeUtil.getParentOfType((PsiElement)element, PbTextField.class, (boolean)false);
        if (containingField == null) {
            return false;
        }
        PbTextFieldName containingFieldName = containingField.getFieldName();
        if (containingFieldName.getExtensionName() != null) {
            return false;
        }
        AnnotationSession session = holder.getCurrentAnnotationSession();
        HashMap<PbTextField, Boolean> reservedFields = (HashMap<PbTextField, Boolean>)session.getUserData(RESERVED_FIELDS_KEY);
        Boolean bl = cached = reservedFields != null ? (Boolean)reservedFields.get(containingField) : null;
        if (cached != null) {
            return cached;
        }
        PbTextMessage containingMessage = (PbTextMessage)PsiTreeUtil.getParentOfType((PsiElement)containingField, PbTextMessage.class);
        if (containingMessage == null) {
            return PbTextAnnotator.isReservedFieldOrDescendant(containingField.getParent(), holder);
        }
        PbMessageType declaredMessage = containingMessage.getDeclaredMessage();
        if (declaredMessage == null) {
            return PbTextAnnotator.isReservedFieldOrDescendant(containingField.getParent(), holder);
        }
        boolean reserved = declaredMessage.isReservedFieldName(containingFieldName.getText());
        if (!reserved) {
            reserved = PbTextAnnotator.isReservedFieldOrDescendant(containingField.getParent(), holder);
        }
        if (reservedFields == null) {
            reservedFields = new HashMap<PbTextField, Boolean>();
            session.putUserData(RESERVED_FIELDS_KEY, reservedFields);
        }
        reservedFields.put(containingField, reserved);
        return reserved;
    }

    private static boolean fullAnnotation(PsiElement element) {
        PsiFile file = element.getContainingFile();
        if (file instanceof PbFile) {
            return true;
        }
        if (file instanceof PbTextFile) {
            return ((PbTextFile)file).isBound();
        }
        return false;
    }

    private static TextAttributesKey getInvalidEscapeAttributes(PsiElement element) {
        if (element.getContainingFile() instanceof PbFile) {
            return PbSyntaxHighlighter.INVALID_STRING_ESCAPE;
        }
        return PbTextSyntaxHighlighter.INVALID_STRING_ESCAPE;
    }

    private static void annotateField(@NotNull PbTextField field, @NotNull AnnotationHolder holder) {
        PbTextFieldName name;
        BuiltInType type;
        if (field == null) {
            PbTextAnnotator.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            PbTextAnnotator.$$$reportNull$$$0(3);
        }
        if ((type = (name = field.getFieldName()).getDeclaredBuiltInType()) != null) {
            PbTextAnnotator.annotateBuiltInValue(field, type, holder);
        } else {
            PbNamedTypeElement namedType = name.getDeclaredNamedType();
            if (namedType instanceof PbMessageType) {
                PbTextAnnotator.annotateMessageValue(field, holder);
            } else if (namedType instanceof PbEnumDefinition) {
                PbTextAnnotator.annotateEnumValue(field, holder);
            }
        }
        PbTextValueList valueList = field.getValueList();
        if (valueList != null) {
            PsiElement next;
            if (!(name.getDeclaredNamedType() instanceof PbMessageType || (next = name.getNextSibling()) != null && ":".equals(next.getText()))) {
                TextRange range = TextRange.from((int)(name.getTextOffset() + name.getTextLength()), (int)1);
                holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("expected.colon.after.non.message.field", new Object[0])).range(range).create();
            }
            PbTextAnnotator.annotateValueList(field, valueList, holder);
        }
    }

    private static void annotateBuiltInValue(PbTextField field, BuiltInType type, AnnotationHolder holder) {
        ValueTester tester = type.getValueTester(ValueTester.ValueTesterType.TEXT);
        for (PbTextElement value : field.getValues()) {
            String error;
            if (value instanceof PbTextLiteral) {
                error = tester.testValue((PbTextLiteral)value);
                if (error == null) continue;
                holder.newAnnotation(HighlightSeverity.ERROR, error).range(value.getTextRange()).create();
                continue;
            }
            error = tester.testValue(null);
            if (error == null) continue;
            holder.newAnnotation(HighlightSeverity.ERROR, error).range((PsiElement)value).create();
        }
    }

    private static void annotateMessageValue(PbTextField field, AnnotationHolder holder) {
        for (PbTextElement value : field.getValues()) {
            if (value instanceof PbTextMessage) continue;
            holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("message.value.expected", new Object[0])).range(value.getTextRange()).create();
        }
    }

    private static void annotateEnumValue(PbTextField field, AnnotationHolder holder) {
        for (PbTextElement value : field.getValues()) {
            if (value instanceof PbTextIdentifierValue) {
                SharedAnnotations.annotateEnumOptionValue((PbTextIdentifierValue)value, holder);
                continue;
            }
            if (value instanceof PbTextNumberValue && ((PbTextNumberValue)value).isValidInt32()) {
                SharedAnnotations.annotateEnumOptionValue((PbTextNumberValue)value, holder);
                continue;
            }
            holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("enum.value.expected", new Object[0])).range(value.getTextRange()).create();
        }
    }

    private static void annotateValueList(PbTextField field, PbTextValueList valueList, AnnotationHolder holder) {
        PbField declaredField = field.getFieldName().getDeclaredField();
        if (declaredField != null && PbTextAnnotator.isIncorrectValueListUsage(field, declaredField)) {
            holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("non.repeated.value.list", declaredField.getName())).range((PsiElement)valueList).create();
        }
    }

    private static boolean isIncorrectValueListUsage(PbTextField field, PbField declaredField) {
        return field != null && declaredField != null && !declaredField.isRepeated() && field.getValueList() != null;
    }

    private static void annotateFieldName(@NotNull PbTextFieldName name, @NotNull AnnotationHolder holder) {
        if (name == null) {
            PbTextAnnotator.$$$reportNull$$$0(4);
        }
        if (holder == null) {
            PbTextAnnotator.$$$reportNull$$$0(5);
        }
        if (name.getExtensionName() == null) {
            PsiElement identifier = name.getNameIdentifier();
            switch (SharedAnnotations.getReferenceState(name.getEffectiveReference())) {
                case VALID: 
                case NULL: {
                    break;
                }
                default: {
                    TextRange range = identifier != null ? identifier.getTextRange() : name.getTextRange();
                    String symbolName = identifier != null ? identifier.getText() : name.getText();
                    holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("cannot.resolve.field", symbolName)).range(range).highlightType(ProblemHighlightType.LIKE_UNKNOWN_SYMBOL).create();
                }
            }
        }
        PbField declaredField = name.getDeclaredField();
        PbTextField field = (PbTextField)PsiTreeUtil.getParentOfType((PsiElement)name, PbTextField.class);
        if (!PbTextAnnotator.isIncorrectValueListUsage(field, declaredField)) {
            PbTextAnnotator.annotateOptionOccurrences(name, holder);
        }
    }

    private static void annotateExtensionName(@NotNull PbTextExtensionName name, @NotNull AnnotationHolder holder) {
        if (name == null) {
            PbTextAnnotator.$$$reportNull$$$0(6);
        }
        if (holder == null) {
            PbTextAnnotator.$$$reportNull$$$0(7);
        }
        if (name.isAnyTypeUrl()) {
            PbTextAnnotator.annotateAnyValue(name, holder);
        } else {
            PbTextSymbolPath symbolPath = name.getSymbolPath();
            if (symbolPath == null) {
                return;
            }
            PbTextMessage message = (PbTextMessage)PsiTreeUtil.getParentOfType((PsiElement)name, PbTextMessage.class);
            PbMessageType qualifierType = message != null ? message.getDeclaredMessage() : null;
            String referenceString = symbolPath.getQualifiedName().toString();
            SharedAnnotations.annotateExtensionName(symbolPath, name.getEffectiveReference(), referenceString, qualifierType, holder, false);
        }
    }

    private static void annotateAnyValue(@NotNull PbTextExtensionName name, @NotNull AnnotationHolder holder) {
        PbTextField thisField;
        PsiElement resolved;
        PbTextSymbolPath symbolPath;
        if (name == null) {
            PbTextAnnotator.$$$reportNull$$$0(8);
        }
        if (holder == null) {
            PbTextAnnotator.$$$reportNull$$$0(9);
        }
        if ((symbolPath = name.getSymbolPath()) == null) {
            return;
        }
        PsiReference ref = symbolPath.getReference();
        if (ref != null && (resolved = ref.resolve()) != null && !(resolved instanceof PbMessageType)) {
            holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("message.type.expected", new Object[0])).range(symbolPath.getSymbol()).create();
        }
        if ((thisField = (PbTextField)PsiTreeUtil.getParentOfType((PsiElement)name, PbTextField.class)) == null) {
            return;
        }
        PbTextMessage parentMessage = (PbTextMessage)PsiTreeUtil.getParentOfType((PsiElement)thisField, PbTextMessage.class);
        if (parentMessage == null || !PbTextAnnotator.isAnyType(parentMessage.getDeclaredMessage())) {
            holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("any.value.parent.field", new Object[0])).range((PsiElement)name).create();
        }
    }

    private static boolean isAnyType(PbNamedTypeElement type) {
        return AnyType.forElement(type) != null;
    }

    private static void annotateDomain(@NotNull PbTextDomain domain, @NotNull AnnotationHolder holder) {
        String domainText;
        if (domain == null) {
            PbTextAnnotator.$$$reportNull$$$0(10);
        }
        if (holder == null) {
            PbTextAnnotator.$$$reportNull$$$0(11);
        }
        if (!"type.googleapis.com".equals(domainText = domain.getDomainName()) && !"type.googleprod.com".equals(domainText)) {
            holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("invalid.any.type.domain", new Object[0])).range((PsiElement)domain).create();
        }
    }

    private static PsiElement getFieldNameAnnotationElement(PbTextFieldName name) {
        PbTextExtensionName extension = name.getExtensionName();
        if (extension != null) {
            if (extension.isAnyTypeUrl()) {
                return extension;
            }
            PbTextSymbolPath path = extension.getSymbolPath();
            if (path != null) {
                return path.getSymbol();
            }
            return extension;
        }
        return name;
    }

    private static void annotateOptionOccurrences(PbTextFieldName name, AnnotationHolder holder) {
        PbTextMessage message = (PbTextMessage)PsiTreeUtil.getParentOfType((PsiElement)name, PbTextMessage.class);
        if (message == null) {
            return;
        }
        OptionOccurrenceTracker tracker = OptionOccurrenceTracker.forMessage(message);
        if (tracker == null) {
            return;
        }
        for (OptionOccurrenceTracker.Occurrence occurrence : tracker.getOccurrences(name)) {
            occurrence.annotate(holder, PbTextAnnotator.getFieldNameAnnotationElement(name));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domain";
                break;
            }
        }
        objectArray2[1] = "com/intellij/protobuf/lang/annotation/PbTextAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "annotate";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "annotateField";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "annotateFieldName";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "annotateExtensionName";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "annotateAnyValue";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "annotateDomain";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

