/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.runConfiguration;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.RemoteConsoleProcessSupport;
import com.intellij.database.console.runConfiguration.DatabaseScriptFilesRunProfileState;
import com.intellij.database.console.runConfiguration.DatabaseScriptRunConfigurationOptions;
import com.intellij.database.console.runConfiguration.DatabaseScriptRunConfigurationSettingsEditor;
import com.intellij.database.console.runConfiguration.DatabaseScriptRunConfigurationType;
import com.intellij.database.console.runConfiguration.DatabaseScriptRunProfileState;
import com.intellij.database.console.runConfiguration.DatabaseScriptTextRunProfileState;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbeTierUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.LocatableRunConfigurationOptions;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.RunConfigurationWithSuppressedDefaultRunAction;
import com.intellij.lang.Language;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B#\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\f\u001a\u00020\u0002H\u0016J\u0010\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0000H\u0016J\u001e\u0010\u0019\u001a\u0018\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u001c\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u001b\u0018\u00010\u001aH\u0002J\u0010\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020 \u0018\u00010\u001fH\u0002J\b\u0010!\u001a\u00020\"H\u0016J\n\u0010#\u001a\u0004\u0018\u00010\tH\u0016\u00a8\u0006$"}, d2={"Lcom/intellij/database/console/runConfiguration/DatabaseScriptRunConfiguration;", "Lcom/intellij/execution/configurations/LocatableConfigurationBase;", "Lcom/intellij/database/console/runConfiguration/DatabaseScriptRunConfigurationOptions;", "Lcom/intellij/execution/runners/RunConfigurationWithSuppressedDefaultRunAction;", "type", "Lcom/intellij/database/console/runConfiguration/DatabaseScriptRunConfigurationType;", "project", "Lcom/intellij/openapi/project/Project;", "name", "", "<init>", "(Lcom/intellij/database/console/runConfiguration/DatabaseScriptRunConfigurationType;Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "getOptions", "getConfigurationEditor", "Lcom/intellij/openapi/options/SettingsEditor;", "Lcom/intellij/execution/configurations/RunConfiguration;", "checkConfiguration", "", "getState", "Lcom/intellij/database/console/runConfiguration/DatabaseScriptRunProfileState;", "executor", "Lcom/intellij/execution/Executor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "clone", "getTargetPairs", "", "Lcom/intellij/openapi/util/Pair;", "Lcom/intellij/database/dataSource/LocalDataSource;", "Lcom/intellij/database/util/ObjectPath;", "getVirtualFiles", "Lcom/intellij/util/containers/JBIterable;", "Lcom/intellij/openapi/vfs/VirtualFile;", "isGeneratedName", "", "suggestedName", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDatabaseScriptRunConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseScriptRunConfiguration.kt\ncom/intellij/database/console/runConfiguration/DatabaseScriptRunConfiguration\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,135:1\n1#2:136\n*E\n"})
public final class DatabaseScriptRunConfiguration
extends LocatableConfigurationBase<DatabaseScriptRunConfigurationOptions>
implements RunConfigurationWithSuppressedDefaultRunAction {
    public DatabaseScriptRunConfiguration(@NotNull DatabaseScriptRunConfigurationType type, @NotNull Project project, @Nullable String name) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, (ConfigurationFactory)type, name);
    }

    public /* synthetic */ DatabaseScriptRunConfiguration(DatabaseScriptRunConfigurationType databaseScriptRunConfigurationType, Project project, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = null;
        }
        this(databaseScriptRunConfigurationType, project, string);
    }

    @NotNull
    public DatabaseScriptRunConfigurationOptions getOptions() {
        LocatableRunConfigurationOptions locatableRunConfigurationOptions = super.getOptions();
        Intrinsics.checkNotNull((Object)locatableRunConfigurationOptions, (String)"null cannot be cast to non-null type com.intellij.database.console.runConfiguration.DatabaseScriptRunConfigurationOptions");
        return (DatabaseScriptRunConfigurationOptions)locatableRunConfigurationOptions;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return new DatabaseScriptRunConfigurationSettingsEditor(project, (Function0<DatabaseScriptRunConfiguration>)((Function0)() -> DatabaseScriptRunConfiguration.getConfigurationEditor$lambda$0(this)));
    }

    public void checkConfiguration() {
        super.checkConfiguration();
        DatabaseScriptRunConfigurationOptions options = this.getOptions();
        if (DbeTierUtilCore.isFreeTier()) {
            throw new RuntimeConfigurationError(DatabaseBundle.message((String)"dialog.message.pro.subscription.is.necessary", (Object[])new Object[0]));
        }
        if (options.getMode() == DatabaseScriptRunConfigurationOptions.Mode.TEXT) {
            CharSequence charSequence = options.getText();
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                throw new RuntimeConfigurationError(DatabaseBundle.message((String)"dialog.message.missing.code.to.execute", (Object[])new Object[0]));
            }
        } else if (this.getVirtualFiles() == null) {
            throw new RuntimeConfigurationError(DatabaseBundle.message((String)"dialog.message.missing.files.to.execute", (Object[])new Object[0]));
        }
        List<Pair<LocalDataSource, ObjectPath>> list = this.getTargetPairs();
        if (list != null) {
            List<Pair<LocalDataSource, ObjectPath>> it = list;
            boolean bl = false;
            if (it.isEmpty()) {
                throw new RuntimeConfigurationError(DatabaseBundle.message((String)"dialog.message.no.configured.target.data.sources", (Object[])new Object[0]));
            }
        } else {
            throw new RuntimeConfigurationError(DatabaseBundle.message((String)"dialog.message.missing.target.data.sources", (Object[])new Object[0]));
        }
    }

    @Nullable
    public DatabaseScriptRunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) {
        DatabaseScriptRunProfileState databaseScriptRunProfileState;
        block7: {
            DatabaseScriptRunProfileState databaseScriptRunProfileState2;
            Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
            Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
            DatabaseScriptRunConfigurationOptions options = this.getOptions();
            List<Pair<LocalDataSource, ObjectPath>> list = this.getTargetPairs();
            if (list == null) {
                return null;
            }
            List<Pair<LocalDataSource, ObjectPath>> targets = list;
            if (targets.isEmpty()) {
                return null;
            }
            Pair singleTarget = (Pair)CollectionsKt.singleOrNull(targets);
            if (options.getMode() == DatabaseScriptRunConfigurationOptions.Mode.TEXT && singleTarget != null) {
                String string = options.getText();
                if (string == null) {
                    return null;
                }
                Object scriptText = string;
                if (!StringsKt.endsWith$default((CharSequence)((CharSequence)scriptText), (char)'\n', (boolean)false, (int)2, null)) {
                    scriptText = (String)scriptText + "\n";
                }
                String string2 = this.getName();
                Project project = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                Object object = singleTarget.first;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first");
                databaseScriptRunProfileState2 = new DatabaseScriptTextRunProfileState(string2, project, (LocalDataSource)object, SearchPath.of((ObjectPath)((ObjectPath)singleTarget.second)), (String)scriptText);
            } else {
                JBIterable<VirtualFile> jBIterable = this.getVirtualFiles();
                if (jBIterable == null) {
                    return null;
                }
                JBIterable<VirtualFile> virtualFiles = jBIterable;
                String string = this.getName();
                Project project = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                List list2 = virtualFiles.toList();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"toList(...)");
                databaseScriptRunProfileState2 = new DatabaseScriptFilesRunProfileState(string, project, list2, targets, environment);
            }
            DatabaseScriptRunProfileState $this$getState_u24lambda_u240 = databaseScriptRunProfileState = databaseScriptRunProfileState2;
            boolean bl = false;
            AsyncTask.Frame frame = (AsyncTask.Frame)RemoteConsoleProcessSupport.BEFORE_RUN_CONTEXT.get((UserDataHolder)environment);
            if (frame == null) break block7;
            AsyncTask.Frame it = frame;
            boolean bl2 = false;
            RemoteConsoleProcessSupport.BEFORE_RUN_CONTEXT.set((UserDataHolder)$this$getState_u24lambda_u240, (Object)it);
        }
        return databaseScriptRunProfileState;
    }

    @NotNull
    public DatabaseScriptRunConfiguration clone() {
        RunConfiguration runConfiguration = super.clone();
        Intrinsics.checkNotNull((Object)runConfiguration, (String)"null cannot be cast to non-null type com.intellij.database.console.runConfiguration.DatabaseScriptRunConfiguration");
        return (DatabaseScriptRunConfiguration)runConfiguration;
    }

    private final List<Pair<LocalDataSource, ObjectPath>> getTargetPairs() {
        List list;
        DataSourceStorage storage = DataSourceStorage.getProjectStorage((Project)this.getProject());
        List it = list = JBIterable.from((Iterable)this.getOptions().getTargets()).map(arg_0 -> DatabaseScriptRunConfiguration.getTargetPairs$lambda$1(arg_0 -> DatabaseScriptRunConfiguration.getTargetPairs$lambda$0(storage, arg_0), arg_0)).toList();
        boolean bl = false;
        return !it.contains(null) ? list : null;
    }

    private final JBIterable<VirtualFile> getVirtualFiles() {
        JBIterable jBIterable;
        DatabaseScriptRunConfigurationOptions options = this.getOptions();
        if (options.getMode() == DatabaseScriptRunConfigurationOptions.Mode.TEXT) {
            String string = options.getText();
            if (string == null) {
                return JBIterable.empty();
            }
            String statementText = string;
            DataSourceStorage projectStorage = DataSourceStorage.getProjectStorage((Project)this.getProject());
            LocalDataSource dataSource = (LocalDataSource)SequencesKt.first((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)options.getTargets()), arg_0 -> DatabaseScriptRunConfiguration.getVirtualFiles$lambda$0(projectStorage, arg_0)));
            LightVirtualFile virtualFile = new LightVirtualFile(this.getName(), (Language)DbSqlUtil.getSqlDialect((LocalDataSource)dataSource), (CharSequence)statementText);
            return JBIterable.of((Object)virtualFile);
        }
        JBIterable it = jBIterable = JBIterable.from((Iterable)options.getFiles()).map(arg_0 -> DatabaseScriptRunConfiguration.getVirtualFiles$lambda$2(DatabaseScriptRunConfiguration::getVirtualFiles$lambda$1, arg_0)).collect();
        boolean bl = false;
        return !it.contains(null) ? jBIterable : null;
    }

    public boolean isGeneratedName() {
        return Intrinsics.areEqual((Object)this.getName(), (Object)this.suggestedName());
    }

    @Nullable
    public String suggestedName() {
        String string;
        if (this.getOptions().getMode() != DatabaseScriptRunConfigurationOptions.Mode.FILE) {
            return null;
        }
        List<String> files2 = this.getOptions().getFiles();
        DatabaseScriptRunConfigurationOptions $this$suggestedName_u24lambda_u240 = (DatabaseScriptRunConfigurationOptions)((Object)this.getState());
        boolean bl = false;
        switch (files2.size()) {
            case 0: {
                string = null;
                break;
            }
            case 1: {
                string = PathUtil.getFileName((String)files2.get(0));
                break;
            }
            default: {
                Object[] objectArray = new Object[]{PathUtil.getFileName((String)files2.get(0)), files2.size() - 1};
                string = DatabaseBundle.message((String)"sql.run.configuration.few.files.to.run.default.name", (Object[])objectArray);
            }
        }
        return string;
    }

    private static final DatabaseScriptRunConfiguration getConfigurationEditor$lambda$0(DatabaseScriptRunConfiguration this$0) {
        ConfigurationFactory configurationFactory = this$0.getFactory();
        Intrinsics.checkNotNull((Object)configurationFactory, (String)"null cannot be cast to non-null type com.intellij.database.console.runConfiguration.DatabaseScriptRunConfigurationType");
        DatabaseScriptRunConfigurationType databaseScriptRunConfigurationType = (DatabaseScriptRunConfigurationType)configurationFactory;
        Project project = this$0.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return new DatabaseScriptRunConfiguration(databaseScriptRunConfigurationType, project, null, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final Pair getTargetPairs$lambda$0(DataSourceStorage $storage, DatabaseScriptRunConfigurationOptions.Target it) {
        Pair pair;
        LocalDataSource localDataSource = $storage.getDataSourceById(it.getDataSourceId());
        if (localDataSource != null) {
            ObjectPath objectPath;
            LocalDataSource ds = localDataSource;
            boolean bl = false;
            LocalDataSource localDataSource2 = ds;
            String string = it.getNamespace();
            if (string != null) {
                void n;
                String string2 = string;
                LocalDataSource localDataSource3 = localDataSource2;
                boolean bl2 = false;
                objectPath = ObjectPath.deserialize((String)n);
                localDataSource2 = localDataSource3;
            } else {
                objectPath = null;
            }
            pair = Pair.create((Object)localDataSource2, objectPath);
        } else {
            pair = null;
        }
        return pair;
    }

    private static final Pair getTargetPairs$lambda$1(Function1 $tmp0, Object p0) {
        return (Pair)$tmp0.invoke(p0);
    }

    private static final LocalDataSource getVirtualFiles$lambda$0(DataSourceStorage $projectStorage, DatabaseScriptRunConfigurationOptions.Target it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return $projectStorage.getDataSourceById(it.getDataSourceId());
    }

    private static final VirtualFile getVirtualFiles$lambda$1(String it) {
        return LocalFileSystem.getInstance().findFileByPath(it);
    }

    private static final VirtualFile getVirtualFiles$lambda$2(Function1 $tmp0, Object p0) {
        return (VirtualFile)$tmp0.invoke(p0);
    }
}

