/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.util;

import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.PackageJsonDependency;
import com.intellij.javascript.nodejs.library.node_modules.NodeModulesDirectoryManager;
import com.intellij.javascript.nodejs.packageJson.InstalledPackageVersion;
import com.intellij.javascript.nodejs.packageJson.NodeInstalledPackageFinder;
import com.intellij.javascript.nodejs.packageJson.PackageJsonFileManager;
import com.intellij.javascript.nodejs.util.NodePackageDependentValue;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J.\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\n2\u0006\u0010\f\u001a\u00020\r2\u0018\u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00110\u00100\u000fJ:\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\n2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0018\u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00110\u00100\u000fH\u0002J8\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0018\u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00110\u00100\u000fH\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0015H\u0002JF\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00152\u0018\u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00110\u00100\u000f2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u001e2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 H\u0002J8\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020#2\u0018\u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00110\u00100\u000fH\u0002J\u0018\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u00152\u0006\u0010&\u001a\u00020\u0004H\u0002J\u0018\u0010'\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u00152\u0006\u0010(\u001a\u00020)H\u0002J8\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0018\u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00110\u00100\u000fH\u0002R \u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\n0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/intellij/javascript/nodejs/util/NodePackageDependentValuesLookup;", "T", "", "cacheKey", "", "<init>", "(Ljava/lang/String;)V", "depsKey", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/psi/util/CachedValue;", "", "findPackageDependentValues", "context", "Lcom/intellij/psi/PsiElement;", "packageDependentValues", "Lkotlin/Lazy;", "", "Lcom/intellij/javascript/nodejs/util/NodePackageDependentValue;", "project", "Lcom/intellij/openapi/project/Project;", "directory", "Lcom/intellij/openapi/vfs/VirtualFile;", "findDirectDependentValues", "isLookupProjectRoot", "", "dir", "addDeclaredValue", "", "packageJson", "foundValues", "", "dependencyType", "Lcom/intellij/javascript/nodejs/PackageJsonDependency;", "findDependentValuesInDirectDepsOfDevDeps", "packageJsonData", "Lcom/intellij/javascript/nodejs/PackageJsonData;", "isPackageInstalled", "nodeModulesDir", "packageName", "isAnyPackageInstalled", "packageDescriptor", "Lcom/intellij/javascript/nodejs/util/NodePackageDescriptor;", "findIndirectDependentValues", "intellij.javascript.backend"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nNodePackageDependentValuesLookup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NodePackageDependentValuesLookup.kt\ncom/intellij/javascript/nodejs/util/NodePackageDependentValuesLookup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,174:1\n1869#2,2:175\n1869#2,2:177\n1869#2,2:179\n1869#2,2:181\n*S KotlinDebug\n*F\n+ 1 NodePackageDependentValuesLookup.kt\ncom/intellij/javascript/nodejs/util/NodePackageDependentValuesLookup\n*L\n110#1:175,2\n124#1:177,2\n145#1:179,2\n161#1:181,2\n*E\n"})
public final class NodePackageDependentValuesLookup<T> {
    @NotNull
    private final Key<CachedValue<Set<T>>> depsKey;

    public NodePackageDependentValuesLookup(@NotNull String cacheKey) {
        Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
        Key key = Key.create((String)cacheKey);
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        this.depsKey = key;
    }

    @NotNull
    public final Set<T> findPackageDependentValues(@NotNull PsiElement context2, @NotNull Lazy<? extends List<NodePackageDependentValue<T>>> packageDependentValues) {
        PsiDirectory directory;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter(packageDependentValues, (String)"packageDependentValues");
        Object object = context2 instanceof PsiDirectory ? (PsiDirectory)context2 : null;
        if (object == null) {
            PsiFile psiFile = context2.getContainingFile();
            object = psiFile != null ? psiFile.getContainingDirectory() : null;
        }
        if ((directory = object) == null) {
            return SetsKt.emptySet();
        }
        Object object2 = CachedValuesManager.getCachedValue((PsiElement)((PsiElement)directory), this.depsKey, () -> NodePackageDependentValuesLookup.findPackageDependentValues$lambda$0(directory, this, packageDependentValues));
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getCachedValue(...)");
        return (Set)object2;
    }

    private final Set<T> findPackageDependentValues(Project project, VirtualFile directory, Lazy<? extends List<NodePackageDependentValue<T>>> packageDependentValues) {
        if (directory == null) {
            return SetsKt.emptySet();
        }
        PackageJsonData nearestPackageJsonData = (PackageJsonData)PackageJsonUtil.processUpPackageJsonFilesAndFindFirst(project, directory, arg_0 -> NodePackageDependentValuesLookup.findPackageDependentValues$lambda$2(NodePackageDependentValuesLookup::findPackageDependentValues$lambda$1, arg_0));
        if (nearestPackageJsonData != null) {
            VirtualFile virtualFile = nearestPackageJsonData.getPackageJsonFile().getParent();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getParent(...)");
            Set<T> directDependentValues = this.findDirectDependentValues(project, virtualFile, packageDependentValues);
            Set<T> valuesInDirectDepsOfDevDeps = this.findDependentValuesInDirectDepsOfDevDeps(project, nearestPackageJsonData, packageDependentValues);
            if (!((Collection)directDependentValues).isEmpty() || !((Collection)valuesInDirectDepsOfDevDeps).isEmpty()) {
                return SetsKt.plus(directDependentValues, (Iterable)valuesInDirectDepsOfDevDeps);
            }
        }
        return this.findIndirectDependentValues(project, directory, packageDependentValues);
    }

    private final Set<T> findDirectDependentValues(Project project, VirtualFile directory, Lazy<? extends List<NodePackageDependentValue<T>>> packageDependentValues) {
        Set foundValues = new LinkedHashSet();
        Ref ref2 = Ref.create();
        Intrinsics.checkNotNullExpressionValue((Object)ref2, (String)"create(...)");
        Ref lastCheckedDirRef = ref2;
        JSProjectUtil.processDirectoriesUpToContentRoot(project, directory, (Processor<? super VirtualFile>)((Processor)arg_0 -> NodePackageDependentValuesLookup.findDirectDependentValues$lambda$1(arg_0 -> NodePackageDependentValuesLookup.findDirectDependentValues$lambda$0(this, packageDependentValues, foundValues, lastCheckedDirRef, arg_0), arg_0)));
        if (foundValues.isEmpty()) {
            VirtualFile dir;
            if (lastCheckedDirRef.get() != null) {
                VirtualFile virtualFile = (VirtualFile)lastCheckedDirRef.get();
                v2 = virtualFile != null ? virtualFile.getParent() : null;
            } else {
                v2 = dir = directory;
            }
            while (dir != null) {
                NodePackageDependentValuesLookup.addDeclaredValue$default(this, PackageJsonUtil.findChildPackageJsonFile(dir), packageDependentValues, foundValues, null, 8, null);
                if (this.isLookupProjectRoot(dir)) break;
                dir = dir.getParent();
            }
        }
        return foundValues;
    }

    private final boolean isLookupProjectRoot(VirtualFile dir) {
        VirtualFile gitDir = dir.findChild(".git");
        return gitDir != null && gitDir.isDirectory();
    }

    private final void addDeclaredValue(VirtualFile packageJson, Lazy<? extends List<NodePackageDependentValue<T>>> packageDependentValues, Set<T> foundValues, PackageJsonDependency dependencyType) {
        if (packageJson == null) {
            return;
        }
        PackageJsonData packageJsonData = PackageJsonData.getOrCreate(packageJson);
        Intrinsics.checkNotNullExpressionValue((Object)packageJsonData, (String)"getOrCreate(...)");
        PackageJsonData packageJsonData2 = packageJsonData;
        Iterable $this$forEach$iv = (Iterable)packageDependentValues.getValue();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NodePackageDependentValue it = (NodePackageDependentValue)element$iv;
            boolean bl = false;
            if (!it.getPackageDescriptorEx().isDeclaredInPackageJson(packageJsonData2, dependencyType)) continue;
            foundValues.add(it.getValue());
        }
    }

    static /* synthetic */ void addDeclaredValue$default(NodePackageDependentValuesLookup nodePackageDependentValuesLookup, VirtualFile virtualFile, Lazy lazy, Set set, PackageJsonDependency packageJsonDependency, int n, Object object) {
        if ((n & 8) != 0) {
            packageJsonDependency = null;
        }
        nodePackageDependentValuesLookup.addDeclaredValue(virtualFile, lazy, set, packageJsonDependency);
    }

    private final Set<T> findDependentValuesInDirectDepsOfDevDeps(Project project, PackageJsonData packageJsonData, Lazy<? extends List<NodePackageDependentValue<T>>> packageDependentValues) {
        Set foundValues = new LinkedHashSet();
        NodeInstalledPackageFinder nodePackageFinder = new NodeInstalledPackageFinder(project, packageJsonData.getPackageJsonFile());
        Iterable $this$forEach$iv = packageJsonData.getAllDependencyEntries().values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            InstalledPackageVersion devDependencyPackageVersion;
            PackageJsonData.PackageJsonDependencyEntry contextPackageDependency = (PackageJsonData.PackageJsonDependencyEntry)element$iv;
            boolean bl = false;
            if (contextPackageDependency.getDependencyType() != PackageJsonDependency.devDependencies) continue;
            InstalledPackageVersion installedPackageVersion = devDependencyPackageVersion = nodePackageFinder.findInstalledPackage(contextPackageDependency.getName());
            this.addDeclaredValue((VirtualFile)(installedPackageVersion != null ? installedPackageVersion.getPackageJson() : null), packageDependentValues, foundValues, PackageJsonDependency.dependencies);
        }
        return foundValues;
    }

    private final boolean isPackageInstalled(VirtualFile nodeModulesDir, String packageName) {
        VirtualFile packageDir = nodeModulesDir.findFileByRelativePath(packageName);
        return packageDir != null && packageDir.isDirectory() && packageDir.isValid();
    }

    private final boolean isAnyPackageInstalled(VirtualFile nodeModulesDir, NodePackageDescriptor packageDescriptor) {
        List<String> list = packageDescriptor.getPackageNames();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getPackageNames(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String packageName = (String)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)packageName);
            if (!this.isPackageInstalled(nodeModulesDir, packageName)) continue;
            String dependency = packageDescriptor.getDependencyByPackageName(packageName);
            return dependency == null || this.isPackageInstalled(nodeModulesDir, dependency);
        }
        return false;
    }

    private final Set<T> findIndirectDependentValues(Project project, VirtualFile directory, Lazy<? extends List<NodePackageDependentValue<T>>> packageDependentValues) {
        Set foundValues = new LinkedHashSet();
        NodeModuleSearchUtil.processUpNodeModulesDirs(project, directory, (Processor<? super VirtualFile>)((Processor)arg_0 -> NodePackageDependentValuesLookup.findIndirectDependentValues$lambda$1(arg_0 -> NodePackageDependentValuesLookup.findIndirectDependentValues$lambda$0(packageDependentValues, this, foundValues, arg_0), arg_0)));
        return foundValues;
    }

    private static final CachedValueProvider.Result findPackageDependentValues$lambda$0(PsiDirectory $directory, NodePackageDependentValuesLookup this$0, Lazy $packageDependentValues) {
        Project project = $directory.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        VirtualFile virtualDirectory = PsiUtilCore.getVirtualFile((PsiElement)((PsiElement)$directory));
        Set result2 = this$0.findPackageDependentValues(project2, virtualDirectory, $packageDependentValues);
        Object[] objectArray = new Object[]{NodeModulesDirectoryManager.getInstance(project2).getNodeModulesDirChangeTracker(), PackageJsonFileManager.getInstance(project2).getModificationTracker()};
        return CachedValueProvider.Result.create(result2, (Object[])objectArray);
    }

    private static final PackageJsonData findPackageDependentValues$lambda$1(VirtualFile packageJsonVirtualFile) {
        return PackageJsonData.getOrCreate(packageJsonVirtualFile);
    }

    private static final PackageJsonData findPackageDependentValues$lambda$2(Function1 $tmp0, Object p0) {
        return (PackageJsonData)$tmp0.invoke(p0);
    }

    private static final boolean findDirectDependentValues$lambda$0(NodePackageDependentValuesLookup this$0, Lazy $packageDependentValues, Set $foundValues, Ref $lastCheckedDirRef, VirtualFile dir) {
        NodePackageDependentValuesLookup.addDeclaredValue$default(this$0, PackageJsonUtil.findChildPackageJsonFile(dir), $packageDependentValues, $foundValues, null, 8, null);
        $lastCheckedDirRef.set((Object)dir);
        return true;
    }

    private static final boolean findDirectDependentValues$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean findIndirectDependentValues$lambda$0(Lazy $packageDependentValues, NodePackageDependentValuesLookup this$0, Set $foundValues, VirtualFile nodeModulesDir) {
        Iterable $this$forEach$iv = (Iterable)$packageDependentValues.getValue();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NodePackageDependentValue packageDependentValue = (NodePackageDependentValue)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)nodeModulesDir);
            if (!this$0.isAnyPackageInstalled(nodeModulesDir, packageDependentValue.getPackageDescriptorEx().getInclude()) || this$0.isAnyPackageInstalled(nodeModulesDir, packageDependentValue.getPackageDescriptorEx().getExclude())) continue;
            $foundValues.add(packageDependentValue.getValue());
        }
        return true;
    }

    private static final boolean findIndirectDependentValues$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

