/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.codeWithMe.ClientId;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSMinifiedFileGistService;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.openapi.vfs.impl.http.RemoteFileInfo;
import com.intellij.openapi.vfs.impl.http.RemoteFileState;
import com.intellij.psi.css.MinifiedFilesUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ThreeState;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u0016\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b\u001a\u000e\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019\u001a\u0010\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\"9\u0010\u0000\u001a-\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004 \u0005*\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00020\u00020\u0001\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"9\u0010\u0007\u001a-\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004 \u0005*\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00020\u00020\u0001\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\" \u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000b\" \u0010\u000e\u001a\u00070\t\u00a2\u0006\u0002\b\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\r\u001a\u0004\b\u000f\u0010\u000b\" \u0010\u0011\u001a\u00070\t\u00a2\u0006\u0002\b\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\r\u001a\u0004\b\u0012\u0010\u000b\u00a8\u0006\u001e"}, d2={"MINIFIED_STATUS_OF_DOCUMENT_KEY", "Lcom/intellij/openapi/util/Key;", "Lkotlin/Pair;", "", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "MINIFIED_STATUS_OF_FILE_KEY", "NO_WHITESPACE_REQUIRED_AFTER", "Lcom/intellij/psi/tree/TokenSet;", "getNO_WHITESPACE_REQUIRED_AFTER", "()Lcom/intellij/psi/tree/TokenSet;", "NO_WHITESPACE_REQUIRED_AFTER$delegate", "Lkotlin/Lazy;", "NO_WHITESPACE_REQUIRED_BEFORE", "getNO_WHITESPACE_REQUIRED_BEFORE", "NO_WHITESPACE_REQUIRED_BEFORE$delegate", "STRING_LITERAL_TYPES", "getSTRING_LITERAL_TYPES", "STRING_LITERAL_TYPES$delegate", "calculateIsMinified", "content", "", "isFileMinified", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "isFileContentMinified", "checkAndPersistFileContentMinified", "intellij.javascript.analysis.impl"})
@JvmName(name="JSMinifiedFileUtil")
@SourceDebugExtension(value={"SMAP\nJSMinifiedFileUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSMinifiedFileUtil.kt\ncom/intellij/lang/javascript/JSMinifiedFileUtil\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,120:1\n42#2,3:121\n*S KotlinDebug\n*F\n+ 1 JSMinifiedFileUtil.kt\ncom/intellij/lang/javascript/JSMinifiedFileUtil\n*L\n117#1:121,3\n*E\n"})
public final class JSMinifiedFileUtil {
    @NotNull
    private static final Key<Pair<Long, Boolean>> MINIFIED_STATUS_OF_DOCUMENT_KEY;
    @NotNull
    private static final Key<Pair<Long, Boolean>> MINIFIED_STATUS_OF_FILE_KEY;
    @NotNull
    private static final Lazy NO_WHITESPACE_REQUIRED_AFTER$delegate;
    @NotNull
    private static final Lazy NO_WHITESPACE_REQUIRED_BEFORE$delegate;
    @NotNull
    private static final Lazy STRING_LITERAL_TYPES$delegate;

    private static final TokenSet getNO_WHITESPACE_REQUIRED_AFTER() {
        Lazy lazy = NO_WHITESPACE_REQUIRED_AFTER$delegate;
        return (TokenSet)lazy.getValue();
    }

    private static final TokenSet getNO_WHITESPACE_REQUIRED_BEFORE() {
        Lazy lazy = NO_WHITESPACE_REQUIRED_BEFORE$delegate;
        return (TokenSet)lazy.getValue();
    }

    private static final TokenSet getSTRING_LITERAL_TYPES() {
        Lazy lazy = STRING_LITERAL_TYPES$delegate;
        return (TokenSet)lazy.getValue();
    }

    public static final boolean calculateIsMinified(@NotNull CharSequence content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        ParserDefinition def = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage((Language)JavascriptLanguage.INSTANCE);
        return MinifiedFilesUtil.isMinified((CharSequence)content, (ParserDefinition)def, (TokenSet)JSMinifiedFileUtil.getNO_WHITESPACE_REQUIRED_BEFORE(), (TokenSet)JSMinifiedFileUtil.getNO_WHITESPACE_REQUIRED_AFTER(), (TokenSet)JSMinifiedFileUtil.getSTRING_LITERAL_TYPES());
    }

    public static final boolean isFileMinified(@NotNull VirtualFile file, @NotNull Project project) {
        ThreeState isExplicitlyCompact;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ThreeState threeState = isExplicitlyCompact = JSLibraryManager.getInstance(project).getFileState(file);
        return switch (threeState == null ? -1 : WhenMappings.$EnumSwitchMapping$0[threeState.ordinal()]) {
            case 1 -> true;
            case 2 -> false;
            default -> JSMinifiedFileUtil.isFileContentMinified(file);
        };
    }

    public static final boolean isFileContentMinified(@NotNull VirtualFile file) {
        long documentTimeStamp;
        Document document;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        VirtualFile file2 = file;
        if (file2.isDirectory() || !file2.isValid()) {
            return false;
        }
        if (file2 instanceof HttpVirtualFile) {
            RemoteFileInfo info = ((HttpVirtualFile)file2).getFileInfo();
            if (info == null || info.getState() != RemoteFileState.DOWNLOADED) {
                return false;
            }
            VirtualFile virtualFile = info.getLocalFile();
            if (virtualFile == null) {
                return false;
            }
            file2 = virtualFile;
        }
        Document document2 = document = FileDocumentManager.getInstance().getCachedDocument(file2);
        long l = documentTimeStamp = document2 != null ? document2.getModificationStamp() : -1L;
        if (document != null && FileDocumentManager.getInstance().isDocumentUnsaved(document)) {
            Pair status = (Pair)MINIFIED_STATUS_OF_DOCUMENT_KEY.get((UserDataHolder)document);
            if (status != null && ((Number)status.getFirst()).longValue() == documentTimeStamp) {
                return (Boolean)status.getSecond();
            }
            CharSequence charSequence = document.getCharsSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
            boolean isMinified = JSMinifiedFileUtil.calculateIsMinified(charSequence);
            MINIFIED_STATUS_OF_DOCUMENT_KEY.set((UserDataHolder)document, (Object)new Pair((Object)documentTimeStamp, (Object)isMinified));
            return isMinified;
        }
        Pair status = (Pair)MINIFIED_STATUS_OF_FILE_KEY.get((UserDataHolder)file2);
        long fileTimeStamp = file2.getTimeStamp();
        if (status != null && ((Number)status.getFirst()).longValue() == fileTimeStamp) {
            return (Boolean)status.getSecond();
        }
        boolean isMinified = JSMinifiedFileUtil.checkAndPersistFileContentMinified(file2);
        MINIFIED_STATUS_OF_FILE_KEY.set((UserDataHolder)file2, (Object)new Pair((Object)fileTimeStamp, (Object)isMinified));
        return isMinified;
    }

    private static final boolean checkAndPersistFileContentMinified(VirtualFile file) {
        boolean bl;
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String fileName = string;
        if (FileTypeRegistry.getInstance().getFileTypeByFileName(fileName) != JavaScriptFileType.INSTANCE) {
            return false;
        }
        if (StringsKt.contains$default((CharSequence)fileName, (CharSequence)".min.", (boolean)false, (int)2, null)) {
            bl = true;
        } else if (StringsKt.contains$default((CharSequence)fileName, (CharSequence)".dev.", (boolean)false, (int)2, null)) {
            bl = false;
        } else {
            boolean $i$f$service = false;
            Class<JSMinifiedFileGistService> serviceClass$iv = JSMinifiedFileGistService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            Object object2 = ((JSMinifiedFileGistService)object).getGist().getFileData(null, file);
            Intrinsics.checkNotNull((Object)object2);
            bl = (Boolean)object2;
        }
        return bl;
    }

    private static final TokenSet NO_WHITESPACE_REQUIRED_AFTER_delegate$lambda$0() {
        TokenSet[] tokenSetArray = new TokenSet[3];
        tokenSetArray[0] = TokenSet.andNot((TokenSet)JSTokenTypes.OPERATIONS, (TokenSet)JSKeywordSets.IDENTIFIER_NAMES);
        IElementType[] iElementTypeArray = new IElementType[]{JSTokenTypes.END_OF_LINE_COMMENT};
        tokenSetArray[1] = TokenSet.andNot((TokenSet)JSElementTypes.COMMENTS, (TokenSet)TokenSet.create((IElementType[])iElementTypeArray));
        iElementTypeArray = new IElementType[]{JSTokenTypes.LBRACE, JSTokenTypes.RBRACE, JSTokenTypes.LBRACKET, JSTokenTypes.RBRACKET, JSTokenTypes.LPAR, JSTokenTypes.RPAR, JSTokenTypes.DOT, JSTokenTypes.SEMICOLON, JSTokenTypes.ANY_IDENTIFIER};
        tokenSetArray[2] = TokenSet.create((IElementType[])iElementTypeArray);
        return TokenSet.orSet((TokenSet[])tokenSetArray);
    }

    private static final TokenSet NO_WHITESPACE_REQUIRED_BEFORE_delegate$lambda$0() {
        TokenSet[] tokenSetArray = new TokenSet[]{JSMinifiedFileUtil.getNO_WHITESPACE_REQUIRED_AFTER(), JSElementTypes.COMMENTS, JSTokenTypes.STRING_LITERALS};
        return TokenSet.orSet((TokenSet[])tokenSetArray);
    }

    private static final TokenSet STRING_LITERAL_TYPES_delegate$lambda$0() {
        TokenSet[] tokenSetArray = new TokenSet[2];
        tokenSetArray[0] = JSTokenTypes.STRING_LITERALS;
        IElementType[] iElementTypeArray = new IElementType[]{JSTokenTypes.STRING_TEMPLATE_PART};
        tokenSetArray[1] = TokenSet.create((IElementType[])iElementTypeArray);
        return TokenSet.orSet((TokenSet[])tokenSetArray);
    }

    static {
        Key key = Key.create((String)"js.minified.status.of.document");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        MINIFIED_STATUS_OF_DOCUMENT_KEY = key;
        Key key2 = Key.create((String)"js.cached.minified.of.file");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        MINIFIED_STATUS_OF_FILE_KEY = key2;
        NO_WHITESPACE_REQUIRED_AFTER$delegate = LazyKt.lazy(JSMinifiedFileUtil::NO_WHITESPACE_REQUIRED_AFTER_delegate$lambda$0);
        NO_WHITESPACE_REQUIRED_BEFORE$delegate = LazyKt.lazy(JSMinifiedFileUtil::NO_WHITESPACE_REQUIRED_BEFORE_delegate$lambda$0);
        STRING_LITERAL_TYPES$delegate = LazyKt.lazy(JSMinifiedFileUtil::STRING_LITERAL_TYPES_delegate$lambda$0);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ThreeState.values().length];
            try {
                nArray[ThreeState.YES.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ThreeState.NO.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

