/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSPostfixExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.psi.PsiElement;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JavaScriptInspection;
import com.sixrr.inspectjs.utils.EquivalenceChecker;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JSDuplicateCaseLabelInspection
extends JavaScriptInspection {
    @Override
    @InspectionMessage
    @NotNull
    public String buildErrorString(Object ... args) {
        String string = InspectionJSBundle.message("duplicate.case.label.error.string", new Object[0]);
        if (string == null) {
            JSDuplicateCaseLabelInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSDuplicateCaseLabelInspection", "buildErrorString"));
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitJSSwitchStatement(@NotNull JSSwitchStatement statement) {
            JSCaseClause[] clauses;
            if (statement == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            HashSet<JSExpression> conditions = new HashSet<JSExpression>();
            Visitor.collectCaseLabels(statement, conditions);
            int numConditions = conditions.size();
            if (numConditions < 2) {
                return;
            }
            JSExpression[] conditionArray = conditions.toArray(new JSExpression[numConditions]);
            boolean[] matched = new boolean[conditionArray.length];
            Arrays.fill(matched, false);
            for (int i = 0; i < conditionArray.length; ++i) {
                if (matched[i]) continue;
                JSExpression condition = conditionArray[i];
                for (int j = i + 1; j < conditionArray.length; ++j) {
                    JSExpression testCondition;
                    boolean areEquivalent;
                    if (matched[j] || !(areEquivalent = EquivalenceChecker.expressionsAreEquivalent(condition, testCondition = conditionArray[j]))) continue;
                    this.registerError((PsiElement)testCondition);
                    if (!matched[i]) {
                        this.registerError((PsiElement)condition);
                    }
                    matched[i] = true;
                    matched[j] = true;
                }
            }
            int numDefaults = 0;
            for (JSCaseClause clause : clauses = statement.getCaseClauses()) {
                if (!clause.isDefault()) continue;
                ++numDefaults;
            }
            if (numDefaults <= 1) {
                return;
            }
            for (JSCaseClause clause : clauses) {
                if (!clause.isDefault()) continue;
                this.registerError(clause.getFirstChild());
            }
        }

        private static void collectCaseLabels(@NotNull JSSwitchStatement statement, @NotNull Set<JSExpression> conditions) {
            JSCaseClause[] clauses;
            if (statement == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            if (conditions == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            for (JSCaseClause clause : clauses = statement.getCaseClauses()) {
                JSExpression unparenthesize;
                JSExpression caseExpression;
                if (clause.isDefault() || (caseExpression = clause.getCaseExpression()) == null || (unparenthesize = JSUtils.unparenthesize((JSExpression)caseExpression)) instanceof JSPostfixExpression || unparenthesize instanceof JSPrefixExpression && (unparenthesize.getText().startsWith("++") || unparenthesize.getText().startsWith("--"))) continue;
                conditions.add(caseExpression);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "conditions";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/inspections/JSDuplicateCaseLabelInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSSwitchStatement";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "collectCaseLabels";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

