/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.memberPullUp;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.presentable.Capitalization;
import com.intellij.lang.javascript.presentable.JSNamedElementPresenter;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.refactoring.BaseJSRefactoringHandler;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.javascript.refactoring.memberPullUp.JSPullUpConflictsUtil;
import com.intellij.lang.javascript.refactoring.memberPullUp.JSPullUpDialog;
import com.intellij.lang.javascript.refactoring.memberPullUp.JSPullUpHelper;
import com.intellij.lang.javascript.refactoring.memberPullUp.JSPullUpParameters;
import com.intellij.lang.javascript.refactoring.util.JSInterfaceContainmentVerifier;
import com.intellij.lang.javascript.refactoring.util.JSMemberInfo;
import com.intellij.lang.javascript.refactoring.util.JSMemberInfoStorage;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.RefactoringEventListener;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JSPullUpHandler
extends BaseJSRefactoringHandler
implements JSPullUpDialog.Validator {
    @NonNls
    public static final String REFACTORING_ID = "refactoring.javascript.pull.up";
    private static final Logger LOG = Logger.getInstance((String)JSPullUpHandler.class.getName());
    private final UICallback myUiCallback;
    private static final UICallback DEFAULT_UI_CALLBACK = JSPullUpHandler::showDialog;

    public JSPullUpHandler(@NotNull UICallback uiCallback) {
        if (uiCallback == null) {
            JSPullUpHandler.$$$reportNull$$$0(0);
        }
        super(JSPullUpHandler.getRefactoringName(), JSPullUpHandler.getCannotRefactorReason());
        this.myUiCallback = uiCallback;
    }

    public JSPullUpHandler() {
        super(JSPullUpHandler.getRefactoringName(), JSPullUpHandler.getCannotRefactorReason());
        this.myUiCallback = DEFAULT_UI_CALLBACK;
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        if (project == null) {
            JSPullUpHandler.$$$reportNull$$$0(1);
        }
        if (elements == null) {
            JSPullUpHandler.$$$reportNull$$$0(2);
        }
        if (elements.length != 1) {
            return;
        }
        PsiElement element2 = elements[0];
        Editor editor = dataContext != null ? (Editor)CommonDataKeys.EDITOR.getData(dataContext) : null;
        JSClass aClass = JSPullUpHandler.getClass(element2);
        if (aClass == null) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)JSPullUpHandler.getCannotRefactorReason());
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)JSPullUpHandler.getRefactoringName(), null);
            return;
        }
        JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)aClass, () -> {
            ArrayList<JSClass> bases = new ArrayList<JSClass>(JSInheritanceUtil.findAllParentsForClass((JSClass)aClass, (boolean)false));
            if (bases.isEmpty()) {
                String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"class.does.not.have.base.classes.interfaces.in.current.project", (Object[])new Object[]{new JSNamedElementPresenter((PsiElement)aClass, Capitalization.UpperCase).describeWithQualifiedName()}));
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)JSPullUpHandler.getRefactoringName(), null);
                return;
            }
            bases.sort(Comparator.comparing(JSQualifiedNamedElement::getQualifiedName));
            JSMemberInfoStorage memberInfoStorage = new JSMemberInfoStorage(aClass, (MemberInfoBase.Filter<JSAttributeListOwner>)new MemberInfoBase.EmptyFilter());
            if (element2 instanceof JSElement) {
                JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)element2, () -> {
                    for (JSMemberInfo memberInfo : memberInfoStorage.getClassMemberInfos((PsiElement)aClass)) {
                        memberInfo.setChecked(Collections.singletonList((JSElement)element2));
                    }
                });
            }
            this.myUiCallback.invoke(aClass, bases, memberInfoStorage, this, (Consumer<? super JSPullUpParameters>)((Consumer)JSPullUpHandler::doRefactoring));
        });
    }

    private static void doRefactoring(JSPullUpParameters parameters2) {
        Project project = parameters2.subClass.getProject();
        WriteCommandAction.runWriteCommandAction((Project)project, (String)JSPullUpHandler.getRefactoringName(), null, () -> {
            JSRefactoringUtil.registerRefactoringUndo(project, REFACTORING_ID);
            LocalHistoryAction a = LocalHistory.getInstance().startAction(JSPullUpHandler.getCommandName(parameters2.subClass));
            try {
                try {
                    JSPullUpHandler.beforeInvoke(project, parameters2);
                    new JSPullUpHelper(parameters2).moveMembersToBase();
                }
                finally {
                    a.finish();
                    JSPullUpHandler.afterInvoke(project, parameters2);
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }, (PsiFile[])new PsiFile[0]);
    }

    private static void afterInvoke(@NotNull Project project, @NotNull JSPullUpParameters parameters2) {
        if (project == null) {
            JSPullUpHandler.$$$reportNull$$$0(3);
        }
        if (parameters2 == null) {
            JSPullUpHandler.$$$reportNull$$$0(4);
        }
        RefactoringEventData eventData = new RefactoringEventData();
        eventData.addElement((PsiElement)parameters2.superClass);
        ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone(REFACTORING_ID, eventData);
    }

    private static void beforeInvoke(@NotNull Project project, @NotNull JSPullUpParameters parameters2) {
        if (project == null) {
            JSPullUpHandler.$$$reportNull$$$0(5);
        }
        if (parameters2 == null) {
            JSPullUpHandler.$$$reportNull$$$0(6);
        }
        RefactoringEventData eventData = new RefactoringEventData();
        eventData.addElement((PsiElement)parameters2.subClass);
        eventData.addMembers((Object[])parameters2.members, MemberInfoBase::getMember);
        ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringStarted(REFACTORING_ID, eventData);
    }

    @NlsContexts.Label
    @NotNull
    private static String getCommandName(JSClass subClass) {
        String string = RefactoringBundle.message((String)"pullUp.command", (Object[])new Object[]{DescriptiveNameUtil.getDescriptiveName((PsiElement)subClass)});
        if (string == null) {
            JSPullUpHandler.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @NotNull
    public MultiMap<PsiElement, String> checkConflicts(JSPullUpParameters parameters2, JSInterfaceContainmentVerifier interfaceContainmentVerifier) {
        if (!JSPullUpHandler.checkWritable(parameters2.superClass, parameters2.members)) {
            return new MultiMap();
        }
        MultiMap<PsiElement, String> multiMap = JSPullUpConflictsUtil.checkConflicts(parameters2.members, parameters2.subClass, parameters2.superClass, interfaceContainmentVerifier, JSVisibilityUtil.DEFAULT_OPTIONS);
        if (multiMap == null) {
            JSPullUpHandler.$$$reportNull$$$0(8);
        }
        return multiMap;
    }

    private static boolean checkWritable(JSClass superClass, JSMemberInfo[] infos) {
        if (!JSRefactoringUtil.checkReadOnlyStatus((PsiElement)superClass, null, JSPullUpHandler.getRefactoringName())) {
            return false;
        }
        for (JSMemberInfo info : infos) {
            if (info.getMember() instanceof JSClass && info.getOverrides() != null || JSRefactoringUtil.checkReadOnlyStatus(info.getMember(), null, JSPullUpHandler.getRefactoringName())) continue;
            return false;
        }
        return true;
    }

    private static void showDialog(@NotNull JSClass subclass, @NotNull List<JSClass> superClasses, @NotNull JSMemberInfoStorage memberInfoStorage, @NotNull JSPullUpDialog.Validator validator, Consumer<? super JSPullUpParameters> parametersConsumer) {
        JSPullUpDialog dialog;
        if (subclass == null) {
            JSPullUpHandler.$$$reportNull$$$0(9);
        }
        if (superClasses == null) {
            JSPullUpHandler.$$$reportNull$$$0(10);
        }
        if (memberInfoStorage == null) {
            JSPullUpHandler.$$$reportNull$$$0(11);
        }
        if (validator == null) {
            JSPullUpHandler.$$$reportNull$$$0(12);
        }
        if (!(dialog = new JSPullUpDialog(subclass, superClasses, memberInfoStorage, validator)).showAndGet()) {
            return;
        }
        parametersConsumer.consume((Object)dialog.getParameters());
    }

    @NlsContexts.DialogMessage
    @NotNull
    private static String getCannotRefactorReason() {
        String string = RefactoringBundle.message((String)"the.caret.should.be.positioned.inside.a.class.to.pull.members.from");
        if (string == null) {
            JSPullUpHandler.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NlsContexts.DialogTitle
    @NotNull
    public static String getRefactoringName() {
        String string = RefactoringBundle.message((String)"pull.members.up.title");
        if (string == null) {
            JSPullUpHandler.$$$reportNull$$$0(14);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiCallback";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 7: 
            case 8: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/memberPullUp/JSPullUpHandler";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subclass";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClasses";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberInfoStorage";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/memberPullUp/JSPullUpHandler";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "checkConflicts";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCannotRefactorReason";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefactoringName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "afterInvoke";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "beforeInvoke";
                break;
            }
            case 7: 
            case 8: 
            case 13: 
            case 14: {
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "showDialog";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 13, 14 -> new IllegalStateException(string);
        };
    }

    public static interface UICallback {
        public void invoke(@NotNull JSClass var1, @NotNull List<JSClass> var2, @NotNull JSMemberInfoStorage var3, @NotNull JSPullUpDialog.Validator var4, @NotNull Consumer<? super JSPullUpParameters> var5);
    }
}

