/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.intellij.lang.javascript.service.TypeScriptServiceOutOfMemoryServiceKt;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.TypeScriptServiceRestarter;
import com.intellij.lang.typescript.compiler.ui.NotificationOutcomeScope;
import com.intellij.lang.typescript.compiler.ui.TypeScriptServiceOutOfMemoryOutcomeKt;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.ui.EditorNotifications;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0010J\u0018\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0011H\u0002J\u0006\u0010\u0018\u001a\u00020\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/lang/javascript/service/TypeScriptServiceOutOfMemoryService;", "", "project", "Lcom/intellij/openapi/project/Project;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "settings", "Lcom/intellij/lang/typescript/compiler/TypeScriptCompilerSettings;", "getSettings", "()Lcom/intellij/lang/typescript/compiler/TypeScriptCompilerSettings;", "outOfMemoryCounters", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "silentRestartLimit", "notifyOutOfMemory", "", "serviceId", "restartSilently", "counter", "resetAll", "intellij.javascript.backend"})
@ApiStatus.Internal
public final class TypeScriptServiceOutOfMemoryService {
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final ConcurrentHashMap<String, Integer> outOfMemoryCounters;
    private final int silentRestartLimit;

    public TypeScriptServiceOutOfMemoryService(@NotNull Project project, @NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.project = project;
        this.cs = cs;
        this.outOfMemoryCounters = new ConcurrentHashMap();
        this.silentRestartLimit = 2;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final TypeScriptCompilerSettings getSettings() {
        return TypeScriptCompilerSettings.Companion.getSettings(this.project);
    }

    public final void notifyOutOfMemory(@NotNull String serviceId) {
        Intrinsics.checkNotNullParameter((Object)serviceId, (String)"serviceId");
        Integer n = this.outOfMemoryCounters.compute(serviceId, (arg_0, arg_1) -> TypeScriptServiceOutOfMemoryService.notifyOutOfMemory$lambda$1(TypeScriptServiceOutOfMemoryService::notifyOutOfMemory$lambda$0, arg_0, arg_1));
        Intrinsics.checkNotNull((Object)n);
        int counter = ((Number)n).intValue();
        if (counter <= this.silentRestartLimit) {
            BuildersKt.launch$default((CoroutineScope)this.cs, (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(counter, this, serviceId, null){
                int label;
                final /* synthetic */ int $counter;
                final /* synthetic */ TypeScriptServiceOutOfMemoryService this$0;
                final /* synthetic */ String $serviceId;
                {
                    this.$counter = $counter;
                    this.this$0 = $receiver;
                    this.$serviceId = $serviceId;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            v0 = DelayKt.delay((long)(100L * (long)this.$counter * (long)this.$counter), (Continuation)((Continuation)this));
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            TypeScriptServiceOutOfMemoryService.access$restartSilently(this.this$0, this.$serviceId, this.$counter);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        } else {
            if (this.getSettings().getMemoryAutoIncrease()) {
                TypeScriptServiceOutOfMemoryServiceKt.access$getLogger$p().info("Restarting " + serviceId + " service with increased memory after an OOM crash");
            } else {
                TypeScriptServiceOutOfMemoryServiceKt.access$getLogger$p().info("Won't restart " + serviceId + " service silently after an OOM crash, attempt limit exceeded");
            }
            TypeScriptServiceOutOfMemoryOutcomeKt.buildOutcome(new NotificationOutcomeScope(this.project), this.project);
            EditorNotifications.getInstance((Project)this.project).updateAllNotifications();
        }
    }

    private final void restartSilently(String serviceId, int counter) {
        HashMap old = new HashMap(this.outOfMemoryCounters);
        TypeScriptServiceOutOfMemoryServiceKt.access$getLogger$p().info("Restarting " + serviceId + " service silently after an OOM crash, attempt " + counter + " of " + this.silentRestartLimit);
        TypeScriptServiceRestarter.restartServices(this.project);
        Logger logger = TypeScriptServiceOutOfMemoryServiceKt.access$getLogger$p();
        Set set = old.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        logger.debug("Restoring OOM crash counters for all services: " + CollectionsKt.joinToString$default((Iterable)set, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
        this.outOfMemoryCounters.clear();
        this.outOfMemoryCounters.putAll(old);
    }

    public final void resetAll() {
        EditorNotifications.getInstance((Project)this.project).updateAllNotifications();
        if (this.outOfMemoryCounters.isEmpty()) {
            return;
        }
        Logger logger = TypeScriptServiceOutOfMemoryServiceKt.access$getLogger$p();
        Set set = this.outOfMemoryCounters.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
        logger.debug("Resetting OOM crash counters for all services: " + CollectionsKt.joinToString$default((Iterable)set, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
        this.outOfMemoryCounters.clear();
    }

    private static final Integer notifyOutOfMemory$lambda$0(String string, Integer value) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        Integer n = value;
        return (n != null ? n : 0) + 1;
    }

    private static final Integer notifyOutOfMemory$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return (Integer)$tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ void access$restartSilently(TypeScriptServiceOutOfMemoryService $this, String serviceId, int counter) {
        $this.restartSilently(serviceId, counter);
    }
}

