/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service.protocol;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.ide.trustedProjects.TrustedProjects;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.nodejs.execution.NodeTargetRunOptions;
import com.intellij.javascript.nodejs.execution.ProcessWithCmdLine;
import com.intellij.javascript.nodejs.interpreter.NodeCommandLineConfigurator;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceTracerUtilKt;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.JSLanguageServiceUtilKt;
import com.intellij.lang.javascript.service.JSNodeServicesProfilerActionKt;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswerConsumer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceCommand;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceInitialState;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceObject;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceProtocol;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceRemoteHelper;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceRequest;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.diagnostic.telemetry.IJTracer;
import com.intellij.platform.lsp.impl.logging.LanguageServiceLogger;
import com.intellij.platform.lsp.impl.logging.LanguageServiceLoggerService;
import com.intellij.util.Consumer;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BaseOutputReader;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.Scope;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Deprecated;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.FunctionReferenceImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0090\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u0000 \u0082\u00012\u00020\u0001:\u0007\u007f\u0080\u0001\u0081\u0001\u0082\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u001d\b\u0017\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u000b\u00a2\u0006\u0004\b\b\u0010\fJ.\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0014\u00101\u001a\u0010\u0012\f\u0012\n\u0018\u000103j\u0004\u0018\u0001`4022\u0006\u00105\u001a\u000206H\u0004J\b\u00107\u001a\u00020#H\u0002J\u0010\u00108\u001a\u0002092\u0006\u0010\"\u001a\u00020#H\u0014J\u0010\u0010:\u001a\u00020;2\u0006\u0010\n\u001a\u00020\u0005H\u0014J\u0010\u0010D\u001a\u0002092\u0006\u0010\"\u001a\u00020#H\u0014J\u0012\u0010K\u001a\u0002092\b\u0010L\u001a\u0004\u0018\u00010MH\u0016J\u0010\u0010N\u001a\u00020\u00032\u0006\u0010O\u001a\u00020\u0003H\u0004J\b\u0010P\u001a\u000200H\u0016J\u0018\u0010Q\u001a\u0004\u0018\u00010R2\u0006\u0010/\u001a\u000200H\u0096@\u00a2\u0006\u0002\u0010SJ\u0010\u0010T\u001a\u0002092\u0006\u0010/\u001a\u000200H\u0002J\u0010\u0010U\u001a\u0002092\u0006\u0010V\u001a\u00020WH\u0002J\u0018\u0010X\u001a\u0002092\u0006\u0010Y\u001a\u00020Z2\u0006\u0010V\u001a\u00020WH\u0014J\b\u0010[\u001a\u000209H\u0002J\b\u0010\\\u001a\u00020.H\u0014J\b\u0010]\u001a\u00020^H$J\"\u0010_\u001a\u00020M2\u0006\u0010O\u001a\u00020`2\u0006\u0010a\u001a\u00020b2\b\u0010c\u001a\u0004\u0018\u00010\u001cH\u0016J \u0010d\u001a\u00020\u00032\u0006\u0010O\u001a\u00020`2\u0006\u0010a\u001a\u00020b2\u0006\u0010\u001d\u001a\u00020\u001bH\u0004J2\u0010h\u001a\u0002092\u0006\u0010i\u001a\u00020j2\n\u0010k\u001a\u0006\u0012\u0002\b\u00030l2\f\u0010m\u001a\b\u0012\u0004\u0012\u00020.0n2\u0006\u0010o\u001a\u00020pH\u0004J\u0010\u0010q\u001a\u0002092\u0006\u0010a\u001a\u00020\u0003H\u0004J\u0012\u0010r\u001a\u0004\u0018\u00010\u00032\u0006\u0010s\u001a\u00020tH\u0004J\u0010\u0010r\u001a\u00020\u00032\u0006\u0010u\u001a\u00020\u0003H\u0004J\u0010\u0010v\u001a\u0002092\u0006\u0010w\u001a\u00020\u0003H\u0007J\b\u0010x\u001a\u000209H\u0007J\b\u0010y\u001a\u000209H\u0016J\u0016\u0010z\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010{2\u0006\u0010|\u001a\u00020\u0003J\u0016\u0010}\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010{2\u0006\u0010~\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u0004\u001a\u00020\u00058\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00078\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000f\u0010\u0010R\u0015\u0010\u0011\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u00020\u00148\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001a8\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u001d\u001a\u00020\u001e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\u0004\u0018\u00010%8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010&\u001a\u0004\u0018\u00010'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020*0)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010+\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u000eR\u0016\u0010<\u001a\u0004\u0018\u00010\u00038TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b=\u0010\u000eR\u0016\u0010>\u001a\u0004\u0018\u00010?8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b@\u0010AR\u0014\u0010B\u001a\u00020?8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\bC\u0010AR\u0014\u0010E\u001a\u00020\u00038DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\bF\u0010\u000eR\u0014\u0010G\u001a\u00020H8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\bI\u0010JR\u0014\u0010e\u001a\u00020\u001b8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\bf\u0010g\u00a8\u0006\u0083\u0001"}, d2={"Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceNodeStdProtocolBase;", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceProtocol;", "serviceName", "", "myProject", "Lcom/intellij/openapi/project/Project;", "readyConsumer", "Ljava/util/function/Consumer;", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;Ljava/util/function/Consumer;)V", "project", "Lcom/intellij/util/Consumer;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/util/Consumer;)V", "getServiceName", "()Ljava/lang/String;", "getReadyConsumer$annotations", "()V", "myInitializeError", "Lorg/jetbrains/annotations/Nls;", "mySessionId", "", "mySeq", "Ljava/util/concurrent/atomic/AtomicInteger;", "myProcessInput", "Ljava/io/OutputStream;", "myCallbacks", "Ljava/util/concurrent/ConcurrentMap;", "", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceAnswerConsumer;", "value", "Lcom/google/gson/Gson;", "gson", "getGson", "()Lcom/google/gson/Gson;", "targetRun", "Lcom/intellij/javascript/nodejs/execution/NodeTargetRun;", "myRemoteHelper", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceRemoteHelper;", "lsCommunicationLogger", "Lcom/intellij/platform/lsp/impl/logging/LanguageServiceLogger;", "myCommandTelemetryInfo", "", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceNodeStdProtocolBase$CommandTelemetryInfo;", "initializeError", "getInitializeError", "waitingReadyNotification", "", "processHandler", "Lcom/intellij/execution/process/ProcessHandler;", "action", "Lcom/intellij/util/ThrowableRunnable;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "checker", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceNodeStdProtocolBase$ReadyChecker;", "createTargetRun", "prepareTargetRun", "", "getNodeCommandLineConfiguratorOptions", "Lcom/intellij/javascript/nodejs/interpreter/NodeCommandLineConfigurator$Options;", "workingDirectory", "getWorkingDirectory", "interpreter", "Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreter;", "getInterpreter", "()Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreter;", "interpreterOrFail", "getInterpreterOrFail", "addNodeProcessAdditionalArguments", "sessionIdParam", "getSessionIdParam", "entryPointFolder", "Ljava/io/File;", "getEntryPointFolder", "()Ljava/io/File;", "cancelCommand", "cancellationToken", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceProtocol$CancellationToken;", "toSystemCommand", "command", "connect", "awaitReadyNotification", "Lcom/google/gson/JsonObject;", "(Lcom/intellij/execution/process/ProcessHandler;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "registerResponseHandlers", "processText", "text", "", "processAnswer", "answer", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceAnswer;", "sendInitialState", "needReadActionToCreateState", "createState", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceInitialState;", "sendCommand", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceCommand;", "data", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceObject;", "resultConsumer", "getWritableString", "uniqueCommandId", "getUniqueCommandId", "()I", "checkReadyCommand", "event", "Lcom/intellij/execution/process/ProcessEvent;", "outputType", "Lcom/intellij/openapi/util/Key;", "result", "Lcom/intellij/openapi/util/Ref;", "countDownLatch", "Ljava/util/concurrent/CountDownLatch;", "writeln", "getFilePath", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "path", "startMessageStreamLogging", "logFileName", "stopMessageStreamLogging", "dispose", "convertTargetPathToLocal", "Ljava/util/concurrent/CompletableFuture;", "targetPath", "convertLocalPathToTarget", "localPath", "ReadyChecker", "CommandIdCancellationToken", "CommandTelemetryInfo", "Companion", "intellij.javascript.backend"})
@SourceDebugExtension(value={"SMAP\nJSLanguageServiceNodeStdProtocolBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSLanguageServiceNodeStdProtocolBase.kt\ncom/intellij/lang/javascript/service/protocol/JSLanguageServiceNodeStdProtocolBase\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,604:1\n106#2:605\n78#2,22:606\n1#3:628\n216#4,2:629\n*S KotlinDebug\n*F\n+ 1 JSLanguageServiceNodeStdProtocolBase.kt\ncom/intellij/lang/javascript/service/protocol/JSLanguageServiceNodeStdProtocolBase\n*L\n445#1:605\n445#1:606,22\n490#1:629,2\n*E\n"})
public abstract class JSLanguageServiceNodeStdProtocolBase
implements JSLanguageServiceProtocol {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String serviceName;
    @JvmField
    @NotNull
    protected final Project myProject;
    @Nullable
    private final java.util.function.Consumer<?> readyConsumer;
    @Nullable
    private volatile String myInitializeError;
    @JvmField
    protected final long mySessionId;
    @NotNull
    private final AtomicInteger mySeq;
    @Nullable
    private OutputStream myProcessInput;
    @JvmField
    @NotNull
    protected final ConcurrentMap<Integer, JSLanguageServiceAnswerConsumer> myCallbacks;
    @NotNull
    private Gson gson;
    @Nullable
    private NodeTargetRun targetRun;
    @JvmField
    @Nullable
    protected volatile JSLanguageServiceRemoteHelper myRemoteHelper;
    @Nullable
    private final LanguageServiceLogger lsCommunicationLogger;
    @NotNull
    private final Map<Integer, CommandTelemetryInfo> myCommandTelemetryInfo;
    @NotNull
    protected static final String ANSWER_READY = "ready";
    @NotNull
    protected static final String ANSWER_ERROR = "error";
    @NotNull
    private static final byte[] NEW_LINE;
    @NotNull
    private static final BaseOutputReader.Options PROCESS_READER_OPTIONS;

    public JSLanguageServiceNodeStdProtocolBase(@NotNull String serviceName, @NotNull Project myProject, @Nullable java.util.function.Consumer<?> readyConsumer) {
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        this.serviceName = serviceName;
        this.myProject = myProject;
        this.readyConsumer = readyConsumer;
        this.mySessionId = System.currentTimeMillis();
        this.mySeq = new AtomicInteger();
        this.myCallbacks = new ConcurrentHashMap();
        this.gson = JSLanguageServiceQueue.SharedGson.GSON;
        this.lsCommunicationLogger = LanguageServiceLoggerService.Companion.isDebugLogEnabled() ? LanguageServiceLoggerService.connect$default((LanguageServiceLoggerService)LanguageServiceLoggerService.Companion.getInstance(), (String)this.serviceName, (boolean)false, (int)2, null) : null;
        this.myCommandTelemetryInfo = new ConcurrentHashMap();
    }

    public /* synthetic */ JSLanguageServiceNodeStdProtocolBase(String string, Project project, java.util.function.Consumer consumer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            consumer = null;
        }
        this(string, project, consumer);
    }

    @NotNull
    public final String getServiceName() {
        return this.serviceName;
    }

    @Deprecated(message="Use the result of awaitReadyNotification call")
    private static /* synthetic */ void getReadyConsumer$annotations() {
    }

    @Deprecated(message="Service name should be provided")
    public JSLanguageServiceNodeStdProtocolBase(@NotNull Project project, @NotNull Consumer<?> readyConsumer) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(readyConsumer, (String)"readyConsumer");
        this("unknown-js-language-service", project, (java.util.function.Consumer)readyConsumer);
    }

    @NotNull
    public final Gson getGson() {
        return this.gson;
    }

    @Override
    @Nullable
    public String getInitializeError() {
        return this.myInitializeError;
    }

    protected final boolean waitingReadyNotification(@NotNull ProcessHandler processHandler, @NotNull ThrowableRunnable<Exception> action, @NotNull ReadyChecker checker) {
        Intrinsics.checkNotNullParameter((Object)processHandler, (String)"processHandler");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)checker, (String)"checker");
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Ref result2 = new Ref((Object)false);
        ProcessListener listener2 = new ProcessListener(countDownLatch, checker, (Ref<Boolean>)result2){
            final /* synthetic */ CountDownLatch $countDownLatch;
            final /* synthetic */ ReadyChecker $checker;
            final /* synthetic */ Ref<Boolean> $result;
            {
                this.$countDownLatch = $countDownLatch;
                this.$checker = $checker;
                this.$result = $result;
            }

            public void onTextAvailable(ProcessEvent event, Key<?> outputType) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                if (this.$countDownLatch.getCount() > 0L) {
                    this.$checker.check(event, outputType, this.$result, this.$countDownLatch);
                }
            }

            public void processTerminated(ProcessEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.$countDownLatch.countDown();
            }
        };
        processHandler.addProcessListener(listener2);
        action.run();
        JSLanguageServiceQueue.Holder.LOGGER.debug("Start waiting for ready start");
        if (JSLanguageServiceUtil.TIMEOUT_DISABLED) {
            countDownLatch.await();
        } else {
            countDownLatch.await(100L, TimeUnit.SECONDS);
        }
        JSLanguageServiceQueue.Holder.LOGGER.debug("End waiting for process starting. Result " + result2.get());
        processHandler.removeProcessListener(listener2);
        Object object = result2.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Boolean)object;
    }

    private final NodeTargetRun createTargetRun() throws ExecutionException {
        NodeJsInterpreter interpreter2 = this.getInterpreterOrFail();
        NodeTargetRun targetRun = new NodeTargetRun(interpreter2, this.myProject, null, NodeTargetRunOptions.Companion.of(false, null, JSLanguageServiceNodeStdProtocolBase::createTargetRun$lambda$0), null, 16, null);
        Gson gson = JSLanguageServiceUtil.createGson(targetRun);
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"createGson(...)");
        this.gson = gson;
        this.prepareTargetRun(targetRun);
        return targetRun;
    }

    protected void prepareTargetRun(@NotNull NodeTargetRun targetRun) {
        Intrinsics.checkNotNullParameter((Object)targetRun, (String)"targetRun");
        TargetedCommandLineBuilder commandLineBuilder = targetRun.getCommandLineBuilder();
        this.addNodeProcessAdditionalArguments(targetRun);
        File file = new File(this.getEntryPointFolder(), Companion.getEntryPointFile());
        if (!file.exists()) {
            throw new RuntimeException("Cannot find resource start point: " + file.getAbsolutePath());
        }
        String string = this.getWorkingDirectory();
        Intrinsics.checkNotNull((Object)string);
        commandLineBuilder.setWorkingDirectory(targetRun.path(string));
        if (JSNodeServicesProfilerActionKt.isNodeServicesProfilerEnabled(this.myProject)) {
            commandLineBuilder.addParameter("--prof");
        }
        String string2 = file.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAbsolutePath(...)");
        commandLineBuilder.addParameter(targetRun.path(string2));
        commandLineBuilder.addParameter(this.getSessionIdParam());
        commandLineBuilder.addParameter("-debug-name=" + this.serviceName);
    }

    @NotNull
    protected NodeCommandLineConfigurator.Options getNodeCommandLineConfiguratorOptions(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        NodeCommandLineConfigurator.Options options = NodeCommandLineConfigurator.emptyOptions(this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)options, (String)"emptyOptions(...)");
        return options;
    }

    @Nullable
    protected String getWorkingDirectory() {
        return this.myProject.getBasePath();
    }

    @Nullable
    protected NodeJsInterpreter getInterpreter() {
        return NodeJsInterpreterManager.getInstance(this.myProject).getInterpreter();
    }

    @NotNull
    protected final NodeJsInterpreter getInterpreterOrFail() {
        NodeJsInterpreter interpreter2 = this.getInterpreter();
        if (interpreter2 == null) {
            this.myInitializeError = JavaScriptBundle.message((String)"javascript.service.node.error", (Object[])new Object[0]);
            throw new RuntimeException(this.getInitializeError());
        }
        return interpreter2;
    }

    protected void addNodeProcessAdditionalArguments(@NotNull NodeTargetRun targetRun) {
        Intrinsics.checkNotNullParameter((Object)targetRun, (String)"targetRun");
        String systemProp = System.getProperty("idea.javascript.language.service.debug.options." + this.serviceName);
        JSLanguageServiceUtil.addNodeProcessArguments(targetRun.getCommandLineBuilder(), this.serviceName, systemProp);
    }

    @NotNull
    protected final String getSessionIdParam() {
        return "-id=" + this.mySessionId;
    }

    @NotNull
    protected final File getEntryPointFolder() {
        File file = JSLanguageServiceUtil.getPluginStarterDirectory();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getPluginStarterDirectory(...)");
        return file;
    }

    @Override
    public void cancelCommand(@Nullable JSLanguageServiceProtocol.CancellationToken cancellationToken) {
        JSLanguageServiceProtocol.CancellationToken cancellationToken2 = cancellationToken;
        if (cancellationToken2 instanceof CommandIdCancellationToken) {
            JSLanguageServiceAnswerConsumer jSLanguageServiceAnswerConsumer = (JSLanguageServiceAnswerConsumer)this.myCallbacks.remove(((CommandIdCancellationToken)cancellationToken).id());
            if (jSLanguageServiceAnswerConsumer != null) {
                jSLanguageServiceAnswerConsumer.consume(null);
            }
        } else if (cancellationToken2 != null) {
            throw new IllegalStateException(cancellationToken.getClass().toString());
        }
    }

    @NotNull
    protected final String toSystemCommand(@NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        return this.mySessionId + " " + command;
    }

    @Override
    @NotNull
    public ProcessHandler connect() {
        if (!TrustedProjects.isProjectTrusted((Project)this.myProject)) {
            throw new IllegalStateException("Project is not trusted");
        }
        NodeTargetRun nodeTargetRun = this.targetRun = this.createTargetRun();
        Intrinsics.checkNotNull((Object)nodeTargetRun);
        ProcessWithCmdLine processWithCmdLine = nodeTargetRun.startProcessEx();
        ProcessHandler processHandler = (ProcessHandler)processWithCmdLine.getProcessHandler();
        if (JSLanguageServiceQueue.Holder.LOGGER.isDebugEnabled()) {
            JSLanguageServiceQueue.Holder.LOGGER.debug("Command line: " + processWithCmdLine.getCommandLinePresentation());
        }
        JSLanguageServiceQueue.Holder.LOGGER.debug("Language service was started. Start initialization of the plugin");
        return processHandler;
    }

    @Override
    @Nullable
    public Object awaitReadyNotification(@NotNull ProcessHandler processHandler, @NotNull Continuation<? super JsonObject> $completion) {
        return JSLanguageServiceNodeStdProtocolBase.awaitReadyNotification$suspendImpl(this, processHandler, $completion);
    }

    static /* synthetic */ Object awaitReadyNotification$suspendImpl(JSLanguageServiceNodeStdProtocolBase $this, ProcessHandler processHandler, Continuation<? super JsonObject> $completion) {
        $this.myProcessInput = processHandler.getProcessInput();
        AtomicReference readyNotification2 = new AtomicReference();
        try {
            if (!$this.waitingReadyNotification(processHandler, (ThrowableRunnable<Exception>)((ThrowableRunnable)() -> ((ProcessHandler)processHandler).startNotify()), new ReadyChecker($this){
                final /* synthetic */ JSLanguageServiceNodeStdProtocolBase $tmp0;
                {
                    this.$tmp0 = $tmp0;
                }

                public final void check(ProcessEvent p0, Key<?> p1, Ref<Boolean> p2, CountDownLatch p3) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    Intrinsics.checkNotNullParameter(p1, (String)"p1");
                    Intrinsics.checkNotNullParameter(p2, (String)"p2");
                    Intrinsics.checkNotNullParameter((Object)p3, (String)"p3");
                    this.$tmp0.checkReadyCommand(p0, p1, p2, p3);
                }

                public final Function<?> getFunctionDelegate() {
                    return (Function)new FunctionReferenceImpl(4, (Object)this.$tmp0, JSLanguageServiceNodeStdProtocolBase.class, "checkReadyCommand", "checkReadyCommand(Lcom/intellij/execution/process/ProcessEvent;Lcom/intellij/openapi/util/Key;Lcom/intellij/openapi/util/Ref;Ljava/util/concurrent/CountDownLatch;)V", 0);
                }

                public final boolean equals(Object other) {
                    return other instanceof ReadyChecker ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
                }

                public final int hashCode() {
                    return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
                }
            })) {
                processHandler.destroyProcess();
                $this.myInitializeError = JavaScriptBundle.message((String)"javascript.language.service.cannot.start", (Object[])new Object[0]);
                return null;
            }
            if (!$this.waitingReadyNotification(processHandler, (ThrowableRunnable<Exception>)((ThrowableRunnable)$this::sendInitialState), (arg_0, arg_1, arg_2, arg_3) -> JSLanguageServiceNodeStdProtocolBase.awaitReadyNotification$lambda$0(readyNotification2, $this, processHandler, arg_0, arg_1, arg_2, arg_3))) {
                processHandler.destroyProcess();
                $this.myInitializeError = JavaScriptBundle.message((String)"javascript.language.service.cannot.start", (Object[])new Object[0]);
                return null;
            }
        }
        catch (Throwable e) {
            processHandler.destroyProcess();
            String string = e.getMessage();
            if (string == null) {
                String string2 = JavaScriptBundle.message((String)"javascript.language.service.cannot.start", (Object[])new Object[0]);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            }
            $this.myInitializeError = string;
            throw e;
        }
        return readyNotification2.get();
    }

    private final void registerResponseHandlers(ProcessHandler processHandler) {
        LanguageServiceLogger logger = this.lsCommunicationLogger;
        if (logger != null) {
            processHandler.addProcessListener(new ProcessListener(logger){
                final /* synthetic */ LanguageServiceLogger $logger;
                {
                    this.$logger = $logger;
                }

                public void onTextAvailable(ProcessEvent event, Key<?> outputType) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                    String string = event.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    CharSequence charSequence = com.intellij.lang.javascript.service.protocol.JSLanguageServiceNodeStdProtocolBase$Companion.access$trimToCharSequence(JSLanguageServiceNodeStdProtocolBase.Companion, string);
                    if (!StringUtil.isEmpty((CharSequence)charSequence)) {
                        if (outputType == ProcessOutputTypes.STDOUT && charSequence.charAt(0) == '{' && charSequence.charAt(charSequence.length() - 1) == '}') {
                            this.$logger.logInbound(charSequence);
                        } else if (outputType == ProcessOutputTypes.STDERR) {
                            this.$logger.logError(charSequence);
                        }
                    }
                }
            });
        }
        processHandler.addProcessListener(new ProcessListener(this){
            final /* synthetic */ JSLanguageServiceNodeStdProtocolBase this$0;
            {
                this.this$0 = $receiver;
            }

            public void onTextAvailable(ProcessEvent event, Key<?> outputType) {
                String text;
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                if (outputType == ProcessOutputTypes.STDOUT && !StringUtil.isEmpty((String)(text = event.getText()))) {
                    Intrinsics.checkNotNull((Object)text);
                    JSLanguageServiceNodeStdProtocolBase.access$processText(this.this$0, com.intellij.lang.javascript.service.protocol.JSLanguageServiceNodeStdProtocolBase$Companion.access$trimToCharSequence(JSLanguageServiceNodeStdProtocolBase.Companion, text));
                }
            }
        });
    }

    private final void processText(CharSequence text) {
        if (text.length() >= 2 && text.charAt(0) == '{' && text.charAt(text.length() - 1) == '}') {
            JSLanguageServiceAnswer answer2 = null;
            try {
                answer2 = new JSLanguageServiceAnswer(text);
            }
            catch (Exception e) {
                JSLanguageServiceQueue.Holder.LOGGER.error("Cannot parse answer for protocol: " + this.getClass().getName() + ", text:\n" + JSLanguageServiceNodeStdProtocolBase.Companion.truncateText(text), (Throwable)e);
            }
            if (answer2 == null) {
                return;
            }
            this.processAnswer(answer2, text);
        }
    }

    protected void processAnswer(@NotNull JSLanguageServiceAnswer answer2, @NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)answer2, (String)"answer");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Integer seq = answer2.getSeq();
        if (seq != null) {
            JSLanguageServiceAnswerConsumer consumer = (JSLanguageServiceAnswerConsumer)this.myCallbacks.remove(seq);
            if (consumer != null) {
                if (JSLanguageServiceQueue.Holder.LOGGER.isDebugEnabled()) {
                    JSLanguageServiceQueue.Holder.LOGGER.debug(this.getClass().getSimpleName() + " Pass request " + seq + " to consumer");
                }
                consumer.consume(answer2);
            } else if (JSLanguageServiceQueue.Holder.LOGGER.isDebugEnabled()) {
                JSLanguageServiceQueue.Holder.LOGGER.debug(this.getClass().getSimpleName() + " No callback for seq: " + text);
            }
        } else if (JSLanguageServiceQueue.Holder.LOGGER.isDebugEnabled()) {
            JSLanguageServiceQueue.Holder.LOGGER.debug(this.getClass().getSimpleName() + " No sequence number, skip request: " + text);
        }
    }

    private final void sendInitialState() {
        JSLanguageServiceInitialState initialState2 = this.needReadActionToCreateState() ? (JSLanguageServiceInitialState)ReadAction.compute(() -> JSLanguageServiceNodeStdProtocolBase.sendInitialState$lambda$0(this)) : this.createState();
        String state = this.gson.toJson((Object)initialState2);
        JSLanguageServiceQueue.Holder.LOGGER.debug(this.getClass().getName() + " Send state to service: " + state);
        Intrinsics.checkNotNull((Object)state);
        this.writeln(state);
    }

    protected boolean needReadActionToCreateState() {
        return true;
    }

    @NotNull
    protected abstract JSLanguageServiceInitialState createState();

    @Override
    @NotNull
    public JSLanguageServiceProtocol.CancellationToken sendCommand(@NotNull JSLanguageServiceCommand command, @NotNull JSLanguageServiceObject data2, @Nullable JSLanguageServiceAnswerConsumer resultConsumer) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        int commandId = this.getUniqueCommandId();
        if (command.isResponseExpected()) {
            this.myCommandTelemetryInfo.put(commandId, new CommandTelemetryInfo(command, this.myCallbacks.get(commandId - 1) != null));
            ((Map)this.myCallbacks).put(commandId, arg_0 -> JSLanguageServiceNodeStdProtocolBase.sendCommand$lambda$0(this, commandId, resultConsumer, arg_0));
        }
        String request2 = this.getWritableString(command, data2, commandId);
        this.writeln(request2);
        if (!command.isResponseExpected() && resultConsumer != null) {
            resultConsumer.consume(null);
        }
        return new CommandIdCancellationToken(commandId);
    }

    @NotNull
    protected final String getWritableString(@NotNull JSLanguageServiceCommand command, @NotNull JSLanguageServiceObject data2, int value) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        JSLanguageServiceRequest toSend = new JSLanguageServiceRequest(command, data2, this.mySessionId, value);
        String request2 = this.gson.toJson((Object)toSend);
        if (JSLanguageServiceQueue.Holder.LOGGER.isTraceEnabled()) {
            Intrinsics.checkNotNull((Object)request2);
            CharSequence toPrint = JSLanguageServiceNodeStdProtocolBase.Companion.truncateText(request2);
            JSLanguageServiceQueue.Holder.LOGGER.trace(JSLanguageServiceUtilKt.getCurrentThreadDebugInfo() + " " + this.getClass().getSimpleName() + " Request: " + toPrint);
        } else if (JSLanguageServiceQueue.Holder.LOGGER.isDebugEnabled()) {
            JSLanguageServiceQueue.Holder.LOGGER.debug(JSLanguageServiceUtilKt.getCurrentThreadDebugInfo() + " " + this.getClass().getSimpleName() + " Request command: " + JSLanguageServiceUtilKt.getDebugString(command));
        }
        Intrinsics.checkNotNull((Object)request2);
        return request2;
    }

    protected final int getUniqueCommandId() {
        return this.mySeq.getAndIncrement();
    }

    protected final void checkReadyCommand(@NotNull ProcessEvent event, @NotNull Key<?> outputType, @NotNull Ref<Boolean> result2, @NotNull CountDownLatch countDownLatch) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        Intrinsics.checkNotNullParameter((Object)countDownLatch, (String)"countDownLatch");
        if (outputType == ProcessOutputTypes.STDOUT && !StringUtil.isEmpty((String)event.getText())) {
            String prefix;
            JSLanguageServiceQueue.Holder.LOGGER.debug("Starting language service output: " + event.getText());
            String string = event.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String $this$trim$iv = string;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            String text = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            if (Intrinsics.areEqual((Object)this.toSystemCommand(ANSWER_READY), (Object)text)) {
                result2.set((Object)true);
                countDownLatch.countDown();
            }
            if (StringsKt.startsWith$default((String)text, (String)(prefix = this.toSystemCommand(ANSWER_ERROR)), (boolean)false, (int)2, null)) {
                String string2 = text.substring(prefix.length());
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                JSLanguageServiceQueue.Holder.LOGGER.debug("Error initialization " + string2);
                String string3 = text.substring(prefix.length());
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                this.myInitializeError = string3;
                countDownLatch.countDown();
            }
        } else if (outputType == ProcessOutputTypes.STDERR) {
            JSLanguageServiceQueue.Holder.LOGGER.debug("Starting language service output error: " + event.getText());
        }
    }

    protected final void writeln(@NotNull String data2) throws IOException {
        block1: {
            OutputStream outputStream;
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            OutputStream outputStream2 = this.myProcessInput;
            if (outputStream2 == null) break block1;
            OutputStream $this$writeln_u24lambda_u240 = outputStream = outputStream2;
            boolean bl = false;
            LanguageServiceLogger languageServiceLogger = this.lsCommunicationLogger;
            if (languageServiceLogger != null) {
                languageServiceLogger.logOutbound((CharSequence)data2);
            }
            String string = data2;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            $this$writeln_u24lambda_u240.write(byArray);
            $this$writeln_u24lambda_u240.write(NEW_LINE);
            $this$writeln_u24lambda_u240.flush();
        }
    }

    @Nullable
    protected final String getFilePath(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Object object = this.myRemoteHelper;
        if (object == null || (object = object.getFilePath(file)) == null) {
            String string = file.getCanonicalPath();
            if (string != null) {
                String it = string;
                boolean bl = false;
                object = FileUtil.toSystemDependentName((String)it);
            } else {
                object = null;
            }
        }
        return object;
    }

    @NotNull
    protected final String getFilePath(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Object object = this.myRemoteHelper;
        if (object == null || (object = object.getFilePath(path2)) == null) {
            object = path2;
        }
        return object;
    }

    @Deprecated(message="Message stream logging is started automatically, no need to do it manually")
    public final void startMessageStreamLogging(@NotNull String logFileName) {
        Intrinsics.checkNotNullParameter((Object)logFileName, (String)"logFileName");
    }

    @Deprecated(message="Message stream logging is stopped on protocol dispose, no need to do it manually")
    public final void stopMessageStreamLogging() {
    }

    public void dispose() {
        block1: {
            this.myProcessInput = null;
            Map $this$forEach$iv = this.myCallbacks;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                JSLanguageServiceAnswerConsumer value = (JSLanguageServiceAnswerConsumer)entry.getValue();
                value.consume(null);
            }
            this.myCallbacks.clear();
            LanguageServiceLogger languageServiceLogger = this.lsCommunicationLogger;
            if (languageServiceLogger == null) break block1;
            LanguageServiceLogger it = languageServiceLogger;
            boolean bl = false;
            LanguageServiceLoggerService.Companion.getInstance().disconnect(it);
        }
    }

    @Nullable
    public final CompletableFuture<String> convertTargetPathToLocal(@NotNull String targetPath) {
        Intrinsics.checkNotNullParameter((Object)targetPath, (String)"targetPath");
        Promise<String> promise = this.targetRun;
        return promise != null && (promise = promise.convertTargetPathToLocal(targetPath)) != null ? Promises.asCompletableFuture(promise) : null;
    }

    @Nullable
    public final CompletableFuture<String> convertLocalPathToTarget(@NotNull String localPath) {
        Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
        Promise<String> promise = this.targetRun;
        return promise != null && (promise = promise.convertLocalPathToTarget(localPath)) != null ? Promises.asCompletableFuture(promise) : null;
    }

    private static final void createTargetRun$lambda$0(NodeTargetRunOptions.Builder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.setProcessReaderOptions(PROCESS_READER_OPTIONS);
    }

    private static final void awaitReadyNotification$lambda$0(AtomicReference $readyNotification, JSLanguageServiceNodeStdProtocolBase this$0, ProcessHandler $processHandler, ProcessEvent event, Key outputType, Ref result2, CountDownLatch countDownLatch) {
        block8: {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter((Object)outputType, (String)"outputType");
            Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
            Intrinsics.checkNotNullParameter((Object)countDownLatch, (String)"countDownLatch");
            if (outputType == ProcessOutputTypes.STDOUT && !StringUtil.isEmpty((String)event.getText())) {
                String text = StringUtil.trim((String)event.getText());
                Intrinsics.checkNotNull((Object)text);
                if (StringsKt.startsWith$default((String)text, (String)"{", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)text, (String)"}", (boolean)false, (int)2, null)) {
                    JsonElement answer2 = JsonParser.parseString((String)text);
                    JsonObject answerAsJsonObject = answer2.getAsJsonObject();
                    try {
                        JsonPrimitive stack;
                        JsonPrimitive success = answerAsJsonObject.getAsJsonPrimitive("success");
                        JsonPrimitive error = answerAsJsonObject.getAsJsonPrimitive(ANSWER_ERROR);
                        if (success.getAsBoolean()) {
                            result2.set((Object)true);
                            $readyNotification.set(answerAsJsonObject);
                            countDownLatch.countDown();
                            this$0.registerResponseHandlers($processHandler);
                            if (this$0.readyConsumer != null) {
                                java.util.function.Consumer<?> consumer = this$0.readyConsumer;
                                Intrinsics.checkNotNull(consumer, (String)"null cannot be cast to non-null type java.util.function.Consumer<com.google.gson.JsonObject>");
                                consumer.accept(answerAsJsonObject);
                            }
                            break block8;
                        }
                        String string = error.getAsString();
                        if (string == null) {
                            string = "";
                        }
                        String errorText = string;
                        JsonPrimitive jsonPrimitive = stack = answerAsJsonObject.getAsJsonPrimitive("stack");
                        String errorWithStack = errorText + "\n" + (jsonPrimitive == null ? "" : jsonPrimitive.getAsString());
                        JSLanguageServiceQueue.Holder.LOGGER.debug(this$0.getClass().getName() + " Error initializing " + errorWithStack);
                        this$0.myInitializeError = errorWithStack;
                        countDownLatch.countDown();
                    }
                    catch (Exception e) {
                        JSLanguageServiceQueue.Holder.LOGGER.debug(this$0.getClass().getName() + " Error initializing " + e.getMessage() + "\nCannot parse " + text);
                        Object[] objectArray = new Object[]{text};
                        this$0.myInitializeError = JavaScriptBundle.message((String)"cannot.parse.service.initialization.answer.0", (Object[])objectArray);
                    }
                } else {
                    JSLanguageServiceQueue.Holder.LOGGER.warn(this$0.getClass().getName() + " Expected json answer: " + event.getText());
                }
            }
        }
    }

    private static final JSLanguageServiceInitialState sendInitialState$lambda$0(JSLanguageServiceNodeStdProtocolBase this$0) {
        return this$0.createState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void sendCommand$lambda$0(JSLanguageServiceNodeStdProtocolBase this$0, int $commandId, JSLanguageServiceAnswerConsumer $resultConsumer, JSLanguageServiceAnswer message) {
        block10: {
            block11: {
                CommandTelemetryInfo nextTelemetry;
                CommandTelemetryInfo commandTelemetryInfo = nextTelemetry = this$0.myCommandTelemetryInfo.get($commandId + 1);
                if (commandTelemetryInfo != null) {
                    commandTelemetryInfo.previousCommandFinished();
                }
                CommandTelemetryInfo curTelemetry = this$0.myCommandTelemetryInfo.remove($commandId);
                if (curTelemetry == null) break block11;
                if ($resultConsumer != null) {
                    curTelemetry.beforeAnswerProcessing();
                    try {
                        Span span = curTelemetry.getProcessingSpan();
                        Intrinsics.checkNotNull((Object)span);
                        AutoCloseable autoCloseable = (AutoCloseable)span.makeCurrent();
                        Throwable throwable = null;
                        try {
                            Scope it = (Scope)autoCloseable;
                            boolean bl = false;
                            $resultConsumer.consume(message);
                            Unit unit = Unit.INSTANCE;
                            break block10;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                        }
                    }
                    finally {
                        curTelemetry.commandFinished(message);
                    }
                }
                curTelemetry.commandFinished(message);
                break block10;
            }
            JSLanguageServiceAnswerConsumer jSLanguageServiceAnswerConsumer = $resultConsumer;
            if (jSLanguageServiceAnswerConsumer == null) break block10;
            jSLanguageServiceAnswerConsumer.consume(message);
        }
    }

    @NotNull
    public static final BaseOutputReader.Options getPROCESS_READER_OPTIONS() {
        return Companion.getPROCESS_READER_OPTIONS();
    }

    public static final /* synthetic */ void access$processText(JSLanguageServiceNodeStdProtocolBase $this, CharSequence text) {
        $this.processText(text);
    }

    static {
        String string = "\n";
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        NEW_LINE = byArray;
        PROCESS_READER_OPTIONS = new BaseOutputReader.Options(){

            public BaseDataReader.SleepingPolicy policy() {
                BaseDataReader.SleepingPolicy sleepingPolicy = BaseOutputReader.Options.BLOCKING.policy();
                Intrinsics.checkNotNullExpressionValue((Object)sleepingPolicy, (String)"policy(...)");
                return sleepingPolicy;
            }

            public boolean splitToLines() {
                return BaseOutputReader.Options.BLOCKING.splitToLines();
            }

            public boolean sendIncompleteLines() {
                return false;
            }
        };
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0084\b\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\b\u001a\u00020\u0004H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u0004H\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceNodeStdProtocolBase$CommandIdCancellationToken;", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceProtocol$CancellationToken;", "Ljava/lang/Record;", "id", "", "<init>", "(I)V", "()I", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "", "intellij.javascript.backend"})
    protected static final class CommandIdCancellationToken
    extends Record
    implements JSLanguageServiceProtocol.CancellationToken {
        private final int id;

        public CommandIdCancellationToken(int id) {
            this.id = id;
        }

        public final int id() {
            return this.id;
        }

        public final int component1() {
            return this.id;
        }

        @NotNull
        public final CommandIdCancellationToken copy(int id) {
            return new CommandIdCancellationToken(id);
        }

        public static /* synthetic */ CommandIdCancellationToken copy$default(CommandIdCancellationToken commandIdCancellationToken, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = commandIdCancellationToken.id;
            }
            return commandIdCancellationToken.copy(n);
        }

        @Override
        @NotNull
        public String toString() {
            return "CommandIdCancellationToken(id=" + this.id + ")";
        }

        @Override
        public int hashCode() {
            return Integer.hashCode(this.id);
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CommandIdCancellationToken)) {
                return false;
            }
            CommandIdCancellationToken commandIdCancellationToken = (CommandIdCancellationToken)other;
            return this.id == commandIdCancellationToken.id;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0017J\u0010\u0010\u0019\u001a\u00020\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001c"}, d2={"Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceNodeStdProtocolBase$CommandTelemetryInfo;", "", "command", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceCommand;", "hasPreviousCommand", "", "<init>", "(Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceCommand;Z)V", "lifecycleSpan", "Lio/opentelemetry/api/trace/Span;", "waitSpan", "serverSpanBuilder", "Lio/opentelemetry/api/trace/SpanBuilder;", "processingSpanBuilder", "serverSpanStart", "Ljava/time/Instant;", "serverSpanEnd", "processingSpan", "getProcessingSpan", "()Lio/opentelemetry/api/trace/Span;", "setProcessingSpan", "(Lio/opentelemetry/api/trace/Span;)V", "previousCommandFinished", "", "beforeAnswerProcessing", "commandFinished", "message", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceAnswer;", "intellij.javascript.backend"})
    @SourceDebugExtension(value={"SMAP\nJSLanguageServiceNodeStdProtocolBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSLanguageServiceNodeStdProtocolBase.kt\ncom/intellij/lang/javascript/service/protocol/JSLanguageServiceNodeStdProtocolBase$CommandTelemetryInfo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,604:1\n1869#2:605\n1870#2:608\n19#3:606\n1#4:607\n*S KotlinDebug\n*F\n+ 1 JSLanguageServiceNodeStdProtocolBase.kt\ncom/intellij/lang/javascript/service/protocol/JSLanguageServiceNodeStdProtocolBase$CommandTelemetryInfo\n*L\n543#1:605\n543#1:608\n546#1:606\n*E\n"})
    private static final class CommandTelemetryInfo {
        @NotNull
        private final Span lifecycleSpan;
        @Nullable
        private Span waitSpan;
        @NotNull
        private final SpanBuilder serverSpanBuilder;
        @NotNull
        private final SpanBuilder processingSpanBuilder;
        @Nullable
        private Instant serverSpanStart;
        @Nullable
        private Instant serverSpanEnd;
        @Nullable
        private Span processingSpan;

        public CommandTelemetryInfo(@NotNull JSLanguageServiceCommand command, boolean hasPreviousCommand) {
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            Span span = JSLanguageServiceTracerUtilKt.serviceTraceSpanBuilder(this.getClass(), "execute command " + command.getCommand()).startSpan();
            Intrinsics.checkNotNullExpressionValue((Object)span, (String)"startSpan(...)");
            this.lifecycleSpan = span;
            Context context2 = Context.current().with((ImplicitContextKeyed)this.lifecycleSpan);
            SpanBuilder spanBuilder = JSLanguageServiceTracerUtilKt.serviceTraceSpanBuilder(this.getClass(), "server processing").setParent(context2);
            Intrinsics.checkNotNullExpressionValue((Object)spanBuilder, (String)"setParent(...)");
            this.serverSpanBuilder = spanBuilder;
            SpanBuilder spanBuilder2 = JSLanguageServiceTracerUtilKt.serviceTraceSpanBuilder(this.getClass(), "process answer").setParent(context2);
            Intrinsics.checkNotNullExpressionValue((Object)spanBuilder2, (String)"setParent(...)");
            this.processingSpanBuilder = spanBuilder2;
            if (hasPreviousCommand) {
                this.waitSpan = JSLanguageServiceTracerUtilKt.serviceTraceSpanBuilder(this.getClass(), "queued").setParent(context2).startSpan();
            } else {
                this.waitSpan = null;
                this.serverSpanStart = Instant.now();
            }
        }

        @Nullable
        public final Span getProcessingSpan() {
            return this.processingSpan;
        }

        public final void setProcessingSpan(@Nullable Span span) {
            this.processingSpan = span;
        }

        public final void previousCommandFinished() {
            Span span = this.waitSpan;
            if (span != null) {
                span.end();
            }
            this.serverSpanStart = Instant.now();
        }

        public final void beforeAnswerProcessing() {
            this.serverSpanEnd = Instant.now();
            this.processingSpan = this.processingSpanBuilder.startSpan();
        }

        public final void commandFinished(@Nullable JSLanguageServiceAnswer message) {
            JsonElement performanceData;
            Span serverSpan;
            Instant serverSpanStart = this.serverSpanStart;
            Instant serverSpanEnd = this.serverSpanEnd;
            Span span = serverSpan = serverSpanStart != null && serverSpanEnd != null ? this.serverSpanBuilder.setStartTimestamp(serverSpanStart).startSpan() : null;
            if (message != null && serverSpanStart != null && (performanceData = message.getElement().get("performanceData")) instanceof JsonObject) {
                Set set = ((JsonObject)performanceData).entrySet();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"entrySet(...)");
                Iterable $this$forEach$iv = set;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    JsonPrimitive jsonPrimitive;
                    Object object;
                    Map.Entry entry = (Map.Entry)element$iv;
                    boolean bl = false;
                    String metricsName = (String)entry.getKey();
                    Intrinsics.checkNotNull((Object)metricsName);
                    if (!StringsKt.endsWith$default((String)metricsName, (String)"Ms", (boolean)false, (int)2, null)) continue;
                    Object $this$asSafely$iv = entry.getValue();
                    boolean $i$f$asSafely = false;
                    Object v = $this$asSafely$iv;
                    if (!(v instanceof JsonPrimitive)) {
                        v = null;
                    }
                    if ((object = (JsonPrimitive)v) == null) continue;
                    JsonPrimitive it = jsonPrimitive = object;
                    boolean bl2 = false;
                    object = it.isNumber() ? jsonPrimitive : null;
                    if (object == null) continue;
                    JsonPrimitive value = object;
                    boolean bl3 = false;
                    long timeNs = (long)(value.getAsDouble() * (double)1000000);
                    IJTracer iJTracer = JSLanguageServiceTracerUtilKt.getJS_LANG_SERVICE_TRACER();
                    String string = metricsName.substring(0, metricsName.length() - 2);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    SpanBuilder spanBuilder = iJTracer.spanBuilder("TypeScript compiler process: " + string);
                    Context context2 = Context.current();
                    Span span2 = serverSpan;
                    if (span2 == null) {
                        span2 = this.lifecycleSpan;
                    }
                    spanBuilder.setParent(context2.with((ImplicitContextKeyed)span2)).setStartTimestamp(serverSpanStart).startSpan().end(serverSpanStart.plusNanos(timeNs));
                }
            }
            Span span3 = serverSpan;
            if (span3 != null) {
                Instant instant = serverSpanEnd;
                Intrinsics.checkNotNull((Object)instant);
                span3.end(instant);
            }
            Span span4 = this.processingSpan;
            if (span4 != null) {
                span4.end();
            }
            this.lifecycleSpan.end();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\r\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000b\u0010\u0003\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0016"}, d2={"Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceNodeStdProtocolBase$Companion;", "", "<init>", "()V", "ANSWER_READY", "", "ANSWER_ERROR", "NEW_LINE", "", "PROCESS_READER_OPTIONS", "Lcom/intellij/util/io/BaseOutputReader$Options;", "getPROCESS_READER_OPTIONS$annotations", "getPROCESS_READER_OPTIONS", "()Lcom/intellij/util/io/BaseOutputReader$Options;", "entryPointFile", "getEntryPointFile", "()Ljava/lang/String;", "trimToCharSequence", "", "text", "truncateText", "request", "intellij.javascript.backend"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BaseOutputReader.Options getPROCESS_READER_OPTIONS() {
            return PROCESS_READER_OPTIONS;
        }

        @JvmStatic
        public static /* synthetic */ void getPROCESS_READER_OPTIONS$annotations() {
        }

        @NotNull
        public final String getEntryPointFile() {
            return "js-language-service.js";
        }

        private final CharSequence trimToCharSequence(String text) {
            int bound;
            int pos;
            for (pos = 0; pos < text.length() && Intrinsics.compare((int)text.charAt(pos), (int)32) <= 0; ++pos) {
            }
            for (bound = text.length(); bound > pos && Intrinsics.compare((int)text.charAt(bound - 1), (int)32) <= 0; --bound) {
            }
            CharBuffer charBuffer = CharBuffer.wrap(text, pos, bound);
            Intrinsics.checkNotNullExpressionValue((Object)charBuffer, (String)"wrap(...)");
            return charBuffer;
        }

        private final CharSequence truncateText(CharSequence request2) {
            CharSequence toPrint = request2;
            if (Registry.Companion.is("JavaScript.Language.Service.truncate.traced.messages", true) && request2.length() > 1000) {
                toPrint = CharBuffer.wrap(request2, 0, 200) + "\n ................................(truncated)";
            }
            return toPrint;
        }

        public static final /* synthetic */ CharSequence access$trimToCharSequence(Companion $this, String text) {
            return $this.trimToCharSequence(text);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e4\u0080\u0001\u0018\u00002\u00020\u0001J2\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\r\u00c0\u0006\u0001"}, d2={"Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceNodeStdProtocolBase$ReadyChecker;", "", "check", "", "event", "Lcom/intellij/execution/process/ProcessEvent;", "outputType", "Lcom/intellij/openapi/util/Key;", "result", "Lcom/intellij/openapi/util/Ref;", "", "countDownLatch", "Ljava/util/concurrent/CountDownLatch;", "intellij.javascript.backend"})
    protected static interface ReadyChecker {
        public void check(@NotNull ProcessEvent var1, @NotNull Key<?> var2, @NotNull Ref<Boolean> var3, @NotNull CountDownLatch var4);
    }
}

