/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.sql.common.impl.formatter;

import com.intellij.database.sql.common.impl.formatter.settings.SqlLanguageCodeStyleSettingsProviderBase;
import com.intellij.lang.Language;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.sql.formatter.SqlDialectCodeStyleProvider;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/sql/common/impl/formatter/SqlDialectCodeStyleSettingsAutoProvider;", "Lcom/intellij/database/sql/common/impl/formatter/settings/SqlLanguageCodeStyleSettingsProviderBase;", "dsp", "Lcom/intellij/sql/formatter/SqlDialectCodeStyleProvider;", "<init>", "(Lcom/intellij/sql/formatter/SqlDialectCodeStyleProvider;)V", "getLanguageName", "", "createCustomSettings", "Lcom/intellij/sql/formatter/settings/SqlCodeStyleSettings;", "settingsContainer", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "isApplicableTo", "", "dialect", "Lcom/intellij/lang/Language;", "getWeight", "", "intellij.database.sql.common.impl"})
public final class SqlDialectCodeStyleSettingsAutoProvider
extends SqlLanguageCodeStyleSettingsProviderBase {
    @NotNull
    private final SqlDialectCodeStyleProvider dsp;

    public SqlDialectCodeStyleSettingsAutoProvider(@NotNull SqlDialectCodeStyleProvider dsp) {
        Intrinsics.checkNotNullParameter((Object)dsp, (String)"dsp");
        super((Language)dsp.getDialect(), dsp.getSettingsClass());
        this.dsp = dsp;
    }

    @Override
    @NotNull
    public String getLanguageName() {
        String string = this.dsp.getDialectDisplayName();
        if (string == null) {
            String string2 = this.dsp.getDialect().getDisplayName();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDisplayName(...)");
        }
        return string;
    }

    @Override
    @NotNull
    public SqlCodeStyleSettings createCustomSettings(@NotNull CodeStyleSettings settingsContainer) {
        Intrinsics.checkNotNullParameter((Object)settingsContainer, (String)"settingsContainer");
        return this.dsp.createCustomSettings(settingsContainer);
    }

    @Override
    public boolean isApplicableTo(@NotNull Language dialect) {
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        return Intrinsics.areEqual((Object)dialect, (Object)this.dsp.getDialect());
    }

    public int getWeight() {
        return this.dsp.getWeight();
    }
}

