/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.diagrams.beans;

import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramEdgeCreationPolicy;
import com.intellij.diagram.DiagramNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.diagrams.SpringGraphBundle;
import com.intellij.spring.diagrams.beans.edges.ByTypeAutowire;
import com.intellij.spring.diagrams.beans.edges.InjectionEdge;
import com.intellij.spring.diagrams.perspectives.beans.SpringBeanPointerWrapper;
import com.intellij.spring.diagrams.perspectives.beans.SpringElementWrapper;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.actions.generate.GenerateAutowiredDependenciesUtil;
import com.intellij.spring.model.actions.generate.GenerateSpringBeanDependenciesUtil;
import com.intellij.spring.model.actions.generate.SpringGenerateTemplatesHolder;
import com.intellij.spring.model.jam.JamPsiClassSpringBean;
import com.intellij.spring.model.jam.JamPsiMemberSpringBean;
import com.intellij.spring.model.jam.JamSpringBeanPointer;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.DomSpringBeanPointer;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringInjection;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xml.DomElement;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class SpringDiagramEdgeCreationUtil {
    private static int ourTestModeXmlBeanInjectionOptionIndex = -1;

    public static DiagramEdgeCreationPolicy<SpringElementWrapper<?>> getDiagramEdgeCreationPolicy() {
        return new DiagramEdgeCreationPolicy<SpringElementWrapper<?>>(){

            public boolean acceptSource(@NotNull DiagramNode<SpringElementWrapper<?>> source) {
                SpringElementWrapper identifyingElement;
                if (source == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((identifyingElement = (SpringElementWrapper)source.getIdentifyingElement()) instanceof SpringBeanPointerWrapper) {
                    SpringBeanPointer wrapped = (SpringBeanPointer)((SpringBeanPointerWrapper)identifyingElement).getWrapped();
                    if (wrapped instanceof JamSpringBeanPointer) {
                        JamPsiMemberSpringBean memberSpringBean = (JamPsiMemberSpringBean)((JamSpringBeanPointer)wrapped).getSpringBean();
                        if (memberSpringBean instanceof JamPsiClassSpringBean) {
                            PsiClass psiClass = ((JamPsiClassSpringBean)memberSpringBean).getPsiElement();
                            return !(psiClass instanceof PsiCompiledElement) && !psiClass.isInterface();
                        }
                    } else if (wrapped instanceof DomSpringBeanPointer) {
                        DomSpringBean bean = (DomSpringBean)wrapped.getSpringBean();
                        PsiFile containingFile = bean.getContainingFile();
                        VirtualFile file = containingFile.getVirtualFile();
                        return file != null && !(file.getFileSystem() instanceof JarFileSystem);
                    }
                }
                return false;
            }

            public boolean acceptTarget(@NotNull DiagramNode<SpringElementWrapper<?>> target) {
                if (target == null) {
                    1.$$$reportNull$$$0(1);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "source";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "target";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/spring/diagrams/beans/SpringDiagramEdgeCreationUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "acceptSource";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "acceptTarget";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Nullable
    public static DiagramEdge<SpringElementWrapper<?>> createEdge(@NotNull DiagramNode<SpringElementWrapper<?>> source, @NotNull DiagramNode<SpringElementWrapper<?>> target, Collection<? extends DiagramEdge<SpringElementWrapper<?>>> edges, DiagramBuilder builder, @Nullable CommonSpringModel applicationModel) {
        if (source == null) {
            SpringDiagramEdgeCreationUtil.$$$reportNull$$$0(0);
        }
        if (target == null) {
            SpringDiagramEdgeCreationUtil.$$$reportNull$$$0(1);
        }
        for (DiagramEdge<SpringElementWrapper<?>> edge : edges) {
            if (!edge.getSource().equals(source) || !edge.getTarget().equals(target)) continue;
            return null;
        }
        SpringElementWrapper identifyingElement = (SpringElementWrapper)source.getIdentifyingElement();
        if (identifyingElement instanceof SpringBeanPointerWrapper) {
            DomSpringBean bean;
            SpringBeanPointer wrapped = (SpringBeanPointer)((SpringBeanPointerWrapper)identifyingElement).getWrapped();
            if (wrapped instanceof JamSpringBeanPointer) {
                JamPsiMemberSpringBean memberSpringBean = (JamPsiMemberSpringBean)((JamSpringBeanPointer)wrapped).getSpringBean();
                if (memberSpringBean instanceof JamPsiClassSpringBean) {
                    PsiClass psiClass = ((JamPsiClassSpringBean)memberSpringBean).getPsiElement();
                    return SpringDiagramEdgeCreationUtil.createJavaClassEdge(source, target, psiClass, builder, applicationModel);
                }
            } else if (wrapped instanceof DomSpringBeanPointer && (bean = (DomSpringBean)wrapped.getSpringBean()) instanceof SpringBean) {
                return SpringDiagramEdgeCreationUtil.createXmlBeanInjectionEdge(source, target, (SpringBean)bean, builder, applicationModel);
            }
        }
        return null;
    }

    @TestOnly
    public static void setTestModeXmlBeanInjectionOptionIndex(int index) {
        ourTestModeXmlBeanInjectionOptionIndex = index;
    }

    @Nullable
    private static DiagramEdge<SpringElementWrapper<?>> createXmlBeanInjectionEdge(DiagramNode<SpringElementWrapper<?>> source, DiagramNode<SpringElementWrapper<?>> target, SpringBean bean, DiagramBuilder builder, CommonSpringModel applicationModel) {
        SpringElementWrapper wrapper = (SpringElementWrapper)target.getIdentifyingElement();
        if (wrapper instanceof SpringBeanPointerWrapper) {
            int index;
            SpringBeanPointer targetPointer = (SpringBeanPointer)((SpringBeanPointerWrapper)wrapper).getWrapped();
            PsiClass beanClass = PsiTypesUtil.getPsiClass((PsiType)bean.getBeanType());
            Object[] names = new String[]{SpringGraphBundle.message("spring.diagrams.setter.injection", new Object[0]), SpringGraphBundle.message("spring.diagrams.constructor.injection", new Object[0])};
            if (!(beanClass instanceof PsiCompiledElement)) {
                names = (String[])ArrayUtil.append((Object[])names, (Object)SpringGraphBundle.message("spring.diagrams.autowired", new Object[0]));
            }
            int n = index = ApplicationManager.getApplication().isUnitTestMode() ? ourTestModeXmlBeanInjectionOptionIndex : Messages.showChooseDialog((String)SpringGraphBundle.message("spring.diagrams.dependency.type", new Object[0]), (String)SpringGraphBundle.message("spring.diagrams.choose.dependency.type", new Object[0]), (String[])names, (String)names[0], null);
            if (index == -1) {
                return null;
            }
            Callable<DiagramEdge> callable = () -> {
                if (index == 2) {
                    List pairs;
                    if (beanClass != null && (pairs = GenerateAutowiredDependenciesUtil.generateAutowiredDependencies((PsiClass)beanClass, Collections.singletonList(targetPointer), (CommonSpringModel)applicationModel)).size() == 1) {
                        ((SpringGenerateTemplatesHolder)pairs.get(0)).runTemplates();
                        return new ByTypeAutowire(source, target);
                    }
                } else {
                    List pairs = GenerateSpringBeanDependenciesUtil.generateDependencies((SpringBean)bean, Collections.singletonList(targetPointer), (index == 0 ? 1 : 0) != 0);
                    if (pairs.size() == 1) {
                        Pair pair = (Pair)pairs.get(0);
                        SpringInjection injection = (SpringInjection)pair.first;
                        if (injection != null) {
                            ((SpringGenerateTemplatesHolder)pair.second).runTemplates();
                            return new InjectionEdge(source, target, (DomElement)injection);
                        }
                    }
                }
                return null;
            };
            DiagramEdge edge = (DiagramEdge)DiagramAction.performCommand((DiagramBuilder)builder, callable, (String)SpringGraphBundle.message("spring.diagrams.add.bean.dependencies.action", new Object[0]), null, (PsiElement[])new PsiElement[]{bean.getContainingFile(), targetPointer.getContainingFile()});
            if (edge == null && beanClass instanceof PsiCompiledElement) {
                Messages.showMessageDialog((String)SpringGraphBundle.message("spring.diagrams.can.t.create.dependency.for.compiled.class", new Object[0]), (String)SpringGraphBundle.message("spring.diagrams.compiled.class.dependency", new Object[0]), null);
            }
            return edge;
        }
        return null;
    }

    @Nullable
    private static DiagramEdge<SpringElementWrapper<?>> createJavaClassEdge(DiagramNode<SpringElementWrapper<?>> source, DiagramNode<SpringElementWrapper<?>> target, PsiClass aClass, DiagramBuilder builder, CommonSpringModel applicationModel) {
        SpringElementWrapper wrapper = (SpringElementWrapper)target.getIdentifyingElement();
        if (wrapper instanceof SpringBeanPointerWrapper) {
            SpringBeanPointer targetPointer = (SpringBeanPointer)((SpringBeanPointerWrapper)wrapper).getWrapped();
            Callable<DiagramEdge> callable = () -> {
                List pairs;
                if (aClass != null && (pairs = GenerateAutowiredDependenciesUtil.generateAutowiredDependencies((PsiClass)aClass, Collections.singletonList(targetPointer), (CommonSpringModel)applicationModel)).size() == 1) {
                    ((SpringGenerateTemplatesHolder)pairs.get(0)).runTemplates();
                    return new ByTypeAutowire(source, target);
                }
                return null;
            };
            return (DiagramEdge)DiagramAction.performCommand((DiagramBuilder)builder, callable, (String)SpringGraphBundle.message("spring.diagrams.add.bean.dependencies.action", new Object[0]), null, (PsiElement[])new PsiElement[]{targetPointer.getContainingFile()});
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "source";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "target";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/diagrams/beans/SpringDiagramEdgeCreationUtil";
        objectArray[2] = "createEdge";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

