/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ftp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Instant;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.UserAuthenticationData;
import org.apache.commons.vfs2.provider.GenericFileName;
import org.apache.commons.vfs2.provider.ftp.FtpClient;
import org.apache.commons.vfs2.provider.ftp.FtpClientFactory;
import org.apache.commons.vfs2.provider.ftp.FtpFileProvider;
import org.apache.commons.vfs2.provider.ftp.FtpFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.ftp.FtpJBHelper;
import org.apache.commons.vfs2.util.UserAuthenticatorUtils;

public class FTPClientWrapper
implements FtpClient {
    private static final Log log = LogFactory.getLog((String)"#com.jetbrains.plugins.webDeployment.ftp");
    protected final FileSystemOptions fileSystemOptions;
    private final GenericFileName root;
    private FTPClient ftpClient;

    protected FTPClientWrapper(GenericFileName root, FileSystemOptions fileSystemOptions) throws FileSystemException {
        this.root = root;
        this.fileSystemOptions = fileSystemOptions;
        this.getFtpClient();
    }

    public GenericFileName getRoot() {
        return this.root;
    }

    public FileSystemOptions getFileSystemOptions() {
        return this.fileSystemOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FTPClient createClient() throws FileSystemException {
        FTPClient fTPClient;
        GenericFileName rootName = this.getRoot();
        UserAuthenticationData authData = null;
        try {
            authData = UserAuthenticatorUtils.authenticate(this.fileSystemOptions, FtpFileProvider.AUTHENTICATOR_TYPES);
            fTPClient = this.createClient(rootName, authData);
        }
        catch (Throwable throwable) {
            UserAuthenticatorUtils.cleanup(authData);
            throw throwable;
        }
        UserAuthenticatorUtils.cleanup(authData);
        return fTPClient;
    }

    protected FTPClient createClient(GenericFileName rootName, UserAuthenticationData authData) throws FileSystemException {
        return FtpClientFactory.createConnection(rootName.getHostName(), rootName.getPort(), UserAuthenticatorUtils.getData(authData, UserAuthenticationData.USERNAME, null), UserAuthenticatorUtils.getData(authData, UserAuthenticationData.PASSWORD, null), rootName.getPath(), this.getFileSystemOptions());
    }

    private FTPClient getFtpClient() throws FileSystemException {
        if (this.ftpClient == null) {
            this.ftpClient = this.createClient();
        }
        return this.ftpClient;
    }

    @Override
    public boolean isConnected() {
        return this.ftpClient != null && this.ftpClient.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void disconnect() throws IOException {
        try {
            this.getFtpClient().quit();
            return;
        }
        catch (IOException e) {
            log.info((Object)e);
            return;
        }
        finally {
            try {
                this.getFtpClient().disconnect();
            }
            catch (IOException e) {
                log.info((Object)e);
            }
            finally {
                this.ftpClient = null;
            }
        }
    }

    @Override
    public FTPFile[] listFiles(String relPath) throws IOException {
        try {
            return this.listFilesInDirectory(relPath);
        }
        catch (IOException e) {
            this.disconnect();
            return this.listFilesInDirectory(relPath);
        }
    }

    private FTPFile[] listFilesInDirectory(String relPath) throws IOException {
        FTPFile[] files;
        boolean forceList = FtpFileSystemConfigBuilder.getInstance().isForceListCommand(this.fileSystemOptions);
        if (!FtpFileSystemConfigBuilder.getInstance().isCompatibleMode(this.fileSystemOptions)) {
            files = FtpJBHelper.listFiles(relPath, this.getFtpClient(), forceList);
            if (FTPReply.isPositiveCompletion((int)this.getFtpClient().getReplyCode())) {
                return files;
            }
        }
        String workingDirectory = null;
        if (relPath != null) {
            workingDirectory = this.getFtpClient().printWorkingDirectory();
            if (!this.getFtpClient().changeWorkingDirectory(relPath)) {
                return null;
            }
        }
        files = FtpJBHelper.listFiles(this.getFtpClient(), forceList);
        if (relPath != null && !this.getFtpClient().changeWorkingDirectory(workingDirectory)) {
            throw new FileSystemException("vfs.provider.ftp.wrapper/change-work-directory-back.error", (Object)workingDirectory);
        }
        return files;
    }

    @Override
    public Instant mdtmInstant(String relPath) throws IOException {
        try {
            return this.getFtpClient().mdtmCalendar(relPath).toInstant();
        }
        catch (IOException ex) {
            this.disconnect();
            return this.getFtpClient().mdtmCalendar(relPath).toInstant();
        }
    }

    @Override
    public boolean removeDirectory(String relPath) throws IOException {
        try {
            return this.getFtpClient().removeDirectory(relPath);
        }
        catch (IOException e) {
            this.disconnect();
            return this.getFtpClient().removeDirectory(relPath);
        }
    }

    @Override
    public boolean deleteFile(String relPath) throws IOException {
        try {
            return this.getFtpClient().deleteFile(relPath);
        }
        catch (IOException e) {
            this.disconnect();
            return this.getFtpClient().deleteFile(relPath);
        }
    }

    @Override
    public boolean rename(String oldName, String newName) throws IOException {
        try {
            return this.getFtpClient().rename(oldName, newName);
        }
        catch (IOException e) {
            this.disconnect();
            return this.getFtpClient().rename(oldName, newName);
        }
    }

    @Override
    public boolean makeDirectory(String relPath) throws IOException {
        try {
            return this.getFtpClient().makeDirectory(relPath);
        }
        catch (IOException e) {
            this.disconnect();
            return this.getFtpClient().makeDirectory(relPath);
        }
    }

    @Override
    public boolean completePendingCommand() throws IOException {
        if (this.ftpClient != null) {
            return this.getFtpClient().completePendingCommand();
        }
        return true;
    }

    @Override
    public InputStream retrieveFileStream(String relPath, int bufferSize) throws IOException {
        try {
            FTPClient client = this.getFtpClient();
            client.setBufferSize(bufferSize);
            return client.retrieveFileStream(relPath);
        }
        catch (IOException e) {
            this.disconnect();
            FTPClient client = this.getFtpClient();
            client.setBufferSize(bufferSize);
            return client.retrieveFileStream(relPath);
        }
    }

    @Override
    public InputStream retrieveFileStream(String relPath) throws IOException {
        try {
            return this.getFtpClient().retrieveFileStream(relPath);
        }
        catch (IOException e) {
            this.disconnect();
            return this.getFtpClient().retrieveFileStream(relPath);
        }
    }

    @Override
    public InputStream retrieveFileStream(String relPath, long restartOffset) throws IOException {
        try {
            FTPClient client = this.getFtpClient();
            client.setRestartOffset(restartOffset);
            return client.retrieveFileStream(relPath);
        }
        catch (IOException e) {
            this.disconnect();
            FTPClient client = this.getFtpClient();
            client.setRestartOffset(restartOffset);
            return client.retrieveFileStream(relPath);
        }
    }

    @Override
    public OutputStream appendFileStream(String relPath) throws IOException {
        try {
            return this.getFtpClient().appendFileStream(relPath);
        }
        catch (IOException e) {
            this.disconnect();
            return this.getFtpClient().appendFileStream(relPath);
        }
    }

    @Override
    public OutputStream storeFileStream(String relPath) throws IOException {
        try {
            return this.getFtpClient().storeFileStream(relPath);
        }
        catch (IOException e) {
            this.disconnect();
            return this.getFtpClient().storeFileStream(relPath);
        }
    }

    @Override
    public boolean abort() throws IOException {
        try {
            this.disconnect();
            return true;
        }
        catch (IOException e) {
            this.disconnect();
            return true;
        }
    }

    @Override
    public String getReplyString() throws IOException {
        return this.getFtpClient().getReplyString();
    }

    @Override
    public boolean hasFeature(String feature) throws IOException {
        try {
            return this.getFtpClient().hasFeature(feature);
        }
        catch (IOException ex) {
            this.disconnect();
            return this.getFtpClient().hasFeature(feature);
        }
    }

    @Override
    public void setLastModifiedTime(String relPath, long timestamp) throws IOException {
        FtpJBHelper.changeModificationTimestamp(this.getFtpClient(), relPath, timestamp);
    }

    @Override
    public void chmod(String relPath, int mask) throws IOException {
        if (!this.getFtpClient().sendSiteCommand("CHMOD " + Integer.toOctalString(mask) + " " + relPath)) {
            String response = this.getFtpClient().getReplyString();
            throw new IOException("Error changing permissions: " + response);
        }
    }

    @Override
    public String printWorkingDirectory() throws IOException {
        return this.getFtpClient().printWorkingDirectory();
    }

    @Override
    public boolean noop() throws IOException {
        return this.getFtpClient().sendNoOp();
    }

    @Override
    public boolean setWorkingDirToCurrent() throws IOException {
        return this.getFtpClient().changeWorkingDirectory(".");
    }

    @Override
    public FTPFile[] invokeListOnCurrentDir() throws IOException {
        return FtpJBHelper.listFiles(this.getFtpClient(), true);
    }
}

