/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.assemble;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.commons.data.SeriesUtil;
import org.jetbrains.letsPlot.core.plot.base.DataFrame;
import org.jetbrains.letsPlot.core.plot.builder.GeomLayer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0013\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eH\u0000\u00a2\u0006\u0002\b\u000fJ\u0015\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u0012J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\b\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/assemble/StitchedPlotLayer;", "", "geomLayers", "", "Lorg/jetbrains/letsPlot/core/plot/builder/GeomLayer;", "(Ljava/util/List;)V", "isYOrientation", "", "()Z", "getDataRange", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "variable", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame$Variable;", "getVariables", "", "getVariables$plot_builder", "hasVariable", "v", "hasVariable$plot_builder", "isNumericData", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nStitchedPlotLayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StitchedPlotLayer.kt\norg/jetbrains/letsPlot/core/plot/builder/assemble/StitchedPlotLayer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,52:1\n1#2:53\n*E\n"})
public final class StitchedPlotLayer {
    @NotNull
    private final List<GeomLayer> geomLayers;

    public StitchedPlotLayer(@NotNull List<? extends GeomLayer> geomLayers) {
        Intrinsics.checkNotNullParameter(geomLayers, (String)"geomLayers");
        this.geomLayers = geomLayers;
    }

    public final boolean isYOrientation() {
        if (!(!((Collection)this.geomLayers).isEmpty())) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        return this.geomLayers.get(0).isYOrientation();
    }

    @Nullable
    public final DoubleSpan getDataRange(@NotNull DataFrame.Variable variable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        if (!this.isNumericData(variable)) {
            boolean bl = false;
            String string = "Not numeric data [" + variable + ']';
            throw new IllegalStateException(string.toString());
        }
        DoubleSpan result2 = null;
        for (GeomLayer layer : this.geomLayers) {
            DoubleSpan range = layer.getDataFrame().range(variable);
            result2 = SeriesUtil.INSTANCE.span(result2, range);
        }
        return result2;
    }

    private final boolean isNumericData(DataFrame.Variable variable) {
        if (!(!((Collection)this.geomLayers).isEmpty())) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        for (GeomLayer layer : this.geomLayers) {
            if (layer.getDataFrame().isNumeric(variable)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public final Set<DataFrame.Variable> getVariables$plot_builder() {
        if (!(!((Collection)this.geomLayers).isEmpty())) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        return this.geomLayers.get(0).getDataFrame().variables();
    }

    public final boolean hasVariable$plot_builder(@NotNull DataFrame.Variable v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        if (!(!((Collection)this.geomLayers).isEmpty())) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        return this.geomLayers.get(0).getDataFrame().has(v);
    }
}

