/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.core.actions.popup;

import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramElementManager;
import com.intellij.diagram.DiagramElementsProvider;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.actions.DiagramActionPopupConsumer;
import com.intellij.diagram.util.DiagramSelectionService;
import com.intellij.diagram.util.DiagramUpdateService;
import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.graph.services.GraphAnimationService;
import com.intellij.openapi.graph.services.GraphCanvasLocationService;
import com.intellij.openapi.graph.services.GraphSelectionService;
import com.intellij.openapi.graph.util.Futures;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.uml.core.actions.popup.UmlElementsListCellRenderer;
import com.intellij.uml.utils.DiagramBundle;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class AddElementsFromPopupAction
extends DiagramAction {
    @NotNull
    private final DiagramElementsProvider<?> myElementsProvider;
    @NotNull
    private final DiagramBuilder myBuilder;

    public AddElementsFromPopupAction(@NotNull DiagramElementsProvider<?> elementsProvider, @NotNull DiagramBuilder builder) {
        if (elementsProvider == null) {
            AddElementsFromPopupAction.$$$reportNull$$$0(0);
        }
        if (builder == null) {
            AddElementsFromPopupAction.$$$reportNull$$$0(1);
        }
        this.myElementsProvider = elementsProvider;
        this.myBuilder = builder;
        this.setShortcutSet(elementsProvider.getShortcutSet());
        this.registerCustomShortcutSet(elementsProvider.getShortcutSet(), builder.getView().getCanvasComponent());
    }

    @Override
    public boolean isUndoable(@NotNull AnActionEvent e) {
        if (e == null) {
            AddElementsFromPopupAction.$$$reportNull$$$0(2);
        }
        return false;
    }

    @NotNull
    private List<Object> getElements(Object element, @NotNull Project project) {
        if (project == null) {
            AddElementsFromPopupAction.$$$reportNull$$$0(3);
        }
        List<Object> list = Arrays.asList(this.myElementsProvider.getElements(element, project));
        if (list == null) {
            AddElementsFromPopupAction.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    @NotNull
    public String getActionName() {
        String string = DiagramBundle.message("action.name.add.elements2", new Object[0]);
        if (string == null) {
            AddElementsFromPopupAction.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    @Nls
    private String getName() {
        String string = this.myElementsProvider.getName();
        if (string == null) {
            AddElementsFromPopupAction.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    @Nls
    private String getPopupTitle(Object element, @NotNull Project project) {
        if (project == null) {
            AddElementsFromPopupAction.$$$reportNull$$$0(7);
        }
        String string = this.myElementsProvider.getHeaderName(element, project);
        if (string == null) {
            AddElementsFromPopupAction.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AddElementsFromPopupAction.$$$reportNull$$$0(9);
        }
        e.getPresentation().setText(this.myElementsProvider.getName());
        DiagramBuilder builder = AddElementsFromPopupAction.getBuilder(e);
        if (builder == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        DiagramElementsProvider<?> elementsProvider = this.myElementsProvider;
        List<DiagramNode<?>> selectedNodesExceptNotes = DiagramSelectionService.getInstance().getSelectedNodesExceptNotes(builder);
        boolean isEnabled = !selectedNodesExceptNotes.isEmpty() && ContainerUtil.and(selectedNodesExceptNotes, it -> elementsProvider.isEnabledOn(it.getIdentifyingElement()));
        e.getPresentation().setEnabledAndVisible(isEnabled);
    }

    @Override
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            AddElementsFromPopupAction.$$$reportNull$$$0(10);
        }
        return actionUpdateThread;
    }

    @Override
    public void perform(@NotNull AnActionEvent e) {
        DiagramBuilder builder;
        if (e == null) {
            AddElementsFromPopupAction.$$$reportNull$$$0(11);
        }
        if ((builder = AddElementsFromPopupAction.getBuilder(e)) == null) {
            return;
        }
        List selectedNodes = GraphSelectionService.getInstance().getSelectedModelNodes(builder.getGraphBuilder());
        if (!selectedNodes.isEmpty()) {
            this.showPopup(builder, selectedNodes);
        }
    }

    private void showPopup(@NotNull DiagramBuilder builder, @NotNull Collection<DiagramNode<?>> selectedNodes) {
        if (builder == null) {
            AddElementsFromPopupAction.$$$reportNull$$$0(12);
        }
        if (selectedNodes == null) {
            AddElementsFromPopupAction.$$$reportNull$$$0(13);
        }
        ThrowableComputable popupCreator = () -> (JBPopup)ReadAction.compute(() -> {
            List allElementsToAdd = selectedNodes.stream().flatMap(it -> this.getElements(it.getIdentifyingElement(), builder.getProject()).stream()).distinct().collect(Collectors.toList());
            DefaultUmlElementsListCellRenderer renderer = new DefaultUmlElementsListCellRenderer();
            allElementsToAdd.sort(renderer.getComparator());
            DiagramElementManager<?> elementManager = builder.getProvider().getElementManager();
            Consumer<Set<Object>> onItemsChosenCallback = MyElementsChosenCallback.create(builder, this.getActionName());
            String popupTitle = allElementsToAdd.size() == 1 ? this.getPopupTitle(allElementsToAdd.get(0), builder.getProject()) : this.getName();
            return JBPopupFactory.getInstance().createPopupChooserBuilder(allElementsToAdd).setTitle(popupTitle).setMovable(true).setRenderer((ListCellRenderer)renderer).setNamerForFiltering(elementManager::getElementTitle).setSelectionMode(2).setItemsChosenCallback(onItemsChosenCallback).createPopup();
        });
        try {
            JBPopup popup;
            JBPopup jBPopup = popup = this.myElementsProvider.showProgress() ? (JBPopup)ProgressManager.getInstance().runProcessWithProgressSynchronously(popupCreator, this.myElementsProvider.getProgressMessage(), true, builder.getProject()) : (JBPopup)popupCreator.compute();
            if (popup != null) {
                if (selectedNodes.size() == 1) {
                    GraphCanvasLocationService.getInstance().showPopupBeneathNode(popup, builder.getGraphBuilder(), Objects.requireNonNull(builder.getNode(selectedNodes.iterator().next())));
                } else {
                    GraphCanvasLocationService.getInstance().showInGraphCenter(popup, builder.getGraphBuilder());
                }
            }
        }
        catch (Exception e) {
            Logger.getInstance(AddElementsFromPopupAction.class).error((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 8, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsProvider";
                break;
            }
            case 1: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/core/actions/popup/AddElementsFromPopupAction";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedNodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/core/actions/popup/AddElementsFromPopupAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getElements";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPopupTitle";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isUndoable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getElements";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPopupTitle";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "showPopup";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 8, 10 -> new IllegalStateException(string);
        };
    }

    private class DefaultUmlElementsListCellRenderer
    extends UmlElementsListCellRenderer {
        @NotNull
        private final List<Object> myExistingModelElements;

        DefaultUmlElementsListCellRenderer() {
            super(AddElementsFromPopupAction.this.myBuilder.getProvider());
            this.myExistingModelElements = ContainerUtil.map(AddElementsFromPopupAction.this.myBuilder.getNodeObjects(), it -> it.getIdentifyingElement());
        }

        @Override
        public Comparator<Object> getComparator() {
            Comparator comp = super.getComparator();
            return (c1, c2) -> {
                boolean b1 = this.myExistingModelElements.contains(c1);
                boolean b2 = this.myExistingModelElements.contains(c2);
                if (b1 && b2 || !b1 && !b2) {
                    int result = AddElementsFromPopupAction.this.myElementsProvider.getComparator().compare(c1, c2);
                    return result == 0 ? comp.compare(c1, c2) : result;
                }
                return b1 ? 1 : -1;
            };
        }

        @Override
        protected int getIconFlags() {
            return 0;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.removeAll();
            DefaultListCellRenderer rightRenderer = DefaultUmlElementsListCellRenderer.getRightCellRenderer(value);
            if (rightRenderer != null) {
                Component rightCellRendererComponent = rightRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                this.add(rightCellRendererComponent, "East");
                JPanel spacer = new JPanel();
                spacer.setBorder((Border)JBUI.Borders.empty((int)0, (int)2));
                spacer.setBackground(isSelected ? UIUtil.getListSelectionBackground((boolean)true) : UIUtil.getListBackground());
                this.add((Component)spacer, "Center");
            }
            Component leftCellRendererComponent = new LeftRenderer().getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            this.add(leftCellRendererComponent, "West");
            this.setBackground(isSelected ? UIUtil.getListSelectionBackground((boolean)true) : UIUtil.getListBackground());
            return this;
        }

        private final class LeftRenderer
        extends ColoredListCellRenderer<Object> {
            private LeftRenderer() {
            }

            protected void customizeCellRenderer(@NotNull JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    LeftRenderer.$$$reportNull$$$0(0);
                }
                if (value instanceof PsiElement) {
                    PsiElement element = (PsiElement)value;
                    PsiFile psiFile = element.getContainingFile();
                    VirtualFile vFile = psiFile.getVirtualFile();
                    boolean isProblemFile = vFile != null && WolfTheProblemSolver.getInstance((Project)psiFile.getProject()).isProblemFile(vFile);
                    Color color = vFile != null ? FileStatusManager.getInstance((Project)psiFile.getProject()).getStatus(vFile).getColor() : list.getForeground();
                    SimpleTextAttributes nameAttributes = this.computeTitleAttributes(element, isProblemFile, color);
                    this.append(Objects.requireNonNull(DefaultUmlElementsListCellRenderer.this.getElementText(element)), nameAttributes);
                    this.setIcon(element.getIcon(DefaultUmlElementsListCellRenderer.this.getIconFlags()));
                } else {
                    DiagramElementManager<?> elementManager = AddElementsFromPopupAction.this.myBuilder.getProvider().getElementManager();
                    this.setIcon(elementManager.getItemIcon(null, value, null));
                    SimpleColoredText text = elementManager.getItemName(value, AddElementsFromPopupAction.this.myBuilder);
                    if (text != null && DefaultUmlElementsListCellRenderer.this.myExistingModelElements.contains(value) && text.getTexts().size() == 1) {
                        text = new SimpleColoredText((String)text.getTexts().get(0), new SimpleTextAttributes(2, (Color)JBColor.GRAY));
                    }
                    if (text != null) {
                        text.appendToComponent((ColoredTextContainer)this);
                    }
                }
                this.setPaintFocusBorder(false);
                this.setBackground(selected ? UIUtil.getListSelectionBackground((boolean)true) : UIUtil.getListBackground());
            }

            @NotNull
            private SimpleTextAttributes computeTitleAttributes(PsiElement element, boolean isProblemFile, Color color) {
                TextAttributes attributes = DefaultUmlElementsListCellRenderer.this.myExistingModelElements.contains(element) ? new TextAttributes((Color)JBColor.GRAY, null, null, null, 2) : (TextAttributes)Optional.ofNullable(element).map(it -> (NavigationItem)ObjectUtils.tryCast((Object)it, NavigationItem.class)).map(it -> it.getPresentation()).map(it -> (ColoredItemPresentation)ObjectUtils.tryCast((Object)it, ColoredItemPresentation.class)).map(it -> it.getTextAttributesKey()).map(it -> EditorColorsManager.getInstance().getGlobalScheme().getAttributes(it)).orElse(null);
                if (isProblemFile) {
                    attributes = TextAttributes.merge((TextAttributes)new TextAttributes(color, null, (Color)JBColor.red, EffectType.WAVE_UNDERSCORE, 0), (TextAttributes)attributes);
                }
                return attributes != null ? SimpleTextAttributes.fromTextAttributes((TextAttributes)attributes) : new SimpleTextAttributes(0, color);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/uml/core/actions/popup/AddElementsFromPopupAction$DefaultUmlElementsListCellRenderer$LeftRenderer", "customizeCellRenderer"));
            }
        }
    }

    private static final class MyElementsChosenCallback
    implements Consumer<Set<Object>> {
        @NotNull
        private final DiagramBuilder myBuilder;

        private MyElementsChosenCallback(@NotNull DiagramBuilder builder) {
            if (builder == null) {
                MyElementsChosenCallback.$$$reportNull$$$0(0);
            }
            this.myBuilder = builder;
        }

        @NotNull
        static Consumer<Set<Object>> create(@NotNull DiagramBuilder builder, @NotNull @Nls String actionName) {
            if (builder == null) {
                MyElementsChosenCallback.$$$reportNull$$$0(1);
            }
            if (actionName == null) {
                MyElementsChosenCallback.$$$reportNull$$$0(2);
            }
            Consumer<Set<Object>> consumer = DiagramAction.createCallback(builder, new DiagramActionPopupConsumer.Adapter<Set<Object>>(new MyElementsChosenCallback(builder), actionName));
            if (consumer == null) {
                MyElementsChosenCallback.$$$reportNull$$$0(3);
            }
            return consumer;
        }

        public void consume(Set<Object> newElements) {
            Map existingModelElementsToNode = ContainerUtil.newMapFromValues(this.myBuilder.getNodeObjects().iterator(), it -> it.getIdentifyingElement());
            if (existingModelElementsToNode.keySet().containsAll(newElements)) {
                this.selectAndFocusViewOnNodes(ContainerUtil.map(newElements, it -> (DiagramNode)existingModelElementsToNode.get(it)));
            } else {
                DiagramDataModel<?> model = this.myBuilder.getDataModel();
                List addedNodes = newElements.stream().filter(it -> !existingModelElementsToNode.containsKey(it)).flatMap(it -> model.addMultiNodeElement(it).stream()).filter(Objects::nonNull).collect(Collectors.toList());
                DiagramUpdateService.getInstance().requestDataModelRefreshPreservingLayout(this.myBuilder).withNodeSizeUpdate((DiagramNode[])addedNodes.toArray(DiagramNode[]::new)).runAsync().thenRunAsync(() -> {
                    JBPopup popup;
                    if (this.myBuilder.isPopupMode() && !addedNodes.isEmpty() && (popup = this.myBuilder.getPopup()) != null) {
                        GraphCanvasLocationService.getInstance().setBestPopupSizeForGraph(popup, this.myBuilder.getGraphBuilder());
                    }
                    this.selectAndFocusViewOnNodes(addedNodes);
                }, Futures.inEdt());
            }
        }

        private void selectAndFocusViewOnNodes(@NotNull List<? extends DiagramNode<?>> nodes) {
            if (nodes == null) {
                MyElementsChosenCallback.$$$reportNull$$$0(4);
            }
            Graph2D graph = this.myBuilder.getGraph();
            graph.unselectAll();
            List existingNodes = ContainerUtil.mapNotNull(nodes, it -> this.myBuilder.getNode((DiagramNode<?>)it));
            GraphSelectionService.getInstance().selectAllNodes(graph, (Collection)existingNodes, true);
            GraphAnimationService.getInstance().focusViewOnNodes(this.myBuilder.getGraphBuilder(), (Collection)existingNodes, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/uml/core/actions/popup/AddElementsFromPopupAction$MyElementsChosenCallback";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/uml/core/actions/popup/AddElementsFromPopupAction$MyElementsChosenCallback";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "selectAndFocusViewOnNodes";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

