/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.index;

import com.intellij.json.JsonFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.swagger.core.index.SwJsonLexerSpecificationRecognizerKt;
import com.intellij.swagger.core.index.SwReferenceData;
import com.intellij.swagger.core.index.SwTokenSearchParameters;
import com.intellij.swagger.core.index.SwTokenSearchResult;
import com.intellij.swagger.core.index.SwYamlLexerSpecificationRecognizerKt;
import com.intellij.swagger.core.reference.definitions.SwObjectCoordinates;
import com.intellij.swagger.core.reference.definitions.SwObjectDefinitionResolverKt;
import com.intellij.util.PathUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileContent;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLFileType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u001a\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0004\u0012\u00020\u00050\u0001B\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007J\"\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/intellij/swagger/core/index/SwReferenceIndexer;", "Lcom/intellij/util/indexing/DataIndexer;", "", "", "Lcom/intellij/swagger/core/index/SwReferenceData;", "Lcom/intellij/util/indexing/FileContent;", "<init>", "()V", "referencesThroughoutTheFileSearchParameters", "Lcom/intellij/swagger/core/index/SwTokenSearchParameters;", "getReferencesThroughoutTheFileSearchParameters", "()Lcom/intellij/swagger/core/index/SwTokenSearchParameters;", "referencesThroughoutTheFileSearchParameters$delegate", "Lkotlin/Lazy;", "map", "", "inputData", "parseReferenceData", "nodeIdAndOffset", "Lcom/intellij/swagger/core/index/SwTokenSearchResult;", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nSwReferenceIndexer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwReferenceIndexer.kt\ncom/intellij/swagger/core/index/SwReferenceIndexer\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,39:1\n996#2:40\n1025#2,3:41\n1028#2,3:51\n382#3,7:44\n*S KotlinDebug\n*F\n+ 1 SwReferenceIndexer.kt\ncom/intellij/swagger/core/index/SwReferenceIndexer\n*L\n25#1:40\n25#1:41,3\n25#1:51,3\n25#1:44,7\n*E\n"})
public final class SwReferenceIndexer
implements DataIndexer<String, List<? extends SwReferenceData>, FileContent> {
    @NotNull
    private final Lazy referencesThroughoutTheFileSearchParameters$delegate = LazyKt.lazy(SwReferenceIndexer::referencesThroughoutTheFileSearchParameters_delegate$lambda$0);

    private final SwTokenSearchParameters getReferencesThroughoutTheFileSearchParameters() {
        Lazy lazy = this.referencesThroughoutTheFileSearchParameters$delegate;
        return (SwTokenSearchParameters)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<String, List<SwReferenceData>> map(@NotNull FileContent inputData) {
        void $this$groupByTo$iv$iv;
        Sequence<SwTokenSearchResult> sequence;
        Intrinsics.checkNotNullParameter((Object)inputData, (String)"inputData");
        FileType fileType = inputData.getFileType();
        if (fileType instanceof YAMLFileType) {
            VirtualFile virtualFile = inputData.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
            CharSequence charSequence = inputData.getContentAsText();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getContentAsText(...)");
            sequence = SwYamlLexerSpecificationRecognizerKt.queryYamlKeyValues(virtualFile, charSequence, this.getReferencesThroughoutTheFileSearchParameters());
        } else if (fileType instanceof JsonFileType) {
            VirtualFile virtualFile = inputData.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
            CharSequence charSequence = inputData.getContentAsText();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getContentAsText(...)");
            sequence = SwJsonLexerSpecificationRecognizerKt.queryJsonProperties(virtualFile, charSequence, this.getReferencesThroughoutTheFileSearchParameters());
        } else {
            return MapsKt.emptyMap();
        }
        Sequence<SwTokenSearchResult> lexerBasedQuery = sequence;
        Sequence $this$groupBy$iv = SequencesKt.mapNotNull(lexerBasedQuery, (Function1)((Function1)new Function1<SwTokenSearchResult, SwReferenceData>((Object)this){

            public final SwReferenceData invoke(SwTokenSearchResult p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return SwReferenceIndexer.access$parseReferenceData((SwReferenceIndexer)this.receiver, p0);
            }
        }));
        boolean $i$f$groupBy = false;
        Sequence sequence2 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            void $this$getOrPut$iv$iv$iv;
            String key$iv$iv;
            SwReferenceData referenceData = (SwReferenceData)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)PathUtil.getFileName((String)referenceData.getTargetFileRelativePath()), (String)"getFileName(...)");
            Map map2 = destination$iv$iv;
            String key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        return destination$iv$iv;
    }

    private final SwReferenceData parseReferenceData(SwTokenSearchResult nodeIdAndOffset) {
        CharSequence charSequence;
        String string = nodeIdAndOffset.getValueText();
        TextRange textRange = TextRange.create((int)0, (int)nodeIdAndOffset.getValueText().length());
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"create(...)");
        SwObjectCoordinates coordinates = SwObjectDefinitionResolverKt.parseObjectCoordinates(string, textRange);
        String targetFileRelativePath = coordinates.getUriValue();
        return coordinates.isLocalPathCoordinates() && !((charSequence = (CharSequence)targetFileRelativePath) == null || StringsKt.isBlank((CharSequence)charSequence)) ? new SwReferenceData(targetFileRelativePath, nodeIdAndOffset.getOffset(), coordinates.referencesEntireFile()) : null;
    }

    private static final SwTokenSearchParameters referencesThroughoutTheFileSearchParameters_delegate$lambda$0() {
        return new SwTokenSearchParameters(SetsKt.setOf((Object)"$ref"), false);
    }

    public static final /* synthetic */ SwReferenceData access$parseReferenceData(SwReferenceIndexer $this, SwTokenSearchResult nodeIdAndOffset) {
        return $this.parseReferenceData(nodeIdAndOffset);
    }
}

