/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.filters.branches;

import com.intellij.rt.coverage.data.JumpData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.SwitchData;
import com.intellij.rt.coverage.instrumentation.data.InstrumentationData;
import com.intellij.rt.coverage.instrumentation.filters.KotlinUtils;
import com.intellij.rt.coverage.instrumentation.filters.lines.CoverageFilter;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.coverage.org.objectweb.asm.Label;

public class KotlinWhenMappingExceptionFilter
extends CoverageFilter {
    private Map<Label, PositionData> myJumpLabels;
    private Map<Label, PositionData> mySwitchLabels;
    private Label myCurrentLabel = null;
    private int myCurrentLine;
    private int myState = 0;
    private Label myJumpLabel;

    public boolean isApplicable(InstrumentationData context) {
        return KotlinUtils.isKotlinClass(context);
    }

    /*
     * WARNING - void declaration
     */
    public void visitLineNumber(int line, Label start) {
        void var1_1;
        void var2_2;
        super.visitLineNumber(line, (Label)var2_2);
        this.myCurrentLine = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void visitLabel(Label label) {
        void var1_1;
        super.visitLabel(label);
        this.myCurrentLabel = label;
        if (this.myState == 2 && var1_1 == this.myJumpLabel) {
            this.myContext.removeLastJump();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void visitJumpInsn(int opcode, Label label) {
        void var2_2;
        void var1_1;
        LineData lineData;
        this.myJumpLabel = label;
        this.myState = 1;
        if (opcode != 167 && opcode != 168 && (lineData = this.myContext.getLineData(this.myCurrentLine)) != null) {
            void var3_3;
            if (this.myJumpLabels == null) {
                this.myJumpLabels = new HashMap<Label, PositionData>();
            }
            this.myJumpLabels.put(label, new PositionData(this.myCurrentLine, var3_3.jumpsCount()));
        }
        super.visitJumpInsn((int)var1_1, (Label)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        void var3_3;
        void var2_2;
        void var1_1;
        LineData lineData = this.myContext.getLineData(this.myCurrentLine);
        if (lineData != null) {
            if (this.mySwitchLabels == null) {
                this.mySwitchLabels = new HashMap<Label, PositionData>();
            }
            this.mySwitchLabels.put(dflt, new PositionData(this.myCurrentLine, lineData.switchesCount()));
        }
        super.visitTableSwitchInsn((int)var1_1, (int)var2_2, (Label)var3_3, labels);
    }

    /*
     * WARNING - void declaration
     */
    public void visitTypeInsn(int opcode, String type) {
        super.visitTypeInsn(opcode, type);
        if (opcode == 187 && type.equals("kotlin/NoWhenBranchMatchedException")) {
            void var2_3;
            SwitchData switchData;
            LineData lineData;
            PositionData switchPosition;
            JumpData jumpData;
            LineData lineData2;
            this.myState = this.myState == 1 ? 2 : 0;
            PositionData jumpPosition = this.myJumpLabels == null ? null : this.myJumpLabels.get(this.myCurrentLabel);
            if (jumpPosition != null && (lineData2 = this.myContext.getLineData(jumpPosition.myLine)) != null && jumpPosition.myIndex < lineData2.jumpsCount() && (jumpData = lineData2.getJumpData(jumpPosition.myIndex)) != null) {
                jumpData.touchFalseHit();
            }
            if ((switchPosition = this.mySwitchLabels == null ? null : this.mySwitchLabels.get(this.myCurrentLabel)) != null && (lineData = this.myContext.getLineData(switchPosition.myLine)) != null && switchPosition.myIndex < lineData.switchesCount() && (switchData = lineData.getSwitchData(((PositionData)var2_3).myIndex)) != null) {
                void var1_2;
                var1_2.touch(-1);
            }
            return;
        }
        this.myState = 0;
    }

    private static class PositionData {
        private final int myLine;
        private final int myIndex;

        /*
         * WARNING - void declaration
         */
        private PositionData(int line, int index) {
            void var2_2;
            void var1_1;
            this.myLine = var1_1;
            this.myIndex = var2_2;
        }
    }
}

