import React from 'react';
import { Extensions, Href, Markdown, Tags } from '../../components';
import { useSpec } from '../../contexts';
import { TERMS_OF_SERVICE_TEXT, CONTENT_TYPES_SITE, URL_SUPPORT_TEXT, EXTERAL_DOCUMENTATION_TEXT, } from '../../constants';
export var Info = function () {
    var _a, _b, _c, _d, _e, _f, _g;
    var asyncapi = useSpec();
    var info = asyncapi.info();
    if (!info) {
        return null;
    }
    var specId = asyncapi.info().id();
    var externalDocs = asyncapi.info().externalDocs();
    var license = info.license();
    var termsOfService = info.termsOfService();
    var defaultContentType = asyncapi.defaultContentType();
    var contact = info.contact();
    var extensions = info.extensions();
    var showInfoList = (_c = (_b = (_a = license !== null && license !== void 0 ? license : termsOfService) !== null && _a !== void 0 ? _a : defaultContentType) !== null && _b !== void 0 ? _b : contact) !== null && _c !== void 0 ? _c : externalDocs;
    return (React.createElement("div", { className: "panel-item" },
        React.createElement("div", { className: "panel-item--center px-8 text-left", id: "introduction" },
            React.createElement("div", { className: "text-4xl" },
                info.title(),
                "\u00A0",
                info.version()),
            showInfoList && (React.createElement("ul", { className: "flex flex-wrap mt-2 leading-normal" },
                license && (React.createElement("li", { className: "inline-block mt-2 mr-2" }, license.url() ? (React.createElement(Href, { className: "border border-solid border-orange-300 hover:bg-orange-300 hover:text-orange-600 text-orange-500 font-bold no-underline text-xs uppercase rounded px-3 py-1", href: (_d = license.url()) !== null && _d !== void 0 ? _d : '' },
                    React.createElement("span", null, license.name()))) : (React.createElement("strong", { className: "border border-solid border-orange-300 hover:bg-orange-300 hover:text-orange-600 text-orange-500 no-underline text-xs uppercase rounded px-3 py-1" }, license.name())))),
                termsOfService && (React.createElement("li", { className: "inline-block mt-2 mr-2" },
                    React.createElement(Href, { className: "border border-solid border-orange-300 hover:bg-orange-300 hover:text-orange-600 text-orange-500 font-bold no-underline text-xs uppercase rounded px-3 py-1", href: termsOfService },
                        React.createElement("span", null, TERMS_OF_SERVICE_TEXT)))),
                defaultContentType && (React.createElement("li", { className: "inline-block mt-2 mr-2" },
                    React.createElement(Href, { className: "border border-solid border-orange-300 hover:bg-orange-300 hover:text-orange-600 text-orange-500 font-bold no-underline text-xs uppercase rounded px-3 py-1", href: "".concat(CONTENT_TYPES_SITE, "/").concat(defaultContentType) },
                        React.createElement("span", null, defaultContentType)))),
                externalDocs && (React.createElement("li", { className: "inline-block mt-2 mr-2" },
                    React.createElement(Href, { className: "border border-solid border-orange-300 hover:bg-orange-300 hover:text-orange-600 text-orange-500 font-bold no-underline text-xs uppercase rounded px-3 py-1", href: externalDocs.url(), title: (_e = externalDocs.description()) !== null && _e !== void 0 ? _e : undefined },
                        React.createElement("span", null, EXTERAL_DOCUMENTATION_TEXT)))),
                contact && (React.createElement(React.Fragment, null,
                    contact.url() && (React.createElement("li", { className: "inline-block mt-2 mr-2" },
                        React.createElement(Href, { className: "border border-solid border-purple-300 hover:bg-purple-300 hover:text-purple-600 text-purple-500 font-bold no-underline text-xs uppercase rounded px-3 py-1", href: (_f = contact.url()) !== null && _f !== void 0 ? _f : '' },
                            React.createElement("span", null, (_g = contact.name()) !== null && _g !== void 0 ? _g : URL_SUPPORT_TEXT)))),
                    contact.email() && (React.createElement("li", { className: "inline-block mt-2 mr-2" },
                        React.createElement(Href, { className: "border border-solid border-purple-300 hover:bg-purple-300 hover:text-purple-600 text-purple-500 font-bold no-underline text-xs uppercase rounded px-3 py-1", href: "mailto:".concat(contact.email()) },
                            React.createElement("span", null, contact.email())))))),
                specId && (React.createElement("li", { className: "inline-block mt-2 mr-2" },
                    React.createElement("strong", { className: "border border-solid border-blue-300 hover:bg-blue-300 hover:text-blue-600 text-blue-500 no-underline text-xs uppercase rounded px-3 py-1" },
                        "ID: ",
                        specId))))),
            info.hasDescription() && (React.createElement("div", { className: "mt-4" },
                React.createElement(Markdown, null, info.description()))),
            asyncapi.info().tags().length > 0 && (React.createElement("div", { className: "mt-4" },
                React.createElement(Tags, { tags: asyncapi.info().tags() }))),
            extensions.length > 0 && (React.createElement("div", { className: "mt-4" },
                React.createElement(Extensions, { name: "Info Extensions", item: info })))),
        React.createElement("div", { className: "panel-item--right" })));
};
//# sourceMappingURL=Info.js.map