/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.wip;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.concurrency.Semaphore;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jsonProtocol.EventMap;
import org.jetbrains.jsonProtocol.EventType;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.wip.JSDebuggerWipBackendBundle;
import org.jetbrains.wip.WipVm;
import org.jetbrains.wip.protocol.ProtocolResponseReader;
import org.jetbrains.wip.protocol.heapprofiler.AddHeapSnapshotChunkEventData;
import org.jetbrains.wip.protocol.heapprofiler.HeapProfilerKt;
import org.jetbrains.wip.protocol.heapprofiler.ReportHeapSnapshotProgressEventData;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/wip/WipV8ProfilingHelper;", "", "v8Vm", "Lorg/jetbrains/wip/WipVm;", "<init>", "(Lorg/jetbrains/wip/WipVm;)V", "takeHeapSnapShot", "", "file", "Ljava/io/File;", "intellij.javascript.wip.backend"})
public final class WipV8ProfilingHelper {
    @NotNull
    private final WipVm v8Vm;

    public WipV8ProfilingHelper(@NotNull WipVm v8Vm) {
        Intrinsics.checkNotNullParameter((Object)((Object)v8Vm), (String)"v8Vm");
        this.v8Vm = v8Vm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nls
    @Nullable
    public final String takeHeapSnapShot(@NotNull File file) {
        Throwable throwable;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Semaphore semaphore = new Semaphore();
        AtomicReference<String> error = new AtomicReference<String>();
        AtomicReference throwableRef = new AtomicReference();
        Closeable closeable = new BufferedOutputStream(new FileOutputStream(file));
        Throwable throwable2 = null;
        try {
            BufferedOutputStream output = (BufferedOutputStream)closeable;
            boolean bl = false;
            EventMap<ProtocolResponseReader> eventMap = this.v8Vm.getCommandProcessor().getEventMap();
            Function1 chunkHandler = arg_0 -> WipV8ProfilingHelper.takeHeapSnapShot$lambda$8$lambda$0(output, arg_0);
            eventMap.add((EventType)AddHeapSnapshotChunkEventData.TYPE, chunkHandler);
            Function1 progressHandler = WipV8ProfilingHelper::takeHeapSnapShot$lambda$8$lambda$1;
            eventMap.add((EventType)ReportHeapSnapshotProgressEventData.TYPE, progressHandler);
            semaphore.down();
            this.v8Vm.getCommandProcessor().send((Request)HeapProfilerKt.TakeHeapSnapshot$default(null, null, null, null, 15, null)).onError(arg_0 -> WipV8ProfilingHelper.takeHeapSnapShot$lambda$8$lambda$3(arg_0 -> WipV8ProfilingHelper.takeHeapSnapShot$lambda$8$lambda$2(error, throwableRef, arg_0), arg_0)).onError(arg_0 -> WipV8ProfilingHelper.takeHeapSnapShot$lambda$8$lambda$5(arg_0 -> WipV8ProfilingHelper.takeHeapSnapShot$lambda$8$lambda$4(throwableRef, arg_0), arg_0)).onProcessed(arg_0 -> WipV8ProfilingHelper.takeHeapSnapShot$lambda$8$lambda$7(arg_0 -> WipV8ProfilingHelper.takeHeapSnapShot$lambda$8$lambda$6(eventMap, chunkHandler, progressHandler, semaphore, arg_0), arg_0));
            if (!semaphore.waitFor(TimeUnit.MINUTES.toMillis(3L))) {
                error.set(JSDebuggerWipBackendBundle.message("error.timeout.occurred.when.saving.v8.heap.snapshot", new Object[0]));
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable3) {
            throwable2 = throwable3;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
        }
        Throwable throwable4 = throwable = (Throwable)throwableRef.get();
        if (throwable4 != null) {
            throw throwable4;
        }
        String message = (String)error.get();
        return message;
    }

    private static final Unit takeHeapSnapShot$lambda$8$lambda$0(BufferedOutputStream $output, AddHeapSnapshotChunkEventData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.chunk();
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        $output.write(byArray);
        return Unit.INSTANCE;
    }

    private static final Unit takeHeapSnapShot$lambda$8$lambda$1(ReportHeapSnapshotProgressEventData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.getFinished()) {
            ProgressManager.progress((String)JSDebuggerWipBackendBundle.message("js.profile.progress.text.v8.heap.snapshot.recorded", new Object[0]));
        } else {
            Object[] objectArray = "%.1f";
            Object[] objectArray2 = new Object[]{(double)it.getDone() / (double)it.getTotal()};
            String string = String.format((String)objectArray, Arrays.copyOf(objectArray2, objectArray2.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            String progress = string;
            objectArray = new Object[]{progress};
            ProgressManager.progress((String)JSDebuggerWipBackendBundle.message("js.profile.progress.text.saving.v8.heap.snapshot.recorded", objectArray));
        }
        return Unit.INSTANCE;
    }

    private static final Unit takeHeapSnapShot$lambda$8$lambda$2(AtomicReference $error, AtomicReference $throwableRef, Throwable it) {
        $error.set(JSDebuggerWipBackendBundle.message("error.taking.v8.snapshot.rejected", new Object[0]));
        $throwableRef.set(it);
        return Unit.INSTANCE;
    }

    private static final void takeHeapSnapShot$lambda$8$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit takeHeapSnapShot$lambda$8$lambda$4(AtomicReference $throwableRef, Throwable it) {
        $throwableRef.set(it);
        return Unit.INSTANCE;
    }

    private static final void takeHeapSnapShot$lambda$8$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit takeHeapSnapShot$lambda$8$lambda$6(EventMap $eventMap, Function1 $chunkHandler, Function1 $progressHandler, Semaphore $semaphore, Unit it) {
        $eventMap.remove((EventType)AddHeapSnapshotChunkEventData.TYPE, $chunkHandler);
        $eventMap.remove((EventType)ReportHeapSnapshotProgressEventData.TYPE, $progressHandler);
        $semaphore.up();
        return Unit.INSTANCE;
    }

    private static final void takeHeapSnapShot$lambda$8$lambda$7(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

