/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.google.common.collect.ImmutableSet;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptDirectivesCompletionProvider
extends CompletionProvider<CompletionParameters> {
    private static final List<String> TS_DIRECTIVES_FOR_TS = Arrays.asList("ts-ignore", "ts-nocheck", "ts-expect-error");
    private static final Collection<String> TS_DIRECTIVES_FOR_JS = ImmutableSet.copyOf((Collection)ContainerUtil.concat(TS_DIRECTIVES_FOR_TS, List.of("ts-check")));

    private static int findDirectiveStartIndex(@Nullable String s) {
        if (s == null || s.length() < 3 || !s.startsWith("//")) {
            return -1;
        }
        int firstAtSingIndex = s.indexOf(64);
        if (firstAtSingIndex != -1) {
            int i;
            int n = i = s.charAt(2) == '/' ? 3 : 2;
            while (i < firstAtSingIndex) {
                if (!Character.isWhitespace(s.charAt(i))) {
                    return -1;
                }
                ++i;
            }
        }
        return firstAtSingIndex;
    }

    private static boolean isCaretInDirectiveName(@NotNull String s, int startIndex) {
        if (s == null) {
            TypeScriptDirectivesCompletionProvider.$$$reportNull$$$0(0);
        }
        for (int i = startIndex; i < s.length(); ++i) {
            if (Character.isLetter(s.charAt(i)) || s.charAt(i) == '-') continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static String getCharsBetweenCommentStartAndCaret(@NotNull PsiElement comment, int offset) {
        if (comment == null) {
            TypeScriptDirectivesCompletionProvider.$$$reportNull$$$0(1);
        }
        String text = comment.getText();
        int caretIndex = offset - comment.getTextOffset();
        if (caretIndex < 0) {
            return null;
        }
        return text.substring(0, caretIndex);
    }

    public static boolean shouldSuggestDirectives(@NotNull PsiElement comment, int offset) {
        if (comment == null) {
            TypeScriptDirectivesCompletionProvider.$$$reportNull$$$0(2);
        }
        String charsBetweenCommentStartAndCaret = TypeScriptDirectivesCompletionProvider.getCharsBetweenCommentStartAndCaret(comment, offset);
        int directiveStartIndex = TypeScriptDirectivesCompletionProvider.findDirectiveStartIndex(charsBetweenCommentStartAndCaret);
        return TypeScriptDirectivesCompletionProvider.shouldSuggestDirectives(charsBetweenCommentStartAndCaret, directiveStartIndex);
    }

    private static boolean shouldSuggestDirectives(@Nullable String charsBetweenCommentStartAndCaret, int directiveStartIndex) {
        return charsBetweenCommentStartAndCaret != null && directiveStartIndex != -1 && TypeScriptDirectivesCompletionProvider.isCaretInDirectiveName(charsBetweenCommentStartAndCaret, directiveStartIndex + 1);
    }

    @NotNull
    private static String resolvePrefix(@NotNull String charsBetweenCommentStartAndCaret, int directiveStartIndex) {
        if (charsBetweenCommentStartAndCaret == null) {
            TypeScriptDirectivesCompletionProvider.$$$reportNull$$$0(3);
        }
        String string = charsBetweenCommentStartAndCaret.substring(directiveStartIndex + 1);
        if (string == null) {
            TypeScriptDirectivesCompletionProvider.$$$reportNull$$$0(4);
        }
        return string;
    }

    protected void addCompletions(@NotNull CompletionParameters parameters2, @NotNull ProcessingContext context2, @NotNull CompletionResultSet result2) {
        int directiveStartIndex;
        int offset;
        PsiElement comment;
        String charsBetweenCommentStartAndCaret;
        if (parameters2 == null) {
            TypeScriptDirectivesCompletionProvider.$$$reportNull$$$0(5);
        }
        if (context2 == null) {
            TypeScriptDirectivesCompletionProvider.$$$reportNull$$$0(6);
        }
        if (result2 == null) {
            TypeScriptDirectivesCompletionProvider.$$$reportNull$$$0(7);
        }
        if (TypeScriptDirectivesCompletionProvider.shouldSuggestDirectives(charsBetweenCommentStartAndCaret = TypeScriptDirectivesCompletionProvider.getCharsBetweenCommentStartAndCaret(comment = parameters2.getPosition(), offset = parameters2.getOffset()), directiveStartIndex = TypeScriptDirectivesCompletionProvider.findDirectiveStartIndex(charsBetweenCommentStartAndCaret))) {
            String prefix = TypeScriptDirectivesCompletionProvider.resolvePrefix(charsBetweenCommentStartAndCaret, directiveStartIndex);
            PrefixMatcher prefixMatcher = result2.getPrefixMatcher().cloneWithPrefix(prefix);
            CompletionResultSet set = result2.withPrefixMatcher(prefixMatcher);
            Collection<String> variants = DialectDetector.isTypeScript(comment) ? TS_DIRECTIVES_FOR_TS : TS_DIRECTIVES_FOR_JS;
            for (String variant : variants) {
                set.addElement((LookupElement)LookupElementBuilder.create((String)variant));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charsBetweenCommentStartAndCaret";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/completion/TypeScriptDirectivesCompletionProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/completion/TypeScriptDirectivesCompletionProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "resolvePrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isCaretInDirectiveName";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCharsBetweenCommentStartAndCaret";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "shouldSuggestDirectives";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resolvePrefix";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addCompletions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

