/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.modules.JSSimpleModuleReferenceInfo;
import com.intellij.lang.javascript.modules.JsDefinedInObject;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.settings.JSApplicationSettings;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSModuleReferenceExpressionInfo
extends JSSimpleModuleReferenceInfo {
    @Nullable
    private final String myParentName;
    @Nullable
    private final JSReferenceExpression myParent;
    @NotNull
    private final JSContext myContext;

    public static boolean isShowHint(@NotNull PsiElement element2) {
        if (element2 == null) {
            JSModuleReferenceExpressionInfo.$$$reportNull$$$0(0);
        }
        if (DialectDetector.isTypeScript(element2)) {
            return JSApplicationSettings.getInstance().showTSImportPopupEffective(element2.getProject());
        }
        if (!JSApplicationSettings.getInstance().showJSImportPopupEffective(element2.getProject())) {
            return false;
        }
        return ES6PsiUtil.findExternalModule(element2) != null;
    }

    public JSModuleReferenceExpressionInfo(@NotNull JSReferenceExpression node) {
        String name;
        if (node == null) {
            JSModuleReferenceExpressionInfo.$$$reportNull$$$0(1);
        }
        super(node.getReferenceName(), JSModuleReferenceExpressionInfo.isShowHint((PsiElement)node));
        PsiElement parent = JSModuleReferenceExpressionInfo.getParentElement(node);
        this.myContext = node.getParent() instanceof JSNewExpression ? JSContext.INSTANCE : JSContext.STATIC;
        String string = name = parent == null ? null : ((JSReferenceExpression)parent).getReferenceName();
        if (name == null || JsDefinedInObject.isPredefined(name, DialectDetector.dialectOfElement((PsiElement)node))) {
            this.myParent = null;
            this.myParentName = null;
            return;
        }
        this.myParentName = name;
        this.myParent = (JSReferenceExpression)parent;
    }

    @Nullable
    private static PsiElement getParentElement(@NotNull JSReferenceExpression node) {
        if (node == null) {
            JSModuleReferenceExpressionInfo.$$$reportNull$$$0(2);
        }
        if (node.getParent() instanceof JSNewExpression) {
            PsiElement parentOverNewExpression = node.getParent().getParent();
            if (parentOverNewExpression instanceof JSReferenceExpression) {
                return parentOverNewExpression;
            }
        } else if (node.getParent() instanceof JSReferenceExpression) {
            return node.getParent();
        }
        return null;
    }

    @Override
    @NotNull
    public Collection<PsiElement> getResolvedParent() {
        JSReferenceExpression ref2 = this.myParent;
        List<PsiElement> list = ref2 == null ? ContainerUtil.emptyList() : JSResolveResult.toElements(ref2.multiResolve(false));
        if (list == null) {
            JSModuleReferenceExpressionInfo.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    @Nullable
    public PsiElement getParentRef() {
        return this.myParent;
    }

    @Override
    @NotNull
    public JSContext getContext() {
        JSContext jSContext = this.myContext;
        if (jSContext == null) {
            JSModuleReferenceExpressionInfo.$$$reportNull$$$0(4);
        }
        return jSContext;
    }

    @Override
    @Nullable
    public String getParentName() {
        return this.myParentName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/JSModuleReferenceExpressionInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/JSModuleReferenceExpressionInfo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedParent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isShowHint";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getParentElement";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

