/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.template.postfix;

import com.intellij.codeInsight.template.postfix.templates.editable.PostfixTemplateExpressionCondition;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public interface JSTemplateExpressionCondition
extends PostfixTemplateExpressionCondition<JSExpression> {

    public static class ArrayCondition
    implements JSTemplateExpressionCondition {
        @NonNls
        public static final String ID = "arrayType";

        @NotNull
        @Nls
        public String getPresentableName() {
            String string = JavaScriptBundle.message("postfix.template.condition.array.name", new Object[0]);
            if (string == null) {
                ArrayCondition.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getId() {
            return ID;
        }

        public boolean value(@NotNull JSExpression expression) {
            if (expression == null) {
                ArrayCondition.$$$reportNull$$$0(1);
            }
            JSType expanded = TypeScriptTypeRelations.expandAndOptimizeExpressionTypeRecursive(expression);
            expanded = JSArrayType.GenericArrayBuilder.asArrayIfGenericType(expanded);
            return expanded instanceof JSArrayType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/template/postfix/JSTemplateExpressionCondition$ArrayCondition";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/template/postfix/JSTemplateExpressionCondition$ArrayCondition";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "value";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }

    public static class NonVoidCondition
    implements JSTemplateExpressionCondition {
        @NonNls
        public static final String ID = "nonVoid";

        public boolean value(@NotNull JSExpression expression) {
            JSType expanded;
            if (expression == null) {
                NonVoidCondition.$$$reportNull$$$0(0);
            }
            return !((expanded = TypeScriptTypeRelations.expandAndOptimizeExpressionTypeRecursive(expression)) instanceof JSVoidType);
        }

        @NotNull
        @Nls
        public String getPresentableName() {
            String string = JavaScriptBundle.message("postfix.template.condition.non.void.name", new Object[0]);
            if (string == null) {
                NonVoidCondition.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getId() {
            return ID;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/template/postfix/JSTemplateExpressionCondition$NonVoidCondition";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/template/postfix/JSTemplateExpressionCondition$NonVoidCondition";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "value";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static interface Factory {
        public JSTemplateExpressionCondition create();
    }
}

