/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService;

import com.intellij.lang.javascript.validation.JSTooltipWithHtmlHighlighter;
import com.intellij.lang.typescript.compiler.languageService.DiagnosticTemplateParser;
import com.intellij.lang.typescript.compiler.languageService.DiagnosticTemplatesEnProvider;
import com.intellij.lang.typescript.compiler.languageService.DiagnosticTemplatesFallbackProvider;
import com.intellij.lang.typescript.compiler.languageService.DiagnosticTemplatesLocalizedProvider;
import com.intellij.lang.typescript.compiler.languageService.DiagnosticTemplatesMemoryCache;
import com.intellij.lang.typescript.compiler.languageService.DiagnosticTemplatesTsGoLocalProvider;
import com.intellij.lang.typescript.compiler.languageService.Fragment;
import com.intellij.lang.typescript.compiler.languageService.LanguageServiceInfo;
import com.intellij.lang.typescript.compiler.languageService.LanguageServiceKind;
import com.intellij.lang.typescript.compiler.languageService.TemplateFragment;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.xml.util.XmlStringUtil;
import java.util.Collection;
import java.util.List;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nJ\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J\u0018\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J.\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dJ\u0006\u0010\u001e\u001a\u00020\u001fJ(\u0010 \u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J(\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\u0006\u0010\"\u001a\u00020#2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\u0006\u0010\"\u001a\u00020#H\u0002J\u001e\u0010%\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u0005H\u0002R\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/lang/typescript/compiler/languageService/DiagnosticMessageParser;", "", "<init>", "()V", "fragmentsToHtml", "", "fragments", "", "Lcom/intellij/lang/typescript/compiler/languageService/Fragment;", "project", "Lcom/intellij/openapi/project/Project;", "removeQuotesAndLastDot", "Lkotlin/sequences/Sequence;", "truncateIfTooLong", "text", "myMoreInputPattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "myMoreReplacementPattern", "myEllipsisInGenericParamsInputPattern", "myEllipsisInGenericParamsReplacementPattern", "myEllipsisPropertiesInputPattern", "myEllipsisPropertiesReplacementPattern", "highlightCode", "parse", "message", "code", "", "languageServiceInfo", "Lcom/intellij/lang/typescript/compiler/languageService/LanguageServiceInfo;", "isEnabled", "", "parseUnknownCode", "getTemplates", "getCriteria", "Lcom/intellij/lang/typescript/compiler/languageService/DiagnosticTemplatesMemoryCache$GetCriteria;", "getFallbackTemplates", "parseByTemplate", "template", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nDiagnosticMessageParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiagnosticMessageParser.kt\ncom/intellij/lang/typescript/compiler/languageService/DiagnosticMessageParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,194:1\n2746#2,3:195\n*S KotlinDebug\n*F\n+ 1 DiagnosticMessageParser.kt\ncom/intellij/lang/typescript/compiler/languageService/DiagnosticMessageParser\n*L\n112#1:195,3\n*E\n"})
public final class DiagnosticMessageParser {
    @NotNull
    public static final DiagnosticMessageParser INSTANCE = new DiagnosticMessageParser();
    private static final Pattern myMoreInputPattern = Pattern.compile("\\.\\.\\. (\\d+) more \\.\\.\\.;");
    private static final Pattern myMoreReplacementPattern = Pattern.compile("/\\*BUhZknQPcSRRQXyT(\\d+)GihKTTwjRXvSLExT\\*/");
    private static final Pattern myEllipsisInGenericParamsInputPattern = Pattern.compile("(?<=<)\\.\\.\\.(?=>)");
    private static final Pattern myEllipsisInGenericParamsReplacementPattern = Pattern.compile("/\\*mGjFYjwJRMjqpROj\\*/");
    private static final Pattern myEllipsisPropertiesInputPattern = Pattern.compile("\\.\\.\\.;");
    private static final Pattern myEllipsisPropertiesReplacementPattern = Pattern.compile("/\\*qGbNUnlPoCLKOzOh\\*/");

    private DiagnosticMessageParser() {
    }

    @NotNull
    public final String fragmentsToHtml(@NotNull List<? extends Fragment> fragments, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(fragments, (String)"fragments");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return SequencesKt.joinToString$default((Sequence)SequencesKt.map(this.removeQuotesAndLastDot(fragments), arg_0 -> DiagnosticMessageParser.fragmentsToHtml$lambda$0(project, arg_0)), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    }

    private final Sequence<Fragment> removeQuotesAndLastDot(List<? extends Fragment> fragments) {
        return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super Fragment>, Continuation<? super Unit>, Object>(fragments, null){
            Object L$1;
            int I$0;
            int I$1;
            int I$2;
            int I$3;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ List<Fragment> $fragments;
            {
                this.$fragments = $fragments;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (SequenceScope)this.L$0;
                var8_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                block0 : switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        i = 0;
                        var4_5 = ((Collection)this.$fragments).size();
lbl8:
                        // 2 sources

                        while (i < var4_5) {
                            if (!(this.$fragments.get(i) instanceof Fragment.PlainText)) break block0;
                            removeFirst = DiagnosticTemplateParser.INSTANCE.getQuotes$intellij_javascript_impl().contains(Boxing.boxChar((char)StringsKt.first((CharSequence)this.$fragments.get(i).getText()))) != false && i >= 2 && this.$fragments.get(i - 1) instanceof Fragment.Code != false && DiagnosticTemplateParser.INSTANCE.getQuotes$intellij_javascript_impl().contains(Boxing.boxChar((char)StringsKt.last((CharSequence)this.$fragments.get(i - 2).getText()))) != false ? 1 : 0;
                            removeLast = (this.$fragments.get(i).getText().length() > 2 || removeFirst == 0) && DiagnosticTemplateParser.INSTANCE.getQuotes$intellij_javascript_impl().contains(Boxing.boxChar((char)StringsKt.last((CharSequence)this.$fragments.get(i).getText()))) != false && i <= CollectionsKt.getLastIndex(this.$fragments) - 2 && this.$fragments.get(i + 1) instanceof Fragment.Code != false && DiagnosticTemplateParser.INSTANCE.getQuotes$intellij_javascript_impl().contains(Boxing.boxChar((char)StringsKt.first((CharSequence)this.$fragments.get(i + 2).getText()))) != false ? 1 : 0;
                            Intrinsics.checkNotNullExpressionValue((Object)this.$fragments.get(i).getText().substring(removeFirst != 0 ? 1 : 0, removeLast != 0 ? StringsKt.getLastIndex((CharSequence)this.$fragments.get(i).getText()) : this.$fragments.get(i).getText().length()), (String)"substring(...)");
                            if (i == CollectionsKt.getLastIndex(this.$fragments) && Intrinsics.areEqual((Object)newText, (Object)".") && i > 0 && this.$fragments.get(i - 1) instanceof Fragment.Code) break block0;
                            this.L$0 = $this$sequence;
                            this.L$1 = SpillingKt.nullOutSpilledVariable((Object)newText);
                            this.I$0 = i;
                            this.I$1 = var4_5;
                            this.I$2 = removeFirst;
                            this.I$3 = removeLast;
                            this.label = 1;
                            v0 = $this$sequence.yield((Object)new Fragment.PlainText(newText), (Continuation)this);
                            if (v0 == var8_3) {
                                return var8_3;
                            }
                            ** GOTO lbl50
                        }
                        break;
                    }
                    case 1: {
                        removeLast = this.I$3;
                        removeFirst = this.I$2;
                        var4_5 = this.I$1;
                        i = this.I$0;
                        newText = (String)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
                        ** GOTO lbl50
                    }
                }
                this.L$0 = $this$sequence;
                this.L$1 = null;
                this.I$0 = i;
                this.I$1 = var4_5;
                this.label = 2;
                v1 = $this$sequence.yield((Object)this.$fragments.get(i), (Continuation)this);
                if (v1 == var8_3) {
                    return var8_3;
                }
                ** GOTO lbl50
                {
                    case 2: {
                        var4_5 = this.I$1;
                        i = this.I$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl50:
                        // 4 sources

                        ++i;
                        ** GOTO lbl8
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(SequenceScope<? super Fragment> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private final String truncateIfTooLong(String text) {
        Object object;
        int maxLength = Registry.Companion.get("ts.highlightCodeInErrorTooltips.maxFragmentLength").asInteger();
        if (text.length() <= maxLength) {
            object = text;
        } else {
            String string = text.substring(0, maxLength - 3);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            object = string + "...";
        }
        return object;
    }

    private final String highlightCode(String text, Project project) {
        String text1 = myMoreInputPattern.matcher(text).replaceAll(DiagnosticMessageParser::highlightCode$lambda$1);
        String text2 = myEllipsisInGenericParamsInputPattern.matcher(text1).replaceAll(myEllipsisInGenericParamsReplacementPattern.pattern());
        String text3 = myEllipsisPropertiesInputPattern.matcher(text2).replaceAll(myEllipsisPropertiesReplacementPattern.pattern());
        Intrinsics.checkNotNull((Object)text3);
        String html3 = JSTooltipWithHtmlHighlighter.Companion.highlightTypeOrStmt$default(JSTooltipWithHtmlHighlighter.Companion, project, text3, false, 0, 12, null);
        String html2 = myEllipsisPropertiesReplacementPattern.matcher(html3).replaceAll(myEllipsisPropertiesInputPattern.pattern());
        Matcher matcher = myEllipsisInGenericParamsReplacementPattern.matcher(html2);
        String string = myEllipsisInGenericParamsInputPattern.pattern();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pattern(...)");
        String html1 = matcher.replaceAll(StringsKt.removeSurrounding((String)string, (CharSequence)"(?<=<)", (CharSequence)"(?=>)"));
        String string2 = myMoreReplacementPattern.matcher(html1).replaceAll(DiagnosticMessageParser::highlightCode$lambda$2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"replaceAll(...)");
        return string2;
    }

    @NotNull
    public final List<Fragment> parse(@NotNull String message, int code, @NotNull Project project, @Nullable LanguageServiceInfo languageServiceInfo) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!this.isEnabled()) {
            return CollectionsKt.listOf((Object)new Fragment.NotParsed(message));
        }
        if (code <= 0) {
            return this.parseUnknownCode(message, project, languageServiceInfo);
        }
        String template = (String)CollectionsKt.firstOrNull(this.getTemplates(new DiagnosticTemplatesMemoryCache.GetByCode(code), project, languageServiceInfo));
        if (template == null) {
            return CollectionsKt.listOf((Object)new Fragment.NotParsed(message));
        }
        return SequencesKt.toList(this.parseByTemplate(message, template));
    }

    public final boolean isEnabled() {
        return Registry.Companion.is("ts.highlightCodeInErrorTooltips.enabled", true);
    }

    private final List<Fragment> parseUnknownCode(String message, Project project, LanguageServiceInfo languageServiceInfo) {
        List bestSoFar = CollectionsKt.emptyList();
        for (String template : this.getTemplates(new DiagnosticTemplatesMemoryCache.SearchByMessage(message, 0, 2, null), project, languageServiceInfo)) {
            boolean bl;
            List fragments;
            block6: {
                fragments = SequencesKt.toList(this.parseByTemplate(message, template));
                if (!(!((Collection)fragments).isEmpty()) || CollectionsKt.first((List)fragments) instanceof Fragment.NotParsed) continue;
                Iterable $this$none$iv = fragments;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        Fragment it = (Fragment)element$iv;
                        boolean bl2 = false;
                        if (!(it instanceof Fragment.NotParsed)) continue;
                        bl = false;
                        break block6;
                    }
                    bl = true;
                }
            }
            if (bl) {
                return fragments;
            }
            if (fragments.size() <= bestSoFar.size()) continue;
            bestSoFar = fragments;
        }
        if (!((Collection)bestSoFar).isEmpty()) {
            return bestSoFar;
        }
        return CollectionsKt.listOf((Object)new Fragment.NotParsed(message));
    }

    private final List<String> getTemplates(DiagnosticTemplatesMemoryCache.GetCriteria getCriteria, Project project, LanguageServiceInfo languageServiceInfo) {
        LanguageServiceInfo languageServiceInfo2 = languageServiceInfo;
        if ((languageServiceInfo2 != null ? languageServiceInfo2.getServiceKind() : null) == LanguageServiceKind.TsGoLocal) {
            return ((DiagnosticTemplatesTsGoLocalProvider)ApplicationManager.getApplication().getService(DiagnosticTemplatesTsGoLocalProvider.class)).getTemplates(languageServiceInfo.getServicePath(), getCriteria);
        }
        LanguageServiceInfo languageServiceInfo3 = languageServiceInfo;
        if ((languageServiceInfo3 != null ? languageServiceInfo3.getServiceKind() : null) == LanguageServiceKind.TsGoNativePreview) {
            return this.getFallbackTemplates(getCriteria);
        }
        LanguageServiceInfo languageServiceInfo4 = languageServiceInfo;
        if ((languageServiceInfo4 != null ? languageServiceInfo4.getLocale() : null) != null) {
            return ((DiagnosticTemplatesLocalizedProvider)project.getService(DiagnosticTemplatesLocalizedProvider.class)).getTemplates(languageServiceInfo.getServicePath(), languageServiceInfo.getLocale(), getCriteria);
        }
        if (languageServiceInfo != null && !Intrinsics.areEqual((Object)languageServiceInfo.getLanguageVersion(), (Object)"5.7.3")) {
            return ((DiagnosticTemplatesEnProvider)project.getService(DiagnosticTemplatesEnProvider.class)).getTemplates(languageServiceInfo.getLanguageVersion(), getCriteria);
        }
        return this.getFallbackTemplates(getCriteria);
    }

    private final List<String> getFallbackTemplates(DiagnosticTemplatesMemoryCache.GetCriteria getCriteria) {
        return ((DiagnosticTemplatesFallbackProvider)ApplicationManager.getApplication().getService(DiagnosticTemplatesFallbackProvider.class)).getTemplates(getCriteria);
    }

    private final Sequence<Fragment> parseByTemplate(String message, String template) {
        return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super Fragment>, Continuation<? super Unit>, Object>(template, message, null){
            Object L$1;
            Object L$2;
            int I$0;
            int I$1;
            int I$2;
            int I$3;
            int I$4;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ String $template;
            final /* synthetic */ String $message;
            {
                this.$template = $template;
                this.$message = $message;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                block15: {
                    block16: {
                        block17: {
                            var2_2 = (SequenceScope)this.L$0;
                            var10_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            block0 : switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    templateFragments = SequencesKt.toList(DiagnosticTemplateParser.INSTANCE.parse(this.$template));
                                    pos = 0;
                                    i = 0;
                                    var6_9 = ((Collection)templateFragments).size();
lbl10:
                                    // 2 sources

                                    while (i < var6_9) {
                                        templateFragment = (TemplateFragment)templateFragments.get(i);
                                        if (!(templateFragment instanceof TemplateFragment.PlainText)) break block0;
                                        fragmentPos = StringsKt.indexOf$default((CharSequence)this.$message, (String)((TemplateFragment.PlainText)templateFragment).getText(), (int)pos, (boolean)false, (int)4, null);
                                        if (fragmentPos == -1) break block15;
                                        if (fragmentPos != pos) {
                                            v0 = this.$message.substring(pos, fragmentPos);
                                            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"substring(...)");
                                            this.L$0 = $this$sequence;
                                            this.L$1 = templateFragments;
                                            this.L$2 = templateFragment;
                                            this.I$0 = pos;
                                            this.I$1 = i;
                                            this.I$2 = var6_9;
                                            this.I$3 = fragmentPos;
                                            this.label = 1;
                                            v1 = $this$sequence.yield((Object)new Fragment.Code(v0), (Continuation)this);
                                            if (v1 == var10_3) {
                                                return var10_3;
                                            }
                                        }
                                        ** GOTO lbl40
                                    }
                                    break block15;
                                }
                                case 1: {
                                    fragmentPos = this.I$3;
                                    var6_9 = this.I$2;
                                    i = this.I$1;
                                    pos = this.I$0;
                                    templateFragment = (TemplateFragment)this.L$2;
                                    templateFragments = (List)this.L$1;
                                    ResultKt.throwOnFailure((Object)$result);
                                    v1 = $result;
lbl40:
                                    // 2 sources

                                    this.L$0 = $this$sequence;
                                    this.L$1 = templateFragments;
                                    this.L$2 = templateFragment;
                                    this.I$0 = pos;
                                    this.I$1 = i;
                                    this.I$2 = var6_9;
                                    this.I$3 = fragmentPos;
                                    this.label = 2;
                                    v2 = $this$sequence.yield((Object)new Fragment.PlainText(((TemplateFragment.PlainText)templateFragment).getText()), (Continuation)this);
                                    if (v2 == var10_3) {
                                        return var10_3;
                                    }
                                    ** GOTO lbl61
                                }
                                case 2: {
                                    fragmentPos = this.I$3;
                                    var6_9 = this.I$2;
                                    i = this.I$1;
                                    pos = this.I$0;
                                    templateFragment = (TemplateFragment)this.L$2;
                                    templateFragments = (List)this.L$1;
                                    ResultKt.throwOnFailure((Object)$result);
                                    v2 = $result;
lbl61:
                                    // 2 sources

                                    pos = fragmentPos + ((TemplateFragment.PlainText)templateFragment).getText().length();
                                    break block16;
                                }
                            }
                            if (!(templateFragment instanceof TemplateFragment.Code)) break block17;
                            if (i != CollectionsKt.getLastIndex((List)templateFragments)) break block16;
                            newlineIndex = StringsKt.indexOf$default((CharSequence)this.$message, (char)'\n', (int)0, (boolean)false, (int)6, null);
                            v3 = endIndex = newlineIndex != -1 ? newlineIndex : this.$message.length();
                            if (pos < endIndex) {
                                v4 = this.$message.substring(pos, endIndex);
                                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"substring(...)");
                                this.L$0 = $this$sequence;
                                this.L$1 = templateFragments;
                                this.L$2 = SpillingKt.nullOutSpilledVariable((Object)templateFragment);
                                this.I$0 = pos;
                                this.I$1 = i;
                                this.I$2 = var6_9;
                                this.I$3 = newlineIndex;
                                this.I$4 = endIndex;
                                this.label = 3;
                                v5 = $this$sequence.yield((Object)new Fragment.Code(v4), (Continuation)this);
                                if (v5 == var10_3) {
                                    return var10_3;
                                }
                            }
                            ** GOTO lbl93
                            {
                                case 3: {
                                    endIndex = this.I$4;
                                    newlineIndex = this.I$3;
                                    var6_9 = this.I$2;
                                    i = this.I$1;
                                    pos = this.I$0;
                                    templateFragment = (TemplateFragment)this.L$2;
                                    templateFragments = (List)this.L$1;
                                    ResultKt.throwOnFailure((Object)$result);
                                    v5 = $result;
lbl93:
                                    // 2 sources

                                    pos = endIndex;
                                    break block16;
                                }
                            }
                        }
                        throw new NoWhenBranchMatchedException();
                    }
                    ++i;
                    ** GOTO lbl10
                }
                if (pos < this.$message.length()) {
                    v6 = this.$message.substring(pos);
                    Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"substring(...)");
                    this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$sequence);
                    this.L$1 = SpillingKt.nullOutSpilledVariable((Object)templateFragments);
                    this.L$2 = null;
                    this.I$0 = pos;
                    this.label = 4;
                    v7 = $this$sequence.yield((Object)new Fragment.NotParsed(v6), (Continuation)this);
                    if (v7 == var10_3) {
                        return var10_3;
                    }
                }
                ** GOTO lbl118
                {
                    case 4: {
                        pos = this.I$0;
                        templateFragments = (List)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        v7 = $result;
lbl118:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(SequenceScope<? super Fragment> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private static final String fragmentsToHtml$lambda$0(Project $project, Fragment it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof Fragment.Code ? INSTANCE.highlightCode(INSTANCE.truncateIfTooLong(((Fragment.Code)it).getText()), $project) : XmlStringUtil.escapeString((String)INSTANCE.truncateIfTooLong(it.getText()));
    }

    private static final String highlightCode$lambda$1(MatchResult match) {
        String string = myMoreReplacementPattern.pattern();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pattern(...)");
        String string2 = match.group(1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"group(...)");
        return "\n" + StringsKt.replace$default((String)string, (String)"(\\d+)", (String)string2, (boolean)false, (int)4, null);
    }

    private static final String highlightCode$lambda$2(MatchResult match) {
        String string = myMoreInputPattern.pattern();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pattern(...)");
        String string2 = match.group(1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"group(...)");
        return StringsKt.replace$default((String)string, (String)"(\\d+)", (String)string2, (boolean)false, (int)4, null);
    }
}

