/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.config;

import com.intellij.java.library.JavaLibraryModificationTracker;
import com.intellij.json.psi.JsonFile;
import com.intellij.lang.Language;
import com.intellij.micronaut.MicronautUtils;
import com.intellij.micronaut.config.MnConfigKeyNameBinder;
import com.intellij.micronaut.config.MnConfigurationMetadataParser;
import com.intellij.micronaut.config.MnMetaConfigKey;
import com.intellij.micronaut.config.PredefinedMetaConfigKeysKt;
import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.microservices.jvm.config.MetaConfigKeyManager;
import com.intellij.microservices.jvm.config.utils.MetaConfigFileUtilsKt;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.OrderEntryUtil;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0016\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rJ\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J&\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\rH\u0002J\"\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u0010H\u0002J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\rH\u0002J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\rH\u0002R\u0010\u0010\u001e\u001a\u00020\r8\u0002X\u0083D\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/micronaut/config/MnMetaConfigKeyManager;", "Lcom/intellij/microservices/jvm/config/MetaConfigKeyManager;", "<init>", "()V", "getAllMetaConfigKeys", "", "Lcom/intellij/microservices/jvm/config/MetaConfigKey;", "module", "Lcom/intellij/openapi/module/Module;", "getConfigKeyNameBinder", "Lcom/intellij/microservices/jvm/config/MetaConfigKeyManager$ConfigKeyNameBinder;", "createFakeConfigKey", "configKey", "", "collectKeys", "inLibraries", "", "findConfigFilesInMetaInf", "Lcom/intellij/json/psi/JsonFile;", "getConfigKeysForFile", "parser", "Lcom/intellij/micronaut/config/MnConfigurationMetadataParser;", "path", "findLocalMetadataJsonFile", "Ljava/io/File;", "relativeFilePath", "unitTestMode", "findInOutputPath", "outputPath", "findLocalMetadataJsonFileForKapt", "GRADLE_KAPT_GENERATED_CLASSES_LIBRARY_NAME", "Companion", "intellij.micronaut"})
@SourceDebugExtension(value={"SMAP\nMnMetaConfigKeyManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MnMetaConfigKeyManager.kt\ncom/intellij/micronaut/config/MnMetaConfigKeyManager\n+ 2 MetaConfigFileUtils.kt\ncom/intellij/microservices/jvm/config/utils/MetaConfigFileUtilsKt\n*L\n1#1,197:1\n44#2,6:198\n*S KotlinDebug\n*F\n+ 1 MnMetaConfigKeyManager.kt\ncom/intellij/micronaut/config/MnMetaConfigKeyManager\n*L\n118#1:198,6\n*E\n"})
public final class MnMetaConfigKeyManager
extends MetaConfigKeyManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NonNls
    @NotNull
    private final String GRADLE_KAPT_GENERATED_CLASSES_LIBRARY_NAME;
    @NotNull
    private static final Logger LOG;

    public MnMetaConfigKeyManager() {
        this.GRADLE_KAPT_GENERATED_CLASSES_LIBRARY_NAME = "Gradle: kaptGeneratedClasses";
    }

    @NotNull
    public List<MetaConfigKey> getAllMetaConfigKeys(@Nullable Module module) {
        if (module == null || !MicronautUtils.hasMicronautLibrary(module)) {
            return CollectionsKt.emptyList();
        }
        List libraryKeys = (List)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> MnMetaConfigKeyManager.getAllMetaConfigKeys$lambda$0(this, module));
        List sourceKeys = (List)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> MnMetaConfigKeyManager.getAllMetaConfigKeys$lambda$1(this, module));
        List list = ContainerUtil.concat((List)libraryKeys, (List)sourceKeys);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"concat(...)");
        return list;
    }

    @NotNull
    public MetaConfigKeyManager.ConfigKeyNameBinder getConfigKeyNameBinder(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return MnConfigKeyNameBinder.INSTANCE;
    }

    @NotNull
    public final MetaConfigKey createFakeConfigKey(@NotNull Module module, @NotNull String configKey) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)configKey, (String)"configKey");
        PsiFile fakeDeclaration = PsiFileFactory.getInstance((Project)module.getProject()).createFileFromText((Language)PlainTextLanguage.INSTANCE, (CharSequence)"");
        Intrinsics.checkNotNull((Object)fakeDeclaration);
        PsiElement psiElement = (PsiElement)fakeDeclaration;
        MetaConfigKey.DescriptionText descriptionText = MetaConfigKey.DescriptionText.NONE;
        Intrinsics.checkNotNullExpressionValue((Object)descriptionText, (String)"NONE");
        return (MetaConfigKey)new MnMetaConfigKey(psiElement, MetaConfigKey.DeclarationResolveResult.PROPERTY, configKey, descriptionText, null, null, MetaConfigKey.AccessType.NORMAL);
    }

    private final List<MetaConfigKey> collectKeys(Module module, boolean inLibraries) {
        List<JsonFile> metaInfConfigFiles = this.findConfigFilesInMetaInf(module, inLibraries);
        Set allKeys = new LinkedHashSet();
        for (JsonFile configMetadataFile : metaInfConfigFiles) {
            MnConfigurationMetadataParser mnConfigurationMetadataParser = new MnConfigurationMetadataParser(configMetadataFile);
            String string = configMetadataFile.getVirtualFile().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            List<MetaConfigKey> keys = this.getConfigKeysForFile(module, mnConfigurationMetadataParser, string);
            allKeys.addAll((Collection)keys);
        }
        if (inLibraries) {
            allKeys.addAll((Collection)PredefinedMetaConfigKeysKt.collectPredefinedKeys(module));
        }
        if (!inLibraries) {
            Set modules = new LinkedHashSet();
            ModuleUtilCore.getDependencies((Module)module, (Set)modules);
            boolean unitTestMode = ApplicationManager.getApplication().isUnitTestMode();
            for (Module dependentModule : modules) {
                File localJsonFile;
                if (this.findLocalMetadataJsonFile(dependentModule, "spring-configuration-metadata.json", unitTestMode) == null) continue;
                MnConfigurationMetadataParser mnConfigurationMetadataParser = new MnConfigurationMetadataParser(module, localJsonFile);
                String string = localJsonFile.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                List<MetaConfigKey> keys = this.getConfigKeysForFile(dependentModule, mnConfigurationMetadataParser, string);
                allKeys.addAll((Collection)keys);
            }
        }
        return CollectionsKt.toList((Iterable)allKeys);
    }

    /*
     * WARNING - void declaration
     */
    private final List<JsonFile> findConfigFilesInMetaInf(Module module, boolean inLibraries) {
        void scope$iv;
        GlobalSearchScope globalSearchScope = GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"moduleRuntimeScope(...)");
        GlobalSearchScope moduleScope = globalSearchScope;
        GlobalSearchScope globalSearchScope2 = ProjectScope.getLibrariesScope((Project)module.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope2, (String)"getLibrariesScope(...)");
        GlobalSearchScope librariesScope = globalSearchScope2;
        if (inLibraries) {
            GlobalSearchScope globalSearchScope3 = moduleScope.intersectWith(librariesScope);
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope3, (String)"intersectWith(...)");
            moduleScope = globalSearchScope3;
        } else {
            GlobalSearchScope globalSearchScope4 = moduleScope.intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)librariesScope));
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope4, (String)"intersectWith(...)");
            moduleScope = globalSearchScope4;
        }
        GlobalSearchScope globalSearchScope5 = moduleScope;
        String fileName$iv = "spring-configuration-metadata.json";
        boolean includeSubpackages$iv = false;
        boolean $i$f$findConfigFilesInMetaInf = false;
        return MetaConfigFileUtilsKt.findConfigFilesInMetaInf((GlobalSearchScope)scope$iv, (String)fileName$iv, JsonFile.class, (boolean)includeSubpackages$iv);
    }

    private final List<MetaConfigKey> getConfigKeysForFile(Module module, MnConfigurationMetadataParser parser, String path) {
        List keys = new ArrayList();
        Set names = new HashSet();
        try {
            parser.processKeys(module, (Processor<? super MetaConfigKey>)((Processor)arg_0 -> MnMetaConfigKeyManager.getConfigKeysForFile$lambda$2(names, keys, arg_0)));
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (IndexNotReadyException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.warn("Error parsing " + path, e);
        }
        keys.addAll((Collection)parser.processExtraMetadataKeys(module));
        return keys;
    }

    private final File findLocalMetadataJsonFile(Module module, String relativeFilePath, boolean unitTestMode) {
        if (!unitTestMode) {
            String compilerOutputPath = CompilerPaths.getModuleOutputPath((Module)module, (boolean)false);
            if (compilerOutputPath == null) {
                return null;
            }
            File compilerOutputJson = this.findInOutputPath(compilerOutputPath, relativeFilePath);
            if (compilerOutputJson != null) {
                return compilerOutputJson;
            }
            return this.findLocalMetadataJsonFileForKapt(module, relativeFilePath);
        }
        VirtualFile tempFSVirtualFile = TempFileSystem.getInstance().findFileByPath("/src/" + relativeFilePath);
        if (tempFSVirtualFile == null) {
            return null;
        }
        try {
            File file = FileUtil.createTempFile((String)"sb-test", (String)"whatever", (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempFile(...)");
            File localJsonFile = file;
            FileUtil.writeToFile((File)localJsonFile, (String)VfsUtilCore.loadText((VirtualFile)tempFSVirtualFile));
            return localJsonFile;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private final File findInOutputPath(String outputPath, String relativeFilePath) {
        String metadataJsonPath = outputPath + "/META-INF/" + relativeFilePath;
        File localJsonFile = new File(metadataJsonPath);
        return localJsonFile.exists() ? localJsonFile : null;
    }

    private final File findLocalMetadataJsonFileForKapt(Module module, String relativeFilePath) {
        LibraryOrderEntry entry = OrderEntryUtil.findLibraryOrderEntry((ModuleRootModel)((ModuleRootModel)ModuleRootManager.getInstance((Module)module)), (String)this.GRADLE_KAPT_GENERATED_CLASSES_LIBRARY_NAME);
        if (entry == null) {
            return null;
        }
        for (VirtualFile virtualFile : entry.getRootFiles(OrderRootType.CLASSES)) {
            String string = VirtualFileManager.extractPath((String)virtualFile.getUrl());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"extractPath(...)");
            File file = this.findInOutputPath(string, relativeFilePath);
            if (file == null) continue;
            return file;
        }
        return null;
    }

    private static final CachedValueProvider.Result getAllMetaConfigKeys$lambda$0(MnMetaConfigKeyManager this$0, Module $module) {
        List<MetaConfigKey> list = this$0.collectKeys($module, true);
        Object[] objectArray = new Object[2];
        objectArray[0] = JavaLibraryModificationTracker.getInstance((Project)$module.getProject());
        Project project = $module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        objectArray[1] = DumbService.Companion.getInstance(project).getModificationTracker();
        return CachedValueProvider.Result.create(list, (Object[])objectArray);
    }

    private static final CachedValueProvider.Result getAllMetaConfigKeys$lambda$1(MnMetaConfigKeyManager this$0, Module $module) {
        List<MetaConfigKey> list = this$0.collectKeys($module, false);
        Object[] objectArray = new Object[3];
        objectArray[0] = PsiModificationTracker.MODIFICATION_COUNT;
        objectArray[1] = JavaLibraryModificationTracker.getInstance((Project)$module.getProject());
        Project project = $module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        objectArray[2] = DumbService.Companion.getInstance(project).getModificationTracker();
        return CachedValueProvider.Result.create(list, (Object[])objectArray);
    }

    private static final boolean getConfigKeysForFile$lambda$2(Set $names, List $keys, MetaConfigKey it) {
        ProgressManager.checkCanceled();
        String string = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if ($names.add(string)) {
            Intrinsics.checkNotNull((Object)it);
            $keys.add(it);
        }
        return true;
    }

    static {
        Logger logger = Logger.getInstance(MnMetaConfigKeyManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/micronaut/config/MnMetaConfigKeyManager$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/intellij/micronaut/config/MnMetaConfigKeyManager;", "intellij.micronaut"})
    @SourceDebugExtension(value={"SMAP\nMnMetaConfigKeyManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MnMetaConfigKeyManager.kt\ncom/intellij/micronaut/config/MnMetaConfigKeyManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,197:1\n30#2,2:198\n*S KotlinDebug\n*F\n+ 1 MnMetaConfigKeyManager.kt\ncom/intellij/micronaut/config/MnMetaConfigKeyManager$Companion\n*L\n45#1:198,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MnMetaConfigKeyManager getInstance() {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
            ComponentManager $this$service$iv = (ComponentManager)application;
            boolean $i$f$service = false;
            Class<MnMetaConfigKeyManager> serviceClass$iv = MnMetaConfigKeyManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (MnMetaConfigKeyManager)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

