/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.jam.http;

import com.intellij.micronaut.jam.http.mapping.MnHttpMethodMapping;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0013\u0010\u0013\u001a\u00020\u00112\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0012\u00a8\u0006\u0017"}, d2={"Lcom/intellij/micronaut/jam/http/MnHttpMappingInfo;", "", "mapping", "Lcom/intellij/micronaut/jam/http/mapping/MnHttpMethodMapping;", "holderClass", "Lcom/intellij/psi/PsiClass;", "<init>", "(Lcom/intellij/micronaut/jam/http/mapping/MnHttpMethodMapping;Lcom/intellij/psi/PsiClass;)V", "getMapping", "()Lcom/intellij/micronaut/jam/http/mapping/MnHttpMethodMapping;", "holderAnchor", "Lcom/intellij/psi/PsiAnchor;", "Lorg/jetbrains/annotations/NotNull;", "holder", "getHolder", "()Lcom/intellij/psi/PsiClass;", "isValid", "", "()Z", "equals", "other", "hashCode", "", "intellij.micronaut"})
public final class MnHttpMappingInfo {
    @NotNull
    private final MnHttpMethodMapping mapping;
    @NotNull
    private final PsiAnchor holderAnchor;

    public MnHttpMappingInfo(@NotNull MnHttpMethodMapping mapping, @NotNull PsiClass holderClass) {
        Intrinsics.checkNotNullParameter((Object)((Object)mapping), (String)"mapping");
        Intrinsics.checkNotNullParameter((Object)holderClass, (String)"holderClass");
        this.mapping = mapping;
        PsiAnchor psiAnchor = PsiAnchor.create((PsiElement)((PsiElement)holderClass));
        Intrinsics.checkNotNullExpressionValue((Object)psiAnchor, (String)"create(...)");
        this.holderAnchor = psiAnchor;
    }

    @NotNull
    public final MnHttpMethodMapping getMapping() {
        return this.mapping;
    }

    @Nullable
    public final PsiClass getHolder() {
        return (PsiClass)this.holderAnchor.retrieve();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isValid() {
        if (!this.mapping.isValid()) return false;
        PsiClass psiClass = this.getHolder();
        if (psiClass == null) return false;
        if (!psiClass.isValid()) return false;
        return true;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.intellij.micronaut.jam.http.MnHttpMappingInfo");
        MnHttpMappingInfo cfr_ignored_0 = (MnHttpMappingInfo)other;
        if (!Intrinsics.areEqual((Object)((Object)this.mapping), (Object)((Object)((MnHttpMappingInfo)other).mapping))) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getHolder(), (Object)((MnHttpMappingInfo)other).getHolder());
    }

    public int hashCode() {
        int result = this.mapping.hashCode();
        result = 31 * result + Objects.hashCode(this.getHolder());
        return result;
    }
}

