/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.provider.mq;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.MergeableLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.jam.JamService;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.micronaut.MicronautBundle;
import com.intellij.micronaut.jam.mq.MnMqConstants;
import com.intellij.micronaut.jam.mq.MnMqMethodElement;
import com.intellij.micronaut.jam.mq.MnSendTo;
import com.intellij.micronaut.jam.mq.kafka.MnKafkaClient;
import com.intellij.micronaut.jam.mq.kafka.MnKafkaListener;
import com.intellij.micronaut.jam.mq.kafka.MnKafkaTopic;
import com.intellij.micronaut.jam.mq.rabbitmq.MnRabbitQueue;
import com.intellij.micronaut.provider.base.MnLineMarkerProvider;
import com.intellij.micronaut.provider.beans.MicronautBeanUtilsKt;
import com.intellij.micronaut.provider.mq.MnMqUtilsKt;
import com.intellij.micronaut.utils.MnLineMarkerBuilder;
import com.intellij.microservices.jvm.MicroservicesJvmIcons;
import com.intellij.microservices.jvm.mq.MQDestinationAnchor;
import com.intellij.microservices.jvm.mq.gutters.MQLineMarkerActionsProvider;
import com.intellij.microservices.jvm.mq.references.MQReference;
import com.intellij.microservices.utils.UsagesNavigationGutterIconBuilder;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.semantic.SemService;
import com.intellij.util.NotNullFunction;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UMethod;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0003\u0015\u0016\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0012\u0010\t\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J&\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0014\u0010\t\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\b0\u000b0\nH\u0014\u00a8\u0006\u0018"}, d2={"Lcom/intellij/micronaut/provider/mq/MnMqLineMarkerProvider;", "Lcom/intellij/micronaut/provider/base/MnLineMarkerProvider;", "<init>", "()V", "collectNavigationMarkers", "", "elements", "", "Lcom/intellij/psi/PsiElement;", "result", "", "Lcom/intellij/codeInsight/daemon/RelatedItemLineMarkerInfo;", "forNavigation", "", "getIcon", "Ljavax/swing/Icon;", "getName", "", "annotateMethod", "uMethod", "Lorg/jetbrains/uast/UMethod;", "Holder", "MnMqLineMarkerInfo", "MnMqLineMarkerProviderHelper", "intellij.micronaut"})
@SourceDebugExtension(value={"SMAP\nMnMqLineMarkerProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MnMqLineMarkerProvider.kt\ncom/intellij/micronaut/provider/mq/MnMqLineMarkerProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,185:1\n1617#2,9:186\n1869#2:195\n1870#2:197\n1626#2:198\n1#3:196\n965#4,5:199\n*S KotlinDebug\n*F\n+ 1 MnMqLineMarkerProvider.kt\ncom/intellij/micronaut/provider/mq/MnMqLineMarkerProvider\n*L\n72#1:186,9\n72#1:195\n72#1:197\n72#1:198\n72#1:196\n77#1:199,5\n*E\n"})
public final class MnMqLineMarkerProvider
extends MnLineMarkerProvider {
    @Override
    public void collectNavigationMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result, boolean forNavigation) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        PsiElement psiElement = (PsiElement)CollectionsKt.firstOrNull(elements);
        if (psiElement == null) {
            return;
        }
        PsiElement psiElement2 = psiElement;
        Project project = psiElement2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (!MnMqUtilsKt.hasMnKafkaInProject(project)) {
            Project project2 = psiElement2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            if (!MnMqUtilsKt.hasMnRabbitInProject(project2)) {
                return;
            }
        }
        super.collectNavigationMarkers(elements, result, forNavigation);
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = MicroservicesJvmIcons.MessageQueueReceiver;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"MessageQueueReceiver");
        return icon;
    }

    @NotNull
    public String getName() {
        return MicronautBundle.message("micronaut.mq.line.markers.name", new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void annotateMethod(@NotNull UMethod uMethod, @NotNull Collection<? super RelatedItemLineMarkerInfo<PsiElement>> result) {
        void destination$iv;
        void $this$flatMapTo$iv;
        Sequence $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)uMethod, (String)"uMethod");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        PsiElement psiElement = UElementKt.getSourcePsiElement((UElement)uMethod.getUastAnchor());
        if (psiElement == null) {
            return;
        }
        PsiElement anchor = psiElement;
        PsiMethod psiMethod = uMethod.getJavaPsi();
        PsiClass containingClass = psiMethod.getContainingClass();
        if (containingClass == null || psiMethod.hasModifier(JvmModifier.PRIVATE) || psiMethod.hasModifier(JvmModifier.STATIC) || psiMethod.isConstructor() || !MicronautBeanUtilsKt.isBeanMappedClass(containingClass)) {
            return;
        }
        SemService semService = SemService.getSemService((Project)psiMethod.getProject());
        List list = AnnotationUtil.findAllAnnotations((PsiModifierListOwner)((PsiModifierListOwner)psiMethod), (Collection)MnMqConstants.getMN_MESSAGING_METHOD_ANNOTATIONS(), (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findAllAnnotations(...)");
        Iterable iterable = list;
        boolean $i$f$mapNotNull = false;
        Iterator iterator = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            MnMqMethodElement it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            PsiAnnotation it = (PsiAnnotation)element$iv$iv;
            boolean bl2 = false;
            if ((MnMqMethodElement)semService.getSemElement(MnMqMethodElement.MN_MQ_METHOD_ELEMENT_SEM_KEY, (PsiElement)it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Sequence relatedItems = CollectionsKt.asSequence((Iterable)((List)destination$iv$iv));
        JamService jamService = JamService.getJamService((Project)psiMethod.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)jamService, (String)"getJamService(...)");
        MnMqLineMarkerProviderHelper helper = new MnMqLineMarkerProviderHelper(anchor, psiMethod, containingClass, jamService);
        $this$mapNotNullTo$iv$iv = relatedItems;
        destination$iv$iv = new LinkedHashSet();
        boolean $i$f$flatMapIterableTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            MnMqMethodElement it = (MnMqMethodElement)element$iv;
            boolean bl = false;
            List list2 = it.getDestinations();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getDestinations(...)");
            Iterable list$iv = list2;
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        Set allDestinations = (Set)destination$iv;
        for (MQLineMarkerActionsProvider actionsProvider : MQLineMarkerActionsProvider.Companion.getInstances()) {
            for (MQLineMarkerActionsProvider.Action action : actionsProvider.getActions((Collection)allDestinations, anchor)) {
                result.add(new MnMqLineMarkerInfo(Holder.INSTANCE.createExternalContributedActionMarker(anchor, action)));
            }
        }
        helper.addLineMarkerInfo((Sequence<? extends MnMqMethodElement>)relatedItems, true, result);
        helper.addLineMarkerInfo((Sequence<? extends MnMqMethodElement>)relatedItems, false, result);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fR#\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lcom/intellij/micronaut/provider/mq/MnMqLineMarkerProvider$Holder;", "", "<init>", "()V", "MQ_CONVERTER", "Lcom/intellij/util/NotNullFunction;", "Lcom/intellij/microservices/jvm/mq/MQDestinationAnchor;", "", "Lcom/intellij/psi/PsiElement;", "getMQ_CONVERTER", "()Lcom/intellij/util/NotNullFunction;", "createExternalContributedActionMarker", "Lcom/intellij/codeInsight/daemon/RelatedItemLineMarkerInfo;", "anchor", "lineMarkerAction", "Lcom/intellij/microservices/jvm/mq/gutters/MQLineMarkerActionsProvider$Action;", "intellij.micronaut"})
    @SourceDebugExtension(value={"SMAP\nMnMqLineMarkerProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MnMqLineMarkerProvider.kt\ncom/intellij/micronaut/provider/mq/MnMqLineMarkerProvider$Holder\n+ 2 MnLineMarkerBuilder.kt\ncom/intellij/micronaut/utils/MnLineMarkerBuilder$CustomNavigationGutterIconBuilder\n*L\n1#1,185:1\n61#2,3:186\n*S KotlinDebug\n*F\n+ 1 MnMqLineMarkerProvider.kt\ncom/intellij/micronaut/provider/mq/MnMqLineMarkerProvider$Holder\n*L\n102#1:186,3\n*E\n"})
    private static final class Holder {
        @NotNull
        public static final Holder INSTANCE = new Holder();
        @NotNull
        private static final NotNullFunction<MQDestinationAnchor, Collection<PsiElement>> MQ_CONVERTER = Holder::MQ_CONVERTER$lambda$0;

        private Holder() {
        }

        @NotNull
        public final NotNullFunction<MQDestinationAnchor, Collection<PsiElement>> getMQ_CONVERTER() {
            return MQ_CONVERTER;
        }

        @NotNull
        public final RelatedItemLineMarkerInfo<PsiElement> createExternalContributedActionMarker(@NotNull PsiElement anchor, @NotNull MQLineMarkerActionsProvider.Action lineMarkerAction) {
            MnLineMarkerBuilder.CustomNavigationGutterIconBuilder<PsiElement> customNavigationGutterIconBuilder;
            Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
            Intrinsics.checkNotNullParameter((Object)lineMarkerAction, (String)"lineMarkerAction");
            MnLineMarkerBuilder.CustomNavigationGutterIconBuilder<PsiElement> this_$iv = MnLineMarkerBuilder.createCustomNavigationBuilder(lineMarkerAction.getLineMarkerIcon());
            boolean $i$f$setNavigationHandler = false;
            MnLineMarkerBuilder.CustomNavigationGutterIconBuilder<PsiElement> it$iv = customNavigationGutterIconBuilder = this_$iv;
            boolean bl = false;
            MnLineMarkerBuilder.CustomNavigationGutterIconBuilder.access$setNavigationHandler$p(this_$iv, new GutterIconNavigationHandler(lineMarkerAction){
                final /* synthetic */ MQLineMarkerActionsProvider.Action $lineMarkerAction$inlined;
                {
                    this.$lineMarkerAction$inlined = action;
                }

                public final void navigate(MouseEvent event, PsiElement element) {
                    Intrinsics.checkNotNull((Object)event);
                    Intrinsics.checkNotNull((Object)element);
                    MouseEvent e = event;
                    boolean bl = false;
                    this.$lineMarkerAction$inlined.getAction().actionPerformed(AnActionEvent.createFromInputEvent((InputEvent)e, (String)"", null, (DataContext)DataManager.getInstance().getDataContext(e.getComponent())));
                }
            });
            RelatedItemLineMarkerInfo relatedItemLineMarkerInfo = customNavigationGutterIconBuilder.setTooltipText(lineMarkerAction.getLineMarkerTooltipText()).setTargets((Collection)CollectionsKt.emptyList()).createLineMarkerInfo(anchor);
            Intrinsics.checkNotNullExpressionValue((Object)relatedItemLineMarkerInfo, (String)"createLineMarkerInfo(...)");
            return relatedItemLineMarkerInfo;
        }

        private static final Collection MQ_CONVERTER$lambda$0(MQDestinationAnchor info) {
            PsiElement psiElement = info.getPsiElement();
            if (psiElement == null) {
                return CollectionsKt.emptyList();
            }
            PsiElement psiElement2 = psiElement;
            Project project = psiElement2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            return CollectionsKt.listOf((Object)MQReference.Companion.createSearchableElement(project, info.getDestination()));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/micronaut/provider/mq/MnMqLineMarkerProvider$MnMqLineMarkerInfo;", "Lcom/intellij/codeInsight/daemon/RelatedItemLineMarkerInfo;", "Lcom/intellij/psi/PsiElement;", "gutter", "<init>", "(Lcom/intellij/codeInsight/daemon/RelatedItemLineMarkerInfo;)V", "canMergeWith", "", "info", "Lcom/intellij/codeInsight/daemon/MergeableLineMarkerInfo;", "getElementPresentation", "", "element", "intellij.micronaut"})
    private static final class MnMqLineMarkerInfo
    extends RelatedItemLineMarkerInfo<PsiElement> {
        public MnMqLineMarkerInfo(@NotNull RelatedItemLineMarkerInfo<PsiElement> gutter) {
            Intrinsics.checkNotNullParameter(gutter, (String)"gutter");
            PsiElement psiElement = gutter.getElement();
            Intrinsics.checkNotNull((Object)psiElement);
            PsiElement psiElement2 = gutter.getElement();
            Intrinsics.checkNotNull((Object)psiElement2);
            super(psiElement, psiElement2.getTextRange(), gutter.getIcon(), arg_0 -> MnMqLineMarkerInfo._init_$lambda$0(gutter, arg_0), gutter.getNavigationHandler(), gutter.createGutterRenderer().getAlignment(), () -> MnMqLineMarkerInfo._init_$lambda$1(gutter));
        }

        public boolean canMergeWith(@NotNull MergeableLineMarkerInfo<?> info) {
            Intrinsics.checkNotNullParameter(info, (String)"info");
            return info instanceof MnMqLineMarkerInfo;
        }

        @NotNull
        public String getElementPresentation(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            String string = this.getLineMarkerTooltip();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLineMarkerTooltip(...)");
            return string;
        }

        private static final String _init_$lambda$0(RelatedItemLineMarkerInfo $gutter, PsiElement it) {
            return $gutter.getLineMarkerTooltip();
        }

        private static final Collection _init_$lambda$1(RelatedItemLineMarkerInfo $gutter) {
            return $gutter.createGotoRelatedItems();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ2\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010!\u001a\u00020\u00152\u0014\u0010\"\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\u00030$0#R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0016R\u0014\u0010\u0018\u001a\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016R\u0014\u0010\u0019\u001a\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0016R\u0014\u0010\u001a\u001a\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0016R\u0014\u0010\u001b\u001a\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0016\u00a8\u0006%"}, d2={"Lcom/intellij/micronaut/provider/mq/MnMqLineMarkerProvider$MnMqLineMarkerProviderHelper;", "", "anchor", "Lcom/intellij/psi/PsiElement;", "psiMethod", "Lcom/intellij/psi/PsiMethod;", "psiClass", "Lcom/intellij/psi/PsiClass;", "jamService", "Lcom/intellij/jam/JamService;", "<init>", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiMethod;Lcom/intellij/psi/PsiClass;Lcom/intellij/jam/JamService;)V", "getAnchor", "()Lcom/intellij/psi/PsiElement;", "getPsiMethod", "()Lcom/intellij/psi/PsiMethod;", "getPsiClass", "()Lcom/intellij/psi/PsiClass;", "getJamService", "()Lcom/intellij/jam/JamService;", "isListener", "", "()Z", "isPublisher", "isKafkaListener", "isRabbitListener", "isKafkaPublisher", "isKafkaSendToPublisher", "addLineMarkerInfo", "", "relatedItems", "Lkotlin/sequences/Sequence;", "Lcom/intellij/micronaut/jam/mq/MnMqMethodElement;", "shouldBeListener", "result", "", "Lcom/intellij/codeInsight/daemon/RelatedItemLineMarkerInfo;", "intellij.micronaut"})
    @SourceDebugExtension(value={"SMAP\nMnMqLineMarkerProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MnMqLineMarkerProvider.kt\ncom/intellij/micronaut/provider/mq/MnMqLineMarkerProvider$MnMqLineMarkerProviderHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,185:1\n1#2:186\n*E\n"})
    private static final class MnMqLineMarkerProviderHelper {
        @NotNull
        private final PsiElement anchor;
        @NotNull
        private final PsiMethod psiMethod;
        @NotNull
        private final PsiClass psiClass;
        @NotNull
        private final JamService jamService;

        public MnMqLineMarkerProviderHelper(@NotNull PsiElement anchor, @NotNull PsiMethod psiMethod, @NotNull PsiClass psiClass, @NotNull JamService jamService) {
            Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
            Intrinsics.checkNotNullParameter((Object)psiMethod, (String)"psiMethod");
            Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
            Intrinsics.checkNotNullParameter((Object)jamService, (String)"jamService");
            this.anchor = anchor;
            this.psiMethod = psiMethod;
            this.psiClass = psiClass;
            this.jamService = jamService;
        }

        @NotNull
        public final PsiElement getAnchor() {
            return this.anchor;
        }

        @NotNull
        public final PsiMethod getPsiMethod() {
            return this.psiMethod;
        }

        @NotNull
        public final PsiClass getPsiClass() {
            return this.psiClass;
        }

        @NotNull
        public final JamService getJamService() {
            return this.jamService;
        }

        public final boolean isListener() {
            return this.isKafkaListener() || this.isRabbitListener();
        }

        public final boolean isPublisher() {
            return this.isKafkaPublisher() || this.isKafkaSendToPublisher();
        }

        private final boolean isKafkaListener() {
            return MnKafkaListener.META.getJamElement((PsiModifierListOwner)this.psiClass) != null && this.jamService.getJamElement(MnKafkaTopic.MN_KAFKA_TOPIC_SEM_KEY, (PsiElement)this.psiMethod) != null;
        }

        private final boolean isRabbitListener() {
            return MnRabbitQueue.getJamElement(this.psiMethod) != null;
        }

        private final boolean isKafkaPublisher() {
            return MnKafkaClient.META.getJamElement((PsiModifierListOwner)this.psiClass) != null && this.jamService.getJamElement(MnKafkaTopic.MN_KAFKA_TOPIC_SEM_KEY, (PsiElement)this.psiMethod) != null;
        }

        private final boolean isKafkaSendToPublisher() {
            return MnKafkaListener.META.getJamElement((PsiModifierListOwner)this.psiClass) != null && this.jamService.getJamElement(MnSendTo.MN_MQ_METHOD_ELEMENT_SEM_KEY, (PsiElement)this.psiMethod) != null;
        }

        public final void addLineMarkerInfo(@NotNull Sequence<? extends MnMqMethodElement> relatedItems, boolean shouldBeListener, @NotNull Collection<? super RelatedItemLineMarkerInfo<PsiElement>> result) {
            Object[] objectArray;
            Icon icon;
            Intrinsics.checkNotNullParameter(relatedItems, (String)"relatedItems");
            Intrinsics.checkNotNullParameter(result, (String)"result");
            if (shouldBeListener && this.isListener()) {
                icon = MicroservicesJvmIcons.MessageQueueReceiver;
            } else if (!shouldBeListener && this.isPublisher()) {
                icon = AllIcons.Webreferences.MessageQueue;
            } else {
                return;
            }
            Icon icon2 = icon;
            Intrinsics.checkNotNull((Object)icon2);
            Icon icon3 = icon2;
            Object[] it = objectArray = SequencesKt.toList((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.filter(relatedItems, arg_0 -> MnMqLineMarkerProviderHelper.addLineMarkerInfo$lambda$0(shouldBeListener, arg_0)), MnMqLineMarkerProviderHelper::addLineMarkerInfo$lambda$1));
            boolean bl = false;
            Object object = !((Collection)it).isEmpty() ? objectArray : null;
            if (object == null) {
                return;
            }
            Object[] items = object;
            NavigationGutterIconBuilder navigationGutterIconBuilder = UsagesNavigationGutterIconBuilder.Companion.create(icon3, Holder.INSTANCE.getMQ_CONVERTER()).setTargets((Collection)items);
            Intrinsics.checkNotNullExpressionValue((Object)navigationGutterIconBuilder, (String)"setTargets(...)");
            NavigationGutterIconBuilder builder = navigationGutterIconBuilder;
            if (items.size() == 1) {
                objectArray = new Object[]{((MQDestinationAnchor)CollectionsKt.first((List)items)).getDestination().getName()};
                v3 = builder.setTooltipText(MicronautBundle.message("micronaut.mq.line.markers.tooltip.single", objectArray));
            } else {
                builder.setTooltipText(MicronautBundle.message("micronaut.mq.line.markers.tooltip", new Object[0]));
                v3 = builder.setPopupTitle(MicronautBundle.message("micronaut.mq.line.markers.popupTitle", new Object[0]));
            }
            RelatedItemLineMarkerInfo relatedItemLineMarkerInfo = builder.createLineMarkerInfo(this.anchor);
            Intrinsics.checkNotNullExpressionValue((Object)relatedItemLineMarkerInfo, (String)"createLineMarkerInfo(...)");
            result.add(new MnMqLineMarkerInfo((RelatedItemLineMarkerInfo<PsiElement>)relatedItemLineMarkerInfo));
        }

        private static final boolean addLineMarkerInfo$lambda$0(boolean $shouldBeListener, MnMqMethodElement it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.isListener() == $shouldBeListener;
        }

        private static final Sequence addLineMarkerInfo$lambda$1(MnMqMethodElement it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            List list = it.getDestinations();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDestinations(...)");
            return CollectionsKt.asSequence((Iterable)list);
        }
    }
}

