/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.providers.contexts;

import com.intellij.codeInspection.dataFlow.StringExpressionHelper;
import com.intellij.java.library.JavaLibraryModificationTracker;
import com.intellij.model.search.SearchContext;
import com.intellij.model.search.SearchService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.thymeleaf.lang.support.ThymeleafContextVariablesProvider;
import com.intellij.thymeleaf.lang.support.beans.ThymeleafRenameableImplicitVariable;
import com.intellij.thymeleaf.lang.support.beans.ThymeleafVariable;
import com.intellij.thymeleaf.references.ThymeleafFakeRenameableReferenceProvider;
import com.intellij.uast.UastModificationTracker;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UastContextKt;

public class ThymeleafContextInitVariablesProvider
extends ThymeleafContextVariablesProvider {
    public static final String SET_VARIABLE_METHOD_NAME = "setVariable";

    @Override
    @NotNull
    public Collection<? extends PsiVariable> getContextVariables(@NotNull PsiElement contextElement) {
        Module module;
        if (contextElement == null) {
            ThymeleafContextInitVariablesProvider.$$$reportNull$$$0(0);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)contextElement)) == null) {
            Set set = Collections.emptySet();
            if (set == null) {
                ThymeleafContextInitVariablesProvider.$$$reportNull$$$0(1);
            }
            return set;
        }
        Collection variables = (Collection)RecursionManager.doPreventingRecursion((Object)this, (boolean)false, () -> ThymeleafContextInitVariablesProvider.getInitVariables(module));
        Collection<Object> collection = variables == null ? Collections.emptySet() : variables;
        if (collection == null) {
            ThymeleafContextInitVariablesProvider.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @NotNull
    private static Collection<? extends PsiVariable> getInitVariables(@NotNull Module module) {
        if (module == null) {
            ThymeleafContextInitVariablesProvider.$$$reportNull$$$0(3);
        }
        Project project = module.getProject();
        Collection collection = (Collection)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)module, () -> {
            PsiMethod[] setVariableMethods;
            Collection<Object> variables = Collections.emptySet();
            PsiClass aClass = JavaPsiFacade.getInstance((Project)project).findClass("org.thymeleaf.context.AbstractContext", module.getModuleWithDependenciesAndLibrariesScope(false));
            if (aClass != null && (setVariableMethods = aClass.findMethodsByName(SET_VARIABLE_METHOD_NAME, false)).length == 1) {
                variables = ThymeleafContextInitVariablesProvider.findInitVariables(setVariableMethods[0], module).values();
            }
            return CachedValueProvider.Result.create(variables, (Object[])new Object[]{UastModificationTracker.getInstance((Project)project), JavaLibraryModificationTracker.getInstance((Project)project)});
        });
        if (collection == null) {
            ThymeleafContextInitVariablesProvider.$$$reportNull$$$0(4);
        }
        return collection;
    }

    public static Map<String, ThymeleafVariable> findInitVariables(@NotNull PsiMethod psiMethod, @NotNull Module module) {
        if (psiMethod == null) {
            ThymeleafContextInitVariablesProvider.$$$reportNull$$$0(5);
        }
        if (module == null) {
            ThymeleafContextInitVariablesProvider.$$$reportNull$$$0(6);
        }
        ConcurrentHashMap<String, ThymeleafVariable> set = new ConcurrentHashMap<String, ThymeleafVariable>();
        Project project = psiMethod.getProject();
        HashSet methodCallExpressions = new HashSet();
        for (LocalSearchScope localSearchScope : ThymeleafContextInitVariablesProvider.getLocalSearchScopes(module, project)) {
            methodCallExpressions.addAll(MethodReferencesSearch.search((PsiMethod)psiMethod, (SearchScope)localSearchScope, (boolean)true).findAll().stream().map(psiReference -> (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)psiReference.getElement(), PsiMethodCallExpression.class)).filter(Objects::nonNull).collect(Collectors.toSet()));
        }
        for (PsiMethodCallExpression methodCallExpression : methodCallExpressions) {
            Pair evaluatedExpression;
            PsiExpression[] expressions = methodCallExpression.getArgumentList().getExpressions();
            if (expressions.length != 2 || (evaluatedExpression = StringExpressionHelper.evaluateExpression((PsiElement)expressions[0])) == null) continue;
            PsiElement psiExpression = (PsiElement)evaluatedExpression.getFirst();
            String name = (String)evaluatedExpression.getSecond();
            PsiType type = expressions[1].getType();
            if (name == null || type == null) continue;
            if (psiExpression instanceof PsiLiteral) {
                RenameableFakePsiElement renameableElement = ThymeleafFakeRenameableReferenceProvider.getOrCreateRenamebaleFakeElement((PsiLiteral)psiExpression);
                set.put(name, new ThymeleafRenameableImplicitVariable(name, type, renameableElement));
                continue;
            }
            set.put(name, new ThymeleafVariable(name, type, psiExpression));
        }
        return Map.copyOf(set);
    }

    @NotNull
    private static Set<LocalSearchScope> getLocalSearchScopes(@NotNull Module module, Project project) {
        if (module == null) {
            ThymeleafContextInitVariablesProvider.$$$reportNull$$$0(7);
        }
        return new HashSet<LocalSearchScope>(SearchService.getInstance().searchWord(project, "org.thymeleaf.context").inContexts(SearchContext.inCode(), new SearchContext[0]).inScope((SearchScope)GlobalSearchScope.moduleWithDependenciesScope((Module)module)).buildQuery(occurrence -> {
            if (occurrence.getOffsetInStart() != 0) {
                return Collections.emptySet();
            }
            UFile uFile = (UFile)UastContextKt.getUastParentOfType((PsiElement)occurrence.getStart(), UFile.class);
            return uFile != null ? Collections.singleton(new LocalSearchScope((PsiElement)uFile.getSourcePsi())) : Collections.emptySet();
        }).findAll());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextElement";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/thymeleaf/providers/contexts/ThymeleafContextInitVariablesProvider";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/thymeleaf/providers/contexts/ThymeleafContextInitVariablesProvider";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextVariables";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitVariables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getContextVariables";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getInitVariables";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findInitVariables";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getLocalSearchScopes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4 -> new IllegalStateException(string);
        };
    }
}

