/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence.database.config.impl.urlParser;

import com.intellij.persistence.database.ConfigDataSourcePropertyValueSearcherKt;
import com.intellij.persistence.database.config.impl.urlParser.CommonDatabaseUrl;
import com.intellij.persistence.database.config.impl.urlParser.ParameterData;
import com.intellij.persistence.database.config.impl.urlParser.PathAndDatabaseName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a9\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00012\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\u0002\u0010\u0015\u001a\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u0001*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0001H\u0000\u001a\u000e\u0010\u0019\u001a\u0004\u0018\u00010\u0001*\u00020\u0017H\u0000\u001a\u000e\u0010\u001a\u001a\u0004\u0018\u00010\u0001*\u00020\u0017H\u0000\u001a\u000e\u0010\u001b\u001a\u0004\u0018\u00010\u0001*\u00020\u0017H\u0000\u001a\u0013\u0010\u001c\u001a\u0004\u0018\u00010\u0014*\u00020\u0017H\u0000\u00a2\u0006\u0002\u0010\u001d\u001a\u000e\u0010\u001e\u001a\u0004\u0018\u00010\u0001*\u00020\u0017H\u0000\u001a\u000e\u0010\u001f\u001a\u0004\u0018\u00010\u0001*\u00020\u0017H\u0000\u001a\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0001H\u0000\u001a\f\u0010&\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0001H\u0000\u001a\u0018\u0010*\u001a\u00020(2\u0006\u0010+\u001a\u00020\u00012\u0006\u0010)\u001a\u00020\u0001H\u0002\u001a;\u0010,\u001a\u0012\u0012\u0004\u0012\u00020\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u0014\u0018\u00010-2\u0006\u0010.\u001a\u00020\u00012\n\b\u0002\u0010/\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u00100\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\u0002\u00101\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010 \u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010!\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\"\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"HOST_REGEXP", "", "PORT_REGEXP", "HOST_PORT_REGEXP", "DATABASE_NAME_REGEXP", "PARAMETERS_REGEXP", "USERNAME_REGEXP", "PASSWORD_REGEXP", "USERNAME_PASSWORD_REGEXP", "PREFIX_REGEXP", "databaseUrlRegex", "Lkotlin/text/Regex;", "paramsPrefixes", "", "parseToCommonDatabaseUrl", "Lcom/intellij/persistence/database/config/impl/urlParser/CommonDatabaseUrl;", "url", "databaseNamePropValue", "host", "port", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;)Lcom/intellij/persistence/database/config/impl/urlParser/CommonDatabaseUrl;", "getValue", "Lkotlin/text/MatchGroupCollection;", "groupName", "getUserName", "getPassword", "getHost", "getPort", "(Lkotlin/text/MatchGroupCollection;)Ljava/lang/Integer;", "getDatabase", "getParameters", "RELATIVE_PATH", "CURRENT_DIR", "HOME_DIR", "splitToPathAndDatabaseName", "Lcom/intellij/persistence/database/config/impl/urlParser/PathAndDatabaseName;", "pathToDb", "removePrefixSlashes", "tryToRetrieveUsernameAndPasswordFromParameters", "Lcom/intellij/persistence/database/config/impl/urlParser/ParameterData;", "parameters", "getParameterData", "delimiter", "retrieveHostAndPort", "Lkotlin/Pair;", "value", "defaultHost", "defaultPort", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;)Lkotlin/Pair;", "intellij.javaee.persistence.impl"})
@SourceDebugExtension(value={"SMAP\nDatabaseUrlParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseUrlParser.kt\ncom/intellij/persistence/database/config/impl/urlParser/DatabaseUrlParserKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,279:1\n1#2:280\n295#3,2:281\n295#3,2:287\n774#3:289\n865#3,2:290\n1869#3,2:292\n413#4,4:283\n*S KotlinDebug\n*F\n+ 1 DatabaseUrlParser.kt\ncom/intellij/persistence/database/config/impl/urlParser/DatabaseUrlParserKt\n*L\n201#1:281,2\n232#1:287,2\n242#1:289\n242#1:290,2\n243#1:292,2\n216#1:283,4\n*E\n"})
public final class DatabaseUrlParserKt {
    @NotNull
    public static final String HOST_REGEXP = "?<host>[A-Za-z0-9-.\\\\]+";
    @NotNull
    public static final String PORT_REGEXP = "?<port>:[0-9]+";
    @NotNull
    public static final String HOST_PORT_REGEXP = "(?<host>[A-Za-z0-9-.\\\\]+)(?<port>:[0-9]+)?";
    @NotNull
    public static final String DATABASE_NAME_REGEXP = "?<databaseName>/[A-Za-z0-9-_]+";
    @NotNull
    public static final String PARAMETERS_REGEXP = "?<parameters>[A-Za-z0-9-\\?=:&\\-;?_/\\.\\\\]+";
    @NotNull
    private static final String USERNAME_REGEXP = "?<username>[A-Za-z0-9_]+";
    @NotNull
    private static final String PASSWORD_REGEXP = "?<password>:[A-Za-z0-9-_@?$!%*#?&]+";
    @NotNull
    public static final String USERNAME_PASSWORD_REGEXP = "(?<username>[A-Za-z0-9_]+)(?<password>:[A-Za-z0-9-_@?$!%*#?&]+)?@";
    @NotNull
    public static final String PREFIX_REGEXP = "?<prefix>[A-Za-z0-9-:\\+]+";
    @NotNull
    private static final Regex databaseUrlRegex = new Regex("(?<prefix>[A-Za-z0-9-:\\+]+)://((?<username>[A-Za-z0-9_]+)(?<password>:[A-Za-z0-9-_@?$!%*#?&]+)?@)?((?<host>[A-Za-z0-9-.\\\\]+)(?<port>:[0-9]+)?)?(?<databaseName>/[A-Za-z0-9-_]+)?(?<parameters>[A-Za-z0-9-\\?=:&\\-;?_/\\.\\\\]+)?");
    @NotNull
    private static final List<String> paramsPrefixes;
    @NotNull
    private static final String RELATIVE_PATH = "..";
    @NotNull
    private static final String CURRENT_DIR = "./";
    @NotNull
    private static final String HOME_DIR = "~/";

    @Nullable
    public static final CommonDatabaseUrl parseToCommonDatabaseUrl(@NotNull String url, @Nullable String databaseNamePropValue, @Nullable String host, @Nullable Integer port) {
        Object object;
        Object object2;
        Object object3;
        String string;
        String string2;
        String string3;
        String string4;
        ParameterData parametersData;
        String parameters;
        String string5;
        Integer specifiedPort;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (ConfigDataSourcePropertyValueSearcherKt.containsPlaceholders(url)) {
            return null;
        }
        MatchResult matchResult = Regex.find$default((Regex)databaseUrlRegex, (CharSequence)url, (int)0, (int)2, null);
        if (matchResult == null || (matchResult = matchResult.getGroups()) == null) {
            return null;
        }
        MatchResult groups = matchResult;
        Object object4 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)groups, (String)"prefix");
        if (object4 == null || (object4 = object4.getValue()) == null) {
            return null;
        }
        Object prefix = object4;
        String string6 = host;
        if (string6 == null && (string6 = DatabaseUrlParserKt.getHost((MatchGroupCollection)groups)) == null) {
            return null;
        }
        String specifiedHost = string6;
        Integer n = port;
        if (n == null) {
            n = specifiedPort = DatabaseUrlParserKt.getPort((MatchGroupCollection)groups);
        }
        if ((string5 = DatabaseUrlParserKt.getDatabase((MatchGroupCollection)groups)) == null) {
            string5 = databaseNamePropValue;
        }
        String databaseName = string5;
        String string7 = parameters = DatabaseUrlParserKt.getParameters((MatchGroupCollection)groups);
        if (string7 != null) {
            String it = string7;
            boolean bl = false;
            v6 = DatabaseUrlParserKt.tryToRetrieveUsernameAndPasswordFromParameters(parameters);
        } else {
            v6 = parametersData = null;
        }
        if ((string4 = DatabaseUrlParserKt.getUserName((MatchGroupCollection)groups)) == null) {
            ParameterData parameterData = parametersData;
            string4 = string3 = parameterData != null ? parameterData.getUsername() : null;
        }
        if ((string2 = DatabaseUrlParserKt.getPassword((MatchGroupCollection)groups)) == null) {
            ParameterData parameterData = parametersData;
            string2 = string = parameterData != null ? parameterData.getPassword() : null;
        }
        if ((object3 = parametersData) == null || (object3 = ((ParameterData)object3).getDatabaseName()) == null) {
            object3 = object2 = databaseName;
        }
        if ((object = parametersData) == null || (object = ((ParameterData)object).getParameters()) == null) {
            object = parameters;
        }
        Object object5 = object;
        return new CommonDatabaseUrl(string, string3, (String)object2, specifiedHost, specifiedPort, (String)prefix, (String)object5, null, 128, null);
    }

    public static /* synthetic */ CommonDatabaseUrl parseToCommonDatabaseUrl$default(String string, String string2, String string3, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string2 = null;
        }
        if ((n2 & 4) != 0) {
            string3 = null;
        }
        if ((n2 & 8) != 0) {
            n = null;
        }
        return DatabaseUrlParserKt.parseToCommonDatabaseUrl(string, string2, string3, n);
    }

    @Nullable
    public static final String getValue(@NotNull MatchGroupCollection $this$getValue, @NotNull String groupName) {
        Intrinsics.checkNotNullParameter((Object)$this$getValue, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)groupName, (String)"groupName");
        MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)$this$getValue, (String)groupName);
        return matchGroup != null ? matchGroup.getValue() : null;
    }

    @Nullable
    public static final String getUserName(@NotNull MatchGroupCollection $this$getUserName) {
        Intrinsics.checkNotNullParameter((Object)$this$getUserName, (String)"<this>");
        return DatabaseUrlParserKt.getValue($this$getUserName, "username");
    }

    @Nullable
    public static final String getPassword(@NotNull MatchGroupCollection $this$getPassword) {
        Intrinsics.checkNotNullParameter((Object)$this$getPassword, (String)"<this>");
        String string = DatabaseUrlParserKt.getValue($this$getPassword, "password");
        return string != null ? StringsKt.removePrefix((String)string, (CharSequence)":") : null;
    }

    @Nullable
    public static final String getHost(@NotNull MatchGroupCollection $this$getHost) {
        Intrinsics.checkNotNullParameter((Object)$this$getHost, (String)"<this>");
        return DatabaseUrlParserKt.getValue($this$getHost, "host");
    }

    @Nullable
    public static final Integer getPort(@NotNull MatchGroupCollection $this$getPort) {
        Intrinsics.checkNotNullParameter((Object)$this$getPort, (String)"<this>");
        String string = DatabaseUrlParserKt.getValue($this$getPort, "port");
        return string != null && (string = StringsKt.removePrefix((String)string, (CharSequence)":")) != null ? StringsKt.toIntOrNull((String)string) : null;
    }

    @Nullable
    public static final String getDatabase(@NotNull MatchGroupCollection $this$getDatabase) {
        Intrinsics.checkNotNullParameter((Object)$this$getDatabase, (String)"<this>");
        String string = DatabaseUrlParserKt.getValue($this$getDatabase, "databaseName");
        return string != null ? StringsKt.removePrefix((String)string, (CharSequence)"/") : null;
    }

    @Nullable
    public static final String getParameters(@NotNull MatchGroupCollection $this$getParameters) {
        Intrinsics.checkNotNullParameter((Object)$this$getParameters, (String)"<this>");
        return DatabaseUrlParserKt.getValue($this$getParameters, "parameters");
    }

    @NotNull
    public static final PathAndDatabaseName splitToPathAndDatabaseName(@NotNull String pathToDb) {
        Object v3;
        String path;
        String databaseName;
        block7: {
            String string;
            block9: {
                block8: {
                    String string2;
                    Intrinsics.checkNotNullParameter((Object)pathToDb, (String)"pathToDb");
                    String it = string2 = StringsKt.substringAfterLast$default((String)pathToDb, (String)"/", null, (int)2, null);
                    boolean bl = false;
                    String string3 = databaseName = ((CharSequence)it).length() > 0 ? string2 : null;
                    if (Intrinsics.areEqual((Object)databaseName, (Object)pathToDb)) {
                        return new PathAndDatabaseName(null, databaseName);
                    }
                    string = databaseName;
                    if (string == null) break block8;
                    String it2 = string;
                    boolean bl2 = false;
                    String string4 = StringsKt.removeSuffix((String)pathToDb, (CharSequence)String.valueOf(databaseName));
                    string = string4;
                    if (string4 != null) break block9;
                }
                string = pathToDb;
            }
            path = string;
            Object[] bl = new String[]{RELATIVE_PATH, CURRENT_DIR, HOME_DIR};
            Iterable $this$firstOrNull$iv = CollectionsKt.listOf((Object[])bl);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl3 = false;
                if (!StringsKt.contains$default((CharSequence)path, (CharSequence)it, (boolean)false, (int)2, null)) continue;
                v3 = element$iv;
                break block7;
            }
            v3 = null;
        }
        String prefix = v3;
        if (prefix != null) {
            String relativePath = StringsKt.substringAfter$default((String)path, (String)prefix, null, (int)2, null);
            return new PathAndDatabaseName(prefix + relativePath, databaseName);
        }
        if (StringsKt.startsWith$default((String)path, (String)"/", (boolean)false, (int)2, null)) {
            String absolutePath = DatabaseUrlParserKt.removePrefixSlashes(path);
            return new PathAndDatabaseName("/" + absolutePath, databaseName);
        }
        return new PathAndDatabaseName(path, databaseName);
    }

    @NotNull
    public static final String removePrefixSlashes(@NotNull String $this$removePrefixSlashes) {
        String string;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$removePrefixSlashes, (String)"<this>");
            String $this$dropWhile$iv = $this$removePrefixSlashes;
            boolean $i$f$dropWhile = false;
            int n = ((CharSequence)$this$dropWhile$iv).length();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                char it = $this$dropWhile$iv.charAt(index$iv);
                boolean bl = false;
                if (it == '/') continue;
                String string2 = $this$dropWhile$iv.substring(index$iv);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                break block1;
            }
            string = "";
        }
        return string;
    }

    @NotNull
    public static final ParameterData tryToRetrieveUsernameAndPasswordFromParameters(@NotNull String parameters) {
        String string;
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        if (StringsKt.contains$default((CharSequence)parameters, (CharSequence)"&", (boolean)false, (int)2, null)) {
            string = "&";
        } else if (StringsKt.contains$default((CharSequence)parameters, (CharSequence)";", (boolean)false, (int)2, null)) {
            string = ";";
        } else {
            return new ParameterData(null, null, parameters, null, 8, null);
        }
        String delimiter = string;
        return DatabaseUrlParserKt.getParameterData(delimiter, parameters);
    }

    /*
     * WARNING - void declaration
     */
    private static final ParameterData getParameterData(String delimiter, String parameters) {
        void var7_8;
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        String string;
        Object v0;
        Object paramsPrefix;
        String[] $this$firstOrNull$iv;
        block8: {
            $this$firstOrNull$iv = (String[])paramsPrefixes;
            boolean $i$f$firstOrNull = false;
            for (Object t : $this$firstOrNull$iv) {
                paramsPrefix = (String)t;
                boolean bl = false;
                if (!StringsKt.startsWith$default((String)parameters, (String)paramsPrefix, (boolean)false, (int)2, null)) continue;
                v0 = t;
                break block8;
            }
            v0 = null;
        }
        if ((string = (String)v0) == null) {
            string = "";
        }
        String prefix = string;
        $this$firstOrNull$iv = new String[]{delimiter};
        List split = StringsKt.split$default((CharSequence)StringsKt.removePrefix((String)parameters, (CharSequence)prefix), (String[])$this$firstOrNull$iv, (boolean)false, (int)0, (int)6, null);
        List params = new ArrayList();
        String user = null;
        String password = null;
        Object var7_7 = null;
        paramsPrefix = split;
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String param = (String)element$iv;
            boolean bl = false;
            if (StringsKt.contains$default((CharSequence)param, (CharSequence)"=", (boolean)false, (int)2, null)) {
                Object element$iv$iv;
                element$iv$iv = new String[]{"="};
                List list = StringsKt.split$default((CharSequence)param, element$iv$iv, (boolean)false, (int)0, (int)6, null);
                String key = (String)list.get(0);
                String value = (String)list.get(1);
                if (StringsKt.contains$default((CharSequence)key, (CharSequence)"user", (boolean)false, (int)2, null)) {
                    user = value;
                    continue;
                }
                if (StringsKt.contains$default((CharSequence)key, (CharSequence)"password", (boolean)false, (int)2, null)) {
                    password = value;
                    continue;
                }
                if (StringsKt.contains((CharSequence)key, (CharSequence)"databaseName", (boolean)true)) {
                    String string2 = value;
                    continue;
                }
                params.add(param);
                continue;
            }
            params.add(param);
        }
        return new ParameterData(user, password, params.isEmpty() ? "" : CollectionsKt.joinToString$default((Iterable)params, (CharSequence)delimiter, (CharSequence)prefix, null, (int)0, null, DatabaseUrlParserKt::getParameterData$lambda$8, (int)28, null), (String)var7_8);
    }

    @Nullable
    public static final Pair<String, Integer> retrieveHostAndPort(@NotNull String value, @Nullable String defaultHost, @Nullable Integer defaultPort) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        MatchResult matchResult = Regex.find$default((Regex)new Regex(HOST_PORT_REGEXP), (CharSequence)value, (int)0, (int)2, null);
        Object hostPort = matchResult != null ? matchResult.getGroups() : null;
        Object object = hostPort;
        if ((object == null || (object = DatabaseUrlParserKt.getHost(object)) == null) && (object = defaultHost) == null) {
            return null;
        }
        Object host = object;
        Object object2 = hostPort;
        if (object2 == null || (object2 = DatabaseUrlParserKt.getPort(object2)) == null) {
            object2 = defaultPort;
        }
        Object specifiedPort = object2;
        return TuplesKt.to((Object)host, (Object)specifiedPort);
    }

    public static /* synthetic */ Pair retrieveHostAndPort$default(String string, String string2, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string2 = null;
        }
        if ((n2 & 4) != 0) {
            n = null;
        }
        return DatabaseUrlParserKt.retrieveHostAndPort(string, string2, n);
    }

    private static final CharSequence getParameterData$lambda$8(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }

    static {
        Object[] objectArray = new String[]{";", ":", "?"};
        paramsPrefixes = CollectionsKt.listOf((Object[])objectArray);
    }
}

