/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence.mongodb.json.intentions;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0018\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001b\u001cB!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\r\u001a\u00020\u00002\b\u0010\n\u001a\u0004\u0018\u00010\u0003J\u0010\u0010\u000e\u001a\u00020\u00002\b\u0010\t\u001a\u0004\u0018\u00010\u0003J\u0010\u0010\u000f\u001a\u00020\u00002\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003J\u0010\u0010\u0010\u001a\u00020\u00002\b\u0010\f\u001a\u0004\u0018\u00010\u0003J\u0006\u0010\u0011\u001a\u00020\u0003J\b\u0010\u0012\u001a\u00020\u0003H\u0002J\b\u0010\u0013\u001a\u00020\u0003H\u0002J\b\u0010\u0014\u001a\u00020\u0003H\u0002J\b\u0010\u0015\u001a\u00020\u0003H\u0002J\b\u0010\u0016\u001a\u00020\u0003H\u0002J\b\u0010\u0017\u001a\u00020\u0003H\u0002J\b\u0010\u0018\u001a\u00020\u0003H\u0002J\b\u0010\u0019\u001a\u00020\u0003H\u0002J\b\u0010\u001a\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/persistence/mongodb/json/intentions/MongoDBJsonQueryBuilder;", "", "collection", "", "type", "Lcom/intellij/persistence/mongodb/json/intentions/MongoDBJsonQueryBuilder$Type;", "query", "<init>", "(Ljava/lang/String;Lcom/intellij/persistence/mongodb/json/intentions/MongoDBJsonQueryBuilder$Type;Ljava/lang/String;)V", "sort", "projection", "collation", "update", "withProjection", "withSort", "withCollation", "withUpdate", "build", "buildAggregateQuery", "buildCountQuery", "buildDeleteQuery", "buildExistsQuery", "buildFindQuery", "buildUpdateQuery", "buildSort", "buildProjection", "buildCollation", "Type", "Companion", "intellij.javaee.persistence.impl"})
@SourceDebugExtension(value={"SMAP\nMongoDBJsonQueryBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MongoDBJsonQueryBuilder.kt\ncom/intellij/persistence/mongodb/json/intentions/MongoDBJsonQueryBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,121:1\n1#2:122\n*E\n"})
public final class MongoDBJsonQueryBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String collection;
    @NotNull
    private final Type type;
    @NotNull
    private final String query;
    @Nullable
    private String sort;
    @Nullable
    private String projection;
    @Nullable
    private String collation;
    @Nullable
    private String update;

    private MongoDBJsonQueryBuilder(String collection, Type type, String query) {
        this.collection = collection;
        this.type = type;
        this.query = query;
    }

    @NotNull
    public final MongoDBJsonQueryBuilder withProjection(@Nullable String projection) {
        MongoDBJsonQueryBuilder mongoDBJsonQueryBuilder;
        MongoDBJsonQueryBuilder $this$withProjection_u24lambda_u240 = mongoDBJsonQueryBuilder = this;
        boolean bl = false;
        $this$withProjection_u24lambda_u240.projection = projection;
        return mongoDBJsonQueryBuilder;
    }

    @NotNull
    public final MongoDBJsonQueryBuilder withSort(@Nullable String sort) {
        MongoDBJsonQueryBuilder mongoDBJsonQueryBuilder;
        MongoDBJsonQueryBuilder $this$withSort_u24lambda_u241 = mongoDBJsonQueryBuilder = this;
        boolean bl = false;
        $this$withSort_u24lambda_u241.sort = sort;
        return mongoDBJsonQueryBuilder;
    }

    @NotNull
    public final MongoDBJsonQueryBuilder withCollation(@Nullable String collation) {
        MongoDBJsonQueryBuilder mongoDBJsonQueryBuilder;
        MongoDBJsonQueryBuilder $this$withCollation_u24lambda_u242 = mongoDBJsonQueryBuilder = this;
        boolean bl = false;
        $this$withCollation_u24lambda_u242.collation = collation;
        return mongoDBJsonQueryBuilder;
    }

    @NotNull
    public final MongoDBJsonQueryBuilder withUpdate(@Nullable String update) {
        MongoDBJsonQueryBuilder mongoDBJsonQueryBuilder;
        MongoDBJsonQueryBuilder $this$withUpdate_u24lambda_u243 = mongoDBJsonQueryBuilder = this;
        boolean bl = false;
        $this$withUpdate_u24lambda_u243.update = update;
        return mongoDBJsonQueryBuilder;
    }

    @NotNull
    public final String build() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 1 -> this.buildAggregateQuery();
            case 2 -> this.buildCountQuery();
            case 3 -> this.buildDeleteQuery();
            case 4 -> this.buildExistsQuery();
            case 5 -> this.buildFindQuery();
            case 6 -> this.buildUpdateQuery();
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final String buildAggregateQuery() {
        String pipeline = this.collation != null && !StringsKt.startsWith$default((CharSequence)this.query, (char)'[', (boolean)false, (int)2, null) ? "[" + this.query + "]" : this.query;
        String options = this.collation != null ? ", { collation: " + this.collation + " }" : "";
        return "db." + this.collection + ".aggregate(" + pipeline + options + ")";
    }

    private final String buildCountQuery() {
        return "db." + this.collection + ".countDocuments(" + this.query + ")";
    }

    private final String buildDeleteQuery() {
        return "db." + this.collection + ".deleteMany(" + this.query + ")";
    }

    private final String buildExistsQuery() {
        return "db." + this.collection + ".find(" + this.query + ").hasNext()";
    }

    private final String buildFindQuery() {
        return "db." + this.collection + ".find(" + this.query + ")" + this.buildCollation() + this.buildProjection() + this.buildSort();
    }

    private final String buildUpdateQuery() {
        return "db." + this.collection + ".updateMany(" + this.query + ", " + this.update + ")";
    }

    private final String buildSort() {
        return this.sort != null ? ".sort(" + this.sort + ")" : "";
    }

    private final String buildProjection() {
        return this.projection != null ? ".projection(" + this.projection + ")" : "";
    }

    private final String buildCollation() {
        return this.collation != null ? ".collation(" + this.collation + ")" : "";
    }

    public /* synthetic */ MongoDBJsonQueryBuilder(String collection, Type type, String query, DefaultConstructorMarker $constructor_marker) {
        this(collection, type, query);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J\u0016\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J\u0016\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J\u0016\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J\u0016\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J\u0016\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007\u00a8\u0006\u000e"}, d2={"Lcom/intellij/persistence/mongodb/json/intentions/MongoDBJsonQueryBuilder$Companion;", "", "<init>", "()V", "aggregateQuery", "Lcom/intellij/persistence/mongodb/json/intentions/MongoDBJsonQueryBuilder;", "collection", "", "query", "countQuery", "deleteQuery", "existsQuery", "findQuery", "updateQuery", "intellij.javaee.persistence.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MongoDBJsonQueryBuilder aggregateQuery(@NotNull String collection, @NotNull String query) {
            Intrinsics.checkNotNullParameter((Object)collection, (String)"collection");
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            return new MongoDBJsonQueryBuilder(collection, Type.AGGREGATE, query, null);
        }

        @NotNull
        public final MongoDBJsonQueryBuilder countQuery(@NotNull String collection, @NotNull String query) {
            Intrinsics.checkNotNullParameter((Object)collection, (String)"collection");
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            return new MongoDBJsonQueryBuilder(collection, Type.COUNT, query, null);
        }

        @NotNull
        public final MongoDBJsonQueryBuilder deleteQuery(@NotNull String collection, @NotNull String query) {
            Intrinsics.checkNotNullParameter((Object)collection, (String)"collection");
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            return new MongoDBJsonQueryBuilder(collection, Type.DELETE, query, null);
        }

        @NotNull
        public final MongoDBJsonQueryBuilder existsQuery(@NotNull String collection, @NotNull String query) {
            Intrinsics.checkNotNullParameter((Object)collection, (String)"collection");
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            return new MongoDBJsonQueryBuilder(collection, Type.EXISTS, query, null);
        }

        @NotNull
        public final MongoDBJsonQueryBuilder findQuery(@NotNull String collection, @NotNull String query) {
            Intrinsics.checkNotNullParameter((Object)collection, (String)"collection");
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            return new MongoDBJsonQueryBuilder(collection, Type.FIND, query, null);
        }

        @NotNull
        public final MongoDBJsonQueryBuilder updateQuery(@NotNull String collection, @NotNull String query) {
            Intrinsics.checkNotNullParameter((Object)collection, (String)"collection");
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            return new MongoDBJsonQueryBuilder(collection, Type.UPDATE, query, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/intellij/persistence/mongodb/json/intentions/MongoDBJsonQueryBuilder$Type;", "", "<init>", "(Ljava/lang/String;I)V", "AGGREGATE", "COUNT", "DELETE", "EXISTS", "FIND", "UPDATE", "intellij.javaee.persistence.impl"})
    private static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type AGGREGATE = new Type();
        public static final /* enum */ Type COUNT = new Type();
        public static final /* enum */ Type DELETE = new Type();
        public static final /* enum */ Type EXISTS = new Type();
        public static final /* enum */ Type FIND = new Type();
        public static final /* enum */ Type UPDATE = new Type();
        private static final /* synthetic */ Type[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value) {
            return Enum.valueOf(Type.class, value);
        }

        @NotNull
        public static EnumEntries<Type> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = typeArray = new Type[]{Type.AGGREGATE, Type.COUNT, Type.DELETE, Type.EXISTS, Type.FIND, Type.UPDATE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Type.values().length];
            try {
                nArray[Type.AGGREGATE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.COUNT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.DELETE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.EXISTS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.FIND.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.UPDATE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

