/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence.mongodb.json.intentions;

import com.intellij.persistence.mongodb.json.psi.MongoDBJsonObject;
import com.intellij.persistence.mongodb.json.psi.MongoDBJsonProperty;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a.\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\nH\u0002\u001a&\u0010\u000e\u001a\u00020\u00052\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\u000f2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007H\u0002\u00a8\u0006\u0011"}, d2={"isSorted", "", "obj", "Lcom/intellij/persistence/mongodb/json/psi/MongoDBJsonObject;", "cycleSortProperties", "", "advance", "", "properties", "", "Lcom/intellij/persistence/mongodb/json/psi/MongoDBJsonProperty;", "size", "cycleStart", "item", "exchange", "", "pos", "intellij.javaee.persistence.impl"})
@SourceDebugExtension(value={"SMAP\nMongoDBJsonSortPropertiesIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MongoDBJsonSortPropertiesIntention.kt\ncom/intellij/persistence/mongodb/json/intentions/MongoDBJsonSortPropertiesIntentionKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,146:1\n1232#2,2:147\n*S KotlinDebug\n*F\n+ 1 MongoDBJsonSortPropertiesIntention.kt\ncom/intellij/persistence/mongodb/json/intentions/MongoDBJsonSortPropertiesIntentionKt\n*L\n103#1:147,2\n*E\n"})
public final class MongoDBJsonSortPropertiesIntentionKt {
    private static final boolean isSorted(MongoDBJsonObject obj) {
        boolean bl;
        block3: {
            List<MongoDBJsonProperty> list = obj.getPropertyList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getPropertyList(...)");
            Sequence $this$all$iv = SequencesKt.zipWithNext((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list), MongoDBJsonSortPropertiesIntentionKt::isSorted$lambda$0));
            boolean $i$f$all = false;
            for (Object element$iv : $this$all$iv) {
                String string;
                Pair pair = (Pair)element$iv;
                boolean bl2 = false;
                String l = (String)pair.component1();
                String r = (String)pair.component2();
                String string2 = l;
                if (string2 == null) {
                    string2 = "";
                }
                if ((string = r) == null) {
                    string = "";
                }
                if (string2.compareTo(string) <= 0) continue;
                bl = false;
                break block3;
            }
            bl = true;
        }
        return bl;
    }

    private static final void cycleSortProperties(MongoDBJsonObject obj) {
        List<MongoDBJsonProperty> list = obj.getPropertyList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getPropertyList(...)");
        List<MongoDBJsonProperty> properties = list;
        int size = properties.size();
        for (int cycleStart = 0; cycleStart < size; ++cycleStart) {
            MongoDBJsonProperty item = properties.get(cycleStart);
            int pos = MongoDBJsonSortPropertiesIntentionKt.advance(properties, size, cycleStart, item);
            if (pos == -1) continue;
            if (pos != cycleStart) {
                MongoDBJsonSortPropertiesIntentionKt.exchange(properties, pos, cycleStart);
            }
            while (pos != cycleStart && (pos = MongoDBJsonSortPropertiesIntentionKt.advance(properties, size, cycleStart, properties.get(cycleStart))) != -1) {
                if (pos == cycleStart) continue;
                MongoDBJsonSortPropertiesIntentionKt.exchange(properties, pos, cycleStart);
            }
        }
    }

    private static final int advance(List<? extends MongoDBJsonProperty> properties, int size, int cycleStart, MongoDBJsonProperty item) {
        int pos = cycleStart;
        String string = item.getName();
        if (string == null) {
            string = "";
        }
        String itemName = string;
        for (int i = cycleStart + 1; i < size; ++i) {
            String string2 = properties.get(i).getName();
            if (string2 == null) {
                string2 = "";
            }
            if (string2.compareTo(itemName) >= 0) continue;
            ++pos;
        }
        if (pos == cycleStart) {
            return -1;
        }
        while (Intrinsics.areEqual((Object)itemName, (Object)properties.get(pos).getName())) {
            ++pos;
        }
        return pos;
    }

    private static final void exchange(List<MongoDBJsonProperty> properties, int pos, int item) {
        MongoDBJsonProperty propertyAtPos = properties.get(pos);
        MongoDBJsonProperty itemProperty = properties.get(item);
        PsiElement psiElement = propertyAtPos.getParent().addBefore((PsiElement)itemProperty, (PsiElement)propertyAtPos);
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.persistence.mongodb.json.psi.MongoDBJsonProperty");
        properties.set(pos, (MongoDBJsonProperty)psiElement);
        PsiElement psiElement2 = itemProperty.getParent().addBefore((PsiElement)propertyAtPos, (PsiElement)itemProperty);
        Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type com.intellij.persistence.mongodb.json.psi.MongoDBJsonProperty");
        properties.set(item, (MongoDBJsonProperty)psiElement2);
        propertyAtPos.delete();
        itemProperty.delete();
    }

    private static final String isSorted$lambda$0(MongoDBJsonProperty it) {
        return it.getName();
    }

    public static final /* synthetic */ boolean access$isSorted(MongoDBJsonObject obj) {
        return MongoDBJsonSortPropertiesIntentionKt.isSorted(obj);
    }

    public static final /* synthetic */ void access$cycleSortProperties(MongoDBJsonObject obj) {
        MongoDBJsonSortPropertiesIntentionKt.cycleSortProperties(obj);
    }
}

