/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.appServers.deployment.ui;

import com.intellij.DynamicBundle;
import com.intellij.ide.DataManager;
import com.intellij.javaee.appServers.AppServersIntegrationBundle;
import com.intellij.javaee.appServers.customDeployment.CustomDeploymentActionHandler;
import com.intellij.javaee.appServers.customDeployment.CustomDeploymentProvider;
import com.intellij.javaee.appServers.customDeployment.DeploymentSourcesCollection;
import com.intellij.javaee.appServers.deployment.ArtifactDeploymentSource;
import com.intellij.javaee.appServers.deployment.DeploymentModel;
import com.intellij.javaee.appServers.deployment.DeploymentProvider;
import com.intellij.javaee.appServers.deployment.DeploymentSettings;
import com.intellij.javaee.appServers.deployment.DeploymentSource;
import com.intellij.javaee.appServers.deployment.ExternalFileDeploymentProvider;
import com.intellij.javaee.appServers.deployment.JavaeeDeploymentUtil;
import com.intellij.javaee.appServers.deployment.ModuleDeploymentSource;
import com.intellij.javaee.appServers.deployment.ui.DeploymentModelSettingsPanel;
import com.intellij.javaee.appServers.deployment.ui.actions.AddArtifactToDeployAction;
import com.intellij.javaee.appServers.deployment.ui.actions.AddArtifactToDeployActionRunnable;
import com.intellij.javaee.appServers.deployment.ui.actions.AddCustomSourceToDeployAction;
import com.intellij.javaee.appServers.deployment.ui.actions.AddExternalFileToDeployAction;
import com.intellij.javaee.appServers.deployment.ui.actions.AddModuleToDeployAction;
import com.intellij.javaee.appServers.deployment.ui.actions.OpenArtifactEditorAction;
import com.intellij.javaee.appServers.run.configuration.CommonModel;
import com.intellij.javaee.appServers.run.configuration.CommonStrategy;
import com.intellij.javaee.appServers.run.configuration.DeploymentSettingsImpl;
import com.intellij.javaee.appServers.run.configuration.view.JavaeeRunConfigurationEditorContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactPointer;
import com.intellij.packaging.artifacts.ArtifactPointerManager;
import com.intellij.remoteServer.configuration.deployment.DeploymentSourceType;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.SortedListModel;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class DeploymentSettingsPanel
extends SettingsEditor<CommonStrategy> {
    private static final Logger LOG = Logger.getInstance(DeploymentSettingsPanel.class);
    private static final Comparator<DeploymentSource> DEPLOYMENT_SOURCE_COMPARATOR = Comparator.comparing(source -> source.getPresentableName());
    private JPanel myMainPanel;
    private JPanel myPropertiesPanel;
    private JPanel myDeploymentModelsListPanel;
    private final JBList<DeploymentSource> myDeploymentModelsList;
    private final CommonStrategy myCommonModel;
    private final DeploymentProvider myDeploymentProvider;
    private final JavaeeRunConfigurationEditorContext myEditorContext;
    private final Map<DeploymentSource, DeploymentModelSettingsPanel> myPanels;
    private final Project myProject;
    private final DeployOrderHandler myDeployOrderHandler;

    public DeploymentSettingsPanel(@NotNull CommonStrategy commonModel, @NotNull DeploymentProvider deploymentProvider, @NotNull JavaeeRunConfigurationEditorContext editorContext) {
        boolean hasCustomProviders;
        if (commonModel == null) {
            DeploymentSettingsPanel.$$$reportNull$$$0(0);
        }
        if (deploymentProvider == null) {
            DeploymentSettingsPanel.$$$reportNull$$$0(1);
        }
        if (editorContext == null) {
            DeploymentSettingsPanel.$$$reportNull$$$0(2);
        }
        this.$$$setupUI$$$();
        this.myPanels = new HashMap<DeploymentSource, DeploymentModelSettingsPanel>();
        this.myCommonModel = commonModel;
        this.myProject = commonModel.getProject();
        this.myDeploymentProvider = deploymentProvider;
        this.myEditorContext = editorContext;
        this.myDeployOrderHandler = deploymentProvider.isDeployOrderMatter() ? new CustomDeployOrderHandler() : new SortedDeployOrderHandler();
        this.myDeploymentModelsList = new JBList(this.myDeployOrderHandler.createListModel());
        this.myDeploymentModelsList.getEmptyText().setText(AppServersIntegrationBundle.message((String)"DeploymentSettingsPanel.nothing.to.deploy", (Object[])new Object[0]));
        ListSpeedSearch.installOn(this.myDeploymentModelsList, o -> o.getPresentableName());
        this.myDeploymentModelsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DeploymentSettingsPanel.this.updateArtifactPropertiesPanel();
            }
        });
        this.myDeploymentModelsList.setCellRenderer((ListCellRenderer)SimpleListCellRenderer.create((label, value, index) -> {
            if (value != null) {
                label.setText(value.getPresentableName());
                label.setIcon(value.getIcon());
                label.setForeground((Color)(value.isValid() ? null : JBColor.RED));
            }
        }));
        ToolbarDecorator toolbarDecorator = ToolbarDecorator.createDecorator(this.myDeploymentModelsList);
        final ExternalFileDeploymentProvider externalFileDeploymentProvider = this.myDeploymentProvider.getExternalFileDeploymentProvider();
        final boolean hasExternalProvider = externalFileDeploymentProvider != null;
        final boolean moduleDeployAllowed = this.myDeploymentProvider.isModuleDeployAllowed();
        final List customProviders = this.myDeploymentProvider.getCustomDeploymentProviders();
        boolean bl = hasCustomProviders = !customProviders.isEmpty();
        if (!(moduleDeployAllowed || hasExternalProvider || hasCustomProviders)) {
            toolbarDecorator.setAddActionName(AppServersIntegrationBundle.message((String)"DeploymentSettingsPanel.add.artifact.to.deploy", (Object[])new Object[0]));
            toolbarDecorator.setAddAction((AnActionButtonRunnable)new AddArtifactToDeployActionRunnable(this));
        } else {
            toolbarDecorator.setAddAction(new AnActionButtonRunnable(){

                public void run(AnActionButton anActionButton) {
                    DefaultActionGroup addGroup = DefaultActionGroup.createPopupGroup((Supplier)Presentation.NULL_STRING);
                    addGroup.add((AnAction)new AddArtifactToDeployAction(DeploymentSettingsPanel.this));
                    if (hasExternalProvider) {
                        addGroup.add((AnAction)new AddExternalFileToDeployAction(DeploymentSettingsPanel.this, externalFileDeploymentProvider));
                    }
                    if (moduleDeployAllowed) {
                        addGroup.add((AnAction)new AddModuleToDeployAction(DeploymentSettingsPanel.this));
                    }
                    for (CustomDeploymentProvider additionalProvider : customProviders) {
                        CustomDeploymentActionHandler actionHandler = additionalProvider.createActionHandler(new DeploymentSourcesCollection(){

                            public @Unmodifiable Collection<DeploymentSource> getItems() {
                                return DeploymentSettingsPanel.this.myDeployOrderHandler.getItems();
                            }

                            public void addItem(DeploymentSource item) {
                                DeploymentSettingsPanel.this.addDeploymentModel(item);
                            }
                        }, DeploymentSettingsPanel.this.myProject);
                        addGroup.add((AnAction)new AddCustomSourceToDeployAction(actionHandler));
                    }
                    ListPopup listPopup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)addGroup, DataManager.getInstance().getDataContext((Component)anActionButton.getContextComponent()), JBPopupFactory.ActionSelectionAid.MNEMONICS, false);
                    listPopup.show(anActionButton.getPreferredPopupPoint());
                }
            });
        }
        toolbarDecorator.setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                DeploymentSettingsPanel.this.removeModels(DeploymentSettingsPanel.this.getSelectedSources());
            }
        });
        OpenArtifactEditorAction openArtifactEditorAction = new OpenArtifactEditorAction(this);
        openArtifactEditorAction.registerCustomShortcutSet(CommonShortcuts.getEditSource(), this.myDeploymentModelsListPanel, (Disposable)this);
        toolbarDecorator.addExtraAction((AnAction)openArtifactEditorAction);
        this.myDeployOrderHandler.customizeToolbarDecorator(toolbarDecorator);
        this.myDeploymentModelsListPanel.add((Component)toolbarDecorator.createPanel(), "Center");
        this.updateArtifactPropertiesPanel();
    }

    public void updateDeploymentModels() {
        HashSet artifacts = ContainerUtil.newHashSet((Object[])ArtifactManager.getInstance((Project)this.myProject).getArtifacts());
        ArrayList<DeploymentSource> toRemove = new ArrayList<DeploymentSource>();
        for (DeploymentSource source : this.myDeployOrderHandler.getItems()) {
            if (!(source instanceof ArtifactDeploymentSource) || artifacts.contains(((ArtifactDeploymentSource)source).getArtifact())) continue;
            toRemove.add(source);
        }
        this.removeModels(toRemove);
        this.myMainPanel.revalidate();
    }

    private void updateArtifactPropertiesPanel() {
        List<DeploymentSource> selected = this.getSelectedSources();
        if (selected.size() == 1) {
            this.showCard(DeploymentSettingsPanel.getCardName(selected.get(0)));
        } else {
            this.showCard("empty");
        }
    }

    public List<DeploymentSource> getSelectedSources() {
        return new ArrayList<DeploymentSource>(this.myDeploymentModelsList.getSelectedValuesList());
    }

    private static String getCardName(@NotNull DeploymentSource source) {
        if (source == null) {
            DeploymentSettingsPanel.$$$reportNull$$$0(3);
        }
        return "source:" + source.getPresentableName();
    }

    private void showCard(String name) {
        ((CardLayout)this.myPropertiesPanel.getLayout()).show(this.myPropertiesPanel, name);
    }

    protected void resetEditorFrom(@NotNull CommonStrategy s) {
        if (s == null) {
            DeploymentSettingsPanel.$$$reportNull$$$0(4);
        }
        DeploymentSettings settings = s.getDeploymentSettings();
        List<DeploymentSource> selected = this.getSelectedSources();
        this.myDeployOrderHandler.clearItems();
        this.myPanels.clear();
        LOG.assertTrue(settings != null, (Object)this.myDeploymentProvider);
        for (DeploymentModel model : settings.getDeploymentModels()) {
            this.createPanel(s, model);
        }
        for (DeploymentSource source : selected) {
            this.myDeploymentModelsList.setSelectedValue((Object)source, true);
        }
        if (selected.isEmpty() && this.myDeploymentModelsList.getItemsCount() > 0) {
            this.myDeploymentModelsList.setSelectedIndex(0);
        }
    }

    private void createPanel(@NotNull CommonStrategy commonStrategy, @NotNull DeploymentModel model) {
        if (commonStrategy == null) {
            DeploymentSettingsPanel.$$$reportNull$$$0(5);
        }
        if (model == null) {
            DeploymentSettingsPanel.$$$reportNull$$$0(6);
        }
        DeploymentModelSettingsPanel panel = new DeploymentModelSettingsPanel(model, commonStrategy, this.myDeploymentProvider);
        Disposer.register((Disposable)this, (Disposable)panel);
        DeploymentSource source = model.getDeploymentSource();
        this.myPropertiesPanel.add((Component)panel.getComponent(), DeploymentSettingsPanel.getCardName(source));
        this.myPanels.put(source, panel);
        this.myDeployOrderHandler.addItem(source);
        panel.resetFrom(model);
    }

    protected void applyEditorTo(@NotNull CommonStrategy s) throws ConfigurationException {
        DeploymentSettingsImpl deploymentSettings;
        if (s == null) {
            DeploymentSettingsPanel.$$$reportNull$$$0(7);
        }
        LOG.assertTrue((deploymentSettings = (DeploymentSettingsImpl)s.getDeploymentSettings()) != null, (Object)this.myDeploymentProvider);
        HashMap<DeploymentSource, DeploymentModel> source2model = new HashMap<DeploymentSource, DeploymentModel>();
        for (DeploymentModel model : deploymentSettings.getDeploymentModels()) {
            source2model.put(model.getDeploymentSource(), model);
        }
        ArrayList<DeploymentModel> result = new ArrayList<DeploymentModel>();
        for (DeploymentSource source : this.myDeployOrderHandler.getItems()) {
            DeploymentModelSettingsPanel panel;
            DeploymentModel resultModel = (DeploymentModel)source2model.remove(source);
            if (resultModel == null) {
                resultModel = this.myDeploymentProvider.createNewDeploymentModel((CommonModel)s, source);
            }
            if ((panel = this.myPanels.get(source)) != null) {
                panel.applyTo(resultModel);
            }
            result.add(resultModel);
        }
        deploymentSettings.setModels(result);
    }

    public void markForDeployment(Artifact artifact) {
        if (this.getAddedArtifacts().contains(artifact)) {
            return;
        }
        ArtifactPointer pointer = ArtifactPointerManager.getInstance((Project)this.myProject).createPointer(artifact);
        ArtifactDeploymentSource source = JavaeeDeploymentUtil.getInstance().createArtifactDeploymentSource(pointer);
        this.addDeploymentModel((DeploymentSource)source);
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            DeploymentSettingsPanel.$$$reportNull$$$0(8);
        }
        return jPanel;
    }

    public void removeModels(List<DeploymentSource> sources) {
        for (DeploymentSource source : sources) {
            this.myDeployOrderHandler.removeItem(source);
            DeploymentModelSettingsPanel panel = this.myPanels.remove(source);
            if (panel != null) {
                this.myPropertiesPanel.remove(panel.getComponent());
            }
            this.onDeploymentChanged(source, false);
        }
        this.myEditorContext.fireDeploymentSettingsChanged();
    }

    public DeploymentProvider getDeploymentProvider() {
        return this.myDeploymentProvider;
    }

    public Set<Artifact> getAddedArtifacts() {
        HashSet<Artifact> result = new HashSet<Artifact>();
        for (DeploymentSource source : this.myDeployOrderHandler.getItems()) {
            if (!(source instanceof ArtifactDeploymentSource)) continue;
            ContainerUtil.addIfNotNull(result, (Object)((ArtifactDeploymentSource)source).getArtifact());
        }
        return result;
    }

    public Set<Module> getAddedModules() {
        HashSet<Module> result = new HashSet<Module>();
        for (DeploymentSource source : this.myDeployOrderHandler.getItems()) {
            if (!(source instanceof ModuleDeploymentSource)) continue;
            ContainerUtil.addIfNotNull(result, (Object)((ModuleDeploymentSource)source).getModule());
        }
        return result;
    }

    public void addDeploymentModel(DeploymentSource deploymentSource) {
        DeploymentModel model = this.myDeploymentProvider.createNewDeploymentModel((CommonModel)this.myCommonModel, deploymentSource);
        if (model == null) {
            LOG.error(String.valueOf(this.myDeploymentProvider.getClass()) + " uses deprecated 'createNewDeploymentModel' method");
            return;
        }
        CommonStrategy snapshot = this.myCommonModel;
        try {
            snapshot = this.myEditorContext.getSnapshot();
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        this.createPanel(snapshot, model);
        this.myDeploymentModelsList.setSelectedIndices(ArrayUtilRt.EMPTY_INT_ARRAY);
        this.myDeploymentModelsList.setSelectedValue((Object)deploymentSource, true);
        this.onDeploymentChanged(deploymentSource, true);
        this.myEditorContext.fireDeploymentSettingsChanged();
    }

    private void onDeploymentChanged(DeploymentSource deploymentSource, boolean added) {
        DeploymentSourceType type = deploymentSource.getType();
        type.updateBuildBeforeRunOption((JComponent)this.myMainPanel, this.myProject, (com.intellij.remoteServer.configuration.deployment.DeploymentSource)deploymentSource, added);
    }

    public Project getProject() {
        return this.myProject;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        this.myMainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/AppServersIntegrationBundle", DeploymentSettingsPanel.class).getString("DeploymentSettingsPanel.title.deploy.at.the.server.startup"), (int)0, (int)0, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, "Center");
        this.myDeploymentModelsListPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        this.myPropertiesPanel = jPanel = new JPanel();
        jPanel.setLayout(new CardLayout(0, 0));
        jPanel4.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel5, "empty");
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deploymentProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonStrategy";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/appServers/deployment/ui/DeploymentSettingsPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/appServers/deployment/ui/DeploymentSettingsPanel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCardName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createPanel";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }

    private static class CustomDeployOrderHandler
    extends DeployOrderHandlerBase<DefaultListModel<DeploymentSource>> {
        private CustomDeployOrderHandler() {
        }

        @Override
        protected DefaultListModel<DeploymentSource> doCreateListModel() {
            return new DefaultListModel<DeploymentSource>();
        }

        @Override
        public @Unmodifiable Collection<DeploymentSource> getItems() {
            return ContainerUtil.collect(((DefaultListModel)this.getListModel()).elements().asIterator());
        }

        @Override
        public void clearItems() {
            ((DefaultListModel)this.getListModel()).clear();
        }

        @Override
        public void addItem(DeploymentSource item) {
            ((DefaultListModel)this.getListModel()).addElement(item);
        }

        @Override
        public void removeItem(DeploymentSource item) {
            ((DefaultListModel)this.getListModel()).removeElement(item);
        }

        @Override
        public void customizeToolbarDecorator(ToolbarDecorator toolbarDecorator) {
        }
    }

    private static class SortedDeployOrderHandler
    extends DeployOrderHandlerBase<SortedListModel<DeploymentSource>> {
        private SortedDeployOrderHandler() {
        }

        @Override
        protected SortedListModel<DeploymentSource> doCreateListModel() {
            return SortedListModel.create(DEPLOYMENT_SOURCE_COMPARATOR);
        }

        @Override
        public Collection<DeploymentSource> getItems() {
            return ((SortedListModel)this.getListModel()).getItems();
        }

        @Override
        public void clearItems() {
            ((SortedListModel)this.getListModel()).clear();
        }

        @Override
        public void addItem(DeploymentSource item) {
            ((SortedListModel)this.getListModel()).add((Object)item);
        }

        @Override
        public void removeItem(DeploymentSource item) {
            ((SortedListModel)this.getListModel()).remove((Object)item);
        }

        @Override
        public void customizeToolbarDecorator(ToolbarDecorator toolbarDecorator) {
            toolbarDecorator.disableUpDownActions();
        }
    }

    private static interface DeployOrderHandler {
        public AbstractListModel<DeploymentSource> createListModel();

        public @Unmodifiable Collection<DeploymentSource> getItems();

        public void clearItems();

        public void addItem(DeploymentSource var1);

        public void removeItem(DeploymentSource var1);

        public void customizeToolbarDecorator(ToolbarDecorator var1);
    }

    private static abstract class DeployOrderHandlerBase<T extends AbstractListModel<DeploymentSource>>
    implements DeployOrderHandler {
        private T myListModel;

        private DeployOrderHandlerBase() {
        }

        @Override
        public AbstractListModel<DeploymentSource> createListModel() {
            this.myListModel = this.doCreateListModel();
            return this.myListModel;
        }

        protected final T getListModel() {
            return this.myListModel;
        }

        protected abstract T doCreateListModel();
    }
}

