/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.util;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.kotlin.jupyter.core.settings.KotlinNotebookDependencies;
import com.intellij.kotlin.jupyter.core.settings.KotlinNotebookDependenciesPropertyKt;
import com.intellij.kotlin.jupyter.core.settings.KotlinNotebookPerFileSettingsCache;
import com.intellij.kotlin.jupyter.core.settings.KotlinNotebookSettings;
import com.intellij.kotlin.jupyter.core.util.IsKotlinNotebookKt;
import com.intellij.kotlin.jupyter.core.util.UtilKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.EditorTabPresentationUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtilKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005*\u00020\u0006\u001a\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005*\u00020\u00062\u0006\u0010\b\u001a\u00020\t\u001a\f\u0010\n\u001a\u0004\u0018\u00010\t*\u00020\u000b\u001a\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0005*\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f\u001a\n\u0010\u0016\u001a\u00020\u000b*\u00020\u000f\u001a\u001c\u0010\u0017\u001a\u00020\u0015*\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001aH\u0001\u001a\u000e\u0010\u001b\u001a\u0004\u0018\u00010\t*\u0004\u0018\u00010\u000f\u001a\u0014\u0010\u001c\u001a\u0004\u0018\u00010\u000b*\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0006\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u001b\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011*\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013*\u0016\u0010\u0014\"\b\u0012\u0004\u0012\u00020\u00150\u00052\b\u0012\u0004\u0012\u00020\u00150\u0005\u00a8\u0006\u001d"}, d2={"isNotEmptyDirectory", "", "Ljava/io/File;", "(Ljava/io/File;)Z", "allSourceRoots", "", "Lcom/intellij/openapi/project/Project;", "sourceRootsForDependencies", "notebookFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "findNotebookVirtualFileOrNull", "Ljava/nio/file/Path;", "findEditors", "Lcom/intellij/openapi/editor/Editor;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "parentsWithSelf", "Lkotlin/sequences/Sequence;", "getParentsWithSelf", "(Lcom/intellij/openapi/vfs/VirtualFile;)Lkotlin/sequences/Sequence;", "ProjectArtifacts", "", "toAbsolutePath", "toPresentablePathAsTabTitle", "project", "contentManager", "Lcom/intellij/ui/content/ContentManager;", "toKotlinNotebookBackedFile", "getRelativePathFromProjectRoot", "intellij.kotlin.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nfiles.kt\nKotlin\n*S Kotlin\n*F\n+ 1 files.kt\ncom/intellij/kotlin/jupyter/core/util/FilesKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,117:1\n10135#2:118\n10557#2,2:119\n11228#2:121\n11563#2,3:122\n10559#2,3:125\n11228#2:131\n11563#2,3:132\n11228#2:138\n11563#2,3:139\n4135#2,11:142\n1374#3:128\n1460#3,2:129\n1462#3,3:135\n1563#3:153\n1634#3,3:154\n*S KotlinDebug\n*F\n+ 1 files.kt\ncom/intellij/kotlin/jupyter/core/util/FilesKt\n*L\n36#1:118\n36#1:119,2\n37#1:121\n37#1:122,3\n36#1:125,3\n50#1:131\n50#1:132,3\n57#1:138\n57#1:139,3\n70#1:142,11\n49#1:128\n49#1:129,2\n49#1:135,3\n71#1:153\n71#1:154,3\n*E\n"})
public final class FilesKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isNotEmptyDirectory(@NotNull File $this$isNotEmptyDirectory) {
        Intrinsics.checkNotNullParameter((Object)$this$isNotEmptyDirectory, (String)"<this>");
        if (!$this$isNotEmptyDirectory.exists()) return false;
        if (!$this$isNotEmptyDirectory.isDirectory()) return false;
        String[] stringArray = $this$isNotEmptyDirectory.list();
        if (stringArray == null) return false;
        if (stringArray.length != 0) return true;
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<File> allSourceRoots(@NotNull Project $this$allSourceRoots) {
        void $this$flatMapTo$iv$iv;
        Module[] allModules;
        Intrinsics.checkNotNullParameter((Object)$this$allSourceRoots, (String)"<this>");
        ModuleManager moduleManager = ModuleManager.Companion.getInstance($this$allSourceRoots);
        Module[] $this$flatMap$iv = allModules = moduleManager.getModules();
        boolean $i$f$flatMap = false;
        Module[] moduleArray = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        int n = ((void)$this$flatMapTo$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            void $this$mapTo$iv$iv;
            void element$iv$iv;
            void module = element$iv$iv = $this$flatMapTo$iv$iv[j];
            boolean bl = false;
            VirtualFile[] $this$map$iv = ProjectRootsUtilKt.getSourceRoots((Module)module);
            boolean $i$f$map = false;
            VirtualFile[] virtualFileArray = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n2 = ((void)$this$mapTo$iv$iv).length;
            for (int k = 0; k < n2; ++k) {
                void it;
                void item$iv$iv;
                void var21_21 = item$iv$iv = $this$mapTo$iv$iv[k];
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(new File(it.getPath()));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<File> sourceRootsForDependencies(@NotNull Project $this$sourceRootsForDependencies, @NotNull BackedNotebookVirtualFile notebookFile) {
        List list;
        KotlinNotebookDependencies dependencies;
        Intrinsics.checkNotNullParameter((Object)$this$sourceRootsForDependencies, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)notebookFile, (String)"notebookFile");
        KotlinNotebookSettings optionsProvider = KotlinNotebookPerFileSettingsCache.Companion.getInstance($this$sourceRootsForDependencies).getSettings(notebookFile);
        KotlinNotebookDependencies kotlinNotebookDependencies = dependencies = optionsProvider.getNotebookDependencies();
        if (kotlinNotebookDependencies instanceof KotlinNotebookDependencies.None) {
            list = CollectionsKt.emptyList();
        } else if (kotlinNotebookDependencies instanceof KotlinNotebookDependencies.AllLibraries) {
            void $this$flatMapTo$iv$iv;
            List<Library> libraries = KotlinNotebookDependenciesPropertyKt.getSuitableLibraries($this$sourceRootsForDependencies);
            Iterable $this$flatMap$iv = libraries;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$mapTo$iv$iv;
                Library library = (Library)element$iv$iv;
                boolean bl = false;
                VirtualFile[] virtualFileArray = library.getRootProvider().getFiles(OrderRootType.SOURCES);
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getFiles(...)");
                Object[] $this$map$iv = virtualFileArray;
                boolean $i$f$map = false;
                Object[] objectArray = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                for (void item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    VirtualFile virtualFile = (VirtualFile)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    collection.add(new File(it.getPath()));
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else if (kotlinNotebookDependencies instanceof KotlinNotebookDependencies.SingleModule) {
            void $this$mapTo$iv$iv;
            Module tagetModule = KotlinNotebookDependenciesPropertyKt.findModule(optionsProvider.getNotebookDependencies(), $this$sourceRootsForDependencies);
            if (tagetModule == null) {
                return CollectionsKt.emptyList();
            }
            VirtualFile[] $this$map$iv = ProjectRootsUtilKt.getSourceRoots((Module)tagetModule);
            boolean $i$f$map = false;
            VirtualFile[] $this$flatMapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int j = 0; j < n; ++j) {
                void it;
                void item$iv$iv;
                void bl = item$iv$iv = $this$mapTo$iv$iv[j];
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(new File(it.getPath()));
            }
            list = (List)destination$iv$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list;
    }

    @Nullable
    public static final BackedNotebookVirtualFile findNotebookVirtualFileOrNull(@NotNull Path $this$findNotebookVirtualFileOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$findNotebookVirtualFileOrNull, (String)"<this>");
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByNioPath($this$findNotebookVirtualFileOrNull);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        return BackedNotebookVirtualFile.Companion.takeBackend(virtualFile2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Editor> findEditors(@NotNull Project $this$findEditors, @NotNull VirtualFile virtualFile) {
        void $this$mapTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$findEditors, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)$this$findEditors);
        FileEditor[] fileEditorArray = fileEditorManager.getAllEditors(virtualFile);
        Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"getAllEditors(...)");
        Object[] $this$filterIsInstance$iv = fileEditorArray;
        boolean $i$f$filterIsInstance = false;
        Object[] objectArray = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (TextEditor element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof TextEditor)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TextEditor element$iv$iv;
            element$iv$iv = (TextEditor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getEditor());
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final Sequence<VirtualFile> getParentsWithSelf(@NotNull VirtualFile $this$parentsWithSelf) {
        Intrinsics.checkNotNullParameter((Object)$this$parentsWithSelf, (String)"<this>");
        return SequencesKt.generateSequence((Object)$this$parentsWithSelf, FilesKt::_get_parentsWithSelf_$lambda$6);
    }

    @NotNull
    public static final Path toAbsolutePath(@NotNull VirtualFile $this$toAbsolutePath) {
        Intrinsics.checkNotNullParameter((Object)$this$toAbsolutePath, (String)"<this>");
        Path path = new File($this$toAbsolutePath.getPath()).getAbsoluteFile().toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        return path;
    }

    @NlsSafe
    @RequiresBackgroundThread
    @NotNull
    public static final String toPresentablePathAsTabTitle(@NotNull BackedNotebookVirtualFile $this$toPresentablePathAsTabTitle, @NotNull Project project, @NotNull ContentManager contentManager) {
        Intrinsics.checkNotNullParameter((Object)$this$toPresentablePathAsTabTitle, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)contentManager, (String)"contentManager");
        ThreadingAssertions.assertBackgroundThread();
        VirtualFile originFile = $this$toPresentablePathAsTabTitle.getOriginFile();
        String simpleName = EditorTabPresentationUtil.getEditorTabTitle((Project)project, (VirtualFile)originFile);
        return contentManager.findContent(simpleName) != null ? EditorTabPresentationUtil.getUniqueEditorTabTitle((Project)project, (VirtualFile)originFile) : simpleName;
    }

    @Nullable
    public static final BackedNotebookVirtualFile toKotlinNotebookBackedFile(@Nullable VirtualFile $this$toKotlinNotebookBackedFile) {
        return $this$toKotlinNotebookBackedFile == null || !IsKotlinNotebookKt.isKotlinNotebook($this$toKotlinNotebookBackedFile) ? null : UtilKt.toBackedNotebookFile($this$toKotlinNotebookBackedFile);
    }

    @Nullable
    public static final Path getRelativePathFromProjectRoot(@NotNull VirtualFile $this$getRelativePathFromProjectRoot, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$getRelativePathFromProjectRoot, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        VirtualFile projectRoot = ProjectUtil.guessProjectDir((Project)project);
        if (projectRoot == null) {
            return VirtualFileUtil.toNioPathOrNull((VirtualFile)$this$getRelativePathFromProjectRoot);
        }
        String string = VfsUtilCore.getRelativePath((VirtualFile)$this$getRelativePathFromProjectRoot, (VirtualFile)projectRoot);
        return string != null ? NioPathUtil.toNioPathOrNull((String)string) : null;
    }

    private static final VirtualFile _get_parentsWithSelf_$lambda$6(VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getParent();
    }
}

