/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl.intention;

import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.api.LspServer;
import com.intellij.platform.lsp.api.customization.LspCodeActionsCustomizer;
import com.intellij.platform.lsp.api.customization.LspCodeActionsSupport;
import com.intellij.platform.lsp.api.customization.LspIntentionAction;
import com.intellij.platform.lsp.impl.LspServerImpl;
import com.intellij.platform.lsp.impl.LspServerManagerImpl;
import com.intellij.platform.lsp.impl.intention.LspIntentionActionServiceKt;
import com.intellij.platform.lsp.util.Lsp4jUtilKt;
import com.intellij.psi.PsiManager;
import com.intellij.util.ui.EDT;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionContext;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.CodeActionTriggerKind;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageServer;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u000f\u001a\u00020\u0010R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/platform/lsp/impl/intention/LspIntentionActionService;", "", "LspIntentionActionService", "()V", "lastIntentionActions", "", "Lcom/intellij/platform/lsp/api/customization/LspIntentionAction;", "lastPsiModificationCount", "", "lastFilePath", "", "lastOffset", "", "lastLength", "getIntentionActions", "editor", "Lcom/intellij/openapi/editor/Editor;", "Companion", "intellij.platform.lsp.impl"})
@SourceDebugExtension(value={"SMAP\nLspIntentionActionService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LspIntentionActionService.kt\ncom/intellij/platform/lsp/impl/intention/LspIntentionActionService\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n24#2:114\n19#3:115\n1#4:116\n1869#5,2:117\n1761#5,3:119\n*S KotlinDebug\n*F\n+ 1 LspIntentionActionService.kt\ncom/intellij/platform/lsp/impl/intention/LspIntentionActionService\n*L\n36#1:114\n66#1:115\n82#1:117,2\n70#1:119,3\n*E\n"})
public final class LspIntentionActionService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private List<? extends LspIntentionAction> lastIntentionActions = CollectionsKt.emptyList();
    private long lastPsiModificationCount = -1L;
    @NotNull
    private String lastFilePath = "";
    private int lastOffset = -1;
    private int lastLength = -1;

    @NotNull
    public final synchronized List<LspIntentionAction> getIntentionActions(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (editor instanceof EditorWindow) {
            LspIntentionActionService lspIntentionActionService = this;
            boolean bl = false;
            Logger logger = Logger.getInstance(LspIntentionActionService.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("EditorWindow not expected here");
            return CollectionsKt.emptyList();
        }
        Project project = editor.getProject();
        if (project == null) {
            return CollectionsKt.emptyList();
        }
        Project project2 = project;
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document2);
        if (virtualFile == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile virtualFile2 = virtualFile;
        long l2 = PsiManager.getInstance((Project)project2).getModificationTracker().getModificationCount();
        String string = virtualFile2.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String string2 = string;
        Caret caret = editor.getCaretModel().getPrimaryCaret();
        Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"getPrimaryCaret(...)");
        Caret caret2 = caret;
        int n2 = caret2.getSelectionStart();
        int n3 = caret2.getSelectionEnd() - n2;
        if (this.lastPsiModificationCount == l2 && Intrinsics.areEqual((Object)this.lastFilePath, (Object)string2) && this.lastOffset == n2 && this.lastLength == n3) {
            return this.lastIntentionActions;
        }
        if (EDT.isCurrentThreadEdt()) {
            return CollectionsKt.emptyList();
        }
        List list = new ArrayList();
        for (LspServerImpl lspServerImpl : LspServerManagerImpl.Companion.getInstanceImpl(project2).getServersWithThisFileOpen$intellij_platform_lsp_impl(virtualFile2)) {
            Object object;
            LspCodeActionsSupport lspCodeActionsSupport;
            ProgressManager.checkCanceled();
            Object object2 = lspServerImpl.getDescriptor().getLspCustomization().getCodeActionsCustomizer();
            boolean bl = false;
            LspCodeActionsCustomizer lspCodeActionsCustomizer = object2;
            if (!(lspCodeActionsCustomizer instanceof LspCodeActionsSupport)) {
                lspCodeActionsCustomizer = null;
            }
            if ((lspCodeActionsSupport = (LspCodeActionsSupport)lspCodeActionsCustomizer) == null) continue;
            Object object3 = object = lspCodeActionsSupport;
            boolean bl2 = false;
            object2 = ((LspCodeActionsSupport)object3).getIntentionActionsSupport() ? object : null;
            if (object2 == null) continue;
            LspCodeActionsCustomizer lspCodeActionsCustomizer2 = object2;
            boolean bl3 = lspServerImpl.supportsCodeActions$intellij_platform_lsp_impl((Function1<? super List<String>, Boolean>)((Function1)LspIntentionActionService::V));
            if (!bl3) continue;
            object3 = object = new CodeActionContext();
            Range range = Lsp4jUtilKt.getLsp4jRange(document2, n2, n3);
            TextDocumentIdentifier textDocumentIdentifier = lspServerImpl.getDocumentIdentifier(virtualFile2);
            bl2 = false;
            object3.setDiagnostics(CollectionsKt.emptyList());
            object3.setTriggerKind(CodeActionTriggerKind.Automatic);
            Unit unit = Unit.INSTANCE;
            LspCodeActionsSupport lspCodeActionsSupport2 = object;
            Range range2 = range;
            TextDocumentIdentifier textDocumentIdentifier2 = textDocumentIdentifier;
            object2 = new CodeActionParams(textDocumentIdentifier2, range2, (CodeActionContext)lspCodeActionsSupport2);
            Object object4 = object = (List)LspServer.sendRequestSync$default(lspServerImpl, 0, arg_0 -> LspIntentionActionService.V((CodeActionParams)object2, arg_0), 1, null);
            if (object4 == null) continue;
            object3 = (Iterable)object4;
            bl2 = false;
            Iterator iterator = object3.iterator();
            while (iterator.hasNext()) {
                LspIntentionAction lspIntentionAction;
                Object t2 = iterator.next();
                Either either = (Either)t2;
                boolean bl4 = false;
                Intrinsics.checkNotNull((Object)either);
                CodeAction codeAction = LspIntentionActionServiceKt.asCodeAction((Either<Command, CodeAction>)either);
                if (codeAction.getKind() != null) {
                    String string3 = codeAction.getKind();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getKind(...)");
                    if (StringsKt.startsWith$default((String)string3, (String)"quickfix", (boolean)false, (int)2, null)) continue;
                }
                if (((LspCodeActionsSupport)lspCodeActionsCustomizer2).createIntentionAction(lspServerImpl, codeAction) == null) continue;
                boolean bl5 = false;
                list.add(lspIntentionAction);
            }
        }
        List list2 = List.copyOf(list);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"copyOf(...)");
        this.lastIntentionActions = list2;
        this.lastPsiModificationCount = l2;
        this.lastFilePath = string2;
        this.lastOffset = n2;
        this.lastLength = n3;
        return this.lastIntentionActions;
    }

    private static final boolean V(List list) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)list, (String)"kinds");
            Iterable iterable = list;
            boolean bl2 = false;
            if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                bl = false;
            } else {
                for (Object t2 : iterable) {
                    String string = (String)t2;
                    boolean bl3 = false;
                    if (!(!StringsKt.startsWith$default((String)string, (String)"quickfix", (boolean)false, (int)2, null))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final CompletableFuture V(CodeActionParams codeActionParams, LanguageServer languageServer) {
        Intrinsics.checkNotNullParameter((Object)languageServer, (String)"it");
        CompletableFuture completableFuture = languageServer.getTextDocumentService().codeAction(codeActionParams);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"codeAction(...)");
        return completableFuture;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/platform/lsp/impl/intention/LspIntentionActionService$Companion;", "", "LspIntentionActionService$Companion", "()V", "getInstance", "Lcom/intellij/platform/lsp/impl/intention/LspIntentionActionService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.lsp.impl"})
    @SourceDebugExtension(value={"SMAP\nLspIntentionActionService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LspIntentionActionService.kt\ncom/intellij/platform/lsp/impl/intention/LspIntentionActionService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,113:1\n30#2,2:114\n*S KotlinDebug\n*F\n+ 1 LspIntentionActionService.kt\ncom/intellij/platform/lsp/impl/intention/LspIntentionActionService$Companion\n*L\n24#1:114,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LspIntentionActionService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager componentManager = (ComponentManager)project;
            boolean bl = false;
            Class<LspIntentionActionService> clazz = LspIntentionActionService.class;
            Object object = componentManager.getService(clazz);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)componentManager, clazz);
            }
            return (LspIntentionActionService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

