/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.NlsActions;
import com.intellij.ui.AnimatedIcon;
import icons.QodanaIcons;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.QodanaBundle;
import org.jetbrains.qodana.cloud.QodanaCloudStateService;
import org.jetbrains.qodana.cloud.UserState;
import org.jetbrains.qodana.ui.settings.QodanaCloudSettingsPanel;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0003J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/qodana/actions/ProblemsViewCloudLoginAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionName", "", "userState", "Lorg/jetbrains/qodana/cloud/UserState;", "getActionIcon", "Ljavax/swing/Icon;", "actionPerformed", "intellij.qodana"})
final class ProblemsViewCloudLoginAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        UserState userState = (UserState)QodanaCloudStateService.Companion.getInstance().getUserState().getValue();
        e.getPresentation().setText(this.getActionName(userState));
        e.getPresentation().setIcon(this.getActionIcon(userState));
    }

    @NlsActions.ActionText
    private final String getActionName(UserState userState) {
        String string;
        UserState userState2 = userState;
        if (userState2 instanceof UserState.Authorized) {
            String string2 = QodanaBundle.message("problems.toolwindow.login.action.authorized", new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        } else if (userState2 instanceof UserState.Authorizing) {
            String string3 = QodanaBundle.message("problems.toolwindow.login.action.authorizing", new Object[0]);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        } else if (userState2 instanceof UserState.NotAuthorized) {
            String string4 = QodanaBundle.message("qodana.panel.action.log.in", new Object[0]);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private final Icon getActionIcon(UserState userState) {
        Icon icon;
        UserState userState2 = userState;
        if (userState2 instanceof UserState.Authorized) {
            Icon icon2 = QodanaIcons.Icons.LoggedUser;
            icon = icon2;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"LoggedUser");
        } else if (userState2 instanceof UserState.Authorizing) {
            AnimatedIcon animatedIcon = AnimatedIcon.Default.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)animatedIcon, (String)"INSTANCE");
            icon = (Icon)animatedIcon;
        } else if (userState2 instanceof UserState.NotAuthorized) {
            Icon icon3 = QodanaIcons.Icons.NotLoggedUser;
            icon = icon3;
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"NotLoggedUser");
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return icon;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        QodanaCloudSettingsPanel.Companion.openSettings(e.getProject());
    }
}

