/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.reactivestreams.inspections;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.reactivestreams.ReactiveStreamsBundle;
import com.intellij.reactivestreams.implementations.ReactiveStreamsNonBlockingAnalysisManager;
import com.intellij.reactivestreams.implementations.info.DefaultBlockingContextProvider;
import com.intellij.reactivestreams.implementations.info.SchedulingMethodCallInfo;
import com.intellij.reactivestreams.implementations.info.SchedulingType;
import com.intellij.reactivestreams.inspections.NonBlockingAnalysisCache;
import com.intellij.reactivestreams.inspections.ReactiveStreamsBlockingScopeCheckResult;
import com.intellij.reactivestreams.inspections.ReactiveStreamsNonBlockingSchedulerCheckerKt;
import com.intellij.reactivestreams.inspections.Scope;
import com.intellij.reactivestreams.settings.ReactiveStreamsSettings;
import com.intellij.reactivestreams.uast.ex.FunctionalObjectsUtil;
import com.intellij.reactivestreams.uast.ex.UCallExpressionContext;
import com.intellij.reactivestreams.uast.ex.UFunctionalObject;
import com.intellij.reactivestreams.util.ReactiveStreamsUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.analysis.Dependency;
import org.jetbrains.uast.analysis.Dependent;
import org.jetbrains.uast.analysis.UastLocalUsageDependencyGraph;
import org.jetbrains.uast.generate.UastCodeGenerationPlugin;
import org.jetbrains.uast.generate.UastCodeGenerationPluginKt;
import org.jetbrains.uast.generate.UastElementFactory;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0007\u0018\u0000 \"2\u00020\u0001:\u0005 !\"#$B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000bH\u0002J\u001c\u0010\u0013\u001a\u00020\u0014*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J,\u0010\u001a\u001a\u00020\u001b*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0002J0\u0010\u001d\u001a\u00020\u0014*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u000b2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u0014H\u0002J\u001a\u0010\u001f\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u00020\u00078AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/reactivestreams/inspections/ReactiveStreamsNonBlockingSchedulerChecker;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "analysisManager", "Lcom/intellij/reactivestreams/implementations/ReactiveStreamsNonBlockingAnalysisManager;", "getAnalysisManager", "()Lcom/intellij/reactivestreams/implementations/ReactiveStreamsNonBlockingAnalysisManager;", "maxRecursionDepth", "", "isCalledInNonBlockingScope", "Lcom/intellij/reactivestreams/inspections/ReactiveStreamsBlockingScopeCheckResult;", "callExpression", "Lorg/jetbrains/uast/UCallExpression;", "checkDepth", "", "depth", "calculateScope", "Lcom/intellij/reactivestreams/inspections/Scope;", "Lcom/intellij/reactivestreams/inspections/NonBlockingAnalysisCache;", "dependencyGraph", "Lorg/jetbrains/uast/analysis/UastLocalUsageDependencyGraph;", "element", "Lorg/jetbrains/uast/UElement;", "getScopeByDependants", "Lcom/intellij/reactivestreams/inspections/ReactiveStreamsNonBlockingSchedulerChecker$ScopeWithDepth;", "lastScope", "getScopeByDependencies", "subscribeOnScope", "getScopeByNextOperatorIfItSchedulingOnNextOperators", "TooDeepRecursionException", "ScopeWithDepth", "Companion", "FindCauseBecauseSchedulingFix", "AddPublishOnBlockingSchedulerFix", "intellij.reactivestreams"})
@SourceDebugExtension(value={"SMAP\nReactiveStreamsNonBlockingSchedulerChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReactiveStreamsNonBlockingSchedulerChecker.kt\ncom/intellij/reactivestreams/inspections/ReactiveStreamsNonBlockingSchedulerChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ReactiveStreamsNonBlockingSchedulerChecker.kt\ncom/intellij/reactivestreams/inspections/ReactiveStreamsNonBlockingSchedulerCheckerKt\n*L\n1#1,468:1\n774#2:469\n865#2,2:470\n1563#2:472\n1634#2,2:473\n1636#2:476\n1740#2,3:478\n1999#2,14:481\n1617#2,9:497\n1869#2:506\n1563#2:507\n1634#2,3:508\n1870#2:512\n1626#2:513\n1563#2:514\n1634#2,3:515\n1#3:475\n1#3:496\n1#3:511\n435#4:477\n440#4:495\n*S KotlinDebug\n*F\n+ 1 ReactiveStreamsNonBlockingSchedulerChecker.kt\ncom/intellij/reactivestreams/inspections/ReactiveStreamsNonBlockingSchedulerChecker\n*L\n139#1:469\n139#1:470,2\n140#1:472\n140#1:473,2\n140#1:476\n162#1:478,3\n162#1:481,14\n191#1:497,9\n191#1:506\n195#1:507\n195#1:508,3\n191#1:512\n191#1:513\n275#1:514\n275#1:515,3\n163#1:496\n191#1:511\n162#1:477\n163#1:495\n*E\n"})
public final class ReactiveStreamsNonBlockingSchedulerChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ReactiveStreamsNonBlockingAnalysisManager analysisManager;
    private final int maxRecursionDepth;

    public ReactiveStreamsNonBlockingSchedulerChecker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.analysisManager = ReactiveStreamsNonBlockingAnalysisManager.Companion.getInstance(this.project);
        this.maxRecursionDepth = Registry.Companion.intValue("reactor.non.blocking.scheduler.checker.max.recursion.limit", 300);
    }

    @JvmName(name="getAnalysisManager")
    @NotNull
    public final ReactiveStreamsNonBlockingAnalysisManager getAnalysisManager() {
        return this.analysisManager;
    }

    @NotNull
    public final ReactiveStreamsBlockingScopeCheckResult isCalledInNonBlockingScope(@NotNull UCallExpression callExpression) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)callExpression, (String)"callExpression");
        if (!ReactiveStreamsSettings.Companion.getInstance(this.project).isAdvancedNonBlockingAnalysisEnabled()) {
            return ReactiveStreamsBlockingScopeCheckResult.Unknown.INSTANCE;
        }
        UFunctionalObject uFunctionalObject = UFunctionalObject.Companion.fromSuitableParent((UElement)callExpression, ReactiveStreamsNonBlockingSchedulerChecker::isCalledInNonBlockingScope$lambda$0);
        if (uFunctionalObject == null) {
            return ReactiveStreamsBlockingScopeCheckResult.Unknown.INSTANCE;
        }
        UFunctionalObject functionalObject = uFunctionalObject;
        if (!functionalObject.checkExpressionIsInsideFunction((UExpression)callExpression)) {
            return ReactiveStreamsBlockingScopeCheckResult.Unknown.INSTANCE;
        }
        UMethod uMethod = UastUtils.getContainingUMethod((UElement)functionalObject);
        if (uMethod == null) {
            return ReactiveStreamsBlockingScopeCheckResult.Unknown.INSTANCE;
        }
        UMethod method = uMethod;
        UastLocalUsageDependencyGraph uastLocalUsageDependencyGraph = UastLocalUsageDependencyGraph.Companion.getGraphByUElement((UElement)method);
        if (uastLocalUsageDependencyGraph == null) {
            return ReactiveStreamsBlockingScopeCheckResult.Unknown.INSTANCE;
        }
        UastLocalUsageDependencyGraph dependencyGraph = uastLocalUsageDependencyGraph;
        NonBlockingAnalysisCache nonBlockingAnalysisCache = NonBlockingAnalysisCache.Companion.getCache(method);
        if (nonBlockingAnalysisCache == null) {
            return ReactiveStreamsBlockingScopeCheckResult.Unknown.INSTANCE;
        }
        NonBlockingAnalysisCache analysisCache = nonBlockingAnalysisCache;
        DefaultBlockingContextProvider blockingContextProvider = this.analysisManager.getDefaultBlockingContextProvider(functionalObject.getContext().getCallExpression());
        try {
            ReactiveStreamsBlockingScopeCheckResult reactiveStreamsBlockingScopeCheckResult;
            object = this.calculateScope(analysisCache, dependencyGraph, (UElement)functionalObject.getContext().getCallExpression());
            if (object instanceof Scope.NonBlocking) {
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{FindCauseBecauseSchedulingFix.INSTANCE};
                reactiveStreamsBlockingScopeCheckResult = new ReactiveStreamsBlockingScopeCheckResult.NonBlocking(AddPublishOnBlockingSchedulerFix.Companion.getAllAvailableFixes(blockingContextProvider, (UElement)callExpression, localQuickFixArray));
            } else {
                reactiveStreamsBlockingScopeCheckResult = Intrinsics.areEqual((Object)object, (Object)Scope.Unknown.INSTANCE) ? (ReactiveStreamsBlockingScopeCheckResult)new ReactiveStreamsBlockingScopeCheckResult.NonBlocking(AddPublishOnBlockingSchedulerFix.Companion.getAllAvailableFixes$default(AddPublishOnBlockingSchedulerFix.Companion, blockingContextProvider, (UElement)callExpression, null, 4, null)) : (ReactiveStreamsBlockingScopeCheckResult)ReactiveStreamsBlockingScopeCheckResult.Unknown.INSTANCE;
            }
            object = reactiveStreamsBlockingScopeCheckResult;
        }
        catch (TooDeepRecursionException e) {
            object = ReactiveStreamsBlockingScopeCheckResult.Unknown.INSTANCE;
        }
        return object;
    }

    private final void checkDepth(int depth) {
        if (depth > this.maxRecursionDepth) {
            ReactiveStreamsNonBlockingSchedulerCheckerKt.access$getLOG$p().info("too deep recursion: " + depth + ", max is " + this.maxRecursionDepth);
            throw TooDeepRecursionException.INSTANCE;
        }
    }

    private final Scope calculateScope(NonBlockingAnalysisCache $this$calculateScope, UastLocalUsageDependencyGraph dependencyGraph, UElement element) {
        Scope scopeAfter;
        Scope scopeBefore = ReactiveStreamsNonBlockingSchedulerChecker.getScopeByDependencies$default(this, $this$calculateScope, dependencyGraph, element, 0, null, 8, null);
        if (scopeBefore instanceof Scope.NonBlocking || scopeBefore instanceof Scope.DeclaredPossiblyBlocking) {
            return scopeBefore;
        }
        if (element instanceof UCallExpression) {
            Scope scope;
            PsiElement psiElement = element.getSourcePsi();
            Intrinsics.checkNotNull((Object)psiElement);
            Project project = psiElement.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            if (Intrinsics.areEqual((Object)ReactiveStreamsNonBlockingAnalysisManager.Companion.getInstance(project).succeedingOperatorIfSchedulingOnNextAffectsContextFor((UCallExpression)element), (Object)true) && (scope = this.getScopeByNextOperatorIfItSchedulingOnNextOperators(dependencyGraph, (UCallExpression)element)) != null) {
                return scope;
            }
        }
        if (Intrinsics.areEqual((Object)(scopeAfter = this.getScopeByDependants($this$calculateScope, dependencyGraph, element, 0, new ScopeWithDepth(Scope.Unknown.INSTANCE, -1)).component1()), (Object)Scope.DeclaredPossiblyBlocking.INSTANCE) || scopeAfter instanceof Scope.NonBlocking) {
            return scopeAfter;
        }
        return scopeBefore;
    }

    /*
     * Unable to fully structure code
     */
    private final ScopeWithDepth getScopeByDependants(NonBlockingAnalysisCache $this$getScopeByDependants, UastLocalUsageDependencyGraph dependencyGraph, UElement element, int depth, ScopeWithDepth lastScope) {
        block29: {
            ProgressManager.checkCanceled();
            this.checkDepth(depth);
            cachedResult = $this$getScopeByDependants.getDownCache(element);
            if (cachedResult != null) {
                return new ScopeWithDepth(cachedResult, depth);
            }
            var8_7 = (Set)dependencyGraph.getDependents().get(element);
            if (var8_7 != null) {
                var10_8 = var8_7;
                $i$f$filter = false;
                var12_14 = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (Dependent)element$iv$iv;
                    $i$a$-filter-ReactiveStreamsNonBlockingSchedulerChecker$getScopeByDependants$dependantsResult$1 = false;
                    if (!(it instanceof Dependent.CallExpression == false && it instanceof Dependent.BinaryOperatorDependent == false)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    it = (Dependent)item$iv$iv;
                    var24_42 = destination$iv$iv;
                    $i$a$-map-ReactiveStreamsNonBlockingSchedulerChecker$getScopeByDependants$dependantsResult$2 = false;
                    callExpression = ReactiveStreamsUtils.getCallExpressionSelectorOrThis(dependent.getElement());
                    v0 = callExpression;
                    v1 = v0 != null ? ReactiveStreamsNonBlockingSchedulerCheckerKt.access$isSchedulingOnNonBlockingScope(v0, SchedulingType.ALL_CHAIN) : false;
                    if (v1) {
                        scope = Intrinsics.areEqual((Object)lastScope.getScope(), (Object)Scope.Unknown.INSTANCE) == false ? lastScope : new ScopeWithDepth(new Scope.NonBlocking(callExpression, SchedulingType.ALL_CHAIN), depth);
                        v2 = this.getScopeByDependants($this$getScopeByDependants, dependencyGraph, dependent.getElement(), depth + 1, scope);
                    } else {
                        if (callExpression != null) {
                            $i$a$-let-ReactiveStreamsNonBlockingSchedulerChecker$getScopeByDependants$dependantsResult$2$calculatedRes$1 = false;
                            v3 = this.analysisManager.getSchedulingMethodInfo(it, SchedulingType.ALL_CHAIN);
                        } else {
                            v3 = null;
                        }
                        if (v3 != null) {
                            var22_40 = lastScope.getScope();
                            v4 = var22_40 instanceof Scope.NonBlocking != false ? (Scope.NonBlocking)var22_40 : null;
                            scopeBeforeIsOnNonBlockingSubscriber = (v4 != null ? v4.getType() : null) == SchedulingType.ALL_CHAIN;
                            scope = scopeBeforeIsOnNonBlockingSubscriber != false ? lastScope : new ScopeWithDepth(Scope.DeclaredPossiblyBlocking.INSTANCE, depth);
                            v2 = this.getScopeByDependants($this$getScopeByDependants, dependencyGraph, dependent.getElement(), depth + 1, scope);
                        } else {
                            v2 = this.getScopeByDependants($this$getScopeByDependants, dependencyGraph, dependent.getElement(), depth + 1, lastScope);
                        }
                    }
                    calculatedRes = v2;
                    var24_42.add(calculatedRes);
                }
                v5 = (List)destination$iv$iv;
            } else {
                v5 = null;
            }
            $this$allDeclaredPossiblyBlocking$iv = dependantsResult = v5;
            $i$f$allDeclaredPossiblyBlocking = false;
            v6 = $this$allDeclaredPossiblyBlocking$iv;
            v7 = v6 != null ? ((Collection)v6).isEmpty() == false : false;
            if (!v7) ** GOTO lbl-1000
            $this$all$iv$iv = $this$allDeclaredPossiblyBlocking$iv;
            $i$f$all = false;
            if ($this$all$iv$iv instanceof Collection && ((Collection)$this$all$iv$iv).isEmpty()) {
                v8 = true;
            } else {
                destination$iv$iv = $this$all$iv$iv.iterator();
                while (destination$iv$iv.hasNext()) {
                    it$iv = element$iv$iv = destination$iv$iv.next();
                    $i$a$-all-ReactiveStreamsNonBlockingSchedulerCheckerKt$allDeclaredPossiblyBlocking$1$iv = false;
                    p0 = (ScopeWithDepth)it$iv;
                    $i$a$-allDeclaredPossiblyBlocking-ReactiveStreamsNonBlockingSchedulerChecker$getScopeByDependants$resultFromDependents$1 = false;
                    if (p0.getScope() instanceof Scope.DeclaredPossiblyBlocking) continue;
                    v8 = false;
                    break block29;
                }
                v8 = true;
            }
        }
        if (v8) {
            v9 = true;
        } else lbl-1000:
        // 2 sources

        {
            v9 = false;
        }
        if (v9) {
            v10 = dependantsResult;
            Intrinsics.checkNotNull(v10);
            $this$maxByOrNull$iv = v10;
            $i$f$maxByOrNull = false;
            iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v11 = null;
            } else {
                maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v11 = maxElem$iv;
                } else {
                    it = (ScopeWithDepth)maxElem$iv;
                    $i$a$-maxByOrNull-ReactiveStreamsNonBlockingSchedulerChecker$getScopeByDependants$resultFromDependents$2 = false;
                    maxValue$iv = it.getDepth();
                    do {
                        e$iv = iterator$iv.next();
                        it = (ScopeWithDepth)e$iv;
                        $i$a$-maxByOrNull-ReactiveStreamsNonBlockingSchedulerChecker$getScopeByDependants$resultFromDependents$2 = false;
                        v$iv = it.getDepth();
                        if (maxValue$iv >= v$iv) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v11 = maxElem$iv;
                }
            }
            v12 = v11;
        } else {
            block30: {
                $this$findNonBlocking$iv = dependantsResult;
                $i$f$findNonBlocking = false;
                v13 = $this$findNonBlocking$iv;
                if (v13 != null) {
                    var11_13 = v13;
                    var12_17 = var11_13.iterator();
                    while (var12_17.hasNext()) {
                        it$iv = var13_18 = var12_17.next();
                        $i$a$-find-ReactiveStreamsNonBlockingSchedulerCheckerKt$findNonBlocking$1$iv = false;
                        p0 = (ScopeWithDepth)it$iv;
                        $i$a$-findNonBlocking-ReactiveStreamsNonBlockingSchedulerChecker$getScopeByDependants$resultFromDependents$3 = false;
                        if (!(p0.getScope() instanceof Scope.NonBlocking)) continue;
                        v14 = var13_18;
                        break block30;
                    }
                    v14 = null;
                } else {
                    v14 = null;
                }
            }
            v12 = v14;
        }
        if ((v15 = (resultFromDependents = v12)) == null) {
            v15 = lastScope;
        }
        if ((result = v15).getDepth() > depth) {
            $this$getScopeByDependants.putDownCache(element, result.getScope());
        } else {
            $this$getScopeByDependants.putDownCache(element, Scope.Unknown.INSTANCE);
        }
        return result;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final Scope getScopeByDependencies(NonBlockingAnalysisCache $this$getScopeByDependencies, UastLocalUsageDependencyGraph dependencyGraph, UElement element, int depth, Scope subscribeOnScope) {
        block28: {
            block23: {
                ProgressManager.checkCanceled();
                this.checkDepth(depth);
                currentScopeInfo = $this$getScopeByDependencies.getUpCache(element);
                if (currentScopeInfo != null) {
                    return currentScopeInfo;
                }
                var8_7 = element.getSourcePsi();
                if (var8_7 != null && (var9_8 /* !! */  = var8_7.getProject()) != null) {
                    it = var9_8 /* !! */ ;
                    $i$a$-let-ReactiveStreamsNonBlockingSchedulerChecker$getScopeByDependencies$nonBlockingAnalysisManager$1 = false;
                    v0 = ReactiveStreamsNonBlockingAnalysisManager.Companion.getInstance(it);
                } else {
                    v0 = null;
                }
                nonBlockingAnalysisManager = v0;
                var9_8 /* !! */  = (Set)dependencyGraph.getDependencies().get(element);
                if (var9_8 /* !! */  == null) break block23;
                var10_14 = (Iterable)var9_8 /* !! */ ;
                $i$f$mapNotNull = false;
                $i$a$-let-ReactiveStreamsNonBlockingSchedulerChecker$getScopeByDependencies$nonBlockingAnalysisManager$1 = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$mapNotNullTo = false;
                $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                $i$f$forEach = false;
                var17_19 = $this$forEach$iv$iv$iv.iterator();
                while (var17_19.hasNext()) {
                    block25: {
                        block27: {
                            block26: {
                                block24: {
                                    element$iv$iv = element$iv$iv$iv = var17_19.next();
                                    $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                                    dependency = (Dependency)element$iv$iv;
                                    $i$a$-mapNotNull-ReactiveStreamsNonBlockingSchedulerChecker$getScopeByDependencies$scopes$1 = false;
                                    var23_25 = dependency;
                                    if (!(var23_25 instanceof Dependency.BranchingDependency)) break block24;
                                    var24_26 = ((Dependency.BranchingDependency)dependency).getElements();
                                    $i$f$map = false;
                                    var26_31 = $this$map$iv;
                                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                    $i$f$mapTo = false;
                                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                                        var31_40 = (UElement)item$iv$iv;
                                        var32_41 = destination$iv$iv;
                                        $i$a$-map-ReactiveStreamsNonBlockingSchedulerChecker$getScopeByDependencies$scopes$1$result$branchesScopes$1 = false;
                                        var32_41.add(this.getScopeByDependencies($this$getScopeByDependencies, dependencyGraph, (UElement)it, depth + 1, subscribeOnScope));
                                    }
                                    branchesScopes = (List)destination$iv$iv;
                                    branchesResult = ReactiveStreamsNonBlockingSchedulerCheckerKt.access$allDeclaredPossiblyBlocking(branchesScopes) != false ? (Scope)Scope.DeclaredPossiblyBlocking.INSTANCE : ReactiveStreamsNonBlockingSchedulerCheckerKt.access$findNonBlocking(branchesScopes);
                                    v1 = branchesResult;
                                    if (v1 == null) {
                                        v1 = Scope.Unknown.INSTANCE;
                                    }
                                    break block25;
                                }
                                if (!(var23_25 instanceof Dependency.CommonDependency)) break block26;
                                callExpression = ReactiveStreamsUtils.getCallExpressionSelectorOrThis(((Dependency.CommonDependency)dependency).getElement());
                                v2 = callExpression;
                                v3 = v2 != null ? ReactiveStreamsNonBlockingSchedulerCheckerKt.access$isSchedulingOnNonBlockingScope(v2, SchedulingType.NEXT_OPERATORS) : false;
                                if (v3) {
                                    v1 = new Scope.NonBlocking(callExpression, SchedulingType.NEXT_OPERATORS);
                                } else {
                                    v4 = callExpression;
                                    v5 = v4 != null ? ReactiveStreamsNonBlockingSchedulerCheckerKt.access$isSchedulingOnNonBlockingScope(v4, SchedulingType.ALL_CHAIN) : false;
                                    if (v5) {
                                        v1 = this.getScopeByDependencies($this$getScopeByDependencies, dependencyGraph, ((Dependency.CommonDependency)dependency).getElement(), depth + 1, new Scope.NonBlocking(callExpression, SchedulingType.ALL_CHAIN));
                                    } else {
                                        if (callExpression != null) {
                                            $i$a$-let-ReactiveStreamsNonBlockingSchedulerChecker$getScopeByDependencies$scopes$1$result$1 = false;
                                            v6 = nonBlockingAnalysisManager;
                                            v7 = v6 != null ? v6.getSchedulingMethodInfo(it, SchedulingType.ALL_CHAIN) : null;
                                        } else {
                                            v7 = null;
                                        }
                                        if (v7 != null) {
                                            v8 = nonBlockingAnalysisManager;
                                            info = v8 != null ? v8.getSchedulingMethodInfo(callExpression, SchedulingType.ALL_CHAIN) : null;
                                            v9 = info;
                                            v1 = this.getScopeByDependencies($this$getScopeByDependencies, dependencyGraph, ((Dependency.CommonDependency)dependency).getElement(), depth + 1, (v9 != null ? !v9.isNonBlocking() : false) != false ? (Scope)Scope.DeclaredPossiblyBlocking.INSTANCE : (Scope)Scope.Unknown.INSTANCE);
                                        } else {
                                            if (callExpression != null) {
                                                $i$a$-let-ReactiveStreamsNonBlockingSchedulerChecker$getScopeByDependencies$scopes$1$result$2 = false;
                                                v10 = nonBlockingAnalysisManager;
                                                v11 = v10 != null ? v10.getSchedulingMethodInfo(it, SchedulingType.NEXT_OPERATORS) : null;
                                            } else {
                                                v11 = null;
                                            }
                                            v1 = v11 == null ? this.getScopeByDependencies($this$getScopeByDependencies, dependencyGraph, ((Dependency.CommonDependency)dependency).getElement(), depth + 1, subscribeOnScope) : (Scope)Scope.DeclaredPossiblyBlocking.INSTANCE;
                                        }
                                    }
                                }
                                break block25;
                            }
                            if (!(var23_25 instanceof Dependency.ArgumentDependency)) break block27;
                            var34_43 = ((Dependency.ArgumentDependency)dependency).getElement().getSourcePsi();
                            if (var34_43 == null || (var24_26 = var34_43.getProject()) == null) ** GOTO lbl-1000
                            it = var24_26;
                            $i$a$-let-ReactiveStreamsNonBlockingSchedulerChecker$getScopeByDependencies$scopes$1$result$3 = false;
                            var25_30 = ReactiveStreamsNonBlockingAnalysisManager.Companion.getInstance((Project)it);
                            if (var25_30 != null && (var26_31 = var25_30.getAnalysableArgument((Dependency.ArgumentDependency)dependency)) != null) {
                                it = var26_31;
                                $i$a$-let-ReactiveStreamsNonBlockingSchedulerChecker$getScopeByDependencies$scopes$1$result$4 = false;
                                v1 = this.getScopeByDependencies($this$getScopeByDependencies, dependencyGraph, it, depth + 1, subscribeOnScope);
                            } else lbl-1000:
                            // 2 sources

                            {
                                v1 = null;
                            }
                            break block25;
                        }
                        if (var23_25 instanceof Dependency.ConnectionDependency) {
                            v1 = null;
                        } else if (var23_25 instanceof Dependency.PotentialSideEffectDependency) {
                            v1 = null;
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    if ((result = v1) == null) continue;
                    $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                v12 = (List)destination$iv$iv;
                break block28;
            }
            v12 = scopes = null;
        }
        if ((v13 = (resultFromDependencies = ReactiveStreamsNonBlockingSchedulerCheckerKt.access$allDeclaredPossiblyBlocking(scopes) != false ? (Scope)Scope.DeclaredPossiblyBlocking.INSTANCE : ReactiveStreamsNonBlockingSchedulerCheckerKt.access$findNonBlocking(scopes))) == null && (v13 = subscribeOnScope) == null) {
            v13 = Scope.Unknown.INSTANCE;
        }
        calculatedResult = v13;
        $this$getScopeByDependencies.putUpCache(element, calculatedResult);
        return calculatedResult;
    }

    static /* synthetic */ Scope getScopeByDependencies$default(ReactiveStreamsNonBlockingSchedulerChecker reactiveStreamsNonBlockingSchedulerChecker, NonBlockingAnalysisCache nonBlockingAnalysisCache, UastLocalUsageDependencyGraph uastLocalUsageDependencyGraph, UElement uElement, int n, Scope scope, int n2, Object object) {
        if ((n2 & 8) != 0) {
            scope = null;
        }
        return reactiveStreamsNonBlockingSchedulerChecker.getScopeByDependencies(nonBlockingAnalysisCache, uastLocalUsageDependencyGraph, uElement, n, scope);
    }

    /*
     * WARNING - void declaration
     */
    private final Scope getScopeByNextOperatorIfItSchedulingOnNextOperators(UastLocalUsageDependencyGraph dependencyGraph, UCallExpression element) {
        void $this$mapTo$iv$iv;
        Object elementToCheck;
        ArrayDeque arrayDeque2;
        ReactiveStreamsNonBlockingAnalysisManager reactiveStreamsNonBlockingAnalysisManager;
        Object object;
        ProgressManager.checkCanceled();
        PsiElement psiElement = element.getSourcePsi();
        if (psiElement != null && (object = psiElement.getProject()) != null) {
            Project it = object;
            boolean arrayDeque2 = false;
            reactiveStreamsNonBlockingAnalysisManager = ReactiveStreamsNonBlockingAnalysisManager.Companion.getInstance(it);
        } else {
            reactiveStreamsNonBlockingAnalysisManager = null;
        }
        ReactiveStreamsNonBlockingAnalysisManager nonBlockingAnalysisManager = reactiveStreamsNonBlockingAnalysisManager;
        Object methodCallsBranches = object = (List)new ArrayList();
        boolean bl = false;
        ArrayDeque $this$getScopeByNextOperatorIfItSchedulingOnNextOperators_u24lambda_u2415_u24lambda_u2414 = arrayDeque2 = new ArrayDeque();
        boolean bl2 = false;
        Set set = (Set)dependencyGraph.getDependents().get(element);
        if (set == null) {
            set = SetsKt.emptySet();
        }
        $this$getScopeByNextOperatorIfItSchedulingOnNextOperators_u24lambda_u2415_u24lambda_u2414.addAll((Collection)set);
        ArrayDeque elementsQueue = arrayDeque2;
        while (!((Collection)elementsQueue).isEmpty()) {
            elementToCheck = (Dependent)elementsQueue.removeFirst();
            if (!(elementToCheck instanceof Dependent.CommonDependent)) continue;
            UElement uElement = ((Dependent.CommonDependent)elementToCheck).getElement();
            if (uElement instanceof UCallExpression) {
                ((Collection)methodCallsBranches).add(uElement);
                continue;
            }
            if (uElement instanceof UParenthesizedExpression || uElement instanceof UQualifiedReferenceExpression) {
                Collection collection = (Collection)elementsQueue;
                Set set2 = (Set)dependencyGraph.getDependents().get(uElement);
                if (set2 == null) {
                    set2 = SetsKt.emptySet();
                }
                CollectionsKt.addAll((Collection)collection, (Iterable)set2);
                continue;
            }
            ((Collection)methodCallsBranches).add(null);
        }
        Object methodCallsBranches2 = object;
        Iterable $this$map$iv = (Iterable)methodCallsBranches2;
        boolean $i$f$map = false;
        elementToCheck = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object object2;
            void call;
            UCallExpression uCallExpression = (UCallExpression)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(call != null ? (ReactiveStreamsNonBlockingSchedulerCheckerKt.access$isSchedulingOnNonBlockingScope((UCallExpression)call, SchedulingType.NEXT_OPERATORS) ? (Scope)new Scope.NonBlocking((UCallExpression)call, SchedulingType.NEXT_OPERATORS) : (((object2 = nonBlockingAnalysisManager) != null && (object2 = ((ReactiveStreamsNonBlockingAnalysisManager)object2).getSchedulingMethodInfo((UCallExpression)call, SchedulingType.NEXT_OPERATORS)) != null ? !((SchedulingMethodCallInfo)object2).isNonBlocking() : false) ? (Scope)Scope.DeclaredPossiblyBlocking.INSTANCE : null)) : null);
        }
        List scopes = (List)destination$iv$iv;
        return ReactiveStreamsNonBlockingSchedulerCheckerKt.access$allDeclaredPossiblyBlocking(scopes) ? (Scope)Scope.DeclaredPossiblyBlocking.INSTANCE : ReactiveStreamsNonBlockingSchedulerCheckerKt.access$findNonBlocking(scopes);
    }

    private static final UCallExpressionContext isCalledInNonBlockingScope$lambda$0(UElement uElement) {
        UCallExpression operatorCall;
        block6: {
            block5: {
                block4: {
                    Intrinsics.checkNotNullParameter((Object)uElement, (String)"uElement");
                    UElement uElement2 = uElement.getUastParent();
                    UCallExpression uCallExpression = uElement2 instanceof UCallExpression ? (UCallExpression)uElement2 : null;
                    if (uCallExpression == null) {
                        return null;
                    }
                    operatorCall = uCallExpression;
                    PsiMethod operatorMethod = operatorCall.resolve();
                    if (ReactiveStreamsUtils.isMethodDefinedInKnownPublisher(operatorMethod)) break block4;
                    PsiMethod psiMethod = operatorMethod;
                    if (!ReactiveStreamsUtils.isBuilderClassToCheck((PsiClass)(psiMethod != null ? psiMethod.getContainingClass() : null))) break block5;
                }
                if (ReactiveStreamsUtils.isPublisher(operatorCall.getReturnType())) break block6;
            }
            return null;
        }
        return FunctionalObjectsUtil.asContext(operatorCall);
    }

    @JvmStatic
    @NotNull
    public static final ReactiveStreamsNonBlockingSchedulerChecker getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/reactivestreams/inspections/ReactiveStreamsNonBlockingSchedulerChecker$AddPublishOnBlockingSchedulerFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "blockingContextProvider", "Lcom/intellij/reactivestreams/implementations/info/DefaultBlockingContextProvider;", "<init>", "(Lcom/intellij/reactivestreams/implementations/info/DefaultBlockingContextProvider;)V", "availableInBatchMode", "", "getName", "", "getFamilyName", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "Companion", "intellij.reactivestreams"})
    @SourceDebugExtension(value={"SMAP\nReactiveStreamsNonBlockingSchedulerChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReactiveStreamsNonBlockingSchedulerChecker.kt\ncom/intellij/reactivestreams/inspections/ReactiveStreamsNonBlockingSchedulerChecker$AddPublishOnBlockingSchedulerFix\n+ 2 UastCodeGenerationPlugin.kt\norg/jetbrains/uast/generate/UastCodeGenerationPluginKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,468:1\n229#2,6:469\n236#2:476\n14#3:475\n*S KotlinDebug\n*F\n+ 1 ReactiveStreamsNonBlockingSchedulerChecker.kt\ncom/intellij/reactivestreams/inspections/ReactiveStreamsNonBlockingSchedulerChecker$AddPublishOnBlockingSchedulerFix\n*L\n385#1:469,6\n385#1:476\n385#1:475\n*E\n"})
    public static final class AddPublishOnBlockingSchedulerFix
    implements LocalQuickFix {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final DefaultBlockingContextProvider blockingContextProvider;

        private AddPublishOnBlockingSchedulerFix(DefaultBlockingContextProvider blockingContextProvider) {
            this.blockingContextProvider = blockingContextProvider;
        }

        public boolean availableInBatchMode() {
            return false;
        }

        @NotNull
        public String getName() {
            return this.getFamilyName();
        }

        @NotNull
        public String getFamilyName() {
            Object[] objectArray = new Object[]{this.blockingContextProvider.getOperatorToChangeContextName(), this.blockingContextProvider.getBlockingContextFactoryMethodName()};
            return ReactiveStreamsBundle.message("inspections.blocking.in.non.blocking.add.publishOn.quickfix.text", objectArray);
        }

        /*
         * WARNING - void declaration
         */
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            block8: {
                UElement uElement;
                void $this$replace$iv;
                UExpression uExpression;
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                UCallExpression uCallExpression = AddPublishOnBlockingSchedulerFix.Companion.getOperatorCall(UastContextKt.toUElement((PsiElement)descriptor.getPsiElement()));
                if (uCallExpression == null) {
                    return;
                }
                UCallExpression operatorCall = uCallExpression;
                UastCodeGenerationPlugin uastCodeGenerationPlugin = UastCodeGenerationPluginKt.getGenerationPlugin((UElement)((UElement)operatorCall));
                if (uastCodeGenerationPlugin == null) {
                    return;
                }
                UastCodeGenerationPlugin generationPlugin = uastCodeGenerationPlugin;
                UastElementFactory factory = generationPlugin.getElementFactory(project);
                UQualifiedReferenceExpression uQualifiedReferenceExpression = factory.createQualifiedReference(this.blockingContextProvider.getContextsProviderClassName(), operatorCall.getSourcePsi());
                if (uQualifiedReferenceExpression == null) {
                    return;
                }
                UQualifiedReferenceExpression schedulers = uQualifiedReferenceExpression;
                UCallExpression uCallExpression2 = factory.createCallExpression((UExpression)schedulers, this.blockingContextProvider.getBlockingContextFactoryMethodName(), CollectionsKt.emptyList(), null, UastCallKind.METHOD_CALL, operatorCall.getSourcePsi());
                if (uCallExpression2 == null || (uExpression = UastUtils.getQualifiedParentOrThis((UExpression)((UExpression)uCallExpression2))) == null) {
                    return;
                }
                UExpression blockingScheduler = uExpression;
                UExpression receiver = operatorCall.getReceiver();
                UExpression uExpression2 = receiver;
                UCallExpression uCallExpression3 = factory.createCallExpression(receiver, this.blockingContextProvider.getOperatorToChangeContextName(), CollectionsKt.listOf((Object)blockingScheduler), (PsiType)(uExpression2 != null ? uExpression2.getExpressionType() : null), UastCallKind.METHOD_CALL, operatorCall.getSourcePsi());
                if (uCallExpression3 == null) {
                    return;
                }
                UCallExpression newReceiver = uCallExpression3;
                UExpression uExpression3 = receiver;
                if (uExpression3 == null) break block8;
                UElement uElement2 = (UElement)uExpression3;
                UElement newElement$iv = (UElement)newReceiver;
                boolean $i$f$replace = false;
                if (Intrinsics.areEqual((Object)$this$replace$iv, (Object)newElement$iv)) {
                    uElement = newElement$iv;
                } else {
                    UastCodeGenerationPlugin uastCodeGenerationPlugin2 = UastCodeGenerationPlugin.Companion.byLanguage($this$replace$iv.getLang());
                    UastCodeGenerationPlugin it$iv = uastCodeGenerationPlugin2 = uastCodeGenerationPlugin2 != null ? uastCodeGenerationPlugin2.replace((UElement)$this$replace$iv, newElement$iv, UCallExpression.class) : null;
                    boolean bl = false;
                    if (it$iv == null) {
                        boolean $i$f$logger = false;
                        Logger logger = Logger.getInstance(UastCodeGenerationPlugin.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                        logger.warn("failed replacing the " + (UElement)$this$replace$iv + " with " + newElement$iv);
                    }
                    uElement = uastCodeGenerationPlugin2;
                }
                UCallExpression cfr_ignored_0 = (UCallExpression)uElement;
            }
        }

        @JvmStatic
        @NotNull
        public static final LocalQuickFix[] getAllAvailableFixes(@Nullable DefaultBlockingContextProvider blockingContextProvider, @Nullable UElement element, LocalQuickFix ... additionalFixes) {
            return Companion.getAllAvailableFixes(blockingContextProvider, element, additionalFixes);
        }

        public /* synthetic */ AddPublishOnBlockingSchedulerFix(DefaultBlockingContextProvider blockingContextProvider, DefaultConstructorMarker $constructor_marker) {
            this(blockingContextProvider);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J=\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0014\b\u0002\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\"\u00020\nH\u0007\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/reactivestreams/inspections/ReactiveStreamsNonBlockingSchedulerChecker$AddPublishOnBlockingSchedulerFix$Companion;", "", "<init>", "()V", "getOperatorCall", "Lorg/jetbrains/uast/UCallExpression;", "element", "Lorg/jetbrains/uast/UElement;", "getAllAvailableFixes", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "blockingContextProvider", "Lcom/intellij/reactivestreams/implementations/info/DefaultBlockingContextProvider;", "additionalFixes", "(Lcom/intellij/reactivestreams/implementations/info/DefaultBlockingContextProvider;Lorg/jetbrains/uast/UElement;[Lcom/intellij/codeInspection/LocalQuickFix;)[Lcom/intellij/codeInspection/LocalQuickFix;", "intellij.reactivestreams"})
        public static final class Companion {
            private Companion() {
            }

            private final UCallExpression getOperatorCall(UElement element) {
                UCallExpression uCallExpression;
                Object t;
                if (element == null) {
                    return null;
                }
                UFunctionalObject uFunctionalObject = UFunctionalObject.Companion.fromSuitableParent(element, Companion::getOperatorCall$lambda$0);
                if (uFunctionalObject == null || (t = uFunctionalObject.getContext()) == null || (uCallExpression = t.getCallExpression()) == null) {
                    return null;
                }
                UCallExpression operatorCall = uCallExpression;
                UExpression receiver = operatorCall.getReceiver();
                UExpression uExpression = receiver;
                if (!(uExpression != null && (uExpression = uExpression.getExpressionType()) != null ? ReactiveStreamsUtils.isPublisher((PsiType)uExpression) : false)) {
                    return null;
                }
                return operatorCall;
            }

            @JvmStatic
            @NotNull
            public final LocalQuickFix[] getAllAvailableFixes(@Nullable DefaultBlockingContextProvider blockingContextProvider, @Nullable UElement element, LocalQuickFix ... additionalFixes) {
                Intrinsics.checkNotNullParameter((Object)additionalFixes, (String)"additionalFixes");
                if (blockingContextProvider != null && this.getOperatorCall(element) != null) {
                    SpreadBuilder spreadBuilder = new SpreadBuilder(2);
                    spreadBuilder.addSpread((Object)additionalFixes);
                    spreadBuilder.add((Object)new AddPublishOnBlockingSchedulerFix(blockingContextProvider, null));
                    return (LocalQuickFix[])spreadBuilder.toArray((Object[])new LocalQuickFix[spreadBuilder.size()]);
                }
                return Arrays.copyOf(additionalFixes, additionalFixes.length);
            }

            public static /* synthetic */ LocalQuickFix[] getAllAvailableFixes$default(Companion companion, DefaultBlockingContextProvider defaultBlockingContextProvider, UElement uElement, LocalQuickFix[] localQuickFixArray, int n, Object object) {
                if ((n & 4) != 0) {
                    Intrinsics.checkNotNullExpressionValue((Object)LocalQuickFix.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                    localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                }
                return companion.getAllAvailableFixes(defaultBlockingContextProvider, uElement, localQuickFixArray);
            }

            private static final UCallExpressionContext getOperatorCall$lambda$0(UElement it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                UElement uElement = it.getUastParent();
                UCallExpression uCallExpression = uElement instanceof UCallExpression ? (UCallExpression)uElement : null;
                return uCallExpression != null ? FunctionalObjectsUtil.asContext(uCallExpression) : null;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/reactivestreams/inspections/ReactiveStreamsNonBlockingSchedulerChecker$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/reactivestreams/inspections/ReactiveStreamsNonBlockingSchedulerChecker;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.reactivestreams"})
    @SourceDebugExtension(value={"SMAP\nReactiveStreamsNonBlockingSchedulerChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReactiveStreamsNonBlockingSchedulerChecker.kt\ncom/intellij/reactivestreams/inspections/ReactiveStreamsNonBlockingSchedulerChecker$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,468:1\n30#2,2:469\n*S KotlinDebug\n*F\n+ 1 ReactiveStreamsNonBlockingSchedulerChecker.kt\ncom/intellij/reactivestreams/inspections/ReactiveStreamsNonBlockingSchedulerChecker$Companion\n*L\n295#1:469,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ReactiveStreamsNonBlockingSchedulerChecker getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<ReactiveStreamsNonBlockingSchedulerChecker> serviceClass$iv = ReactiveStreamsNonBlockingSchedulerChecker.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (ReactiveStreamsNonBlockingSchedulerChecker)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/reactivestreams/inspections/ReactiveStreamsNonBlockingSchedulerChecker$FindCauseBecauseSchedulingFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "<init>", "()V", "getFamilyName", "", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "startInWriteAction", "", "intellij.reactivestreams"})
    @SourceDebugExtension(value={"SMAP\nReactiveStreamsNonBlockingSchedulerChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReactiveStreamsNonBlockingSchedulerChecker.kt\ncom/intellij/reactivestreams/inspections/ReactiveStreamsNonBlockingSchedulerChecker$FindCauseBecauseSchedulingFix\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,468:1\n1#2:469\n*E\n"})
    private static final class FindCauseBecauseSchedulingFix
    implements LocalQuickFix {
        @NotNull
        public static final FindCauseBecauseSchedulingFix INSTANCE = new FindCauseBecauseSchedulingFix();

        private FindCauseBecauseSchedulingFix() {
        }

        @NotNull
        public String getFamilyName() {
            return ReactiveStreamsBundle.message("inspections.blocking.in.non.blocking.quickfix.name", new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            ReactiveStreamsNonBlockingSchedulerChecker checker;
            UElement uElement;
            block16: {
                block15: {
                    Object t;
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                    UElement uElement2 = UastContextKt.toUElement((PsiElement)descriptor.getPsiElement());
                    if (uElement2 == null) break block15;
                    uElement = uElement2;
                    boolean bl = false;
                    UFunctionalObject uFunctionalObject = UFunctionalObject.Companion.fromSuitableParent(uElement, FindCauseBecauseSchedulingFix::applyFix$lambda$1$lambda$0);
                    if (uFunctionalObject != null && (t = uFunctionalObject.getContext()) != null && (uElement = t.getCallExpression()) != null) break block16;
                }
                return;
            }
            UElement operatorCall = uElement;
            UMethod uMethod = UastUtils.getContainingUMethod((UElement)operatorCall);
            if (uMethod == null) {
                return;
            }
            UMethod containingUMethod = uMethod;
            UastLocalUsageDependencyGraph uastLocalUsageDependencyGraph = UastLocalUsageDependencyGraph.Companion.getGraphByUElement((UElement)containingUMethod);
            if (uastLocalUsageDependencyGraph == null) {
                return;
            }
            UastLocalUsageDependencyGraph dependencyGraph = uastLocalUsageDependencyGraph;
            NonBlockingAnalysisCache nonBlockingAnalysisCache = NonBlockingAnalysisCache.Companion.getCache(containingUMethod);
            if (nonBlockingAnalysisCache == null) {
                return;
            }
            NonBlockingAnalysisCache cache = nonBlockingAnalysisCache;
            ReactiveStreamsNonBlockingSchedulerChecker $this$applyFix_u24lambda_u242 = checker = Companion.getInstance(project);
            boolean bl = false;
            Scope scope = $this$applyFix_u24lambda_u242.calculateScope(cache, dependencyGraph, operatorCall);
            Scope.NonBlocking nonBlocking = scope instanceof Scope.NonBlocking ? (Scope.NonBlocking)scope : null;
            if (nonBlocking == null) {
                return;
            }
            Scope.NonBlocking scope2 = nonBlocking;
            SchedulingMethodCallInfo schedulingMethodCallInfo = checker.getAnalysisManager().getSchedulingMethodInfo(scope2.getCause(), SchedulingType.ANY);
            if (schedulingMethodCallInfo == null) {
                return;
            }
            SchedulingMethodCallInfo schedulingInfo = schedulingMethodCallInfo;
            String hintText = null;
            UIdentifier navigablePsi = null;
            if (schedulingInfo.getScheduler() != null) {
                UCallExpression scheduler = schedulingInfo.getScheduler();
                UIdentifier uIdentifier = scheduler.getMethodIdentifier();
                if (uIdentifier == null || (uIdentifier = uIdentifier.getSourcePsi()) == null) {
                    return;
                }
                navigablePsi = uIdentifier;
                Object[] objectArray = scheduler.getMethodName();
                if (objectArray == null) {
                    return;
                }
                schedulerName = objectArray;
                Object[] objectArray2 = new Object[]{schedulerName};
                hintText = ReactiveStreamsBundle.message("inspections.blocking.in.non.blocking.quickfix.text", objectArray2);
            } else {
                UIdentifier uIdentifier = schedulingInfo.getCallExpression().getMethodIdentifier();
                if (uIdentifier == null || (uIdentifier = uIdentifier.getSourcePsi()) == null) {
                    return;
                }
                navigablePsi = uIdentifier;
                Object object = schedulingInfo.getCallExpression().resolve();
                if (object == null || (object = ReactiveStreamsNonBlockingSchedulerCheckerKt.access$getNameWithClassName(object)) == null) {
                    return;
                }
                Object methodName = object;
                schedulerName = new Object[]{methodName, schedulingInfo.getSchedulerInfo()};
                hintText = ReactiveStreamsBundle.message("inspections.blocking.in.non.blocking.quickfix.alternative.text", schedulerName);
            }
            Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
            if (editor == null) {
                return;
            }
            Editor editor2 = editor;
            PsiNavigationSupport.getInstance().createNavigatable(project, navigablePsi.getContainingFile().getVirtualFile(), navigablePsi.getTextRange().getStartOffset()).navigate(true);
            HintManager hintManager = HintManager.getInstance();
            hintManager.showInformationHint(editor2, hintText);
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static final UCallExpressionContext applyFix$lambda$1$lambda$0(UElement it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            UElement uElement = it.getUastParent();
            UCallExpression uCallExpression = uElement instanceof UCallExpression ? (UCallExpression)uElement : null;
            return uCallExpression != null ? FunctionalObjectsUtil.asContext(uCallExpression) : null;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/reactivestreams/inspections/ReactiveStreamsNonBlockingSchedulerChecker$ScopeWithDepth;", "", "scope", "Lcom/intellij/reactivestreams/inspections/Scope;", "depth", "", "<init>", "(Lcom/intellij/reactivestreams/inspections/Scope;I)V", "getScope", "()Lcom/intellij/reactivestreams/inspections/Scope;", "getDepth", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.reactivestreams"})
    private static final class ScopeWithDepth {
        @NotNull
        private final Scope scope;
        private final int depth;

        public ScopeWithDepth(@NotNull Scope scope, int depth) {
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            this.scope = scope;
            this.depth = depth;
        }

        @NotNull
        public final Scope getScope() {
            return this.scope;
        }

        public final int getDepth() {
            return this.depth;
        }

        @NotNull
        public final Scope component1() {
            return this.scope;
        }

        public final int component2() {
            return this.depth;
        }

        @NotNull
        public final ScopeWithDepth copy(@NotNull Scope scope, int depth) {
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            return new ScopeWithDepth(scope, depth);
        }

        public static /* synthetic */ ScopeWithDepth copy$default(ScopeWithDepth scopeWithDepth, Scope scope, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                scope = scopeWithDepth.scope;
            }
            if ((n2 & 2) != 0) {
                n = scopeWithDepth.depth;
            }
            return scopeWithDepth.copy(scope, n);
        }

        @NotNull
        public String toString() {
            return "ScopeWithDepth(scope=" + this.scope + ", depth=" + this.depth + ")";
        }

        public int hashCode() {
            int result = this.scope.hashCode();
            result = result * 31 + Integer.hashCode(this.depth);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ScopeWithDepth)) {
                return false;
            }
            ScopeWithDepth scopeWithDepth = (ScopeWithDepth)other;
            if (!Intrinsics.areEqual((Object)this.scope, (Object)scopeWithDepth.scope)) {
                return false;
            }
            return this.depth == scopeWithDepth.depth;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/reactivestreams/inspections/ReactiveStreamsNonBlockingSchedulerChecker$TooDeepRecursionException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "<init>", "()V", "intellij.reactivestreams"})
    private static final class TooDeepRecursionException
    extends RuntimeException {
        @NotNull
        public static final TooDeepRecursionException INSTANCE = new TooDeepRecursionException();

        private TooDeepRecursionException() {
            super("too deep recursion while traversing graph", null, false, false);
        }
    }
}

