/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.reactivestreams.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.reactivestreams.implementations.info.ThrowReplacementInfo;
import com.intellij.reactivestreams.inspections.InternalCountStrategy;
import com.intellij.reactivestreams.inspections.InternalReplacementStrategy;
import com.intellij.reactivestreams.inspections.ReactiveStreamsThrowInOperatorQuickfix;
import com.intellij.reactivestreams.uast.ex.UFunctionalObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UThrowExpression;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u001a\u0018\u0010\u0000\u001a\u0004\u0018\u00010\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002\u001a \u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\u0010\u0010\u000b\u001a\u00020\t*\u0006\u0012\u0002\b\u00030\u0003H\u0002\u00a8\u0006\f"}, d2={"createReplacementStrategy", "Lcom/intellij/reactivestreams/inspections/InternalReplacementStrategy;", "functionalObject", "Lcom/intellij/reactivestreams/uast/ex/UFunctionalObject;", "Lcom/intellij/reactivestreams/implementations/info/ThrowReplacementInfo;", "getThrowReplacementQuickFixes", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "throwsCount", "", "strategy", "calculateThrowExpressionsCount", "intellij.reactivestreams.core"})
public final class ReactiveStreamsThrowInOperatorInspectionKt {
    private static final InternalReplacementStrategy createReplacementStrategy(UFunctionalObject<ThrowReplacementInfo> functionalObject) {
        ThrowReplacementInfo.ReplaceType replaceType = functionalObject.getContext().getReplaceType();
        return replaceType instanceof ThrowReplacementInfo.ReplaceType.ReplaceWithReturnType ? (InternalReplacementStrategy)InternalReplacementStrategy.ReplaceWithReturn.Companion.create(((ThrowReplacementInfo.ReplaceType.ReplaceWithReturnType)replaceType).getReferenceName(), ((ThrowReplacementInfo.ReplaceType.ReplaceWithReturnType)replaceType).getMethodName()) : (replaceType instanceof ThrowReplacementInfo.ReplaceType.ReplaceWithMethodCallType ? (InternalReplacementStrategy)InternalReplacementStrategy.ReplaceWithCall.Companion.create(functionalObject, ((ThrowReplacementInfo.ReplaceType.ReplaceWithMethodCallType)replaceType).getLambdaParameterIndex(), ((ThrowReplacementInfo.ReplaceType.ReplaceWithMethodCallType)replaceType).getMethodName()) : (replaceType instanceof ThrowReplacementInfo.ReplaceType.ReplaceWithWrappedCall ? (InternalReplacementStrategy)InternalReplacementStrategy.ReplaceWithWrappedCall.Companion.create(((ThrowReplacementInfo.ReplaceType.ReplaceWithWrappedCall)replaceType).getClassFqn(), ((ThrowReplacementInfo.ReplaceType.ReplaceWithWrappedCall)replaceType).getMethodName()) : null));
    }

    private static final List<LocalQuickFix> getThrowReplacementQuickFixes(int throwsCount, InternalReplacementStrategy strategy) {
        if (strategy == null) {
            return CollectionsKt.emptyList();
        }
        List quickFixes = new ArrayList();
        if (throwsCount > 0) {
            ((Collection)quickFixes).add(new ReactiveStreamsThrowInOperatorQuickfix(strategy, InternalCountStrategy.CurrentThrow.INSTANCE));
        }
        if (throwsCount > 1) {
            ((Collection)quickFixes).add(new ReactiveStreamsThrowInOperatorQuickfix(strategy, InternalCountStrategy.AllThrows.INSTANCE));
        }
        return quickFixes;
    }

    private static final int calculateThrowExpressionsCount(UFunctionalObject<?> $this$calculateThrowExpressionsCount) {
        Ref.IntRef count = new Ref.IntRef();
        $this$calculateThrowExpressionsCount.accept((UastVisitor)new AbstractUastVisitor($this$calculateThrowExpressionsCount, count){
            final /* synthetic */ UFunctionalObject<?> $this_calculateThrowExpressionsCount;
            final /* synthetic */ Ref.IntRef $count;
            {
                this.$this_calculateThrowExpressionsCount = $receiver;
                this.$count = $count;
            }

            public boolean visitThrowExpression(UThrowExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (this.$this_calculateThrowExpressionsCount.checkExpressionIsInsideFunction((UExpression)node)) {
                    int n = this.$count.element;
                    this.$count.element = n + 1;
                }
                return true;
            }
        });
        return count.element;
    }

    public static final /* synthetic */ List access$getThrowReplacementQuickFixes(int throwsCount, InternalReplacementStrategy strategy) {
        return ReactiveStreamsThrowInOperatorInspectionKt.getThrowReplacementQuickFixes(throwsCount, strategy);
    }

    public static final /* synthetic */ int access$calculateThrowExpressionsCount(UFunctionalObject $receiver) {
        return ReactiveStreamsThrowInOperatorInspectionKt.calculateThrowExpressionsCount($receiver);
    }

    public static final /* synthetic */ InternalReplacementStrategy access$createReplacementStrategy(UFunctionalObject functionalObject) {
        return ReactiveStreamsThrowInOperatorInspectionKt.createReplacementStrategy(functionalObject);
    }
}

