/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.reactivestreams.mutiny;

import com.intellij.codeInspection.AnalysisUastUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.reactivestreams.implementations.ReactiveStreamsImplementation;
import com.intellij.reactivestreams.implementations.info.ThrowReplacementInfo;
import com.intellij.reactivestreams.mutiny.MutinyLibraryUtilKt;
import com.intellij.reactivestreams.mutiny.MutinyNonBlockingAnalysisManager;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.UReferenceExpression;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J!\u0010!\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%H\u0016\u00a2\u0006\u0002\u0010&J \u0010'\u001a\b\u0012\u0004\u0012\u00020)0(2\u0006\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%H\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0014\u0010\u0014\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006*"}, d2={"Lcom/intellij/reactivestreams/mutiny/MutinyReactiveStreamsImplementation;", "Lcom/intellij/reactivestreams/implementations/ReactiveStreamsImplementation;", "<init>", "()V", "publisherImplementationsTypes", "", "", "getPublisherImplementationsTypes", "()Ljava/lang/Iterable;", "publisherInterfacesTypes", "getPublisherInterfacesTypes", "builderClassesToCheck", "getBuilderClassesToCheck", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "isAvailableFor", "file", "Lcom/intellij/psi/PsiFile;", "implementationPackage", "getImplementationPackage", "()Ljava/lang/String;", "isCollapsableMethodDefinedInPublisher", "callExpression", "Lorg/jetbrains/uast/UCallExpression;", "createThrowReplacementInfo", "Lcom/intellij/reactivestreams/implementations/info/ThrowReplacementInfo;", "methodCall", "functionalObject", "Lorg/jetbrains/uast/UElement;", "getBlockingNonBlockingAnalysisManager", "Lcom/intellij/reactivestreams/implementations/ReactiveStreamsImplementation$NonBlockingAnalysisManager;", "canMethodLambdaReturnNull", "method", "Lcom/intellij/psi/PsiMethod;", "functionalParameter", "Lcom/intellij/psi/PsiParameter;", "(Lcom/intellij/psi/PsiMethod;Lcom/intellij/psi/PsiParameter;)Ljava/lang/Boolean;", "provideQuickFixForLambdaReturningNull", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "intellij.reactivestreams.mutiny"})
@SourceDebugExtension(value={"SMAP\nMutinyReactiveStreamsImplementation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MutinyReactiveStreamsImplementation.kt\ncom/intellij/reactivestreams/mutiny/MutinyReactiveStreamsImplementation\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,80:1\n19#2:81\n19#2:82\n19#2:83\n19#2:84\n1#3:85\n*S KotlinDebug\n*F\n+ 1 MutinyReactiveStreamsImplementation.kt\ncom/intellij/reactivestreams/mutiny/MutinyReactiveStreamsImplementation\n*L\n37#1:81\n38#1:82\n42#1:83\n43#1:84\n*E\n"})
public final class MutinyReactiveStreamsImplementation
implements ReactiveStreamsImplementation {
    @NotNull
    private final Iterable<String> publisherImplementationsTypes;
    @NotNull
    private final Iterable<String> publisherInterfacesTypes;
    @NotNull
    private final Iterable<String> builderClassesToCheck;

    public MutinyReactiveStreamsImplementation() {
        Object[] objectArray = new String[]{"io.smallrye.mutiny.Uni", "io.smallrye.mutiny.Multi"};
        this.publisherImplementationsTypes = CollectionsKt.listOf((Object[])objectArray);
        this.publisherInterfacesTypes = CollectionsKt.listOf((Object)"io.smallrye.mutiny.Uni");
        objectArray = new String[]{"io.smallrye.mutiny.groups.UniOnItem", "io.smallrye.mutiny.groups.MultiOnItem"};
        this.builderClassesToCheck = CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public Iterable<String> getPublisherImplementationsTypes() {
        return this.publisherImplementationsTypes;
    }

    @Override
    @NotNull
    public Iterable<String> getPublisherInterfacesTypes() {
        return this.publisherInterfacesTypes;
    }

    @Override
    @NotNull
    public Iterable<String> getBuilderClassesToCheck() {
        return this.builderClassesToCheck;
    }

    @Override
    public boolean isAvailable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return MutinyLibraryUtilKt.hasMutinyLibrary(project);
    }

    @Override
    public boolean isAvailableFor(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return MutinyLibraryUtilKt.hasMutinyLibraryFor(file);
    }

    @Override
    @NotNull
    public String getImplementationPackage() {
        return "io.smallrye.mutiny";
    }

    @Override
    public boolean isCollapsableMethodDefinedInPublisher(@NotNull UCallExpression callExpression) {
        Intrinsics.checkNotNullParameter((Object)callExpression, (String)"callExpression");
        return MutinyLibraryUtilKt.isMutinyPublisher(callExpression.getReceiverType());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public ThrowReplacementInfo createThrowReplacementInfo(@NotNull UCallExpression methodCall, @NotNull UElement functionalObject) {
        String string;
        PsiType psiType;
        UExpression uExpression;
        Object object;
        boolean $i$f$asSafely;
        block18: {
            block17: {
                PsiClass psiClass;
                void $this$asSafely$iv;
                UReferenceExpression uReferenceExpression;
                void $this$asSafely$iv2;
                Intrinsics.checkNotNullParameter((Object)methodCall, (String)"methodCall");
                Intrinsics.checkNotNullParameter((Object)functionalObject, (String)"functionalObject");
                if (!MutinyLibraryUtilKt.isMutinyClass(methodCall.getReceiverType())) break block17;
                UExpression uExpression2 = methodCall.getReceiver();
                $i$f$asSafely = false;
                Object v0 = $this$asSafely$iv2;
                if (!(v0 instanceof UReferenceExpression)) {
                    v0 = null;
                }
                uReferenceExpression = (uReferenceExpression = (UReferenceExpression)v0) != null ? uReferenceExpression.resolve() : null;
                boolean $i$f$asSafely2 = false;
                Object v1 = $this$asSafely$iv;
                if (!(v1 instanceof PsiClass)) {
                    v1 = null;
                }
                if (!Intrinsics.areEqual((Object)((psiClass = (PsiClass)v1) != null ? psiClass.getQualifiedName() : null), (Object)"io.smallrye.mutiny.unchecked.Unchecked")) break block18;
            }
            return null;
        }
        UElement $this$asSafely$iv = functionalObject;
        $i$f$asSafely = false;
        UElement uElement = $this$asSafely$iv;
        if (!(uElement instanceof ULambdaExpression)) {
            uElement = null;
        }
        if ((object = (ULambdaExpression)uElement) != null && (object = object.getValueParameters()) != null) {
        } else {
            return null;
        }
        boolean lambdaHasArgs = !((Collection)object).isEmpty();
        UElement $this$asSafely$iv3 = functionalObject;
        boolean $i$f$asSafely3 = false;
        UElement uElement2 = $this$asSafely$iv3;
        if (!(uElement2 instanceof ULambdaExpression)) {
            uElement2 = null;
        }
        if (($this$asSafely$iv = (ULambdaExpression)uElement2) != null && (uExpression = $this$asSafely$iv.getBody()) != null) {
            UExpression lambdaBody = uExpression;
            boolean bl = false;
            psiType = AnalysisUastUtil.getContainingMethodOrLambdaReturnType((UExpression)lambdaBody);
        } else {
            psiType = null;
        }
        boolean voidReturnType = Intrinsics.areEqual(psiType, (Object)PsiTypes.voidType());
        if (lambdaHasArgs && voidReturnType) {
            string = "consumer";
        } else if (lambdaHasArgs && !voidReturnType) {
            string = "function";
        } else if (!lambdaHasArgs && !voidReturnType) {
            string = "supplier";
        } else {
            return null;
        }
        String replacementMethod = string;
        return new ThrowReplacementInfo(replacementMethod, methodCall){
            final /* synthetic */ String $replacementMethod;
            final /* synthetic */ UCallExpression $methodCall;
            {
                this.$replacementMethod = $replacementMethod;
                this.$methodCall = $methodCall;
            }

            public ThrowReplacementInfo.ReplaceType getReplaceType() {
                return new ThrowReplacementInfo.ReplaceType.ReplaceWithWrappedCall("io.smallrye.mutiny.unchecked.Unchecked", this.$replacementMethod);
            }

            public ThrowReplacementInfo.MethodType getMethodType() {
                return MutinyLibraryUtilKt.isMutinyFactory(this.$methodCall.getReceiverType()) ? ThrowReplacementInfo.MethodType.FACTORY : ThrowReplacementInfo.MethodType.OPERATOR;
            }

            public String getFrameworkName() {
                return "Mutiny";
            }

            public UCallExpression getCallExpression() {
                return this.$methodCall;
            }
        };
    }

    @Override
    @NotNull
    public ReactiveStreamsImplementation.NonBlockingAnalysisManager getBlockingNonBlockingAnalysisManager() {
        return new MutinyNonBlockingAnalysisManager();
    }

    @Override
    @Nullable
    public Boolean canMethodLambdaReturnNull(@NotNull PsiMethod method, @Nullable PsiParameter functionalParameter) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (!MutinyLibraryUtilKt.isMutinyPublisher(method.getContainingClass()) || !MutinyLibraryUtilKt.isMutinyPublisher(method.getReturnType())) {
            return null;
        }
        PsiClass psiClass = method.getContainingClass();
        return Intrinsics.areEqual((Object)(psiClass != null ? psiClass.getQualifiedName() : null), (Object)"io.smallrye.mutiny.Uni");
    }

    @Override
    @NotNull
    public List<LocalQuickFix> provideQuickFixForLambdaReturningNull(@NotNull PsiMethod method, @Nullable PsiParameter functionalParameter) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        return CollectionsKt.emptyList();
    }
}

