/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.reactivestreams.provider;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.blockingCallsDetection.BlockingMethodChecker;
import com.intellij.codeInspection.blockingCallsDetection.ElementContext;
import com.intellij.codeInspection.blockingCallsDetection.MethodContext;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.reactivestreams.inspections.ReactiveStreamsBaseNonBlockingScopeInspection;
import com.intellij.reactivestreams.inspections.ReactiveStreamsBlockingScopeCheckResult;
import com.intellij.reactivestreams.util.ReactiveStreamsUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J\u001b\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/intellij/reactivestreams/provider/ReactiveStreamsBlockingMethodChecker;", "Lcom/intellij/codeInspection/blockingCallsDetection/BlockingMethodChecker;", "<init>", "()V", "isApplicable", "", "file", "Lcom/intellij/psi/PsiFile;", "isMethodNonBlocking", "context", "Lcom/intellij/codeInspection/blockingCallsDetection/MethodContext;", "getQuickFixesFor", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "elementContext", "Lcom/intellij/codeInspection/blockingCallsDetection/ElementContext;", "(Lcom/intellij/codeInspection/blockingCallsDetection/ElementContext;)[Lcom/intellij/codeInspection/LocalQuickFix;", "intellij.reactivestreams.core"})
@SourceDebugExtension(value={"SMAP\nReactiveStreamsBlockingMethodChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReactiveStreamsBlockingMethodChecker.kt\ncom/intellij/reactivestreams/provider/ReactiveStreamsBlockingMethodChecker\n+ 2 UastContext.kt\norg/jetbrains/uast/UastContextKt\n*L\n1#1,31:1\n171#2:32\n*S KotlinDebug\n*F\n+ 1 ReactiveStreamsBlockingMethodChecker.kt\ncom/intellij/reactivestreams/provider/ReactiveStreamsBlockingMethodChecker\n*L\n27#1:32\n*E\n"})
public final class ReactiveStreamsBlockingMethodChecker
implements BlockingMethodChecker {
    public boolean isApplicable(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return JavaPsiFacade.getInstance((Project)file.getProject()).findClass("org.reactivestreams.Publisher", file.getResolveScope()) != null;
    }

    public boolean isMethodNonBlocking(@NotNull MethodContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PsiType returnType = context.getElement().getReturnType();
        return ReactiveStreamsUtils.isPublisher(returnType);
    }

    @NotNull
    public LocalQuickFix[] getQuickFixesFor(@NotNull ElementContext elementContext) {
        Intrinsics.checkNotNullParameter((Object)elementContext, (String)"elementContext");
        PsiElement $this$toUElementOfType$iv = elementContext.getElement();
        boolean $i$f$toUElementOfType = false;
        UCallExpression uCallExpression = (UCallExpression)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UCallExpression.class);
        if (uCallExpression == null) {
            Intrinsics.checkNotNullExpressionValue((Object)LocalQuickFix.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return LocalQuickFix.EMPTY_ARRAY;
        }
        UCallExpression callExpression = uCallExpression;
        ReactiveStreamsBlockingScopeCheckResult result = ReactiveStreamsBaseNonBlockingScopeInspection.isCalledInNonBlockingContext(callExpression);
        LocalQuickFix[] localQuickFixArray = result instanceof ReactiveStreamsBlockingScopeCheckResult.NonBlocking ? (LocalQuickFix[])result : null;
        if (localQuickFixArray == null || (localQuickFixArray = localQuickFixArray.getQuickFixes()) == null) {
            localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
            Intrinsics.checkNotNullExpressionValue((Object)LocalQuickFix.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
        }
        return localQuickFixArray;
    }
}

