/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.deployment;

import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.DockerDeploymentConfigurationUtilsKt;
import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import com.intellij.docker.deployment.DockerRunConfig;
import com.intellij.docker.deploymentSource.DockerComposeDeploymentSourceType;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.execution.ParametersListUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b&\u0018\u0000 \u000f2\u00020\u0001:\u0004\u000f\u0010\u0011\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&J(\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006H&\u00a8\u0006\u0013"}, d2={"Lcom/intellij/docker/deployment/DockerRunConfigurationPathHandler;", "", "<init>", "()V", "getPaths", "", "", "project", "Lcom/intellij/openapi/project/Project;", "dockerRunConfig", "Lcom/intellij/docker/deployment/DockerRunConfig;", "replacePath", "", "oldPath", "newPath", "Companion", "MainSourceFile", "SecondaryComposeFiles", "BindMounts", "intellij.clouds.docker"})
public abstract class DockerRunConfigurationPathHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ExtensionPointName<DockerRunConfigurationPathHandler> EP_NAME = ExtensionPointName.Companion.create("com.intellij.docker.runConfiguration.pathHandler");

    @NotNull
    public abstract List<String> getPaths(@NotNull Project var1, @NotNull DockerRunConfig var2);

    public abstract void replacePath(@NotNull Project var1, @NotNull DockerRunConfig var2, @NotNull String var3, @NotNull String var4);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J(\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006H\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/docker/deployment/DockerRunConfigurationPathHandler$BindMounts;", "Lcom/intellij/docker/deployment/DockerRunConfigurationPathHandler;", "<init>", "()V", "getPaths", "", "", "project", "Lcom/intellij/openapi/project/Project;", "dockerRunConfig", "Lcom/intellij/docker/deployment/DockerRunConfig;", "replacePath", "", "oldPath", "newPath", "intellij.clouds.docker"})
    @SourceDebugExtension(value={"SMAP\nDockerRunConfigurationPathHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerRunConfigurationPathHandler.kt\ncom/intellij/docker/deployment/DockerRunConfigurationPathHandler$BindMounts\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,105:1\n1617#2,9:106\n1869#2:115\n1870#2:117\n1626#2:118\n1#3:116\n*S KotlinDebug\n*F\n+ 1 DockerRunConfigurationPathHandler.kt\ncom/intellij/docker/deployment/DockerRunConfigurationPathHandler$BindMounts\n*L\n90#1:106,9\n90#1:115\n90#1:117\n90#1:118\n90#1:116\n*E\n"})
    public static final class BindMounts
    extends DockerRunConfigurationPathHandler {
        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<String> getPaths(@NotNull Project project, @NotNull DockerRunConfig dockerRunConfig) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            List list2;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dockerRunConfig, (String)"dockerRunConfig");
            List $this$getPaths_u24lambda_u242 = list2 = (List)new ArrayList();
            boolean bl = false;
            Iterable iterable = dockerRunConfig.getDeployment().getVolumeBindings();
            List list3 = $this$getPaths_u24lambda_u242;
            boolean $i$f$mapNotNull = false;
            void var9_9 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl2 = false;
                DockerVolumeBindingImpl it = (DockerVolumeBindingImpl)element$iv$iv;
                boolean bl3 = false;
                if (it.getHostPath() == null) continue;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list3.addAll((List)destination$iv$iv);
            Companion.iterateCliVolumes(dockerRunConfig.getDeployment(), (Function2<? super String, ? super Boolean, Unit>)((Function2)(arg_0, arg_1) -> BindMounts.getPaths$lambda$2$lambda$1($this$getPaths_u24lambda_u242, arg_0, arg_1)));
            return list2;
        }

        @Override
        public void replacePath(@NotNull Project project, @NotNull DockerRunConfig dockerRunConfig, @NotNull String oldPath, @NotNull String newPath) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dockerRunConfig, (String)"dockerRunConfig");
            Intrinsics.checkNotNullParameter((Object)oldPath, (String)"oldPath");
            Intrinsics.checkNotNullParameter((Object)newPath, (String)"newPath");
            if (((CharSequence)newPath).length() > 0) {
                Companion.replaceMountedPath(dockerRunConfig.getDeployment(), oldPath, newPath);
            }
        }

        private static final Unit getPaths$lambda$2$lambda$1(List $this_apply, String param, boolean isVolume) {
            Intrinsics.checkNotNullParameter((Object)param, (String)"param");
            if (isVolume && StringsKt.contains$default((CharSequence)param, (CharSequence)":", (boolean)false, (int)2, null)) {
                UtilKt.addIfNotNull((List)$this_apply, (Object)StringsKt.substringBefore$default((String)param, (String)":", null, (int)2, null));
            }
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ$\u0010\u000f\u001a\u00020\n*\u00020\u000b2\u0018\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\n0\u0011R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/docker/deployment/DockerRunConfigurationPathHandler$Companion;", "", "<init>", "()V", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/docker/deployment/DockerRunConfigurationPathHandler;", "getEP_NAME", "()Lcom/intellij/openapi/extensions/ExtensionPointName;", "replaceMountedPath", "", "Lcom/intellij/docker/DockerDeploymentConfiguration;", "oldPath", "", "newPath", "iterateCliVolumes", "handler", "Lkotlin/Function2;", "", "intellij.clouds.docker"})
    @SourceDebugExtension(value={"SMAP\nDockerRunConfigurationPathHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerRunConfigurationPathHandler.kt\ncom/intellij/docker/deployment/DockerRunConfigurationPathHandler$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n1869#2,2:106\n*S KotlinDebug\n*F\n+ 1 DockerRunConfigurationPathHandler.kt\ncom/intellij/docker/deployment/DockerRunConfigurationPathHandler$Companion\n*L\n22#1:106,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ExtensionPointName<DockerRunConfigurationPathHandler> getEP_NAME() {
            return EP_NAME;
        }

        public final void replaceMountedPath(@NotNull DockerDeploymentConfiguration $this$replaceMountedPath, @NotNull String oldPath, @NotNull String newPath) {
            Intrinsics.checkNotNullParameter((Object)$this$replaceMountedPath, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)oldPath, (String)"oldPath");
            Intrinsics.checkNotNullParameter((Object)newPath, (String)"newPath");
            Iterable $this$forEach$iv = $this$replaceMountedPath.getVolumeBindings();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DockerVolumeBindingImpl it = (DockerVolumeBindingImpl)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getHostPath(), (Object)oldPath)) continue;
                it.setHostPath(newPath);
            }
            List newCli = new ArrayList();
            Ref.BooleanRef changed = new Ref.BooleanRef();
            this.iterateCliVolumes($this$replaceMountedPath, (Function2<? super String, ? super Boolean, Unit>)((Function2)(arg_0, arg_1) -> Companion.replaceMountedPath$lambda$1(oldPath, newCli, newPath, changed, arg_0, arg_1)));
            if (changed.element) {
                $this$replaceMountedPath.setRunCliOptions(CollectionsKt.joinToString$default((Iterable)newCli, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
            }
        }

        public final void iterateCliVolumes(@NotNull DockerDeploymentConfiguration $this$iterateCliVolumes, @NotNull Function2<? super String, ? super Boolean, Unit> handler2) {
            Intrinsics.checkNotNullParameter((Object)$this$iterateCliVolumes, (String)"<this>");
            Intrinsics.checkNotNullParameter(handler2, (String)"handler");
            String string = $this$iterateCliVolumes.getRunCliOptions();
            if (string == null) {
                return;
            }
            String cliOptions = string;
            boolean nextIsVolume = false;
            for (Object e : ParametersListUtil.parse((String)cliOptions)) {
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                String next = (String)e;
                handler2.invoke((Object)next, (Object)nextIsVolume);
                nextIsVolume = Intrinsics.areEqual((Object)next, (Object)"-v") || Intrinsics.areEqual((Object)next, (Object)"--volume");
            }
        }

        private static final Unit replaceMountedPath$lambda$1(String $oldPath, List $newCli, String $newPath, Ref.BooleanRef $changed, String param, boolean isVolume) {
            Intrinsics.checkNotNullParameter((Object)param, (String)"param");
            if (isVolume && StringsKt.startsWith$default((String)param, (String)$oldPath, (boolean)false, (int)2, null)) {
                $newCli.add(StringsKt.replace$default((String)param, (String)$oldPath, (String)$newPath, (boolean)false, (int)4, null));
                $changed.element = true;
            } else {
                $newCli.add(param);
            }
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J(\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006H\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/docker/deployment/DockerRunConfigurationPathHandler$MainSourceFile;", "Lcom/intellij/docker/deployment/DockerRunConfigurationPathHandler;", "<init>", "()V", "getPaths", "", "", "project", "Lcom/intellij/openapi/project/Project;", "dockerRunConfig", "Lcom/intellij/docker/deployment/DockerRunConfig;", "replacePath", "", "oldPath", "newPath", "intellij.clouds.docker"})
    public static final class MainSourceFile
    extends DockerRunConfigurationPathHandler {
        @Override
        @NotNull
        public List<String> getPaths(@NotNull Project project, @NotNull DockerRunConfig dockerRunConfig) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dockerRunConfig, (String)"dockerRunConfig");
            Path path2 = DockerDeploymentConfigurationUtilsKt.resolvePath(project, dockerRunConfig.getDeployment().getSourceFilePath());
            return CollectionsKt.listOfNotNull((Object)(path2 != null ? ((Object)path2.toAbsolutePath()).toString() : null));
        }

        @Override
        public void replacePath(@NotNull Project project, @NotNull DockerRunConfig dockerRunConfig, @NotNull String oldPath, @NotNull String newPath) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)dockerRunConfig, (String)"dockerRunConfig");
                Intrinsics.checkNotNullParameter((Object)oldPath, (String)"oldPath");
                Intrinsics.checkNotNullParameter((Object)newPath, (String)"newPath");
                if (!(!StringsKt.isBlank((CharSequence)newPath))) break block1;
                DockerDeploymentConfigurationUtilsKt.setSourceFile(project, dockerRunConfig.getDeployment(), new File(newPath));
                String string = DockerComposeDeploymentSourceType.getInstance().suggestConfigurationName(dockerRunConfig.getDeployment());
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    dockerRunConfig.getRunConfiguration().setName(it);
                }
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J(\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006H\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/docker/deployment/DockerRunConfigurationPathHandler$SecondaryComposeFiles;", "Lcom/intellij/docker/deployment/DockerRunConfigurationPathHandler;", "<init>", "()V", "getPaths", "", "", "project", "Lcom/intellij/openapi/project/Project;", "dockerRunConfig", "Lcom/intellij/docker/deployment/DockerRunConfig;", "replacePath", "", "oldPath", "newPath", "intellij.clouds.docker"})
    @SourceDebugExtension(value={"SMAP\nDockerRunConfigurationPathHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerRunConfigurationPathHandler.kt\ncom/intellij/docker/deployment/DockerRunConfigurationPathHandler$SecondaryComposeFiles\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,105:1\n1617#2,9:106\n1869#2:115\n1870#2:117\n1626#2:118\n1617#2,9:119\n1869#2:128\n1870#2:130\n1626#2:131\n1#3:116\n1#3:129\n*S KotlinDebug\n*F\n+ 1 DockerRunConfigurationPathHandler.kt\ncom/intellij/docker/deployment/DockerRunConfigurationPathHandler$SecondaryComposeFiles\n*L\n70#1:106,9\n70#1:115\n70#1:117\n70#1:118\n80#1:119,9\n80#1:128\n80#1:130\n80#1:131\n70#1:116\n80#1:129\n*E\n"})
    public static final class SecondaryComposeFiles
    extends DockerRunConfigurationPathHandler {
        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<String> getPaths(@NotNull Project project, @NotNull DockerRunConfig dockerRunConfig) {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dockerRunConfig, (String)"dockerRunConfig");
            Iterable $this$mapNotNull$iv = dockerRunConfig.getDeployment().getSecondarySourceFiles();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                Path path2 = DockerDeploymentConfigurationUtilsKt.resolvePath(project, it);
                if ((path2 != null ? ((Object)path2.toAbsolutePath()).toString() : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void replacePath(@NotNull Project project, @NotNull DockerRunConfig dockerRunConfig, @NotNull String oldPath, @NotNull String newPath) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dockerRunConfig, (String)"dockerRunConfig");
            Intrinsics.checkNotNullParameter((Object)oldPath, (String)"oldPath");
            Intrinsics.checkNotNullParameter((Object)newPath, (String)"newPath");
            if (StringsKt.isBlank((CharSequence)newPath)) {
                return;
            }
            DockerDeploymentConfiguration deployment = dockerRunConfig.getDeployment();
            List newFilesList = new ArrayList();
            UtilKt.addIfNotNull((List)newFilesList, (Object)DockerDeploymentConfigurationUtilsKt.getSourceFile(project, deployment));
            Iterable iterable = deployment.getSecondarySourceFiles();
            List list2 = newFilesList;
            boolean $i$f$mapNotNull = false;
            void var9_10 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                File it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                if ((Intrinsics.areEqual((Object)it, (Object)oldPath) ? new File(newPath) : DockerDeploymentConfigurationUtilsKt.resolveFile(project, it)) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list2.addAll((List)destination$iv$iv);
            DockerDeploymentConfigurationUtilsKt.setManySourceFiles(project, deployment, newFilesList);
        }
    }
}

