/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.commitgraph;

import java.text.MessageFormat;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.commitgraph.CommitGraph;
import org.eclipse.jgit.internal.storage.commitgraph.CommitGraphFormatException;
import org.eclipse.jgit.internal.storage.commitgraph.CommitGraphV1;
import org.eclipse.jgit.internal.storage.commitgraph.GraphCommitData;
import org.eclipse.jgit.internal.storage.commitgraph.GraphObjectIndex;

class CommitGraphBuilder {
    private final int hashLength;
    private byte[] oidFanout;
    private byte[] oidLookup;
    private byte[] commitData;
    private byte[] extraList;

    static CommitGraphBuilder builder() {
        return new CommitGraphBuilder(20);
    }

    private CommitGraphBuilder(int hashLength) {
        this.hashLength = hashLength;
    }

    CommitGraphBuilder addOidFanout(byte[] buffer) throws CommitGraphFormatException {
        this.assertChunkNotSeenYet(this.oidFanout, 1330201670);
        this.oidFanout = buffer;
        return this;
    }

    CommitGraphBuilder addOidLookUp(byte[] buffer) throws CommitGraphFormatException {
        this.assertChunkNotSeenYet(this.oidLookup, 1330201676);
        this.oidLookup = buffer;
        return this;
    }

    CommitGraphBuilder addCommitData(byte[] buffer) throws CommitGraphFormatException {
        this.assertChunkNotSeenYet(this.commitData, 1128546644);
        this.commitData = buffer;
        return this;
    }

    CommitGraphBuilder addExtraList(byte[] buffer) throws CommitGraphFormatException {
        this.assertChunkNotSeenYet(this.extraList, 0x45444745);
        this.extraList = buffer;
        return this;
    }

    CommitGraph build() throws CommitGraphFormatException {
        this.assertChunkNotNull(this.oidFanout, 1330201670);
        this.assertChunkNotNull(this.oidLookup, 1330201676);
        this.assertChunkNotNull(this.commitData, 1128546644);
        GraphObjectIndex index = new GraphObjectIndex(this.hashLength, this.oidFanout, this.oidLookup);
        GraphCommitData commitDataChunk = new GraphCommitData(this.hashLength, this.commitData, this.extraList);
        return new CommitGraphV1(index, commitDataChunk);
    }

    private void assertChunkNotNull(Object object, int chunkId) throws CommitGraphFormatException {
        if (object == null) {
            throw new CommitGraphFormatException(MessageFormat.format(JGitText.get().commitGraphChunkNeeded, Integer.toHexString(chunkId)));
        }
    }

    private void assertChunkNotSeenYet(Object object, int chunkId) throws CommitGraphFormatException {
        if (object != null) {
            throw new CommitGraphFormatException(MessageFormat.format(JGitText.get().commitGraphChunkRepeated, Integer.toHexString(chunkId)));
        }
    }
}

