/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.resolve.directive;

import com.google.common.collect.ImmutableList;
import com.intellij.openapi.util.TextRange;
import com.intellij.protobuf.ide.PbCompositeModificationTracker;
import com.intellij.protobuf.lang.PbTextLanguage;
import com.intellij.protobuf.lang.psi.PbFile;
import com.intellij.protobuf.lang.psi.PbMessageType;
import com.intellij.protobuf.lang.resolve.PbSymbolResolver;
import com.intellij.protobuf.lang.resolve.directive.FileComment;
import com.intellij.protobuf.lang.resolve.directive.MessageComment;
import com.intellij.protobuf.lang.resolve.directive.SchemaComment;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SchemaDirective {
    private static final Pattern commentPattern = Pattern.compile("^#\\s*(?<key>proto-(?<type>file|message|import)\\s*:)\\s*(?<name>.*)");
    private final FileComment fileComment;
    private final MessageComment messageComment;
    private final ImmutableList<FileComment> importComments;

    private SchemaDirective(FileComment fileComment, MessageComment messageComment, ImmutableList<FileComment> importComments) {
        this.fileComment = fileComment;
        this.messageComment = messageComment;
        this.importComments = importComments;
    }

    @Nullable
    public static SchemaDirective find(PsiFile file) {
        return (SchemaDirective)CachedValuesManager.getCachedValue((PsiElement)file, () -> CachedValueProvider.Result.create((Object)SchemaDirective.findNoCache(file), (Object[])new Object[]{PbCompositeModificationTracker.byElement((PsiElement)file)}));
    }

    private static SchemaDirective findNoCache(PsiFile file) {
        if (!PbTextLanguage.INSTANCE.is(file.getLanguage())) {
            return null;
        }
        FileComment fileComment = null;
        MessageComment messageComment = null;
        ImmutableList.Builder importCommentsBuilder = ImmutableList.builder();
        for (PsiComment comment : SyntaxTraverser.psiTraverser((PsiElement)file).filter(PsiComment.class)) {
            String type;
            Matcher matcher = commentPattern.matcher(comment.getText());
            if (!matcher.matches()) continue;
            TextRange keyRange = TextRange.create((int)matcher.start("key"), (int)matcher.end("key"));
            TextRange nameRange = null;
            if (!matcher.group("name").isEmpty()) {
                nameRange = TextRange.create((int)matcher.start("name"), (int)matcher.end("name"));
            }
            if ("file".equals(type = matcher.group("type"))) {
                if (fileComment != null) continue;
                fileComment = new FileComment(comment, keyRange, nameRange, SchemaComment.Type.FILE);
                continue;
            }
            if ("message".equals(type)) {
                if (messageComment != null) continue;
                messageComment = new MessageComment(comment, keyRange, nameRange);
                continue;
            }
            if (!"import".equals(type)) continue;
            importCommentsBuilder.add((Object)new FileComment(comment, keyRange, nameRange, SchemaComment.Type.IMPORT));
        }
        ImmutableList importComments = importCommentsBuilder.build();
        if (fileComment == null && messageComment == null && importComments.isEmpty()) {
            return null;
        }
        if (messageComment != null) {
            messageComment.setFileComment(fileComment);
        }
        return new SchemaDirective(fileComment, messageComment, (ImmutableList<FileComment>)importComments);
    }

    @Nullable
    public SchemaComment getFileComment() {
        return this.fileComment;
    }

    @Nullable
    public SchemaComment getMessageComment() {
        return this.messageComment;
    }

    @NotNull
    public ImmutableList<? extends SchemaComment> getImportComments() {
        ImmutableList<FileComment> immutableList = this.importComments;
        if (immutableList == null) {
            SchemaDirective.$$$reportNull$$$0(0);
        }
        return immutableList;
    }

    @Nullable
    public SchemaComment getSchemaComment(PsiComment comment) {
        if (comment == null) {
            return null;
        }
        if (this.fileComment != null && comment.equals(this.fileComment.getComment())) {
            return this.fileComment;
        }
        if (this.messageComment != null && comment.equals(this.messageComment.getComment())) {
            return this.messageComment;
        }
        for (SchemaComment importComment : this.importComments) {
            if (!comment.equals(importComment.getComment())) continue;
            return importComment;
        }
        return null;
    }

    @Nullable
    public PbMessageType getMessage() {
        if (this.messageComment == null) {
            return null;
        }
        PsiReference reference = this.messageComment.getReference();
        if (reference == null) {
            return null;
        }
        PsiElement resolved = reference.resolve();
        if (resolved instanceof PbMessageType) {
            return (PbMessageType)resolved;
        }
        return null;
    }

    PbSymbolResolver getExtensionResolver() {
        ImmutableList.Builder builder = ImmutableList.builder();
        SchemaDirective.addFileIfResolved(this.fileComment, (ImmutableList.Builder<PbFile>)builder);
        for (SchemaComment importComment : this.importComments) {
            SchemaDirective.addFileIfResolved(importComment, (ImmutableList.Builder<PbFile>)builder);
        }
        return PbSymbolResolver.forFileExports((List<PbFile>)builder.build());
    }

    public String getFilename() {
        if (this.fileComment == null) {
            return null;
        }
        return this.fileComment.getName();
    }

    public String getMessageName() {
        if (this.messageComment == null) {
            return null;
        }
        return this.messageComment.getName();
    }

    private static void addFileIfResolved(SchemaComment comment, ImmutableList.Builder<PbFile> builder) {
        if (comment == null) {
            return;
        }
        PsiReference ref = comment.getReference();
        if (ref == null) {
            return;
        }
        PsiElement resolved = ref.resolve();
        if (resolved instanceof PbFile) {
            builder.add((Object)((PbFile)resolved));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/protobuf/lang/resolve/directive/SchemaDirective", "getImportComments"));
    }
}

