/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.jpa.jdbc;

import com.intellij.codeInspection.AbstractBaseUastLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jpa.ORMReferencesUtil;
import com.intellij.jpa.highlighting.JpaInspectionUtil;
import com.intellij.jpa.jpb.model.orm.model.OrmFramework;
import com.intellij.jpa.jpb.model.orm.model.OrmUnit;
import com.intellij.jpa.jpb.model.util.OrmUtil;
import com.intellij.jpa.jpb.model.util.PsiUtilsKt;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.spring.data.jdbc.SpringDataJdbcUtilsKt;
import com.intellij.spring.data.jdbc.orm.SpringDataJdbcOrmFramework;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UField;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J/\u0010\n\u001a\f\u0012\u0006\b\u0001\u0012\u00020\f\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/intellij/spring/data/jpa/jdbc/SpringDataJdbcAssociatedDbElementsInspection;", "Lcom/intellij/codeInspection/AbstractBaseUastLocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "checkClass", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "aClass", "Lorg/jetbrains/uast/UClass;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "(Lorg/jetbrains/uast/UClass;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "intellij.spring.data"})
public final class SpringDataJdbcAssociatedDbElementsInspection
extends AbstractBaseUastLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        PsiFile psiFile = holder.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        Module module = PsiUtilsKt.module((PsiFile)psiFile);
        if (module == null || !SpringDataJdbcUtilsKt.hasSpringDataJdbcSupport(module)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        PsiElementVisitor psiElementVisitor = super.buildVisitor(holder, isOnTheFly);
        Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"buildVisitor(...)");
        return psiElementVisitor;
    }

    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull UClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)aClass, (String)"aClass");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        PsiClass psiClass = ORMReferencesUtil.getTargetClass((UElement)((UElement)aClass));
        if (psiClass == null) {
            return null;
        }
        PsiClass psiClass2 = psiClass;
        OrmUnit ormUnit = OrmUtil.INSTANCE.getOrmUnitForPsiClass((OrmFramework)SpringDataJdbcOrmFramework.INSTANCE, psiClass2);
        ProblemHighlightType highlightType = (ormUnit != null ? ormUnit.getDefaultDataSourceId() : null) != null ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.WARNING;
        ProblemsHolder holder = new ProblemsHolder(manager, psiClass2.getContainingFile(), isOnTheFly);
        JpaInspectionUtil.checkMemberAnnotations((UAnnotated)((UAnnotated)aClass), (ProblemsHolder)holder, ORMReferencesUtil.DataSourceRelatedReference.class, (ProblemHighlightType)highlightType);
        for (UField uField : aClass.getFields()) {
            JpaInspectionUtil.checkMemberAnnotations((UAnnotated)((UAnnotated)uField), (ProblemsHolder)holder, ORMReferencesUtil.DataSourceRelatedReference.class, (ProblemHighlightType)highlightType);
        }
        for (UField uField : aClass.getMethods()) {
            JpaInspectionUtil.checkMemberAnnotations((UAnnotated)((UAnnotated)uField), (ProblemsHolder)holder, ORMReferencesUtil.DataSourceRelatedReference.class, (ProblemHighlightType)highlightType);
        }
        return holder.getResultsArray();
    }
}

