/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.ecmascript6.parsing.ES6FunctionParser;
import com.intellij.lang.javascript.BasicJavaScriptStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.ecmascript6.parsing.TypeScriptParser;
import com.intellij.lang.javascript.ecmascript6.parsing.TypeScriptStatementParser;
import com.intellij.lang.javascript.parsing.FunctionParser;
import com.intellij.lang.javascript.parsing.JavaScriptParser;
import com.intellij.lang.typescript.BasicTypeScriptStubElementTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0016\u0018\u0000 \u001e2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001eB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0014J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0007H\u0016J\u001a\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u00112\b\u0010\u001a\u001a\u0004\u0018\u00010\tH\u0014J\u0012\u0010\u001d\u001a\u00020\u00112\b\u0010\u001a\u001a\u0004\u0018\u00010\tH\u0014R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\t8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000bR\u0014\u0010\u001b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u000b\u00a8\u0006\u001f"}, d2={"Lcom/intellij/lang/javascript/ecmascript6/parsing/TypeScriptFunctionParser;", "Lcom/intellij/lang/ecmascript6/parsing/ES6FunctionParser;", "Lcom/intellij/lang/javascript/ecmascript6/parsing/TypeScriptParser;", "parser", "<init>", "(Lcom/intellij/lang/javascript/ecmascript6/parsing/TypeScriptParser;)V", "parseParameterAttributeList", "", "parameterType", "Lcom/intellij/psi/tree/IElementType;", "getParameterType", "()Lcom/intellij/psi/tree/IElementType;", "functionExpressionElementType", "getFunctionExpressionElementType", "functionDeclarationElementType", "getFunctionDeclarationElementType", "parseAttributesList", "", "parseFunctionNoMarker", "context", "Lcom/intellij/lang/javascript/parsing/FunctionParser$Context;", "functionMarker", "Lcom/intellij/lang/PsiBuilder$Marker;", "parseParameterOptionalMark", "isParameterName", "allowPropertyNameAsIdentifier", "tokenType", "parameterListElementType", "getParameterListElementType", "isAcceptableLambdaTokenAfterAsync", "Companion", "intellij.javascript.parser"})
public class TypeScriptFunctionParser
extends ES6FunctionParser<TypeScriptParser> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final TokenSet VISIBILITY_MODIFIERS;
    @NotNull
    private static final TokenSet FUNCTION_PARAMETER_MODIFIERS;

    public TypeScriptFunctionParser(@NotNull TypeScriptParser parser) {
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        super((JavaScriptParser)parser);
    }

    @Override
    protected void parseParameterAttributeList() {
        IElementType ahead;
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker attrList = marker;
        if (this.builder.getTokenType() == JSTokenTypes.AT) {
            this.tryParseES7Decorators();
        }
        while (FUNCTION_PARAMETER_MODIFIERS.contains(this.builder.getTokenType()) && this.isIdentifierToken(ahead = this.builder.lookAhead(1))) {
            this.builder.advanceLexer();
        }
        attrList.done(this.getAttributeListElementType());
    }

    @Override
    @NotNull
    public IElementType getParameterType() {
        return BasicTypeScriptStubElementTypes.TYPESCRIPT_PARAMETER;
    }

    @Override
    @NotNull
    protected IElementType getFunctionExpressionElementType() {
        return BasicJavaScriptStubElementTypes.TYPESCRIPT_FUNCTION_EXPRESSION;
    }

    @Override
    @NotNull
    public IElementType getFunctionDeclarationElementType() {
        return BasicJavaScriptStubElementTypes.TYPESCRIPT_FUNCTION;
    }

    @Override
    public boolean parseAttributesList() {
        if (this.builder.getTokenType() == JSTokenTypes.LBRACKET) {
            return false;
        }
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker modifierList = marker;
        boolean hadAttributes = this.tryParseES7Decorators();
        if (hadAttributes && (((TypeScriptParser)this.parser).getStatementParser().isExportDefault() || ((TypeScriptParser)this.parser).getStatementParser().isGlobalModuleExport())) {
            modifierList.done(this.getAttributeListElementType());
            return true;
        }
        while (JSTokenTypes.MODIFIERS.contains(this.builder.getTokenType()) || this.builder.getTokenType() == JSTokenTypes.GET_KEYWORD || this.builder.getTokenType() == JSTokenTypes.SET_KEYWORD || this.builder.getTokenType() == JSTokenTypes.MULT || TypeScriptStatementParser.Companion.isConstEnum(this.builder)) {
            if (this.builder.getTokenType() == JSTokenTypes.DECLARE_KEYWORD) {
                this.builder.putUserData(FunctionParser.methodsEmptinessKey, (Object)FunctionParser.MethodEmptiness.ALWAYS);
            } else if (this.builder.getTokenType() == JSTokenTypes.ASYNC_KEYWORD) {
                this.builder.putUserData(ES6FunctionParser.HAD_ASYNC_MODIFIER_KEY, (Object)true);
            }
            IElementType lookAhead = this.builder.lookAhead(1);
            if (lookAhead == JSTokenTypes.LPAR) break;
            this.builder.advanceLexer();
            if (this.builder.getTokenType() != JSTokenTypes.AT || hadAttributes) continue;
            this.tryParseES7Decorators();
        }
        modifierList.done(this.getAttributeListElementType());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean parseFunctionNoMarker(@NotNull FunctionParser.Context context, @NotNull PsiBuilder.Marker functionMarker) {
        Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
        Intrinsics.checkNotNullParameter((Object)functionMarker, (String)"functionMarker");
        FunctionParser.MethodEmptiness methodsEmptiness = (FunctionParser.MethodEmptiness)((Object)this.builder.getUserData(FunctionParser.methodsEmptinessKey));
        try {
            if (methodsEmptiness == null) {
                this.builder.putUserData(FunctionParser.methodsEmptinessKey, (Object)FunctionParser.MethodEmptiness.POSSIBLY);
            }
            boolean bl = super.parseFunctionNoMarker(context, functionMarker);
            return bl;
        }
        finally {
            this.builder.putUserData(FunctionParser.methodsEmptinessKey, (Object)methodsEmptiness);
        }
    }

    @Override
    public void parseParameterOptionalMark() {
        if (this.builder.getTokenType() == JSTokenTypes.QUEST) {
            this.builder.advanceLexer();
        }
    }

    @Override
    protected boolean isParameterName(boolean allowPropertyNameAsIdentifier, @Nullable IElementType tokenType) {
        if (tokenType == JSTokenTypes.THIS_KEYWORD) {
            return true;
        }
        return super.isParameterName(allowPropertyNameAsIdentifier, tokenType);
    }

    @Override
    @NotNull
    public IElementType getParameterListElementType() {
        return BasicTypeScriptStubElementTypes.TYPESCRIPT_PARAMETER_LIST;
    }

    @Override
    protected boolean isAcceptableLambdaTokenAfterAsync(@Nullable IElementType tokenType) {
        return super.isAcceptableLambdaTokenAfterAsync(tokenType) || tokenType == JSTokenTypes.LT;
    }

    static {
        IElementType[] iElementTypeArray = new IElementType[]{JSTokenTypes.INTERNAL_KEYWORD};
        TokenSet tokenSet = TokenSet.andNot((TokenSet)JSTokenTypes.ACCESS_MODIFIERS, (TokenSet)TokenSet.create((IElementType[])iElementTypeArray));
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"andNot(...)");
        VISIBILITY_MODIFIERS = tokenSet;
        iElementTypeArray = new TokenSet[2];
        iElementTypeArray[0] = VISIBILITY_MODIFIERS;
        IElementType[] iElementTypeArray2 = new IElementType[]{JSTokenTypes.READONLY_KEYWORD, JSTokenTypes.OVERRIDE_KEYWORD};
        iElementTypeArray[1] = TokenSet.create((IElementType[])iElementTypeArray2);
        TokenSet tokenSet2 = TokenSet.orSet((TokenSet[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet2, (String)"orSet(...)");
        FUNCTION_PARAMETER_MODIFIERS = tokenSet2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/lang/javascript/ecmascript6/parsing/TypeScriptFunctionParser$Companion;", "", "<init>", "()V", "VISIBILITY_MODIFIERS", "Lcom/intellij/psi/tree/TokenSet;", "FUNCTION_PARAMETER_MODIFIERS", "intellij.javascript.parser"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

