/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.CommonBundle;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.client.DatabaseSessionClientWithFile;
import com.intellij.database.console.session.DatabaseSessionViewService;
import com.intellij.database.data.types.BaseConversionGraph;
import com.intellij.database.data.types.BaseDomainRegistry;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.GeoHelper;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.TextDomain;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridListener;
import com.intellij.database.datagrid.DataGridSessionClient;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataGridUtilCore;
import com.intellij.database.datagrid.GeoViewerKt;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dbimport.ObjectToTextConverter;
import com.intellij.database.extractors.TextInfo;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.remote.jdbc.GeoWrapper;
import com.intellij.database.remote.jdbc.LobInfo;
import com.intellij.database.run.session.LogView;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.util.Version;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.IconButton;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.content.Content;
import com.intellij.ui.jcef.JBCefBrowser;
import com.intellij.ui.jcef.JBCefBrowserBase;
import com.intellij.ui.jcef.JBCefJSQuery;
import com.intellij.util.Alarm;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.cef.CefSettings;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.handler.CefDisplayHandler;
import org.cef.handler.CefDisplayHandlerAdapter;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefLoadHandlerAdapter;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0007\u0018\u0000 82\u00020\u0001:\u00018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J&\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0014\u0010\u0016\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0014\u0012\u0004\u0012\u00020\u000f0\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0014H\u0002J\u0012\u0010\u0019\u001a\f0\u0014\u00a2\u0006\u0002\b\u001a\u00a2\u0006\u0002\b\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u000fH\u0002J\u0012\u0010\u001d\u001a\u00020\u000f2\b\b\u0001\u0010\u001e\u001a\u00020\u0014H\u0002J\b\u0010\u001f\u001a\u00020\u000fH\u0002J\b\u0010 \u001a\u00020\u000fH\u0002J\b\u0010!\u001a\u00020\u000fH\u0002J\u0010\u0010\"\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\u0014H\u0002JG\u0010$\u001a\t\u0018\u00010%\u00a2\u0006\u0002\b&2\u0006\u0010'\u001a\u00020(2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020,0*2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020+0.2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020,0.H\u0002JH\u00100\u001a\u00020\u00142\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020,0*2\u000e\u0010-\u001a\n\u0012\u0004\u0012\u00020+\u0018\u00010.2\u0012\u00101\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020,0.022\u0006\u0010'\u001a\u00020(H\u0002J\u0006\u00103\u001a\u00020\tJ\u0006\u00104\u001a\u00020\tJ\u0010\u00105\u001a\u00020\u00142\u0006\u00106\u001a\u00020\u0014H\u0002J\b\u00107\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/intellij/database/datagrid/GeoViewer;", "Lcom/intellij/openapi/Disposable;", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "<init>", "(Lcom/intellij/database/datagrid/DataGrid;)V", "bro", "Lcom/intellij/ui/jcef/JBCefBrowser;", "panel", "Ljavax/swing/JComponent;", "alarm", "Lcom/intellij/util/Alarm;", "selecting", "Ljava/util/concurrent/atomic/AtomicInteger;", "loadViewer", "", "selectInTable", "idx", "", "simpleInject", "", "name", "action", "Lkotlin/Function1;", "getDefaultLayer", "getStoredLayer", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/openapi/util/NlsSafe;", "scheduleMapUpdate", "exec", "js", "updateSelection", "viewAll", "updateMap", "reProjectEWkt", "eWkt", "strData", "", "Lorg/jetbrains/annotations/Nullable;", "cvt", "Lcom/intellij/database/dbimport/ObjectToTextConverter;", "data", "Lcom/intellij/database/datagrid/GridModel;", "Lcom/intellij/database/datagrid/GridRow;", "Lcom/intellij/database/datagrid/GridColumn;", "rIdx", "Lcom/intellij/database/datagrid/ModelIndex;", "cIdx", "getRowData", "geoCols", "", "getComponent", "getPreferableFocusComponent", "str", "s", "dispose", "Companion", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nGeoViewer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeoViewer.kt\ncom/intellij/database/datagrid/GeoViewer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,414:1\n1#2:415\n*E\n"})
public final class GeoViewer
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DataGrid grid;
    @NotNull
    private final JBCefBrowser bro;
    @NotNull
    private final JComponent panel;
    @NotNull
    private final Alarm alarm;
    @NotNull
    private final AtomicInteger selecting;
    @NotNull
    private static final Logger LOG;
    private static final String GEO_VIEWER;
    @NotNull
    private static final Key<GeoViewer> GEO_VIEWER_KEY;
    @NotNull
    private static final Regex LON_PATTERN;
    @NotNull
    private static final Regex LAT_PATTERN;

    public GeoViewer(@NotNull DataGrid grid) {
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        this.grid = grid;
        this.bro = new JBCefBrowser();
        this.alarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this);
        this.selecting = new AtomicInteger(0);
        Disposer.register((Disposable)this, (Disposable)((Disposable)this.bro));
        this.bro.getJBCefClient().addDisplayHandler((CefDisplayHandler)new CefDisplayHandlerAdapter(){

            public boolean onConsoleMessage(CefBrowser browser, CefSettings.LogSeverity level, String message, String source, int line) {
                Intrinsics.checkNotNullParameter((Object)browser, (String)"browser");
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                LOG.warn(message);
                return true;
            }
        }, this.bro.getCefBrowser());
        JComponent jComponent = this.bro.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        this.panel = jComponent;
        this.loadViewer();
        final String injection = StringsKt.trimIndent((String)("\n      window.dg = {\n        " + this.simpleInject("selectInTable", (Function1<? super String, Unit>)((Function1)arg_0 -> GeoViewer._init_$lambda$0(this, arg_0))) + ",\n        " + this.simpleInject("storeLayer", (Function1<? super String, Unit>)((Function1)arg_0 -> GeoViewer._init_$lambda$1(this, arg_0))) + ",\n      };\n      document.getElementById(\"mapid\").style[\"background-color\"] = \"" + ColorUtil.toHtmlColor((Color)EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground()) + "\";\n    "));
        this.bro.getJBCefClient().addLoadHandler((CefLoadHandler)new CefLoadHandlerAdapter(){

            public void onLoadEnd(CefBrowser browser, CefFrame frame, int httpStatusCode) {
                Intrinsics.checkNotNullParameter((Object)browser, (String)"browser");
                Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
                if (!Intrinsics.areEqual((Object)browser.getURL(), (Object)"about:blank")) {
                    this.exec(injection);
                    this.scheduleMapUpdate();
                }
            }
        }, this.bro.getCefBrowser());
        this.grid.addDataGridListener(new DataGridListener(){

            public void onSelectionChanged(DataGrid dataGrid) {
                Intrinsics.checkNotNullParameter((Object)dataGrid, (String)"dataGrid");
                if (selecting.get() == 0) {
                    this.updateSelection();
                }
            }

            public void onContentChanged(DataGrid dataGrid, GridRequestSource.RequestPlace place) {
                Intrinsics.checkNotNullParameter((Object)dataGrid, (String)"dataGrid");
                this.scheduleMapUpdate();
            }
        }, (Disposable)this);
    }

    private final void loadViewer() {
        try {
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("resources/geo-viewer.html");
            if (inputStream == null) {
                throw new AssertionError((Object)"No geo-viewer");
            }
            InputStream stream = inputStream;
            String string = FileUtil.loadTextAndClose((InputStream)stream);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"loadTextAndClose(...)");
            CharSequence charSequence = string;
            Regex regex = new Regex("(?<=let defaultLayer = )null");
            String string2 = this.str(this.getStoredLayer());
            this.bro.loadHTML(regex.replace(charSequence, string2), "geo-viewer.html");
        }
        catch (Exception e) {
            this.bro.loadHTML("<html><body><h1>fail:" + e.getMessage() + "</h1></body></html>");
        }
    }

    private final void selectInTable(int idx) {
        if (idx == -1) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> GeoViewer.selectInTable$lambda$2(this, idx));
    }

    private final String simpleInject(String name2, Function1<? super String, Unit> action) {
        JBCefBrowser jBCefBrowser = this.bro;
        Intrinsics.checkNotNull((Object)jBCefBrowser, (String)"null cannot be cast to non-null type com.intellij.ui.jcef.JBCefBrowserBase");
        JBCefJSQuery jBCefJSQuery = JBCefJSQuery.create((JBCefBrowserBase)((JBCefBrowserBase)jBCefBrowser));
        Intrinsics.checkNotNullExpressionValue((Object)jBCefJSQuery, (String)"create(...)");
        JBCefJSQuery handler2 = jBCefJSQuery;
        handler2.addHandler(arg_0 -> GeoViewer.simpleInject$lambda$4(arg_0 -> GeoViewer.simpleInject$lambda$3(action, arg_0), arg_0));
        return name2 + ": function(arg) {" + handler2.inject("arg") + "}";
    }

    private final String getDefaultLayer() {
        return "CartoDB." + (UIUtil.isUnderDarcula() ? "DarkMatter" : "Positron");
    }

    private final String getStoredLayer() {
        String string = PropertiesComponent.getInstance().getValue("GeoViewer.layer", this.getDefaultLayer());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
        return string;
    }

    private final void scheduleMapUpdate() {
        this.alarm.cancelAllRequests();
        this.alarm.addRequest(this::updateMap, 300);
    }

    private final void exec(@Language(value="JavaScript") String js) {
        this.bro.getCefBrowser().executeJavaScript(js, this.getClass().getName(), 0);
    }

    private final void updateSelection() {
        JBIterable jBIterable = this.grid.getSelectionModel().getSelectedRows().asIterable();
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"asIterable(...)");
        String selection = CollectionsKt.joinToString$default((Iterable)((Iterable)jBIterable), null, null, null, (int)0, null, GeoViewer::updateSelection$lambda$5, (int)31, null);
        this.exec("selectFeaturesFromTable([" + selection + "])");
        if (((CharSequence)selection).length() == 0) {
            this.viewAll();
        }
    }

    private final void viewAll() {
        this.exec("viewAll(true)");
    }

    private final void updateMap() {
        this.exec("clearFeatures()");
        GridModel gridModel = this.grid.getDataModel(DataAccessType.DATABASE_DATA);
        Intrinsics.checkNotNullExpressionValue((Object)gridModel, (String)"getDataModel(...)");
        GridModel data = gridModel;
        Dbms dbms = DataGridUtil.getDbms(this.grid);
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Dbms dbms2 = dbms;
        GeoHelper helper = (GeoHelper)GeoHelper.EP.forDbms(dbms2);
        ObjectToTextConverter cvt = new ObjectToTextConverter(BaseConversionGraph.get((CoreGrid)((CoreGrid)this.grid)));
        JBIterable jBIterable = Companion.collectGeoColumns(this.grid).collect();
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"collect(...)");
        JBIterable geoCols = jBIterable;
        JBIterable jBIterable2 = Companion.collectCoordinateColumns(this.grid).collect();
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"collect(...)");
        JBIterable coordCols = jBIterable2;
        Set set = geoCols.append((Iterable)coordCols.flatten(arg_0 -> GeoViewer.updateMap$lambda$7(GeoViewer::updateMap$lambda$6, arg_0))).toSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"toSet(...)");
        Set excludeFromData = set;
        if (!((Collection)excludeFromData).isEmpty()) {
            for (ModelIndex rIdx : this.grid.getVisibleRows().asIterable()) {
                String rowData = this.getRowData((GridModel<GridRow, GridColumn>)data, (ModelIndex<GridRow>)rIdx, excludeFromData, cvt);
                for (ModelIndex cIdx : geoCols) {
                    String string;
                    GridColumn column2;
                    if ((GridColumn)data.getColumn(cIdx) == null) continue;
                    String typeName = column2.getTypeName();
                    boolean geoColumn = typeName != null && helper.isGeoType(typeName);
                    Object cellVal = data.getValueAt(rIdx, cIdx);
                    if (geoColumn) {
                        Intrinsics.checkNotNull((Object)helper);
                        string = GeoViewer.Companion.toWkt(cellVal, helper, column2);
                    } else {
                        Object object = cvt.convert(cellVal, (ColumnDescriptor)column2);
                        string = object != null ? object.toString() : null;
                    }
                    if (string == null) continue;
                    String wkt = string;
                    boolean bl = false;
                    String rWkt = this.reProjectEWkt(wkt);
                    this.exec("addWktFeature(" + this.str(rWkt) + ", " + rIdx.value + ", [" + rowData + "])");
                }
                for (Couple coords : Companion.collectCoordinateColumns(this.grid)) {
                    Object lat;
                    Object lon;
                    Intrinsics.checkNotNull((Object)rIdx);
                    Object object = coords.first;
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first");
                    if (this.strData(cvt, (GridModel<GridRow, GridColumn>)data, (ModelIndex<GridRow>)rIdx, (ModelIndex<GridColumn>)((ModelIndex)object)) == null) continue;
                    Object object2 = coords.second;
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"second");
                    if (this.strData(cvt, (GridModel<GridRow, GridColumn>)data, (ModelIndex<GridRow>)rIdx, (ModelIndex<GridColumn>)((ModelIndex)object2)) == null) continue;
                    this.exec("addWktFeature(" + this.str("POINT (" + lon + " " + lat + ")") + ", " + rIdx.value + ", [" + rowData + "])");
                }
            }
        }
        this.updateSelection();
    }

    private final String reProjectEWkt(String eWkt) {
        String sridText;
        MatchResult matchResult = Regex.find$default((Regex)GeoViewerKt.access$getSridPattern$p(), (CharSequence)eWkt, (int)0, (int)2, null);
        if (matchResult == null) {
            return eWkt;
        }
        MatchResult m = matchResult;
        MatchGroup matchGroup = m.getGroups().get(1);
        String string = sridText = matchGroup != null ? matchGroup.getValue() : null;
        if (sridText == null || Intrinsics.areEqual((Object)sridText, (Object)"4326")) {
            return eWkt;
        }
        Integer n = StringsKt.toIntOrNull((String)sridText);
        if (n == null) {
            return eWkt;
        }
        int srid = n;
        String string2 = eWkt.substring(m.getRange().getEndInclusive() + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String string3 = GeoHelper.reProjectWkt((String)string2, (int)srid);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"reProjectWkt(...)");
        return string3;
    }

    private final Object strData(ObjectToTextConverter cvt, GridModel<GridRow, GridColumn> data, ModelIndex<GridRow> rIdx, ModelIndex<GridColumn> cIdx) {
        Object object;
        GridColumn gridColumn = (GridColumn)data.getColumn(cIdx);
        if (gridColumn != null) {
            GridColumn it = gridColumn;
            boolean bl = false;
            object = cvt.convert(data.getValueAt(rIdx, cIdx), (ColumnDescriptor)it);
        } else {
            object = null;
        }
        return object;
    }

    private final String getRowData(GridModel<GridRow, GridColumn> data, ModelIndex<GridRow> rIdx, Set<? extends ModelIndex<GridColumn>> geoCols, ObjectToTextConverter cvt) {
        JBIterable jBIterable = this.grid.getVisibleColumns().asIterable().filter(arg_0 -> GeoViewer.getRowData$lambda$11(arg_0 -> GeoViewer.getRowData$lambda$10(geoCols, arg_0), arg_0)).filterMap(arg_0 -> GeoViewer.getRowData$lambda$14(arg_0 -> GeoViewer.getRowData$lambda$13(data, cvt, rIdx, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filterMap(...)");
        String rowData = CollectionsKt.joinToString$default((Iterable)((Iterable)jBIterable), null, null, null, (int)0, null, arg_0 -> GeoViewer.getRowData$lambda$16(this, arg_0), (int)31, null);
        return rowData;
    }

    @NotNull
    public final JComponent getComponent() {
        return this.panel;
    }

    @NotNull
    public final JComponent getPreferableFocusComponent() {
        return this.panel;
    }

    private final String str(String s) {
        String string = StringUtil.wrapWithDoubleQuote((String)StringUtil.escapeStringCharacters((String)s));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"wrapWithDoubleQuote(...)");
        return string;
    }

    public void dispose() {
    }

    private static final Unit _init_$lambda$0(GeoViewer this$0, String it) {
        this$0.selectInTable(StringUtil.parseInt((String)it, (int)-1));
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(GeoViewer this$0, String it) {
        PropertiesComponent.getInstance().setValue("GeoViewer.layer", it, this$0.getDefaultLayer());
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void selectInTable$lambda$2(GeoViewer this$0, int $idx) {
        this$0.selecting.incrementAndGet();
        try {
            this$0.grid.getSelectionModel().setRowSelection(ModelIndex.forRow((CoreGrid)((CoreGrid)this$0.grid), (int)$idx), true);
        }
        finally {
            this$0.selecting.decrementAndGet();
        }
    }

    private static final JBCefJSQuery.Response simpleInject$lambda$3(Function1 $action, String it) {
        $action.invoke((Object)it);
        return null;
    }

    private static final JBCefJSQuery.Response simpleInject$lambda$4(Function1 $tmp0, Object p0) {
        return (JBCefJSQuery.Response)$tmp0.invoke(p0);
    }

    private static final CharSequence updateSelection$lambda$5(ModelIndex it) {
        return String.valueOf(it.value);
    }

    private static final Iterable updateMap$lambda$6(Couple it) {
        Object[] objectArray = new ModelIndex[]{it.first, it.second};
        return (Iterable)JBIterable.of((Object[])objectArray);
    }

    private static final Iterable updateMap$lambda$7(Function1 $tmp0, Object p0) {
        return (Iterable)$tmp0.invoke(p0);
    }

    private static final boolean getRowData$lambda$10(Set $geoCols, ModelIndex it) {
        return !$geoCols.contains(it);
    }

    private static final boolean getRowData$lambda$11(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Pair getRowData$lambda$13(GridModel $data, ObjectToTextConverter $cvt, ModelIndex $rIdx, ModelIndex it) {
        Pair pair;
        GridColumn gridColumn = (GridColumn)$data.getColumn(it);
        if (gridColumn != null) {
            GridColumn desc = gridColumn;
            boolean bl = false;
            Object object = $cvt.convert($data.getValueAt($rIdx, it), (ColumnDescriptor)desc);
            pair = new Pair((Object)desc.getName(), (Object)(object != null ? object.toString() : null));
        } else {
            pair = null;
        }
        return pair;
    }

    private static final Pair getRowData$lambda$14(Function1 $tmp0, Object p0) {
        return (Pair)$tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final CharSequence getRowData$lambda$16(GeoViewer this$0, Pair it) {
        String string;
        Object object = it;
        if (object == null || (object = (String)object.getFirst()) == null) {
            object = "";
        }
        String string2 = this$0.str((String)object);
        Object object2 = it;
        if (object2 != null && (object2 = (String)object2.getSecond()) != null) {
            void v;
            Object object3 = object2;
            String string3 = string2;
            boolean bl = false;
            string = this$0.str((String)v);
            string2 = string3;
        } else {
            string = null;
        }
        return "[" + string2 + ", " + string + "]";
    }

    @JvmStatic
    public static final void close(@NotNull AnActionEvent e) {
        Companion.close(e);
    }

    @JvmStatic
    @Nullable
    public static final Content getViewer(@Nullable LogView<?> $this$getViewer) {
        return Companion.getViewer($this$getViewer);
    }

    @JvmStatic
    @Nullable
    public static final LogView<DatabaseSessionClientWithFile> getLogView(@NotNull AnActionEvent e) {
        return Companion.getLogView(e);
    }

    @JvmStatic
    public static final void show(@NotNull AnActionEvent e) {
        Companion.show(e);
    }

    @JvmStatic
    @NotNull
    public static final JBIterable<ModelIndex<GridColumn>> collectGeoColumns(@NotNull DataGrid grid) {
        return Companion.collectGeoColumns(grid);
    }

    @JvmStatic
    @NotNull
    public static final JBIterable<Couple<ModelIndex<GridColumn>>> collectCoordinateColumns(@NotNull DataGrid grid) {
        return Companion.collectCoordinateColumns(grid);
    }

    @JvmStatic
    private static final boolean isGeoColumn(GeoHelper helper, DomainRegistry registry, ObjectToTextConverter cvt, GridModel<GridRow, GridColumn> data, ModelIndex<GridColumn> cIdx) {
        return GeoViewer.Companion.isGeoColumn(helper, registry, cvt, (GridModel<GridRow, GridColumn>)data, (ModelIndex<GridColumn>)cIdx);
    }

    @JvmStatic
    private static final boolean isPossiblyWkt(ObjectToTextConverter cvt, GridModel<GridRow, GridColumn> data, ModelIndex<GridColumn> cIdx) {
        return GeoViewer.Companion.isPossiblyWkt(cvt, (GridModel<GridRow, GridColumn>)data, (ModelIndex<GridColumn>)cIdx);
    }

    @JvmStatic
    @TestOnly
    @Nullable
    public static final String toWkt(@NotNull DataGrid grid, @NotNull ModelIndex<GridColumn> cIdx, @NotNull ModelIndex<GridRow> rIdx) {
        return Companion.toWkt(grid, cIdx, rIdx);
    }

    @JvmStatic
    private static final String toWkt(Object cellVal, GeoHelper helper, GridColumn column2) {
        return GeoViewer.Companion.toWkt(cellVal, helper, column2);
    }

    static {
        Logger logger = Logger.getInstance(GeoViewer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        GEO_VIEWER = GeoViewer.class.getSimpleName();
        Key key = Key.create((String)GEO_VIEWER);
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        GEO_VIEWER_KEY = key;
        LON_PATTERN = new Regex(".*(lon(?:g(?:itude)?)?|(?<=\\b|_)x(?=\\b|_)).*", RegexOption.IGNORE_CASE);
        LAT_PATTERN = new Regex(".*(lat(?:itude)?|(?<=\\b|_)y(?=\\b|_)).*", RegexOption.IGNORE_CASE);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0014\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\b\u0012\u0002\b\u0003\u0018\u00010\u0013H\u0007J\u0018\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00132\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u001c\u0010\u0017\u001a\u00020\u00122\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001c\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0\u001e0\u001d2\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\"\u0010#\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0\u001e0$0\u001d2\u0006\u0010\u0019\u001a\u00020\u001aH\u0007JD\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020,2\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020\u001f0.2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0003J2\u00101\u001a\u00020&2\u0006\u0010+\u001a\u00020,2\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020\u001f0.2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0003J.\u00102\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0019\u001a\u00020\u001a2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\f\u00103\u001a\b\u0012\u0004\u0012\u00020/0\u001eH\u0007J&\u00102\u001a\u0004\u0018\u00010\b2\b\u00104\u001a\u0004\u0018\u00010\u00012\u0006\u0010'\u001a\u00020(2\b\u00105\u001a\u0004\u0018\u00010\u001fH\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\n\u001a\u0015\u0012\f\u0012\n \t*\u0004\u0018\u00010\f0\f0\u000b\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/intellij/database/datagrid/GeoViewer$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "GEO_VIEWER", "", "kotlin.jvm.PlatformType", "GEO_VIEWER_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/database/datagrid/GeoViewer;", "close", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getViewer", "Lcom/intellij/ui/content/Content;", "Lcom/intellij/database/run/session/LogView;", "getLogView", "Lcom/intellij/database/console/client/DatabaseSessionClientWithFile;", "show", "addGeoViewer", "view", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "getClient", "collectGeoColumns", "Lcom/intellij/util/containers/JBIterable;", "Lcom/intellij/database/datagrid/ModelIndex;", "Lcom/intellij/database/datagrid/GridColumn;", "LON_PATTERN", "Lkotlin/text/Regex;", "LAT_PATTERN", "collectCoordinateColumns", "Lcom/intellij/openapi/util/Couple;", "isGeoColumn", "", "helper", "Lcom/intellij/database/data/types/GeoHelper;", "registry", "Lcom/intellij/database/data/types/DomainRegistry;", "cvt", "Lcom/intellij/database/dbimport/ObjectToTextConverter;", "data", "Lcom/intellij/database/datagrid/GridModel;", "Lcom/intellij/database/datagrid/GridRow;", "cIdx", "isPossiblyWkt", "toWkt", "rIdx", "cellVal", "column", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nGeoViewer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeoViewer.kt\ncom/intellij/database/datagrid/GeoViewer$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,414:1\n1#2:415\n382#3,7:416\n*S KotlinDebug\n*F\n+ 1 GeoViewer.kt\ncom/intellij/database/datagrid/GeoViewer$Companion\n*L\n342#1:416,7\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void close(@NotNull AnActionEvent e) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Content view = this.getLogView(e);
                Content content = view;
                if (content == null || (content = this.getViewer((LogView<?>)content)) == null) break block0;
                Content content2 = content;
                boolean bl = false;
                view.getUi().removeContent(content2, true);
            }
        }

        @JvmStatic
        @Nullable
        public final Content getViewer(@Nullable LogView<?> $this$getViewer) {
            Content content;
            LogView<?> logView = $this$getViewer;
            if (logView != null) {
                LogView<?> $this$getViewer_u24lambda_u241 = logView;
                boolean bl = false;
                content = $this$getViewer_u24lambda_u241.getUi().findContent(GEO_VIEWER);
            } else {
                content = null;
            }
            return content;
        }

        @JvmStatic
        @Nullable
        public final LogView<DatabaseSessionClientWithFile> getLogView(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            DataGrid dataGrid = GridUtil.getDataGrid((DataContext)e.getDataContext());
            if (dataGrid == null) {
                return null;
            }
            DataGrid grid = dataGrid;
            DatabaseSessionClientWithFile databaseSessionClientWithFile = this.getClient(grid, e);
            if (databaseSessionClientWithFile == null) {
                return null;
            }
            DatabaseSessionClientWithFile client = databaseSessionClientWithFile;
            return DatabaseSessionViewService.Companion.getInstance().getClientViewIfAny(client);
        }

        @JvmStatic
        public final void show(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            DataGrid dataGrid = GridUtil.getDataGrid((DataContext)e.getDataContext());
            if (dataGrid == null) {
                return;
            }
            DataGrid grid = dataGrid;
            LogView<DatabaseSessionClientWithFile> view = this.getLogView(e);
            if (view != null) {
                Content content = this.getViewer(view);
                if (content != null) {
                    GeoViewer prevViewer;
                    Content content2 = content;
                    boolean bl = false;
                    GeoViewer geoViewer = prevViewer = (GeoViewer)content2.getUserData(GEO_VIEWER_KEY);
                    if (!Intrinsics.areEqual((Object)(geoViewer != null ? geoViewer.grid : null), (Object)grid)) {
                        view.getUi().removeContent(content2, true);
                    } else {
                        view.getUi().selectAndFocus(content2, false, false);
                        return;
                    }
                }
                Content content3 = this.addGeoViewer(view, grid);
                view.show(true, false);
                ActionCallback actionCallback = view.getUi().selectAndFocus(content3, false, false);
                Intrinsics.checkNotNull((Object)actionCallback);
            } else {
                ComponentPopupBuilder componentPopupBuilder;
                GeoViewer viewer = new GeoViewer(grid);
                ComponentPopupBuilder $this$show_u24lambda_u243 = componentPopupBuilder = JBPopupFactory.getInstance().createComponentPopupBuilder(viewer.getComponent(), viewer.getPreferableFocusComponent());
                boolean bl = false;
                $this$show_u24lambda_u243.setCancelOnClickOutside(false);
                $this$show_u24lambda_u243.setCancelOnWindowDeactivation(false);
                $this$show_u24lambda_u243.setTitle(DatabaseBundle.message((String)"geo.viewer", (Object[])new Object[0]));
                $this$show_u24lambda_u243.setResizable(true);
                $this$show_u24lambda_u243.setMovable(true);
                $this$show_u24lambda_u243.setRequestFocus(true);
                $this$show_u24lambda_u243.setCancelButton(new IconButton(CommonBundle.message((String)"action.text.close", (Object[])new Object[0]), AllIcons.Actions.Close, AllIcons.Actions.CloseHovered));
                $this$show_u24lambda_u243.addListener(new JBPopupListener(viewer){
                    final /* synthetic */ GeoViewer $viewer;
                    {
                        this.$viewer = $viewer;
                    }

                    public void onClosed(LightweightWindowEvent event) {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        Disposer.dispose((Disposable)this.$viewer);
                    }
                });
                componentPopupBuilder.createPopup().showInBestPositionFor(e.getDataContext());
            }
        }

        private final Content addGeoViewer(LogView<?> view, DataGrid grid) {
            GeoViewer viewer = new GeoViewer(grid);
            Content content = view.getUi().createContent(GEO_VIEWER, viewer.getComponent(), DatabaseBundle.message((String)"geo.viewer", (Object[])new Object[0]), AllIcons.Nodes.PpWeb, viewer.getPreferableFocusComponent());
            Intrinsics.checkNotNullExpressionValue((Object)content, (String)"createContent(...)");
            Content content2 = content;
            Disposer.register((Disposable)((Disposable)content2), (Disposable)viewer);
            Disposer.register((Disposable)((Disposable)grid), () -> Companion.addGeoViewer$lambda$4(view, content2));
            content2.putUserData(GEO_VIEWER_KEY, (Object)viewer);
            view.getUi().addContent(content2, 0, PlaceInGrid.right, false);
            return content2;
        }

        private final DatabaseSessionClientWithFile getClient(DataGrid grid, AnActionEvent e) {
            DataGridSessionClient dataGridSessionClient = DataGridUtil.getDataGridClient(grid);
            return dataGridSessionClient != null ? (DatabaseSessionClientWithFile)dataGridSessionClient : (DatabaseSessionClientWithFile)JdbcConsole.findConsole(e);
        }

        @JvmStatic
        @NotNull
        public final JBIterable<ModelIndex<GridColumn>> collectGeoColumns(@NotNull DataGrid grid) {
            Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
            GridModel gridModel = grid.getDataModel(DataAccessType.DATABASE_DATA);
            Intrinsics.checkNotNullExpressionValue((Object)gridModel, (String)"getDataModel(...)");
            GridModel data = gridModel;
            Dbms dbms = DataGridUtilCore.getDbms((CoreGrid)((CoreGrid)grid));
            Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
            Dbms dbms2 = dbms;
            DbDataSource dbDataSource = DataGridUtilCore.getDatabaseSystem((CoreGrid)((CoreGrid)grid));
            Version version = dbDataSource != null ? dbDataSource.getVersion() : null;
            DomainRegistry domainRegistry = BaseDomainRegistry.get((Dbms)dbms2, (Version)version);
            Intrinsics.checkNotNullExpressionValue((Object)domainRegistry, (String)"get(...)");
            DomainRegistry registry = domainRegistry;
            ObjectToTextConverter cvt = new ObjectToTextConverter(BaseConversionGraph.get((CoreGrid)((CoreGrid)grid)));
            GeoHelper helper = (GeoHelper)GeoHelper.EP.forDbms(dbms2);
            JBIterable jBIterable = grid.getVisibleColumns().asIterable().filter(arg_0 -> Companion.collectGeoColumns$lambda$6(arg_0 -> Companion.collectGeoColumns$lambda$5(helper, registry, cvt, data, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
            return jBIterable;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final JBIterable<Couple<ModelIndex<GridColumn>>> collectCoordinateColumns(@NotNull DataGrid grid) {
            Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
            GridModel gridModel = grid.getDataModel(DataAccessType.DATABASE_DATA);
            Intrinsics.checkNotNullExpressionValue((Object)gridModel, (String)"getDataModel(...)");
            GridModel data = gridModel;
            LinkedHashMap pairs = new LinkedHashMap();
            for (ModelIndex idx : grid.getVisibleColumns().asIterable()) {
                void $this$getOrPut$iv;
                Object object;
                Object it;
                block10: {
                    block9: {
                        Pair pair;
                        GridColumn column2;
                        if ((GridColumn)data.getColumn(idx) == null) continue;
                        Regex regex = LON_PATTERN;
                        String string = column2.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        MatchResult matchResult = regex.matchEntire((CharSequence)string);
                        if (matchResult != null) {
                            it = matchResult;
                            boolean bl = false;
                            pair = new Pair(it, (Object)true);
                        } else {
                            MatchResult it2;
                            Regex regex2 = LAT_PATTERN;
                            String string2 = column2.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                            if (regex2.matchEntire((CharSequence)string2) == null) continue;
                            boolean bl = false;
                            pair = new Pair((Object)it2, (Object)false);
                        }
                        Pair pair2 = pair;
                        MatchResult mr = (MatchResult)pair2.component1();
                        boolean lon = (Boolean)pair2.component2();
                        object = mr.getGroups().get(1);
                        if (object == null || (object = object.getRange()) == null) break block9;
                        Object it3 = object;
                        boolean bl = false;
                        String $this$collectCoordinateColumns_u24lambda_u2410_u24lambda_u249 = column2.getName();
                        boolean bl2 = false;
                        Intrinsics.checkNotNull((Object)$this$collectCoordinateColumns_u24lambda_u2410_u24lambda_u249);
                        String string3 = $this$collectCoordinateColumns_u24lambda_u2410_u24lambda_u249.substring(0, it3.getFirst());
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                        String string4 = $this$collectCoordinateColumns_u24lambda_u2410_u24lambda_u249.substring(it3.getLast() + 1);
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                        String string5 = string3 + string4;
                        object = string5;
                        if (string5 != null) break block10;
                    }
                    object = "coords";
                }
                Object group = object;
                it = pairs;
                Object key$iv = group;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    ModelIndex[] answer$iv = new ModelIndex[2];
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    v11 = answer$iv;
                } else {
                    v11 = value$iv;
                }
                ((ModelIndex[])v11)[lon ? 0 : 1] = idx;
            }
            JBIterable jBIterable = JBIterable.from((Iterable)pairs.values()).filterMap(arg_0 -> Companion.collectCoordinateColumns$lambda$13(Companion::collectCoordinateColumns$lambda$12, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filterMap(...)");
            return jBIterable;
        }

        @JvmStatic
        private final boolean isGeoColumn(GeoHelper helper, DomainRegistry registry, ObjectToTextConverter cvt, GridModel<GridRow, GridColumn> data, ModelIndex<GridColumn> cIdx) {
            GridColumn gridColumn = (GridColumn)data.getColumn(cIdx);
            if (gridColumn != null) {
                Domain domain;
                GridColumn col = gridColumn;
                boolean bl = false;
                String typeName = col.getTypeName();
                if (typeName != null && helper.isGeoType(typeName)) {
                    return true;
                }
                DomainRegistry domainRegistry = registry;
                Domain domain2 = domain = domainRegistry != null ? domainRegistry.getDomain((ColumnDescriptor)col) : null;
                if (domain instanceof TextDomain || domain == null) {
                    return Companion.isPossiblyWkt(cvt, data, cIdx);
                }
            }
            return false;
        }

        @JvmStatic
        private final boolean isPossiblyWkt(ObjectToTextConverter cvt, GridModel<GridRow, GridColumn> data, ModelIndex<GridColumn> cIdx) {
            String string;
            Regex checker = new Regex("^(?:SRID\\s*=\\s*\\d+\\s*;\\s*)?(?:EMPTY|(?:POINT|LINESTRING|LINEARRING|POLYGON|MULTIPOINT|MULTILINESTRING|MULTIPOLYGON|GEOMETRYCOLLECTION|CIRCLE)Z?M?\\s*\\()");
            GridColumn gridColumn = (GridColumn)data.getColumn(cIdx);
            if (gridColumn == null) {
                return false;
            }
            GridColumn col = gridColumn;
            Object object = data.getRowIndices().asIterable().filter(arg_0 -> Companion.isPossiblyWkt$lambda$16(Companion::isPossiblyWkt$lambda$15, arg_0)).filterMap(arg_0 -> Companion.isPossiblyWkt$lambda$18(arg_0 -> Companion.isPossiblyWkt$lambda$17(cvt, data, cIdx, col, arg_0), arg_0)).first();
            if (object == null || (string = object.toString()) == null) {
                return false;
            }
            String value = string;
            return Regex.find$default((Regex)checker, (CharSequence)value, (int)0, (int)2, null) != null;
        }

        @JvmStatic
        @TestOnly
        @Nullable
        public final String toWkt(@NotNull DataGrid grid, @NotNull ModelIndex<GridColumn> cIdx, @NotNull ModelIndex<GridRow> rIdx) {
            Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
            Intrinsics.checkNotNullParameter(cIdx, (String)"cIdx");
            Intrinsics.checkNotNullParameter(rIdx, (String)"rIdx");
            Dbms dbms = DataGridUtil.getDbms(grid);
            Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
            Dbms dbms2 = dbms;
            GridModel gridModel = grid.getDataModel(DataAccessType.DATABASE_DATA);
            Intrinsics.checkNotNullExpressionValue((Object)gridModel, (String)"getDataModel(...)");
            GridModel data = gridModel;
            Object cellVal = data.getValueAt(rIdx, cIdx);
            GridColumn column2 = (GridColumn)data.getColumn(cIdx);
            Object object = GeoHelper.EP.forDbms(dbms2);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"forDbms(...)");
            return this.toWkt(cellVal, (GeoHelper)object, column2);
        }

        @JvmStatic
        private final String toWkt(Object cellVal, GeoHelper helper, GridColumn column2) {
            Object object = cellVal;
            return object == null ? null : (object instanceof TextInfo ? this.toWkt(((TextInfo)cellVal).text, helper, column2) : (object instanceof LobInfo.ClobInfo ? (((LobInfo.ClobInfo)cellVal).isTruncated() ? null : this.toWkt(((LobInfo.ClobInfo)cellVal).data, helper, column2)) : (object instanceof LobInfo.BlobInfo ? (((LobInfo.BlobInfo)cellVal).isTruncated() ? null : this.toWkt(((LobInfo.BlobInfo)cellVal).data, helper, column2)) : (object instanceof GeoWrapper ? ((GeoWrapper)cellVal).getWkt() : helper.extractGeometryAsWkt(cellVal, column2)))));
        }

        private static final void addGeoViewer$lambda$4(LogView $view, Content $content) {
            $view.getUi().removeContent($content, true);
        }

        private static final boolean collectGeoColumns$lambda$5(GeoHelper $helper, DomainRegistry $registry, ObjectToTextConverter $cvt, GridModel $data, ModelIndex cIdx) {
            Intrinsics.checkNotNull((Object)$helper);
            Intrinsics.checkNotNull((Object)cIdx);
            return Companion.isGeoColumn($helper, $registry, $cvt, (GridModel<GridRow, GridColumn>)$data, (ModelIndex<GridColumn>)cIdx);
        }

        private static final boolean collectGeoColumns$lambda$6(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final Couple collectCoordinateColumns$lambda$12(ModelIndex[] indexes) {
            ModelIndex modelIndex = indexes[0];
            if (modelIndex == null) {
                return null;
            }
            ModelIndex lon = modelIndex;
            ModelIndex modelIndex2 = indexes[1];
            if (modelIndex2 == null) {
                return null;
            }
            ModelIndex lat = modelIndex2;
            return Couple.of((Object)lon, (Object)lat);
        }

        private static final Couple collectCoordinateColumns$lambda$13(Function1 $tmp0, Object p0) {
            return (Couple)$tmp0.invoke(p0);
        }

        private static final boolean isPossiblyWkt$lambda$15(ModelIndex it) {
            return it != null;
        }

        private static final boolean isPossiblyWkt$lambda$16(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final Object isPossiblyWkt$lambda$17(ObjectToTextConverter $cvt, GridModel $data, ModelIndex $cIdx, GridColumn $col, ModelIndex it) {
            return $cvt.convert($data.getValueAt(it, $cIdx), (ColumnDescriptor)$col);
        }

        private static final Object isPossiblyWkt$lambda$18(Function1 $tmp0, Object p0) {
            return $tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

