/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mongo.translator.tree_creator.builder;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dialects.mongo.translator.MongoToDatabaseScriptTranslator;
import com.intellij.database.dialects.mongo.translator.tree.MongoIdentifier;
import com.intellij.database.dialects.mongo.translator.tree.query.select.from.IMongoFromExpr;
import com.intellij.database.dialects.mongo.translator.tree.query.select.from.IMongoTableFromExpr;
import com.intellij.database.dialects.mongo.translator.tree.query.select.from.MongoJoin;
import com.intellij.database.dialects.mongo.translator.tree.query.select.from.MongoJoinCondition;
import com.intellij.database.dialects.mongo.translator.tree_creator.builder.IMongoJoinBuilder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlJoinConditionClause;
import com.intellij.sql.psi.SqlJoinExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0013\u001a\u00020\u000eH\u0016J\u0010\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0010H\u0016J\u0010\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0012H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0012H\u0002J \u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/database/dialects/mongo/translator/tree_creator/builder/MongoJoinBuilder;", "Lcom/intellij/database/dialects/mongo/translator/tree_creator/builder/IMongoJoinBuilder;", "o", "Lcom/intellij/sql/psi/SqlJoinExpression;", "root", "Lcom/intellij/sql/psi/SqlElement;", "<init>", "(Lcom/intellij/sql/psi/SqlJoinExpression;Lcom/intellij/sql/psi/SqlElement;)V", "getO", "()Lcom/intellij/sql/psi/SqlJoinExpression;", "getRoot", "()Lcom/intellij/sql/psi/SqlElement;", "fromExprs", "", "Lcom/intellij/database/dialects/mongo/translator/tree/query/select/from/IMongoFromExpr;", "condition", "Lcom/intellij/database/dialects/mongo/translator/tree/query/select/from/MongoJoinCondition;", "opTokens", "", "build", "fromExpr", "v", "opToken", "convertOpCompositeToken", "", "compositeOpToken", "handleJoinCondition", "leftFromExpr", "rightTableFromExpr", "Lcom/intellij/database/dialects/mongo/translator/tree/query/select/from/IMongoTableFromExpr;", "intellij.database.dialects.mongo"})
@SourceDebugExtension(value={"SMAP\nMongoJoinBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MongoJoinBuilder.kt\ncom/intellij/database/dialects/mongo/translator/tree_creator/builder/MongoJoinBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,89:1\n1#2:90\n1563#3:91\n1634#3,3:92\n*S KotlinDebug\n*F\n+ 1 MongoJoinBuilder.kt\ncom/intellij/database/dialects/mongo/translator/tree_creator/builder/MongoJoinBuilder\n*L\n69#1:91\n69#1:92,3\n*E\n"})
public final class MongoJoinBuilder
implements IMongoJoinBuilder {
    @NotNull
    private final SqlJoinExpression o;
    @NotNull
    private final SqlElement root;
    @NotNull
    private List<IMongoFromExpr> fromExprs;
    @Nullable
    private MongoJoinCondition condition;
    @NotNull
    private final List<String> opTokens;

    public MongoJoinBuilder(@NotNull SqlJoinExpression o, @NotNull SqlElement root) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.o = o;
        this.root = root;
        this.fromExprs = new ArrayList();
        this.opTokens = new ArrayList();
    }

    @NotNull
    public final SqlJoinExpression getO() {
        return this.o;
    }

    @NotNull
    public final SqlElement getRoot() {
        return this.root;
    }

    @Override
    @NotNull
    public IMongoFromExpr build() {
        if (this.opTokens.isEmpty()) {
            if (this.fromExprs.size() == 1) {
                throw MongoToDatabaseScriptTranslator.Companion.createTranslationPSIStructureException((PsiElement)this.o, (PsiElement)this.root);
            }
            Object[] objectArray = new Object[]{"CROSS JOIN"};
            String string = DatabaseBundle.message((String)"MongoTranslator.errors.0.is.unsupported.please.use.inner.join.or.left.join", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            throw MongoToDatabaseScriptTranslator.Companion.createTranslationException(string, (PsiElement)this.o, (PsiElement)this.root);
        }
        boolean operatorIsInnerInsteadOfLeft = this.convertOpCompositeToken(CollectionsKt.joinToString$default((Iterable)this.opTokens, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
        if (this.fromExprs.size() != 2) {
            throw MongoToDatabaseScriptTranslator.Companion.createTranslationPSIStructureException((PsiElement)this.o, (PsiElement)this.root);
        }
        IMongoFromExpr leftFromExpr = this.fromExprs.get(0);
        IMongoFromExpr rightFromExpr = this.fromExprs.get(1);
        if (!(rightFromExpr instanceof IMongoTableFromExpr)) {
            String string = DatabaseBundle.message((String)"MongoTranslator.errors.only.join.with.table.second.argument.is.supported", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            throw MongoToDatabaseScriptTranslator.Companion.createTranslationException(string, (PsiElement)this.o, (PsiElement)this.root);
        }
        MongoJoinCondition mongoJoinCondition = this.condition;
        if (mongoJoinCondition == null) {
            throw MongoToDatabaseScriptTranslator.Companion.createTranslationPSIStructureException((PsiElement)this.o, (PsiElement)this.root);
        }
        MongoJoinCondition condition = mongoJoinCondition;
        return new MongoJoin(leftFromExpr, (IMongoTableFromExpr)rightFromExpr, this.handleJoinCondition(leftFromExpr, (IMongoTableFromExpr)rightFromExpr, condition), operatorIsInnerInsteadOfLeft);
    }

    @Override
    @NotNull
    public MongoJoinBuilder fromExpr(@NotNull IMongoFromExpr v) {
        MongoJoinBuilder mongoJoinBuilder;
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        MongoJoinBuilder $this$fromExpr_u24lambda_u240 = mongoJoinBuilder = this;
        boolean bl = false;
        $this$fromExpr_u24lambda_u240.fromExprs.add(v);
        return mongoJoinBuilder;
    }

    @Override
    @NotNull
    public MongoJoinBuilder condition(@NotNull MongoJoinCondition v) {
        MongoJoinBuilder mongoJoinBuilder;
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        MongoJoinBuilder $this$condition_u24lambda_u241 = mongoJoinBuilder = this;
        boolean bl = false;
        $this$condition_u24lambda_u241.condition = v;
        return mongoJoinBuilder;
    }

    @Override
    @NotNull
    public MongoJoinBuilder opToken(@NotNull String v) {
        MongoJoinBuilder mongoJoinBuilder;
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        MongoJoinBuilder $this$opToken_u24lambda_u242 = mongoJoinBuilder = this;
        boolean bl = false;
        $this$opToken_u24lambda_u242.opTokens.add(v);
        return mongoJoinBuilder;
    }

    private final boolean convertOpCompositeToken(String compositeOpToken) {
        return switch (compositeOpToken) {
            case "INNER JOIN", "JOIN" -> true;
            case "LEFT JOIN", "LEFT OUTER JOIN" -> false;
            default -> {
                PsiElement var4_3;
                try {
                    var4_3 = this.o.getOpSignElement();
                }
                catch (AssertionError e) {
                    var4_3 = null;
                }
                PsiElement op = var4_3;
                Object[] var5_5 = new Object[]{compositeOpToken};
                String v1 = DatabaseBundle.message((String)"MongoTranslator.errors.0.is.unsupported.please.use.inner.join.or.left.join", (Object[])var5_5);
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"message(...)");
                throw MongoToDatabaseScriptTranslator.Companion.createTranslationException(v1, op, (PsiElement)this.root);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private final MongoJoinCondition handleJoinCondition(IMongoFromExpr leftFromExpr, IMongoTableFromExpr rightTableFromExpr, MongoJoinCondition condition) {
        Object[] $this$mapTo$iv$iv;
        Iterable $this$map$iv = leftFromExpr.nameIdentifiers();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object t : $this$mapTo$iv$iv) {
            void it;
            MongoIdentifier mongoIdentifier = (MongoIdentifier)t;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        List leftNames = (List)destination$iv$iv;
        String rightTableName = rightTableFromExpr.nameIdentifier().getName();
        if (leftNames.contains(rightTableName)) {
            $this$mapTo$iv$iv = new Object[]{rightTableName};
            String string = DatabaseBundle.message((String)"MongoTranslator.errors.not.unique.table.alias", (Object[])$this$mapTo$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            throw MongoToDatabaseScriptTranslator.Companion.createTranslationException(string, (PsiElement)this.o, (PsiElement)this.root);
        }
        MongoIdentifier mongoIdentifier = condition.getLocalColumn().getTableIdentifier();
        if (CollectionsKt.contains((Iterable)leftNames, (Object)(mongoIdentifier != null ? mongoIdentifier.getName() : null))) {
            MongoIdentifier mongoIdentifier2 = condition.getForeignColumn().getTableIdentifier();
            if (Intrinsics.areEqual((Object)rightTableName, (Object)(mongoIdentifier2 != null ? mongoIdentifier2.getName() : null))) {
                return condition;
            }
        }
        MongoIdentifier mongoIdentifier3 = condition.getLocalColumn().getTableIdentifier();
        if (Intrinsics.areEqual((Object)rightTableName, (Object)(mongoIdentifier3 != null ? mongoIdentifier3.getName() : null))) {
            MongoIdentifier mongoIdentifier4 = condition.getForeignColumn().getTableIdentifier();
            if (CollectionsKt.contains((Iterable)leftNames, (Object)(mongoIdentifier4 != null ? mongoIdentifier4.getName() : null))) {
                return new MongoJoinCondition(condition.getForeignColumn(), condition.getLocalColumn());
            }
        }
        String quotedLeftNamesArg = CollectionsKt.joinToString$default((Iterable)leftNames, (CharSequence)", ", null, null, (int)0, null, MongoJoinBuilder::handleJoinCondition$lambda$4, (int)30, null);
        String quotedRightTableName = "'" + rightTableName + "'";
        Object[] objectArray = new Object[]{quotedLeftNamesArg, quotedRightTableName};
        String string = DatabaseBundle.message((String)"MongoTranslator.errors.incorrect.columns.in.join.condition", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        throw MongoToDatabaseScriptTranslator.Companion.createTranslationException(string, PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)this.o), SqlJoinConditionClause.class), (PsiElement)this.root);
    }

    private static final CharSequence handleJoinCondition$lambda$4(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "'" + it + "'";
    }
}

