/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.core.util;

import com.intellij.diff.util.DiffUtil;
import com.intellij.jpa.jpb.model.core.util.IoFileSynchronizationHelper;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.ProjectScope;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public final class JpbVfsUtil {
    @Nullable
    public static VirtualFile findRelativeFile(@Nullable VirtualFile base, @NotNull String path) {
        if (path == null) {
            JpbVfsUtil.$$$reportNull$$$0(0);
        }
        return VfsUtil.findRelativeFile((VirtualFile)base, (String[])path.replace('\\', '/').split("/"));
    }

    @Nullable
    public static String getRelativePathToSourceRoot(Project project, @NotNull VirtualFile file, @Nullable String defaultValue) {
        VirtualFile sourceRoot;
        if (file == null) {
            JpbVfsUtil.$$$reportNull$$$0(1);
        }
        if ((sourceRoot = JpbVfsUtil.findSourceRoot(file.getPath(), project, true)) != null) {
            String relativePath = VfsUtil.getRelativePath((VirtualFile)file, (VirtualFile)sourceRoot);
            return relativePath == null ? defaultValue : relativePath;
        }
        return defaultValue;
    }

    public static File saveContent(@NotNull VirtualFile folder, @NotNull String path, @NotNull String content) throws IOException {
        if (folder == null) {
            JpbVfsUtil.$$$reportNull$$$0(2);
        }
        if (path == null) {
            JpbVfsUtil.$$$reportNull$$$0(3);
        }
        if (content == null) {
            JpbVfsUtil.$$$reportNull$$$0(4);
        }
        return JpbVfsUtil.saveContent(folder, path, content, null);
    }

    public static File saveContent(@NotNull VirtualFile folder, @NotNull String path, @NotNull String content, @Nullable Project project) throws IOException {
        if (folder == null) {
            JpbVfsUtil.$$$reportNull$$$0(5);
        }
        if (path == null) {
            JpbVfsUtil.$$$reportNull$$$0(6);
        }
        if (content == null) {
            JpbVfsUtil.$$$reportNull$$$0(7);
        }
        return JpbVfsUtil.saveContent(folder, path, content, StandardCharsets.UTF_8, project);
    }

    public static File saveContent(@NotNull VirtualFile folder, @NotNull String path, @NotNull String content, @NotNull Charset contentCharset, @Nullable Project project) throws IOException {
        if (folder == null) {
            JpbVfsUtil.$$$reportNull$$$0(8);
        }
        if (path == null) {
            JpbVfsUtil.$$$reportNull$$$0(9);
        }
        if (content == null) {
            JpbVfsUtil.$$$reportNull$$$0(10);
        }
        if (contentCharset == null) {
            JpbVfsUtil.$$$reportNull$$$0(11);
        }
        if (!folder.isWritable() && !DiffUtil.makeWritable(null, (VirtualFile)folder)) {
            throw new IOException("File is read-only: " + folder.getPresentableName());
        }
        path = path.replace('\\', '/');
        File folderFile = new File(folder.getPath());
        File ioFile = new File(folderFile, path);
        if (ioFile.isDirectory()) {
            throw new IOException("File '" + String.valueOf(folder) + "/" + path + "' is directory");
        }
        if (!ioFile.getParentFile().exists()) {
            ioFile.getParentFile().mkdirs();
        }
        boolean created = !ioFile.exists();
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(ioFile), contentCharset);){
            writer.write(content);
        }
        if (created && project != null) {
            IoFileSynchronizationHelper.getInstance(project).scheduleSynchronization(ioFile);
            return ioFile;
        }
        return null;
    }

    public static String readString(VirtualFile file) {
        try {
            return new String(VfsUtil.loadBytes((VirtualFile)file), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isProjectFile(PsiElement element) {
        return JpbVfsUtil.isProjectFile(element.getProject(), element.getOriginalElement().getContainingFile().getVirtualFile());
    }

    public static boolean isProjectFile(Project project, VirtualFile virtualFile) {
        return ProjectScope.getProjectScope((Project)project).accept(virtualFile);
    }

    @Nullable
    public static VirtualFile findSourceRoot(String childPath, Project project, boolean includeResource) {
        return StreamEx.of(JpbVfsUtil.getAllSourceRoots(project, includeResource)).findFirst(rootFile -> FileUtil.isAncestor((String)rootFile.getPath(), (String)childPath, (boolean)true) || FileUtil.pathsEqual((String)rootFile.getPath(), (String)childPath)).orElse(null);
    }

    public static List<VirtualFile> getAllSourceRoots(Project project, boolean includeResource) {
        HashSet rootTypes = new HashSet();
        if (includeResource) {
            rootTypes.add((JpsModuleSourceRootType<?>)JavaResourceRootType.RESOURCE);
        }
        rootTypes.addAll(JavaModuleSourceRootTypes.SOURCES);
        return JpbVfsUtil.getProjectSourceRoots(project, rootTypes);
    }

    public static List<VirtualFile> getProjectSourceRoots(Project project, @NotNull Set<JpsModuleSourceRootType<?>> rootTypes) {
        if (rootTypes == null) {
            JpbVfsUtil.$$$reportNull$$$0(12);
        }
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : moduleManager.getModules()) {
            result.addAll(JpbVfsUtil.getModuleSourceRoots(module, rootTypes));
        }
        return result;
    }

    public static List<VirtualFile> getModuleSourceRoots(Module module, @NotNull Set<JpsModuleSourceRootType<?>> rootTypes) {
        if (rootTypes == null) {
            JpbVfsUtil.$$$reportNull$$$0(13);
        }
        return ModuleRootManager.getInstance((Module)module).getSourceRoots(rootTypes);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folder";
                break;
            }
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentCharset";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTypes";
                break;
            }
        }
        objectArray2[1] = "com/intellij/jpa/jpb/model/core/util/JpbVfsUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findRelativeFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getRelativePathToSourceRoot";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "saveContent";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getProjectSourceRoots";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "getModuleSourceRoots";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

