/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.inspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.jpa.jpb.model.core.msg.JpaModelBundle;
import com.intellij.jpa.jpb.model.inspection.AbstractEntityAnnotationInspection;
import com.intellij.jpa.jpb.model.inspection.LombokBuilderInspectionKt;
import com.intellij.jpa.jpb.model.inspection.fix.AppendAllArgsConstructorFix;
import com.intellij.jpa.jpb.model.inspection.fix.AppendSimpleAllArgsConstructorFix;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UClass;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u001b\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0014\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0014J#\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\t2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\nH\u0014\u00a2\u0006\u0002\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/intellij/jpa/jpb/model/inspection/LombokBuilderAllArgsInspection;", "Lcom/intellij/jpa/jpb/model/inspection/AbstractEntityAnnotationInspection;", "<init>", "()V", "isApplyInspection", "", "psiClass", "Lcom/intellij/psi/PsiClass;", "getProblemPsiElements", "", "Lcom/intellij/psi/PsiElement;", "uClass", "Lorg/jetbrains/uast/UClass;", "(Lorg/jetbrains/uast/UClass;)[Lcom/intellij/psi/PsiElement;", "getProblemDescriptorMessage", "", "getFixes", "Lcom/intellij/codeInspection/LocalQuickFix;", "entityClass", "psiElement", "(Lorg/jetbrains/uast/UClass;Lcom/intellij/psi/PsiElement;)[Lcom/intellij/codeInspection/LocalQuickFix;", "intellij.javaee.jpa.jpb.model"})
@SourceDebugExtension(value={"SMAP\nLombokBuilderInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LombokBuilderInspection.kt\ncom/intellij/jpa/jpb/model/inspection/LombokBuilderAllArgsInspection\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,89:1\n19652#2,2:90\n12637#2,2:92\n12637#2,2:94\n19652#2,2:96\n*S KotlinDebug\n*F\n+ 1 LombokBuilderInspection.kt\ncom/intellij/jpa/jpb/model/inspection/LombokBuilderAllArgsInspection\n*L\n59#1:90,2\n60#1:92,2\n61#1:94,2\n62#1:96,2\n*E\n"})
public final class LombokBuilderAllArgsInspection
extends AbstractEntityAnnotationInspection {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean isApplyInspection(@NotNull PsiClass psiClass) {
        boolean bl;
        int n;
        int n2;
        boolean $i$f$any;
        Object[] $this$any$iv;
        PsiMethod it;
        Object element$iv2;
        boolean $i$f$none;
        Object[] $this$none$iv;
        block11: {
            block10: {
                Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
                if (!Intrinsics.areEqual((Object)psiClass.getLanguage(), (Object)JavaLanguage.INSTANCE)) return false;
                PsiMethod[] psiMethodArray = psiClass.getConstructors();
                Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"getConstructors(...)");
                $this$none$iv = psiMethodArray;
                $i$f$none = false;
                for (Object element$iv2 : $this$none$iv) {
                    it = (PsiMethod)element$iv2;
                    boolean bl2 = false;
                    if (!it.getParameterList().isEmpty()) {
                        return false;
                    }
                    boolean bl3 = false;
                    if (!bl3) continue;
                    return false;
                }
                boolean bl4 = true;
                if (!bl4) return false;
                PsiAnnotation[] psiAnnotationArray = psiClass.getAnnotations();
                Intrinsics.checkNotNullExpressionValue((Object)psiAnnotationArray, (String)"getAnnotations(...)");
                $this$any$iv = psiAnnotationArray;
                $i$f$any = false;
                n2 = 0;
                n = $this$any$iv.length;
                while (n2 < n) {
                    element$iv2 = $this$any$iv[n2];
                    it = (PsiAnnotation)element$iv2;
                    boolean bl5 = false;
                    if (!it.hasQualifiedName("lombok.Builder")) {
                        ++n2;
                        continue;
                    }
                    break block10;
                }
                return false;
            }
            boolean bl6 = true;
            if (!bl6) return false;
            PsiAnnotation[] psiAnnotationArray = psiClass.getAnnotations();
            Intrinsics.checkNotNullExpressionValue((Object)psiAnnotationArray, (String)"getAnnotations(...)");
            $this$any$iv = psiAnnotationArray;
            $i$f$any = false;
            for (Object element$iv2 : $this$any$iv) {
                it = (PsiAnnotation)element$iv2;
                boolean bl7 = false;
                if (!it.hasQualifiedName("lombok.NoArgsConstructor")) continue;
                bl = true;
                break block11;
            }
            bl = false;
        }
        if (!bl) {
            block12: {
                PsiMethod[] psiMethodArray = psiClass.getConstructors();
                Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"getConstructors(...)");
                $this$any$iv = psiMethodArray;
                $i$f$any = false;
                n2 = 0;
                n = $this$any$iv.length;
                while (n2 < n) {
                    element$iv2 = $this$any$iv[n2];
                    it = (PsiMethod)element$iv2;
                    boolean bl8 = false;
                    if (!it.getParameterList().isEmpty()) {
                        ++n2;
                        continue;
                    }
                    break block12;
                }
                return false;
            }
            boolean bl9 = true;
            if (!bl9) return false;
        }
        PsiAnnotation[] psiAnnotationArray = psiClass.getAnnotations();
        Intrinsics.checkNotNullExpressionValue((Object)psiAnnotationArray, (String)"getAnnotations(...)");
        $this$none$iv = psiAnnotationArray;
        $i$f$none = false;
        n2 = 0;
        n = $this$none$iv.length;
        while (n2 < n) {
            element$iv2 = $this$none$iv[n2];
            it = (PsiAnnotation)element$iv2;
            boolean bl10 = false;
            if (it.hasQualifiedName("lombok.AllArgsConstructor")) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    @NotNull
    protected PsiElement[] getProblemPsiElements(@NotNull UClass uClass) {
        Intrinsics.checkNotNullParameter((Object)uClass, (String)"uClass");
        UAnnotation annotation = uClass.findAnnotation("lombok.Builder");
        if (annotation != null) {
            PsiElement psiElement = annotation.getSourcePsi();
            if (psiElement == null) {
                return new PsiElement[0];
            }
            PsiElement sourcePsi = psiElement;
            PsiElement[] psiElementArray = new PsiElement[]{sourcePsi};
            return psiElementArray;
        }
        return new PsiElement[0];
    }

    @Override
    @NotNull
    protected String getProblemDescriptorMessage() {
        String string = JpaModelBundle.message("inspection.LombokBuilderAllArgsInspection", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    @NotNull
    protected LocalQuickFix[] getFixes(@NotNull UClass entityClass, @NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)entityClass, (String)"entityClass");
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new AppendAllArgsConstructorFix(), LombokBuilderInspectionKt.asQuickFix((ModCommandAction)new AppendSimpleAllArgsConstructorFix(entityClass.getJavaPsi()))};
        return localQuickFixArray;
    }
}

