/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.model;

import com.google.common.base.Joiner;
import com.intellij.jpa.jpb.model.action.creation.entity.SequenceItem;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.AnnotationDescriptor;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.JpaAttributeAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.JpaConstraintAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.JpaEnum;
import com.intellij.jpa.jpb.model.backend.ed.indexing.CustomTypeModel;
import com.intellij.jpa.jpb.model.core.model.ConstantAttributeValue;
import com.intellij.jpa.jpb.model.core.msg.JpaModelBundle;
import com.intellij.jpa.jpb.model.model.AssociationType;
import com.intellij.jpa.jpb.model.model.AttributeOverride;
import com.intellij.jpa.jpb.model.model.CollectionTable;
import com.intellij.jpa.jpb.model.model.Datatype;
import com.intellij.jpa.jpb.model.model.Datatypes;
import com.intellij.jpa.jpb.model.model.DbIdentifierHelper;
import com.intellij.jpa.jpb.model.model.Entity;
import com.intellij.jpa.jpb.model.model.EntityAttributeModel;
import com.intellij.jpa.jpb.model.model.ForeignKeyModel;
import com.intellij.jpa.jpb.model.model.IdGeneratedStrategy;
import com.intellij.jpa.jpb.model.model.MapKeyColumn;
import com.intellij.jpa.jpb.model.model.OrderColumn;
import com.intellij.jpa.jpb.model.model.SoftDeleteModel;
import com.intellij.jpa.jpb.model.model.constraint.Constraint;
import com.intellij.jpa.jpb.model.util.annotation.JoinColumn;
import com.intellij.jpa.jpb.model.util.annotation.JoinTable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EntityAttribute
implements Comparable<EntityAttribute> {
    public static final String COLUMN = "column";
    public static final String FETCH_TYPE = "fetchType";
    public static final String ENUM_TYPE = "enumType";
    public static final String CARDINALITY = "cardinality";
    public static final String MAPPING = "mappingType";
    public static final String VERSION = "version";
    public static final String COLLECTION_TYPE = "collectionType";
    public static final String COLLECTION_TABLE = "collectionTable";
    public static final String JOIN_COLUMN = "joinColumn";
    public static final String MANDATORY = "mandatory";
    public static final String UNIQUE = "unique";
    public static final String LENGTH = "length";
    public static final String MAPPED_BY = "mappedBy";
    public static final String PRECISION = "precision";
    public static final String SCALE = "scale";
    public static final String ID = "id";
    public static final String OWNER = "owner";
    public static final String DIRECTION = "direction";
    public static final String ASSOCIATION_TYPE = "associationType";
    public static final String TRANSIENT = "transient";
    public static final String CREATE_FIELD = "createField";
    public static final String JOIN_TABLE = "joinTable";
    public static final String JOIN_TABLE_NAME = "joinTableName";
    public static final String JOIN_TABLE_JOIN_COLUMN_NAME = "joinColumnName";
    public static final String JOIN_TABLE_JOIN_COLUMN_REFERENCED_NAME = "joinColumnReferencedColumnName";
    public static final String JOIN_TABLE_INVERSE_JOIN_COLUMN_NAME = "inverseJoinColumnName";
    public static final String JOIN_TABLE_INVERSE_JOIN_COLUMN_REFERENCED_NAME = "inverseJoinColumnReferencedColumnName";
    public static final String COLLECTION_TABLE_JOIN_COLUMN = "collectionTableJoinColumn";
    public static final String ORDER_BY = "orderBy";
    public static final String COLUMN_DEFINITION = "columnDefinition";
    public static final String NUMBER_FORMAT = "numberFormat";
    public static final String NUMBER_FORMAT_STYLE = "numberFormatStyle";
    public static final String TEMPORAL_TYPE = "temporalType";
    public static final String TIME_ZONE_STORAGE_TYPE = "timeZoneStorageType";
    public static final String TIME_ZONE_COLUMN = "timeZoneColumn";
    public static final String ORPHAN_REMOVAL = "orphanRemoval";
    public static final String CONVERTER = "converter";
    public static final String ATTRIBUTE_OVERRIDES = "attributeOverrides";
    public static final String GENERATE_EQUALS_HASHCODE = "generateEqualsAndHashCode";
    public static final String CASCADE = "cascade";
    public static final String SQL_TYPE = "sqlType";
    public static final int DEFAULT_LENGTH = 255;
    public static final int DEFAULT_INITIAL_VALUE = 1;
    public static final int DEFAULT_ALLOCATION_SIZE = 50;
    public static final int DEFAULT_HIBERNATE_INCREMENT_SIZE = 1;
    public static final int DEFAULT_HIBERNATE6_INCREMENT_SIZE = 50;
    public static final String NAME = "name";
    public static final String GETTER_PROPERTY_NAME = "getterPropertyName";
    public static final String TYPE = "type";
    public static final String READ_ONLY = "readOnly";
    public static final String MUTABLE = "mutable";
    public static final String JDBC_TYPE_CODE = "jdbcTypeCode";
    public static final String GENERATED_STRATEGY = "generatedStrategy";
    public static final String SEQUENCE_TYPE = "sequenceType";
    public static final String GENERATOR_NAME = "generatorName";
    public static final String SEQUENCE_OR_TABLE_GENERATOR_NAME = "sequenceOrTableGeneratorName";
    public static final String INITIAL_VALUE = "initialValue";
    public static final String ALLOCATION_SIZE = "allocationSize";
    public static final List<String> GENERIC_GENERATOR_SEQUENCE_STRATEGIES = List.of("enhanced-sequence", "sequence", "org.hibernate.id.enhanced.SequenceStyleGenerator");
    public static final String SEQUENCE_PARAM = "sequence_name";
    public static final String INITIAL_PARAM = "initial_value";
    public static final String INCREMENT_PARAM = "increment_size";
    public static final String CONFIG_PREFER_SEQUENCE_PER_ENTITY = "prefer_sequence_per_entity";
    public static final String CONFIG_SEQUENCE_PER_ENTITY_SUFFIX = "sequence_per_entity_suffix";
    public static final String DEF_SEQUENCE_SUFFIX = "_SEQ";
    public static final String UPDATABLE = "updatable";
    public static final String LOB = "lob";
    public static final String GENERATE_ATTRIBUTE_OVERRIDES = "generateAttributeOverrides";
    public static final String ON_DELETE = "onDelete";
    public static final String ON_DELETE_INVERSE = "onDeleteInverse";
    public static final String META_PROPERTY = "metaProperty";
    public static final String CONVERSION_TYPE = "conversionType";
    public static final String DECIMAL_SEP = "decimalSep";
    public static final String GROUP_SEP = "groupSep";
    public static final int DEFAULT_PRECISION = 19;
    public static final int DEFAULT_SCALE = 2;

    public abstract int getPrecision();

    public abstract int getScale();

    public abstract String getMappedBy();

    public abstract boolean isPersistent();

    public abstract boolean isMandatory();

    public abstract boolean isUnique();

    public abstract boolean isVersion();

    public abstract boolean isId();

    public abstract boolean isElementCollection();

    public abstract String getCollectionTable();

    public abstract List<JoinColumn> getCollectionTableJoinColumns();

    public abstract boolean isCreatedDateAudit();

    public abstract boolean isLastModifiedDateAudit();

    public abstract boolean isCreatedByAudit();

    public abstract boolean isLastModifiedByAudit();

    public abstract boolean isHibernateEnversAudited();

    public abstract boolean isHibernateEnversNotAudited();

    public abstract boolean isLombokGetter();

    public abstract boolean isLombokSetter();

    public abstract boolean isLombokToStringInclude();

    public abstract boolean isCreateField();

    @Nullable
    public abstract Datatypes.CollectionDatatype getCollectionType();

    @Nullable
    public abstract String getCollectionTypeFqn();

    public abstract boolean isSqlType();

    public abstract boolean isUnknownType();

    public abstract boolean isTransient();

    public abstract boolean isSystem();

    public abstract boolean isOrphanRemoval();

    public abstract List<CascadeType> getCascadeTypes();

    public abstract OnDeleteAction getOnDeleteAction();

    public abstract Map<String, Object> getAdditionalProperties();

    public abstract Map<String, String> getUnknownAnnotations();

    public abstract Map<String, Map<String, String>> getAnnotationUnknownParams();

    public abstract ForeignKeyModel getForeignKey();

    public abstract List<ConstantAttributeValue> getConstantAttributeValues();

    public abstract boolean isEnum();

    public abstract boolean isDatatype();

    public abstract boolean isEmbedded();

    public abstract boolean isLob();

    public abstract boolean isNationalized();

    public abstract TemporalType getTemporalType();

    public abstract TimeZoneStorageType getTimeZoneStorageType();

    public abstract String getTimeZoneColumn();

    @Nullable
    public abstract Integer getProcessedLength();

    @Nullable
    public PsiElement getPsiElement() {
        return null;
    }

    @Nullable
    public abstract String getLength();

    public abstract String getOrderBy();

    @Nullable
    public abstract MappingType getMappingType();

    @Nullable
    public abstract String getColumn();

    @Nullable
    public abstract String getReferencedColumnName();

    @Nullable
    public abstract OrderColumn getOrderColumn();

    @Nullable
    public abstract MapKeyColumn getMapKeyColumn();

    @Nullable
    public abstract Datatype getMapKeyType();

    public abstract String getColumnPhysical();

    public abstract String getColumnDefinition();

    public abstract FetchType getFetchType();

    @Nullable
    public abstract FetchMode getFetchMode();

    @Nullable
    public abstract EnumType getEnumType();

    @Nullable
    public abstract Cardinality getCardinality();

    public abstract AssociationType getAssociationType();

    public abstract boolean isReadOnly();

    public abstract String getName();

    @Nullable
    public abstract String getGetterPropertyName();

    public abstract Datatype getType();

    public abstract Datatype getType(Entity var1);

    @Nullable
    public abstract Integer getJdbcTypeCode();

    @Nullable
    public abstract String getDefaultValue();

    public abstract boolean isNaturalId();

    public abstract boolean isGenericType();

    public abstract LinkedHashMap<String, String> getJoinColumns();

    @Nullable
    public abstract CollectionTable getCollectionTable(@Nullable Entity var1);

    public abstract boolean isMapsId();

    @Nullable
    public abstract String getMapsIdValue();

    public abstract LinkedHashSet<AttributeOverride> getAttributeOverrides();

    @NotNull
    public abstract JoinTable getJoinTable();

    @NotNull
    public abstract JoinTable getJoinTable(@Nullable Entity var1);

    public abstract boolean isOwner();

    public abstract String getNumberFormat();

    public abstract NumberFormatStyle getNumberFormatStyle();

    public abstract LinkedHashSet<Constraint> getConstraints();

    public abstract boolean isUpdatable();

    public abstract boolean isInsertable();

    @Nullable
    public abstract GeneratedStrategy getGeneratedStrategy();

    public abstract boolean isSequenceGeneratorOnAttribute();

    @Nullable
    public abstract String getGeneratorName();

    @Nullable
    public abstract String getSequenceOrTableGeneratorName();

    public abstract int getInitialValue();

    public abstract int getAllocationSize();

    public abstract SequenceItem getSequenceType();

    public abstract CustomTypeModel getConverter();

    public abstract boolean isTodoComment();

    public abstract String getTargetEntityFqn();

    @Nullable
    public abstract String getComment();

    public abstract boolean isRevisionNumber();

    public abstract boolean isRevisionTimestamp();

    @Nullable
    public abstract SoftDeleteModel getSoftDelete();

    public EntityAttributeModel getModel() {
        return new EntityAttributeModel(this);
    }

    public boolean isClass() {
        MappingType mappingType = this.getMappingType();
        return mappingType == MappingType.ASSOCIATION;
    }

    public Map<String, String> getAnnotationUnknownParams(String annotation) {
        return this.getAnnotationUnknownParams().getOrDefault(annotation, new HashMap());
    }

    public String getClearValidColumnName() {
        return DbIdentifierHelper.convertToClearValidIdentifier(this.getColumn());
    }

    public String getClearDbColumn() {
        String column = this.getColumn();
        if (column != null) {
            return DbIdentifierHelper.trimEscapeQuotes(this.getColumn(), true);
        }
        return this.getName();
    }

    public String getDdlManipulationColumn() {
        return DbIdentifierHelper.trimEscapeQuotes(this.getColumn(), false);
    }

    @Nullable
    public AttributeOverride getAttributeOverride(String attrName) {
        return StreamEx.of(this.getAttributeOverrides()).findFirst(attributeOverride -> Objects.equals(attributeOverride.getName(), attrName)).orElse(null);
    }

    @Nullable
    public String getEmbeddedColumnName(@Nullable EntityAttribute idAttribute) {
        AttributeOverride attributeOverride;
        String embAttrColumnName = this.getDdlManipulationColumn();
        if (this.isTransient() || StringUtils.isBlank((CharSequence)embAttrColumnName)) {
            return null;
        }
        AttributeOverride attributeOverride2 = attributeOverride = idAttribute == null ? null : idAttribute.getAttributeOverride(this.getName());
        if (attributeOverride != null && StringUtil.isNotEmpty((String)attributeOverride.getColumn())) {
            embAttrColumnName = attributeOverride.getColumn();
        }
        return embAttrColumnName;
    }

    public boolean compareColumn(@Nullable String c) {
        return DbIdentifierHelper.compareIdentifier(this.getColumn(), c);
    }

    public Set<AttributeOverride> getAttributeOverrides(boolean isAssociation) {
        Entity embEntity;
        LinkedHashSet<AttributeOverride> attributeOverrides;
        block4: {
            block3: {
                attributeOverrides = this.getAttributeOverrides();
                Datatype type = this.getType();
                if (!(type instanceof Entity)) break block3;
                embEntity = (Entity)type;
                if (!attributeOverrides.isEmpty()) break block4;
            }
            return Collections.emptySet();
        }
        LinkedHashSet<AttributeOverride> result = new LinkedHashSet<AttributeOverride>();
        for (AttributeOverride entry : attributeOverrides) {
            EntityAttribute attribute = embEntity.getAttribute(entry.getName());
            if (attribute == null || (attribute.getCardinality() == null || !isAssociation) && (attribute.getCardinality() != null || isAssociation)) continue;
            result.add(entry);
        }
        return result;
    }

    @Nullable
    public String getConcatJoinColumns() {
        LinkedHashMap<String, String> joinColumns = this.getJoinColumns();
        return joinColumns.isEmpty() ? null : Joiner.on((String)", ").join(joinColumns.keySet());
    }

    public boolean isCompKeyType() {
        Datatype type = this.getType();
        if (!(type instanceof Entity)) {
            return false;
        }
        List<EntityAttribute> idAttrs = ((Entity)type).getIdAttributes();
        return idAttrs.size() == 1 && idAttrs.get(0).getType() instanceof Entity || idAttrs.size() > 1;
    }

    public boolean isCardinalityMany() {
        Cardinality cardinality = this.getCardinality();
        return cardinality != null && cardinality.isMany();
    }

    @Override
    public int compareTo(EntityAttribute attr) {
        return Comparator.comparing(entityAttribute -> !entityAttribute.isId()).thenComparing(EntityAttribute::getName).compare(this, attr);
    }

    public String toString() {
        return this.getName();
    }

    public boolean isColumnNameExist() {
        return true;
    }

    public Map<String, String> getCompletedJoinColumns() {
        LinkedHashMap<String, String> joinColumns = this.getJoinColumns();
        String column = this.getColumn();
        if (joinColumns.isEmpty() && StringUtil.isNotEmpty((String)column)) {
            HashMap<String, String> result = new HashMap<String, String>();
            result.put(column, "");
            return result;
        }
        return joinColumns;
    }

    @Nullable
    public String getColumn(@Nullable Entity entity) {
        String overrideColumn;
        String attrColumnName = this.getColumn();
        if (entity != null && StringUtil.isNotEmpty((String)(overrideColumn = entity.getOverrideColumn(this)))) {
            attrColumnName = overrideColumn;
        }
        return attrColumnName;
    }

    public String getColumnDefinition(Entity entity) {
        String overColumnDefinition;
        AttributeOverride attributeOverride;
        AttributeOverride attributeOverride2 = attributeOverride = entity == null ? null : entity.getAttributeOverrideEx(this.getName());
        if (attributeOverride != null && StringUtil.isNotEmpty((String)(overColumnDefinition = attributeOverride.getColumnDefinition()))) {
            return overColumnDefinition;
        }
        return this.getColumnDefinition();
    }

    public boolean isNotNullColumn(boolean embeddedEntity) {
        if (!embeddedEntity && this.getConstraints().stream().anyMatch(constraint -> constraint.isEnabled() && Objects.equals(constraint.getName(), JpaConstraintAnnotation.NotNull.name()))) {
            return true;
        }
        if (this.isMandatory()) {
            return true;
        }
        Datatype type = this.getType();
        return type instanceof Datatypes.BasicDatatype && ((Datatypes.BasicDatatype)type).isPrimitive();
    }

    public static enum MappingType {
        DATATYPE,
        ENUM,
        ASSOCIATION,
        EMBEDDED,
        ELEMENT_COLLECTION;


        public static MappingType[] valuesForTransient() {
            return new MappingType[]{DATATYPE, ENUM, ASSOCIATION};
        }

        public static MappingType[] valuesForJpaTransient() {
            return new MappingType[]{DATATYPE, ENUM, ASSOCIATION};
        }

        public static MappingType[] valuesForMappedSuperClass() {
            return new MappingType[]{DATATYPE, ENUM, ASSOCIATION, EMBEDDED};
        }

        public static MappingType[] uiSupportedValues() {
            return new MappingType[]{DATATYPE, ENUM, ASSOCIATION, EMBEDDED};
        }
    }

    public static enum Cardinality {
        MANY_TO_ONE(JpaAttributeAnnotation.ManyToOne, JpaModelBundle.message("AttributePropertiesPanel.cardinality.manyToOne", new Object[0]), "AttributePropertiesPanel.cardinality.manyToOne.mandatoryHint", "AttributePropertiesPanel.cardinality.manyToOne.nonMandatoryHint"),
        ONE_TO_MANY(JpaAttributeAnnotation.OneToMany, JpaModelBundle.message("AttributePropertiesPanel.cardinality.oneToMany", new Object[0]), "AttributePropertiesPanel.cardinality.oneToMany.hint"),
        MANY_TO_MANY(JpaAttributeAnnotation.ManyToMany, JpaModelBundle.message("AttributePropertiesPanel.cardinality.manyToMany", new Object[0]), "AttributePropertiesPanel.cardinality.manyToMany.hint"),
        ONE_TO_ONE(JpaAttributeAnnotation.OneToOne, JpaModelBundle.message("AttributePropertiesPanel.cardinality.oneToOne", new Object[0]), "AttributePropertiesPanel.cardinality.oneToOne.mandatoryHint", "AttributePropertiesPanel.cardinality.oneToOne.nonMandatoryHint");

        public static final Cardinality[] WITHOUT_ONE_TO_MANY;
        @NlsSafe
        public final String label;
        private final String mandatoryHintKey;
        private final String nonMandatoryHintKey;
        private final AnnotationDescriptor annotationDescriptor;

        private Cardinality(JpaAttributeAnnotation annotation, String label, String mandatoryHintKey) {
            this(annotation, label, mandatoryHintKey, mandatoryHintKey);
        }

        private Cardinality(JpaAttributeAnnotation annotation, String label, String mandatoryHintKey, String nonMandatoryHintKey) {
            this.label = label;
            this.mandatoryHintKey = mandatoryHintKey;
            this.nonMandatoryHintKey = nonMandatoryHintKey;
            this.annotationDescriptor = annotation;
        }

        public String getPresentableName() {
            return this.annotationDescriptor.toString();
        }

        public String getFqn(Project project, Module module) {
            return this.annotationDescriptor.getFqn(project, module);
        }

        public Cardinality getInverse() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case ONE_TO_ONE -> ONE_TO_ONE;
                case MANY_TO_MANY -> MANY_TO_MANY;
                case MANY_TO_ONE -> ONE_TO_MANY;
                case ONE_TO_MANY -> MANY_TO_ONE;
            };
        }

        @NlsContexts.Label
        @NotNull
        public String getHint(@NotNull String firstEntityName, @Nullable String secondEntityName, boolean mandatory) {
            if (firstEntityName == null) {
                Cardinality.$$$reportNull$$$0(0);
            }
            Object secondName = StringUtil.isEmptyOrSpaces((String)secondEntityName) ? "" : "'" + secondEntityName + "' ";
            String string = JpaModelBundle.message(mandatory ? this.mandatoryHintKey : this.nonMandatoryHintKey, firstEntityName, secondName);
            if (string == null) {
                Cardinality.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isMany() {
            return this == ONE_TO_MANY || this == MANY_TO_MANY;
        }

        public String toString() {
            return this.label;
        }

        static {
            WITHOUT_ONE_TO_MANY = new Cardinality[]{ONE_TO_ONE, MANY_TO_ONE, MANY_TO_MANY};
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "firstEntityName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/jpa/jpb/model/model/EntityAttribute$Cardinality";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/jpa/jpb/model/model/EntityAttribute$Cardinality";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHint";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getHint";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static enum TimeZoneStorageType {
        NATIVE,
        NORMALIZE,
        NORMALIZE_UTC,
        COLUMN,
        AUTO;


        public String getFqn() {
            return "org.hibernate.annotations.TimeZoneStorageType." + this.name();
        }
    }

    public static enum TemporalType {
        DATE("DATE"),
        TIME("TIME"),
        TIMESTAMP("TIMESTAMP");

        private final String id;

        private TemporalType(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public String getFqn(Project project, Module module) {
            return JpaEnum.TemporalType.getEnumEntryFqn(project, module, this.id);
        }

        @Nullable
        public static TemporalType findById(String id) {
            for (TemporalType temporalType : TemporalType.values()) {
                if (!temporalType.getId().equals(id)) continue;
                return temporalType;
            }
            return null;
        }

        public String toString() {
            return this.id;
        }
    }

    public static enum FetchMode {
        SELECT,
        JOIN,
        SUBSELECT;

    }

    public static enum LazyToOneOption {
        NO_PROXY,
        FALSE,
        PROXY;

    }

    public static enum FetchType {
        LAZY,
        EAGER;


        public static FetchType getDefault(@Nullable Cardinality c) {
            return c != null && c.isMany() ? LAZY : EAGER;
        }
    }

    public static enum OnDeleteAction {
        NO_ACTION,
        CASCADE,
        RESTRICT,
        SET_NULL,
        SET_DEFAULT;

    }

    public static enum CascadeType {
        ALL,
        PERSIST,
        MERGE,
        REMOVE,
        REFRESH,
        DETACH;

    }

    public static enum EnumType {
        ORDINAL,
        STRING;


        public static EnumType getDefault() {
            return ORDINAL;
        }
    }

    public static enum GeneratedStrategy {
        AUTO("Auto"),
        IDENTITY("Identity"),
        SEQUENCE("Sequence"),
        TABLE("Table"),
        UUID("UUID");

        private final String caption;

        private GeneratedStrategy(String caption) {
            this.caption = caption;
        }

        public static GeneratedStrategy getDefault() {
            return AUTO;
        }

        public String toString() {
            return this.caption;
        }

        public IdGeneratedStrategy toIdGeneratedStrategy() {
            switch (this) {
                case IDENTITY: {
                    return IdGeneratedStrategy.IDENTITY;
                }
                case SEQUENCE: {
                    return IdGeneratedStrategy.SEQUENCE;
                }
                case UUID: {
                    return IdGeneratedStrategy.UUID;
                }
            }
            return IdGeneratedStrategy.NONE;
        }
    }

    public static enum NumberFormatStyle {
        DEFAULT,
        NUMBER,
        PERCENT,
        CURRENCY;

    }
}

